/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.scheduler.taskmanagers;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.DbQueryManager;
import com.uwyn.rife.database.DbRowProcessor;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.CreateSequence;
import com.uwyn.rife.database.queries.CreateTable;
import com.uwyn.rife.database.queries.Delete;
import com.uwyn.rife.database.queries.DropSequence;
import com.uwyn.rife.database.queries.DropTable;
import com.uwyn.rife.database.queries.Insert;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.database.queries.SequenceValue;
import com.uwyn.rife.database.queries.Update;
import com.uwyn.rife.scheduler.Scheduler;
import com.uwyn.rife.scheduler.Task;
import com.uwyn.rife.scheduler.TaskManager;
import com.uwyn.rife.scheduler.exceptions.FrequencyException;
import com.uwyn.rife.scheduler.exceptions.TaskManagerException;
import com.uwyn.rife.scheduler.taskmanagers.exceptions.ActivateTaskErrorException;
import com.uwyn.rife.scheduler.taskmanagers.exceptions.AddTaskErrorException;
import com.uwyn.rife.scheduler.taskmanagers.exceptions.ConcludeTaskErrorException;
import com.uwyn.rife.scheduler.taskmanagers.exceptions.DesactivateTaskErrorException;
import com.uwyn.rife.scheduler.taskmanagers.exceptions.GetScheduledTasksErrorException;
import com.uwyn.rife.scheduler.taskmanagers.exceptions.GetTaskErrorException;
import com.uwyn.rife.scheduler.taskmanagers.exceptions.GetTaskIdErrorException;
import com.uwyn.rife.scheduler.taskmanagers.exceptions.GetTasksToProcessErrorException;
import com.uwyn.rife.scheduler.taskmanagers.exceptions.InstallTasksErrorException;
import com.uwyn.rife.scheduler.taskmanagers.exceptions.RemoveTaskErrorException;
import com.uwyn.rife.scheduler.taskmanagers.exceptions.RemoveTasksErrorException;
import com.uwyn.rife.scheduler.taskmanagers.exceptions.RescheduleTaskErrorException;
import com.uwyn.rife.scheduler.taskmanagers.exceptions.UpdateTaskErrorException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseTasks
extends DbQueryManager
implements TaskManager {
    private Scheduler mScheduler = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    protected DatabaseTasks(Datasource datasource) {
        super(datasource);
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.mScheduler = scheduler;
    }

    @Override
    public Scheduler getScheduler() {
        return this.mScheduler;
    }

    public abstract boolean install() throws TaskManagerException;

    public abstract boolean remove() throws TaskManagerException;

    protected boolean _install(CreateSequence createSequenceTask, CreateTable createTableTask) throws TaskManagerException {
        if (!$assertionsDisabled && createSequenceTask == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && createTableTask == null) {
            throw new AssertionError();
        }
        try {
            this.executeUpdate(createSequenceTask);
            this.executeUpdate(createTableTask);
        }
        catch (DatabaseException e) {
            throw new InstallTasksErrorException(e);
        }
        return true;
    }

    protected boolean _remove(DropSequence dropSequenceTask, DropTable dropTableTask) throws TaskManagerException {
        if (!$assertionsDisabled && dropSequenceTask == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dropTableTask == null) {
            throw new AssertionError();
        }
        try {
            this.executeUpdate(dropTableTask);
            this.executeUpdate(dropSequenceTask);
        }
        catch (DatabaseException e) {
            throw new RemoveTasksErrorException(e);
        }
        return true;
    }

    protected int _addTask(SequenceValue getTaskId, Insert insertTask, DbPreparedStatementHandler handler, Task task) throws TaskManagerException {
        if (!$assertionsDisabled && getTaskId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && insertTask == null) {
            throw new AssertionError();
        }
        if (task == null) {
            throw new IllegalArgumentException("task can't be null.");
        }
        int result = -1;
        int task_id = -1;
        try {
            task_id = this.executeGetFirstInt(getTaskId);
            if (-1 == task_id) {
                throw new GetTaskIdErrorException();
            }
        }
        catch (DatabaseException e) {
            throw new GetTaskIdErrorException(e);
        }
        if (task_id >= 0) {
            task.setId(task_id);
            try {
                if (0 == this.executeUpdate(insertTask, handler)) {
                    throw new AddTaskErrorException(task);
                }
                result = task_id;
            }
            catch (DatabaseException e) {
                throw new AddTaskErrorException(task, e);
            }
        }
        if (!$assertionsDisabled && result < 0) {
            throw new AssertionError();
        }
        return result;
    }

    protected boolean _updateTask(Update updateTask, DbPreparedStatementHandler handler, Task task) throws TaskManagerException {
        if (!$assertionsDisabled && updateTask == null) {
            throw new AssertionError();
        }
        if (task == null) {
            throw new IllegalArgumentException("task can't be null.");
        }
        boolean result = false;
        try {
            if (0 == this.executeUpdate(updateTask, handler)) {
                throw new UpdateTaskErrorException(task);
            }
            result = true;
        }
        catch (DatabaseException e) {
            throw new UpdateTaskErrorException(task, e);
        }
        return result;
    }

    protected Task _getTask(Select getTask, ProcessTask processTask, int id) throws TaskManagerException {
        if (!$assertionsDisabled && getTask == null) {
            throw new AssertionError();
        }
        if (id < 0) {
            throw new IllegalArgumentException("the task id can't be negative.");
        }
        Task task = null;
        try {
            this.executeFetchFirst(getTask, processTask, new 1(id));
            task = processTask.getTask();
        }
        catch (DatabaseException e) {
            throw new GetTaskErrorException(id, e);
        }
        return task;
    }

    protected Collection<Task> _getTasksToProcess(Select getTasksToProcess, ProcessTask processTask) throws TaskManagerException {
        if (!$assertionsDisabled && getTasksToProcess == null) {
            throw new AssertionError();
        }
        ArrayList<Task> tasks_to_process = new ArrayList<Task>();
        processTask.setCollection(tasks_to_process);
        try {
            this.executeFetchAll(getTasksToProcess, processTask, new 2());
        }
        catch (DatabaseException e) {
            throw new GetTasksToProcessErrorException(e);
        }
        if (!$assertionsDisabled && tasks_to_process == null) {
            throw new AssertionError();
        }
        return tasks_to_process;
    }

    protected Collection<Task> _getScheduledTasks(Select getScheduledTasks, ProcessTask processTask) throws TaskManagerException {
        ArrayList<Task> scheduled_tasks = new ArrayList<Task>();
        processTask.setCollection(scheduled_tasks);
        try {
            this.executeFetchAll(getScheduledTasks, processTask, new 3());
        }
        catch (DatabaseException e) {
            throw new GetScheduledTasksErrorException(e);
        }
        if (!$assertionsDisabled && scheduled_tasks == null) {
            throw new AssertionError();
        }
        return scheduled_tasks;
    }

    protected boolean _removeTask(Delete removeTask, int id) throws TaskManagerException {
        if (!$assertionsDisabled && removeTask == null) {
            throw new AssertionError();
        }
        if (id < 0) {
            throw new IllegalArgumentException("the task id can't be negative.");
        }
        boolean result = false;
        try {
            if (0 != this.executeUpdate(removeTask, new 4(id))) {
                result = true;
            }
        }
        catch (DatabaseException e) {
            throw new RemoveTaskErrorException(id, e);
        }
        return result;
    }

    protected boolean _rescheduleTask(Task task, long newPlanned, String frequency) throws TaskManagerException {
        if (task == null) {
            throw new IllegalArgumentException("task can't be null.");
        }
        if (newPlanned <= (long)0) {
            throw new IllegalArgumentException("newPlanned has to be bigger than 0.");
        }
        boolean result = false;
        Task task_tmp = null;
        try {
            task_tmp = task.clone();
            task_tmp.setPlanned(newPlanned);
            task_tmp.setFrequency(frequency);
        }
        catch (Throwable e) {
            if (frequency == null) {
                throw new RescheduleTaskErrorException(task.getId(), newPlanned, e);
            }
            throw new RescheduleTaskErrorException(task.getId(), newPlanned, frequency, e);
        }
        result = this.updateTask(task_tmp);
        if (!$assertionsDisabled && !result) {
            throw new AssertionError();
        }
        return result;
    }

    protected boolean _concludeTask(Task task) throws TaskManagerException {
        if (task == null) {
            throw new IllegalArgumentException("task can't be null.");
        }
        if (task.getPlanned() <= Calendar.getInstance().getTimeInMillis()) {
            if (task.getFrequency() == null) {
                return this.removeTask(task.getId());
            }
            try {
                long next_date = task.getNextDate();
                if (next_date >= (long)0 && this.rescheduleTask(task, next_date, task.getFrequency()) && this.deactivateTask(task.getId())) {
                    return true;
                }
            }
            catch (FrequencyException e) {
                throw new ConcludeTaskErrorException(task.getId(), e);
            }
        }
        return false;
    }

    protected boolean _activateTask(Update activateTask, int id) throws TaskManagerException {
        if (!$assertionsDisabled && activateTask == null) {
            throw new AssertionError();
        }
        if (id < 0) {
            throw new IllegalArgumentException("the task id can't be negative.");
        }
        boolean result = false;
        boolean rows_processed = false;
        try {
            if (0 != this.executeUpdate(activateTask, new 5(id))) {
                result = true;
            }
        }
        catch (DatabaseException e) {
            throw new ActivateTaskErrorException(id);
        }
        return result;
    }

    protected boolean _desactivateTask(Update desactivateTask, int id) throws TaskManagerException {
        if (!$assertionsDisabled && desactivateTask == null) {
            throw new AssertionError();
        }
        if (id < 0) {
            throw new IllegalArgumentException("the task id can't be negative.");
        }
        boolean result = false;
        boolean rows_processed = false;
        try {
            if (0 != this.executeUpdate(desactivateTask, new 6(id))) {
                result = true;
            }
        }
        catch (DatabaseException e) {
            throw new DesactivateTaskErrorException(id, e);
        }
        return result;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.scheduler.taskmanagers.DatabaseTasks");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ProcessTask
    extends DbRowProcessor {
        protected Collection<Task> mCollection = null;
        protected Task mTask = null;
        private static /* synthetic */ boolean $assertionsDisabled;

        public void setCollection(Collection<Task> collection) {
            this.mCollection = collection;
        }

        @Override
        public boolean processRow(ResultSet resultSet) throws SQLException {
            if (!$assertionsDisabled && resultSet == null) {
                throw new AssertionError();
            }
            this.mTask = new Task();
            this.mTask.setId(resultSet.getInt("id"));
            this.mTask.setType(resultSet.getString("type"));
            this.mTask.setPlanned(resultSet.getLong("planned"));
            try {
                this.mTask.setFrequency(resultSet.getString("frequency"));
            }
            catch (FrequencyException e) {
                throw new SQLException(e.getMessage());
            }
            this.mTask.setBusy(resultSet.getBoolean("busy"));
            this.mTask.setTaskManager(DatabaseTasks.this);
            if (this.mCollection != null) {
                this.mCollection.add(this.mTask);
            }
            return true;
        }

        Task getTask() {
            return this.mTask;
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.scheduler.taskmanagers.DatabaseTasks$ProcessTask");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        static /* synthetic */ DatabaseTasks access$0(ProcessTask processTask) {
            return processTask.DatabaseTasks.this;
        }
    }

    class 1
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$id;

        1(int n) {
            this.val$id = n;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("id", this.val$id);
        }

        static /* synthetic */ DatabaseTasks access$0(1 var0) {
            return var0.DatabaseTasks.this;
        }
    }

    class 2
    extends DbPreparedStatementHandler {
        2() {
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong("planned", Calendar.getInstance().getTimeInMillis());
        }

        static /* synthetic */ DatabaseTasks access$0(2 var0) {
            return var0.DatabaseTasks.this;
        }
    }

    class 3
    extends DbPreparedStatementHandler {
        3() {
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong("planned", Calendar.getInstance().getTimeInMillis());
        }

        static /* synthetic */ DatabaseTasks access$0(3 var0) {
            return var0.DatabaseTasks.this;
        }
    }

    class 4
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$id;

        4(int n) {
            this.val$id = n;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("id", this.val$id);
        }

        static /* synthetic */ DatabaseTasks access$0(4 var0) {
            return var0.DatabaseTasks.this;
        }
    }

    class 5
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$id;

        5(int n) {
            this.val$id = n;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("id", this.val$id);
        }

        static /* synthetic */ DatabaseTasks access$0(5 var0) {
            return var0.DatabaseTasks.this;
        }
    }

    class 6
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$id;

        6(int n) {
            this.val$id = n;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("id", this.val$id);
        }

        static /* synthetic */ DatabaseTasks access$0(6 var0) {
            return var0.DatabaseTasks.this;
        }
    }
}

