/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.scheduler;

import com.uwyn.rife.scheduler.Frequency;
import com.uwyn.rife.scheduler.Scheduler;
import com.uwyn.rife.scheduler.TaskManager;
import com.uwyn.rife.scheduler.Taskoption;
import com.uwyn.rife.scheduler.TaskoptionManager;
import com.uwyn.rife.scheduler.exceptions.FrequencyException;
import com.uwyn.rife.scheduler.exceptions.SchedulerException;
import com.uwyn.rife.site.Validation;
import com.uwyn.rife.site.ValidationError;
import com.uwyn.rife.site.ValidationRule;
import com.uwyn.rife.site.ValidationRuleNotEmpty;
import com.uwyn.rife.site.ValidationRuleNotNull;
import java.util.Calendar;
import java.util.Date;

public class Task
extends Validation
implements Cloneable {
    private int mId = -1;
    private String mType = null;
    private long mPlanned = 0;
    private Frequency mFrequency = null;
    private boolean mBusy = false;
    private TaskManager mTaskManager = null;

    static /* synthetic */ void access$S1000002(Task task, long l) {
        task.mPlanned = l;
    }

    protected void activateValidation() {
        this.addRule(new ValidationRuleNotNull("type"));
        this.addRule(new ValidationRuleNotEmpty("planned"));
        this.addRule(new InvalidPlanned());
    }

    public void setTaskManager(TaskManager taskManager) {
        this.mTaskManager = taskManager;
    }

    public TaskManager getTaskManager() {
        return this.mTaskManager;
    }

    public String getTaskoptionValue(String name) throws SchedulerException {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (this.mTaskManager == null) {
            return null;
        }
        Scheduler scheduler = this.mTaskManager.getScheduler();
        if (scheduler == null) {
            return null;
        }
        TaskoptionManager taskoption_manager = scheduler.getTaskoptionManager();
        if (taskoption_manager == null) {
            return null;
        }
        Taskoption taskoption = taskoption_manager.getTaskoption(this.getId(), name);
        if (taskoption == null) {
            return null;
        }
        return taskoption.getValue();
    }

    public long getNextDate() throws FrequencyException {
        Calendar current_calendar = Calendar.getInstance();
        current_calendar.set(13, 0);
        current_calendar.set(14, 0);
        long current_time = current_calendar.getTimeInMillis();
        if (this.mPlanned <= current_time) {
            return this.getNextDate(current_time);
        }
        return -1;
    }

    public long getNextDate(long start) throws FrequencyException {
        if (this.mFrequency == null) {
            return -1;
        }
        return this.mFrequency.getNextDate(start);
    }

    public void setId(int id) {
        this.mId = id;
    }

    public int getId() {
        return this.mId;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public String getType() {
        return this.mType;
    }

    public void setPlanned(Date planned) {
        this.setPlanned(planned.getTime());
    }

    public void setPlanned(long planned) {
        Calendar planned_calendar = Calendar.getInstance();
        planned_calendar.setTimeInMillis(planned);
        planned_calendar.set(13, 0);
        planned_calendar.set(14, 0);
        this.mPlanned = planned_calendar.getTimeInMillis();
    }

    public long getPlanned() {
        return this.mPlanned;
    }

    public void setFrequency(String frequency) throws FrequencyException {
        this.mFrequency = frequency == null ? null : new Frequency(frequency);
    }

    public String getFrequency() {
        if (this.mFrequency == null) {
            return null;
        }
        return this.mFrequency.getFrequency();
    }

    public void setBusy(boolean busy) {
        this.mBusy = busy;
    }

    public boolean isBusy() {
        return this.mBusy;
    }

    public Task clone() throws CloneNotSupportedException {
        Task new_task = (Task)super.clone();
        return new_task;
    }

    public /* synthetic */ Validation clone() throws CloneNotSupportedException {
        return this.clone();
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.clone();
    }

    public boolean equals(Object object) {
        Task other_task = (Task)object;
        return object != null && other_task.getId() == this.getId() && other_task.getType().equals(this.getType()) && other_task.getPlanned() == this.getPlanned() && other_task.getFrequency() == this.getFrequency() && other_task.getTaskManager() == this.getTaskManager();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InvalidPlanned
    implements ValidationRule {
        @Override
        public boolean validate() {
            if ((long)0 == Task.this.mPlanned) {
                return true;
            }
            Calendar current_calendar = Calendar.getInstance();
            current_calendar.set(13, 0);
            current_calendar.set(14, 0);
            return Task.this.mPlanned >= current_calendar.getTimeInMillis();
        }

        @Override
        public String getSubject() {
            return "planned";
        }

        @Override
        public ValidationError getError() {
            return new ValidationError.INVALID(this.getSubject());
        }

        @Override
        public Object getBean() {
            return null;
        }

        @Override
        public <T extends ValidationRule> T setBean(Object bean) {
            return (T)this;
        }

        @Override
        public Object clone() {
            return this;
        }

        static /* synthetic */ Task access$0(InvalidPlanned invalidPlanned) {
            return invalidPlanned.Task.this;
        }
    }
}

