/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.scheduler;

import com.uwyn.rife.scheduler.Executor;
import com.uwyn.rife.scheduler.Task;
import com.uwyn.rife.scheduler.TaskManager;
import com.uwyn.rife.scheduler.TaskoptionManager;
import com.uwyn.rife.scheduler.exceptions.ExecutorAlreadyRegisteredException;
import com.uwyn.rife.scheduler.exceptions.NoExecutorForTasktypeException;
import com.uwyn.rife.scheduler.exceptions.SchedulerException;
import com.uwyn.rife.scheduler.exceptions.TaskManagerException;
import com.uwyn.rife.scheduler.exceptions.UnableToRetrieveTasksToProcessException;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scheduler
extends Thread {
    private TaskManager mTaskManager = null;
    private TaskoptionManager mTaskoptionManager = null;
    private int mSleepTime = 500;
    private HashMap<Object, Executor> mExecutors = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    public Scheduler(TaskManager taskManager, TaskoptionManager taskoptionManager) {
        super("SCHEDULER_DEAMON");
        this.setDaemon(true);
        this.setTaskManager(taskManager);
        this.setTaskoptionManager(taskoptionManager);
        this.mExecutors = new HashMap();
    }

    public void setTaskManager(TaskManager taskManager) {
        if (taskManager == null) {
            throw new IllegalArgumentException("taskManager can't be null.");
        }
        this.mTaskManager = taskManager;
        taskManager.setScheduler(this);
    }

    public TaskManager getTaskManager() {
        return this.mTaskManager;
    }

    public void setTaskoptionManager(TaskoptionManager taskoptionManager) {
        if (taskoptionManager == null) {
            throw new IllegalArgumentException("taskoptionManager can't be null.");
        }
        this.mTaskoptionManager = taskoptionManager;
        taskoptionManager.setScheduler(this);
    }

    public TaskoptionManager getTaskoptionManager() {
        return this.mTaskoptionManager;
    }

    public boolean addExecutor(Executor executor) throws SchedulerException {
        if (executor == null) {
            throw new IllegalArgumentException("executor can't be null.");
        }
        if (executor.getScheduler() != null) {
            if (this == executor.getScheduler()) {
                return false;
            }
            throw new ExecutorAlreadyRegisteredException(executor);
        }
        this.mExecutors.put(executor.getHandledTasktype(), executor);
        executor.setScheduler(this);
        if (!$assertionsDisabled && !this.mExecutors.containsKey(executor.getHandledTasktype())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && executor != this.mExecutors.get(executor.getHandledTasktype())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this != executor.getScheduler()) {
            throw new AssertionError();
        }
        return true;
    }

    public boolean removeExecutor(Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("executor can't be null.");
        }
        if (this.mExecutors.remove(executor.getHandledTasktype()) == null) {
            return false;
        }
        executor.setScheduler(null);
        if (!$assertionsDisabled && this.mExecutors.containsKey(executor.getHandledTasktype())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && executor.getScheduler() != null) {
            throw new AssertionError();
        }
        return true;
    }

    public Executor getExecutor(String tasktype) {
        if (tasktype == null) {
            throw new IllegalArgumentException("tasktype can't be null.");
        }
        return this.mExecutors.get(tasktype);
    }

    public Collection<Executor> getExecutors() {
        return this.mExecutors.values();
    }

    public void setSleepTime(int sleeptime) {
        if (sleeptime <= 0) {
            throw new IllegalArgumentException("sleeptime has to be bigger than 0.");
        }
        this.mSleepTime = sleeptime;
    }

    @Override
    public void run() {
        while (true) {
            try {
                if (this.isInterrupted()) break;
                this.scheduleStep();
                long now = System.currentTimeMillis();
                long projected = (System.currentTimeMillis() + (long)this.mSleepTime) / (long)this.mSleepTime * (long)this.mSleepTime;
                long difference = projected - now;
                Thread.sleep(difference);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        Scheduler scheduler = this;
        synchronized (scheduler) {
            this.notifyAll();
        }
    }

    private void scheduleStep() {
        if (!$assertionsDisabled && this.mTaskManager == null) {
            throw new AssertionError();
        }
        try {
            Executor executor = null;
            for (Task task : this.mTaskManager.getTasksToProcess()) {
                executor = this.mExecutors.get(task.getType());
                if (executor != null) {
                    executor.startTaskExecution(task);
                    continue;
                }
                throw new NoExecutorForTasktypeException(task.getType());
            }
        }
        catch (TaskManagerException e) {
            throw new UnableToRetrieveTasksToProcessException(e);
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.scheduler.Scheduler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

