/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.resources.databasedrivers;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.queries.CreateTable;
import com.uwyn.rife.database.queries.Delete;
import com.uwyn.rife.database.queries.DropTable;
import com.uwyn.rife.database.queries.Insert;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.database.queries.Update;
import com.uwyn.rife.resources.DatabaseResources;
import com.uwyn.rife.resources.exceptions.ResourceFinderErrorException;
import com.uwyn.rife.resources.exceptions.ResourceWriterErrorException;
import com.uwyn.rife.tools.InputStreamUser;
import java.net.URL;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class generic
extends DatabaseResources {
    protected CreateTable mCreateTable = null;
    protected DropTable mDropTable = null;
    protected Insert mAddResource = null;
    protected Update mUpdateResource = null;
    protected Delete mRemoveResource = null;
    protected Select mHasResource = null;
    protected Select mGetResourceContent = null;
    protected Select mGetResourceModified = null;

    public generic(Datasource datasource) {
        super(datasource);
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        String table = RifeConfig.Resources.getTableResources();
        try {
            clazz3 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        try {
            clazz2 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        try {
            clazz = Class.forName("java.sql.Timestamp");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mCreateTable = new CreateTable(this.getDatasource()).table(table).column("name", clazz3, 255, CreateTable.NOTNULL).column("content", clazz2).column("modified", clazz).primaryKey("name");
        this.mDropTable = new DropTable(this.getDatasource()).table(table);
        this.mAddResource = new Insert(this.getDatasource()).into(table).fieldParameter("name").fieldParameter("content").fieldParameter("modified");
        this.mUpdateResource = (Update)new Update(this.getDatasource()).table(table).fieldParameter("content").fieldParameter("modified").whereParameter("name", "=");
        this.mRemoveResource = (Delete)new Delete(this.getDatasource()).from(table).whereParameter("name", "=");
        this.mHasResource = (Select)new Select(this.getDatasource()).from(table).field("name").whereParameter("name", "=");
        this.mGetResourceContent = (Select)new Select(this.getDatasource()).from(table).field("content").whereParameter("name", "=");
        this.mGetResourceModified = (Select)new Select(this.getDatasource()).from(table).field("modified").whereParameter("name", "=");
    }

    @Override
    public boolean install() throws ResourceWriterErrorException {
        return this._install(this.mCreateTable);
    }

    @Override
    public boolean remove() throws ResourceWriterErrorException {
        return this._remove(this.mDropTable);
    }

    @Override
    public void addResource(String name, String content) throws ResourceWriterErrorException {
        this._addResource(this.mAddResource, name, content);
    }

    @Override
    public boolean updateResource(String name, String content) throws ResourceWriterErrorException {
        return this._updateResource(this.mUpdateResource, name, content);
    }

    @Override
    public boolean removeResource(String name) throws ResourceWriterErrorException {
        return this._removeResource(this.mRemoveResource, name);
    }

    @Override
    public URL getResource(String name) {
        return this._getResource(this.mHasResource, name);
    }

    @Override
    public <ResultType> ResultType useStream(URL resource, InputStreamUser user) throws ResourceFinderErrorException {
        return this._useStream(this.mGetResourceContent, resource, user);
    }

    @Override
    public String getContent(URL resource, String encoding) throws ResourceFinderErrorException {
        return this._getContent(this.mGetResourceContent, resource, encoding);
    }

    @Override
    public long getModificationTime(URL resource) throws ResourceFinderErrorException {
        return this._getModificationTime(this.mGetResourceModified, resource);
    }

    static /* synthetic */ String access$Lcom$uwyn$rife$resources$DatabaseResources$2() {
        return DatabaseResources.COLUMN_NAME;
    }

    static /* synthetic */ void access$Scom$uwyn$rife$resources$DatabaseResources$2(String string) {
        DatabaseResources.COLUMN_NAME = string;
    }

    static /* synthetic */ String access$Lcom$uwyn$rife$resources$DatabaseResources$3() {
        return DatabaseResources.COLUMN_CONTENT;
    }

    static /* synthetic */ void access$Scom$uwyn$rife$resources$DatabaseResources$3(String string) {
        DatabaseResources.COLUMN_CONTENT = string;
    }

    static /* synthetic */ String access$Lcom$uwyn$rife$resources$DatabaseResources$4() {
        return DatabaseResources.COLUMN_MODIFIED;
    }

    static /* synthetic */ void access$Scom$uwyn$rife$resources$DatabaseResources$4(String string) {
        DatabaseResources.COLUMN_MODIFIED = string;
    }
}

