/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.resources;

import com.uwyn.rife.resources.AbstractResourceFinder;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.resources.exceptions.CantOpenResourceStreamException;
import com.uwyn.rife.resources.exceptions.ResourceFinderErrorException;
import com.uwyn.rife.tools.InputStreamUser;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFinderGroup
extends AbstractResourceFinder {
    private ArrayList<ResourceFinder> mResourceFinders = new ArrayList();

    public ResourceFinderGroup add(ResourceFinder resourceFinder) {
        this.mResourceFinders.add(resourceFinder);
        return this;
    }

    @Override
    public URL getResource(String name) {
        URL result = null;
        for (ResourceFinder resource_finder : (Collection)this.mResourceFinders) {
            result = resource_finder.getResource(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public <ResultType> ResultType useStream(URL resource, InputStreamUser user) throws ResourceFinderErrorException {
        ResultType result = null;
        for (ResourceFinder resource_finder : (Collection)this.mResourceFinders) {
            try {
                result = resource_finder.useStream(resource, user);
            }
            catch (CantOpenResourceStreamException e) {
                continue;
            }
            return result;
        }
        throw new CantOpenResourceStreamException(resource, null);
    }

    @Override
    public String getContent(URL resource, String encoding) throws ResourceFinderErrorException {
        String result = null;
        for (ResourceFinder resource_finder : (Collection)this.mResourceFinders) {
            result = resource_finder.getContent(resource, encoding);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public long getModificationTime(URL resource) throws ResourceFinderErrorException {
        long result = -1;
        for (ResourceFinder resource_finder : (Collection)this.mResourceFinders) {
            result = resource_finder.getModificationTime(resource);
            if (result == (long)-1) continue;
            return result;
        }
        return -1;
    }
}

