/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.resources;

import com.uwyn.rife.resources.AbstractResourceFinder;
import com.uwyn.rife.resources.exceptions.CantOpenResourceStreamException;
import com.uwyn.rife.resources.exceptions.CantRetrieveResourceContentException;
import com.uwyn.rife.resources.exceptions.CouldntAccessResourceFileException;
import com.uwyn.rife.resources.exceptions.ResourceFinderErrorException;
import com.uwyn.rife.resources.exceptions.UnsupportedResourceProtocolException;
import com.uwyn.rife.tools.FileUtils;
import com.uwyn.rife.tools.InputStreamUser;
import com.uwyn.rife.tools.exceptions.FileUtilsErrorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFinderDirectories
extends AbstractResourceFinder {
    private ArrayList<File> mDirectories = new ArrayList();

    public ResourceFinderDirectories(File[] directories) {
        if (directories != null) {
            File[] fileArray = directories;
            int n = 0;
            while (n < fileArray.length) {
                File directory = fileArray[n];
                if (directory != null && directory.canRead() && directory.isDirectory()) {
                    this.mDirectories.add(directory);
                }
                ++n;
            }
        }
    }

    @Override
    public URL getResource(String name) {
        File resource = null;
        for (File directory : (Collection)this.mDirectories) {
            String local_name = name.replace('/', File.separatorChar);
            resource = new File(new StringBuffer().append(new StringBuffer().append(directory.getAbsolutePath()).append(File.separator).toString()).append(local_name).toString());
            if (!resource.exists() || !resource.canRead() || !resource.isFile()) continue;
            try {
                return resource.toURL();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public <ResultType> ResultType useStream(URL resource, InputStreamUser user) throws ResourceFinderErrorException {
        if (resource == null || user == null) {
            return null;
        }
        InputStream stream = null;
        try {
            try {
                stream = resource.openStream();
                Object ResultType = user.useInputStream(stream);
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                return ResultType;
            }
            catch (IOException e) {
                throw new CantOpenResourceStreamException(resource, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            block11: {
                if (stream == null) break block11;
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
            throw throwable;
        }
    }

    @Override
    public String getContent(URL resource, String encoding) throws ResourceFinderErrorException {
        if (resource == null) {
            return null;
        }
        try {
            return FileUtils.readString(resource, encoding);
        }
        catch (FileUtilsErrorException e) {
            throw new CantRetrieveResourceContentException(resource, encoding, e);
        }
    }

    @Override
    public long getModificationTime(URL resource) throws ResourceFinderErrorException {
        File resource_file;
        if (resource == null) {
            return -1;
        }
        long modification_time = -1;
        String resource_protocol = resource.getProtocol();
        String resource_filename = URLDecoder.decode(resource.getFile());
        if (resource_protocol.equals("file")) {
            resource_file = new File(resource_filename);
            if (resource_file == null || !resource_file.exists() || !resource_file.canRead()) {
                throw new CouldntAccessResourceFileException(resource_filename);
            }
        } else {
            throw new UnsupportedResourceProtocolException(resource_filename, resource_protocol);
        }
        modification_time = resource_file.lastModified();
        return modification_time;
    }
}

