/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.resources;

import com.uwyn.rife.resources.AbstractResourceFinder;
import com.uwyn.rife.resources.ModificationTimeClasspath;
import com.uwyn.rife.resources.ResourceFinderClasspathSingleton;
import com.uwyn.rife.resources.exceptions.CantOpenResourceStreamException;
import com.uwyn.rife.resources.exceptions.CantRetrieveResourceContentException;
import com.uwyn.rife.resources.exceptions.ResourceFinderErrorException;
import com.uwyn.rife.tools.FileUtils;
import com.uwyn.rife.tools.InputStreamUser;
import com.uwyn.rife.tools.exceptions.FileUtilsErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFinderClasspath
extends AbstractResourceFinder {
    protected ResourceFinderClasspath() {
    }

    public static ResourceFinderClasspath getInstance() {
        return ResourceFinderClasspathSingleton.INSTANCE;
    }

    @Override
    public URL getResource(String name) {
        URL resource = null;
        resource = this.getClass().getClassLoader() != null ? this.getClass().getClassLoader().getResource(name) : ClassLoader.getSystemClassLoader().getResource(name);
        if (resource == null) {
            resource = this.getClass().getResource(name);
        }
        return resource;
    }

    @Override
    public <ResultType> ResultType useStream(URL resource, InputStreamUser user) throws ResourceFinderErrorException {
        if (resource == null || user == null) {
            return null;
        }
        InputStream stream = null;
        try {
            try {
                stream = resource.openStream();
                Object ResultType = user.useInputStream(stream);
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                return ResultType;
            }
            catch (IOException e) {
                throw new CantOpenResourceStreamException(resource, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            block11: {
                if (stream == null) break block11;
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
            throw throwable;
        }
    }

    @Override
    public String getContent(URL resource, String encoding) throws ResourceFinderErrorException {
        if (resource == null) {
            return null;
        }
        try {
            return FileUtils.readString(resource, encoding);
        }
        catch (FileUtilsErrorException e) {
            throw new CantRetrieveResourceContentException(resource, encoding, e);
        }
    }

    @Override
    public long getModificationTime(URL resource) throws ResourceFinderErrorException {
        return ModificationTimeClasspath.getModificationTime(resource);
    }
}

