/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.resources;

import com.uwyn.rife.resources.exceptions.CantFindResourceJarEntryException;
import com.uwyn.rife.resources.exceptions.CouldntAccessResourceFileException;
import com.uwyn.rife.resources.exceptions.CouldntAccessResourceJarException;
import com.uwyn.rife.resources.exceptions.ResourceFinderErrorException;
import com.uwyn.rife.resources.exceptions.UnsupportedResourceProtocolException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ModificationTimeClasspath {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long getModificationTime(URL resource) throws ResourceFinderErrorException {
        if (resource == null) {
            return -1;
        }
        long modification_time = -1;
        String resource_protocol = resource.getProtocol();
        String resource_filename = URLDecoder.decode(resource.getFile());
        if (resource_protocol.equals("jar")) {
            String prefix = "file:";
            String jar_filename = resource_filename.substring(prefix.length(), resource_filename.indexOf(33));
            String jar_entryname = resource_filename.substring(resource_filename.indexOf(33) + 2);
            File jar_regularfile = new File(jar_filename);
            if (jar_regularfile == null) throw new CouldntAccessResourceJarException(jar_filename, jar_entryname);
            if (!jar_regularfile.exists()) throw new CouldntAccessResourceJarException(jar_filename, jar_entryname);
            if (!jar_regularfile.canRead()) throw new CouldntAccessResourceJarException(jar_filename, jar_entryname);
            try {
                JarFile jar_file = new JarFile(jar_regularfile);
                JarEntry jar_entry = jar_file.getJarEntry(jar_entryname);
                if (jar_entry == null) throw new CantFindResourceJarEntryException(jar_filename, jar_entryname, null);
                return jar_entry.getTime();
            }
            catch (IOException e) {
                throw new CantFindResourceJarEntryException(jar_filename, jar_entryname, e);
            }
        }
        if (resource_protocol.equals("file")) {
            File resource_file = new File(resource_filename);
            if (resource_file == null) throw new CouldntAccessResourceFileException(resource_filename);
            if (!resource_file.exists()) throw new CouldntAccessResourceFileException(resource_filename);
            if (!resource_file.canRead()) throw new CouldntAccessResourceFileException(resource_filename);
            return resource_file.lastModified();
        }
        if (resource_protocol.equals("classloader")) {
            return -1;
        }
        if (!resource_protocol.equals("zip")) throw new UnsupportedResourceProtocolException(resource_filename, resource_protocol);
        return -1;
    }
}

