/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.resources;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.DbQueryManager;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.CreateTable;
import com.uwyn.rife.database.queries.Delete;
import com.uwyn.rife.database.queries.DropTable;
import com.uwyn.rife.database.queries.Insert;
import com.uwyn.rife.database.queries.ReadQuery;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.database.queries.Update;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.resources.ResourceWriter;
import com.uwyn.rife.resources.exceptions.CantOpenResourceStreamException;
import com.uwyn.rife.resources.exceptions.CantRetrieveResourceContentException;
import com.uwyn.rife.resources.exceptions.ResourceAdditionErrorException;
import com.uwyn.rife.resources.exceptions.ResourceFinderErrorException;
import com.uwyn.rife.resources.exceptions.ResourceRemovalErrorException;
import com.uwyn.rife.resources.exceptions.ResourceStructureInstallationException;
import com.uwyn.rife.resources.exceptions.ResourceStructureRemovalException;
import com.uwyn.rife.resources.exceptions.ResourceUpdateErrorException;
import com.uwyn.rife.resources.exceptions.ResourceWriterErrorException;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.InputStreamUser;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseResources
extends DbQueryManager
implements ResourceFinder,
ResourceWriter {
    protected static final String PROTOCOL = "file";
    protected static final String COLUMN_NAME = "name";
    protected static final String COLUMN_CONTENT = "content";
    protected static final String COLUMN_MODIFIED = "modified";
    private static /* synthetic */ boolean $assertionsDisabled;

    protected DatabaseResources(Datasource datasource) {
        super(datasource);
    }

    public abstract boolean install() throws ResourceWriterErrorException;

    public abstract boolean remove() throws ResourceWriterErrorException;

    protected boolean _install(CreateTable createTable) throws ResourceWriterErrorException {
        try {
            this.executeUpdate(createTable);
        }
        catch (DatabaseException e) {
            throw new ResourceStructureInstallationException(e);
        }
        return true;
    }

    protected boolean _remove(DropTable dropTable) throws ResourceWriterErrorException {
        try {
            this.executeUpdate(dropTable);
        }
        catch (DatabaseException e) {
            throw new ResourceStructureRemovalException(e);
        }
        return true;
    }

    protected void _addResource(Insert addResource, String name, String content) throws ResourceWriterErrorException {
        if (!$assertionsDisabled && addResource == null) {
            throw new AssertionError();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (content == null) {
            throw new IllegalArgumentException("content can't be null.");
        }
        try {
            this.executeUpdate(addResource, new 1(name, content));
        }
        catch (DatabaseException e) {
            throw new ResourceAdditionErrorException(name, content, e);
        }
    }

    protected boolean _updateResource(Update updateResource, String name, String content) throws ResourceWriterErrorException {
        if (!$assertionsDisabled && updateResource == null) {
            throw new AssertionError();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (content == null) {
            throw new IllegalArgumentException("content can't be null.");
        }
        boolean result = false;
        try {
            if (0 != this.executeUpdate(updateResource, new 2(content, name))) {
                result = true;
            }
        }
        catch (DatabaseException e) {
            throw new ResourceUpdateErrorException(name, content, e);
        }
        return result;
    }

    protected boolean _removeResource(Delete removeResource, String name) throws ResourceWriterErrorException {
        if (!$assertionsDisabled && removeResource == null) {
            throw new AssertionError();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        boolean result = false;
        try {
            if (0 != this.executeUpdate(removeResource, new 3(name))) {
                result = true;
            }
        }
        catch (DatabaseException e) {
            throw new ResourceRemovalErrorException(name, e);
        }
        return result;
    }

    protected URL _getResource(Select hasResource, String name) {
        if (!$assertionsDisabled && hasResource == null) {
            throw new AssertionError();
        }
        if (name == null) {
            return null;
        }
        URL resource = null;
        try {
            if (this.executeHasResultRows(hasResource, new 4(name))) {
                resource = new URL(PROTOCOL, "", name);
            }
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (DatabaseException e) {
            Logger.getLogger("com.uwyn.rife.resources").severe(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Error while retrieving the resource with name '").append(name).toString()).append("' :\n").toString()).append(ExceptionUtils.getExceptionStackTrace(e)).toString());
            return null;
        }
        return resource;
    }

    protected <ResultType> ResultType _useStream(Select getResourceContent, URL resource, InputStreamUser user) throws ResourceFinderErrorException {
        if (!$assertionsDisabled && getResourceContent == null) {
            throw new AssertionError();
        }
        if (resource == null || user == null) {
            return null;
        }
        if (!PROTOCOL.equals(resource.getProtocol())) {
            return null;
        }
        try {
            return this.executeUseFirstBinaryStream(getResourceContent, user, new 5(resource));
        }
        catch (DatabaseException e) {
            throw new CantOpenResourceStreamException(resource, (Throwable)e);
        }
    }

    protected String _getContent(Select getResourceContent, URL resource, String encoding) throws ResourceFinderErrorException {
        if (!$assertionsDisabled && getResourceContent == null) {
            throw new AssertionError();
        }
        if (resource == null) {
            return null;
        }
        if (!PROTOCOL.equals(resource.getProtocol())) {
            return null;
        }
        String result = null;
        try {
            result = this.executeGetFirstString(getResourceContent, new 6(resource));
        }
        catch (DatabaseException e) {
            throw new CantRetrieveResourceContentException(resource, encoding, e);
        }
        return result;
    }

    protected long _getModificationTime(Select getResourceModified, URL resource) throws ResourceFinderErrorException {
        if (!$assertionsDisabled && getResourceModified == null) {
            throw new AssertionError();
        }
        if (resource == null) {
            return -1;
        }
        if (!PROTOCOL.equals(resource.getProtocol())) {
            return -1;
        }
        try {
            long result = -1;
            Timestamp timestamp = this.executeGetFirstTimestamp((ReadQuery)getResourceModified, new 7(resource));
            if (timestamp == null) {
                return -1;
            }
            result = timestamp.getTime();
            return result;
        }
        catch (DatabaseException e) {
            return -1;
        }
    }

    @Override
    public <ResultType> ResultType useStream(String name, InputStreamUser user) throws ResourceFinderErrorException {
        if (name == null || user == null) {
            return null;
        }
        URL resource = this.getResource(name);
        if (resource == null) {
            return null;
        }
        return this.useStream(resource, user);
    }

    @Override
    public String getContent(String name) throws ResourceFinderErrorException {
        return this.getContent(name, null);
    }

    @Override
    public String getContent(String name, String encoding) throws ResourceFinderErrorException {
        if (name == null) {
            return null;
        }
        URL resource = this.getResource(name);
        if (resource == null) {
            return null;
        }
        return this.getContent(resource, encoding);
    }

    @Override
    public String getContent(URL resource) throws ResourceFinderErrorException {
        return this.getContent(resource, null);
    }

    @Override
    public long getModificationTime(String name) throws ResourceFinderErrorException {
        if (name == null) {
            return -1;
        }
        URL resource = this.getResource(name);
        if (resource == null) {
            return -1;
        }
        return this.getModificationTime(resource);
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.resources.DatabaseResources");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    class 1
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$name;
        private final /* synthetic */ String val$content;

        1(String string, String string2) {
            this.val$name = string;
            this.val$content = string2;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString(DatabaseResources.COLUMN_NAME, this.val$name).setString(DatabaseResources.COLUMN_CONTENT, this.val$content).setTimestamp(DatabaseResources.COLUMN_MODIFIED, new Timestamp(Calendar.getInstance().getTimeInMillis()));
        }

        static /* synthetic */ DatabaseResources access$0(1 var0) {
            return var0.DatabaseResources.this;
        }
    }

    class 2
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$content;
        private final /* synthetic */ String val$name;

        2(String string, String string2) {
            this.val$content = string;
            this.val$name = string2;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString(DatabaseResources.COLUMN_CONTENT, this.val$content).setTimestamp(DatabaseResources.COLUMN_MODIFIED, new Timestamp(Calendar.getInstance().getTimeInMillis())).setString(DatabaseResources.COLUMN_NAME, this.val$name);
        }

        static /* synthetic */ DatabaseResources access$0(2 var0) {
            return var0.DatabaseResources.this;
        }
    }

    class 3
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$name;

        3(String string) {
            this.val$name = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString(DatabaseResources.COLUMN_NAME, this.val$name);
        }

        static /* synthetic */ DatabaseResources access$0(3 var0) {
            return var0.DatabaseResources.this;
        }
    }

    class 4
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$name;

        4(String string) {
            this.val$name = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString(DatabaseResources.COLUMN_NAME, this.val$name);
        }

        static /* synthetic */ DatabaseResources access$0(4 var0) {
            return var0.DatabaseResources.this;
        }
    }

    class 5
    extends DbPreparedStatementHandler {
        private final /* synthetic */ URL val$resource;

        5(URL uRL) {
            this.val$resource = uRL;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString(DatabaseResources.COLUMN_NAME, URLDecoder.decode(this.val$resource.getFile()));
        }

        static /* synthetic */ DatabaseResources access$0(5 var0) {
            return var0.DatabaseResources.this;
        }
    }

    class 6
    extends DbPreparedStatementHandler {
        private final /* synthetic */ URL val$resource;

        6(URL uRL) {
            this.val$resource = uRL;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString(DatabaseResources.COLUMN_NAME, URLDecoder.decode(this.val$resource.getFile()));
        }

        static /* synthetic */ DatabaseResources access$0(6 var0) {
            return var0.DatabaseResources.this;
        }
    }

    class 7
    extends DbPreparedStatementHandler {
        private final /* synthetic */ URL val$resource;

        7(URL uRL) {
            this.val$resource = uRL;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString(DatabaseResources.COLUMN_NAME, URLDecoder.decode(this.val$resource.getFile()));
        }

        static /* synthetic */ DatabaseResources access$0(7 var0) {
            return var0.DatabaseResources.this;
        }
    }
}

