/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.rep;

import com.uwyn.rife.rep.BlockingRepository;
import com.uwyn.rife.rep.exceptions.ParticipantNotFoundException;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.tools.StringUtils;
import com.uwyn.rife.xml.Xml2Data;
import com.uwyn.rife.xml.exceptions.XmlErrorException;
import org.xml.sax.Attributes;

public class Xml2BlockingRepository
extends Xml2Data {
    private BlockingRepository mRepository = null;
    private String mName = null;
    private boolean mBlocking = false;
    private String mParameter = null;
    private StringBuffer mCharacterData = null;

    Xml2BlockingRepository(BlockingRepository repository) {
        this.mRepository = repository;
    }

    public void addRepParticipants(String resource, ResourceFinder resourcefinder) {
        this.processXml(resource, resourcefinder);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (qName.equals("participant")) {
            this.mCharacterData = new StringBuffer();
            this.mName = atts.getValue("name");
            this.mBlocking = false;
            String blocking = atts.getValue("blocking");
            if (blocking != null && (blocking.equals("1") || blocking.equals("t") || blocking.equals("true"))) {
                this.mBlocking = true;
            }
            this.mParameter = atts.getValue("param");
        } else if (!qName.equals("rep")) {
            throw new XmlErrorException("Unsupport element name '" + qName + "'.");
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (qName.equals("participant") && !this.mRepository.addParticipant(StringUtils.trim(this.mCharacterData.toString()), this.mName, this.mBlocking, this.mParameter)) {
            throw new ParticipantNotFoundException(this.mCharacterData.toString());
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (length > 0) {
            this.mCharacterData.append(String.copyValueOf(ch, start, length));
        }
    }
}

