/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.rep;

import com.uwyn.rife.rep.BlockingRepository;
import com.uwyn.rife.rep.Participant;
import com.uwyn.rife.rep.Repository;
import com.uwyn.rife.resources.ResourceFinder;
import java.util.Collection;
import java.util.Properties;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Rep {
    private static Repository sDefaultRepository = null;

    public static void initialize(String repXmlPath) {
        Rep.initialize(repXmlPath, null);
    }

    public static void initialize(String repXmlPath, ResourceFinder resourcefinder) {
        BlockingRepository repository = new BlockingRepository();
        sDefaultRepository = repository;
        repository.initialize(repXmlPath, resourcefinder);
    }

    public static void setDefaultRepository(Repository repository) {
        sDefaultRepository = repository;
    }

    public static Repository getDefaultRepository() {
        return sDefaultRepository;
    }

    public static boolean hasParticipant(String name) {
        if (sDefaultRepository == null) {
            return false;
        }
        return sDefaultRepository.hasParticipant(name);
    }

    public static Participant getParticipant(String name) {
        if (sDefaultRepository == null) {
            return null;
        }
        return sDefaultRepository.getParticipant(name);
    }

    public static Collection<? extends Participant> getParticipants(String name) {
        if (sDefaultRepository == null) {
            return null;
        }
        return sDefaultRepository.getParticipants(name);
    }

    public static Properties getProperties() {
        if (sDefaultRepository == null) {
            return null;
        }
        return sDefaultRepository.getProperties();
    }

    public static void cleanup() {
        if (sDefaultRepository == null) {
            return;
        }
        sDefaultRepository.cleanup();
    }
}

