/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.pcj.map;

import com.uwyn.rife.pcj.CharIterator;
import com.uwyn.rife.pcj.hash.CharHashFunction;
import com.uwyn.rife.pcj.hash.DefaultCharHashFunction;
import com.uwyn.rife.pcj.hash.Primes;
import com.uwyn.rife.pcj.map.AbstractCharKeyMap;
import com.uwyn.rife.pcj.map.CharKeyMap;
import com.uwyn.rife.pcj.map.CharKeyMapIterator;
import com.uwyn.rife.pcj.set.AbstractCharSet;
import com.uwyn.rife.pcj.set.CharSet;
import com.uwyn.rife.pcj.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharKeyOpenHashMap<E>
extends AbstractCharKeyMap<E>
implements CharKeyMap<E>,
Cloneable,
Serializable {
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private CharHashFunction keyhash;
    private int size;
    private transient char[] keys;
    private transient E[] values;
    private transient byte[] states;
    private static final byte EMPTY = 0;
    private static final byte OCCUPIED = 1;
    private static final byte REMOVED = 2;
    private transient int used;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;
    private transient CharSet ckeys;
    private transient Collection cvalues;

    static /* synthetic */ void access$S1000005(CharKeyOpenHashMap charKeyOpenHashMap, char[] cArray) {
        charKeyOpenHashMap.keys = cArray;
    }

    static /* synthetic */ void access$S1000006(CharKeyOpenHashMap charKeyOpenHashMap, Object[] objectArray) {
        charKeyOpenHashMap.values = objectArray;
    }

    static /* synthetic */ void access$S1000007(CharKeyOpenHashMap charKeyOpenHashMap, byte[] byArray) {
        charKeyOpenHashMap.states = byArray;
    }

    static /* synthetic */ byte access$L1000009() {
        return OCCUPIED;
    }

    static /* synthetic */ void access$S1000009(byte by) {
        OCCUPIED = by;
    }

    static /* synthetic */ byte access$L1000010() {
        return REMOVED;
    }

    static /* synthetic */ void access$S1000010(byte by) {
        REMOVED = by;
    }

    CharKeyOpenHashMap(CharHashFunction keyhash, int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        if (keyhash == null) {
            Exceptions.nullArgument("hash function");
        }
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk <= 0) {
            Exceptions.negativeOrZeroArgument("growthChunk", String.valueOf(growthChunk));
        }
        if (loadFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(loadFactor));
        }
        this.keyhash = keyhash;
        capacity = Primes.nextPrime(capacity);
        this.keys = new char[capacity];
        this.values = new Object[capacity];
        this.states = new byte[capacity];
        this.size = 0;
        this.expandAt = (int)Math.round(loadFactor * (double)capacity);
        this.used = 0;
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
        this.loadFactor = loadFactor;
    }

    CharKeyOpenHashMap(int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        this(DefaultCharHashFunction.INSTANCE, capacity, growthPolicy, growthFactor, growthChunk, loadFactor);
    }

    public CharKeyOpenHashMap() {
        this(11);
    }

    public CharKeyOpenHashMap(CharKeyMap map) {
        this();
        this.putAll(map);
    }

    public CharKeyOpenHashMap(int capacity) {
        this(capacity, 0, 1.0, 10, 0.75);
    }

    public CharKeyOpenHashMap(double loadFactor) {
        this(11, 0, 1.0, 10, loadFactor);
    }

    public CharKeyOpenHashMap(int capacity, double loadFactor) {
        this(capacity, 0, 1.0, 10, loadFactor);
    }

    public CharKeyOpenHashMap(int capacity, double loadFactor, double growthFactor) {
        this(capacity, 0, growthFactor, 10, loadFactor);
    }

    public CharKeyOpenHashMap(int capacity, double loadFactor, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk, loadFactor);
    }

    public CharKeyOpenHashMap(CharHashFunction keyhash) {
        this(keyhash, 11, 0, 1.0, 10, 0.75);
    }

    public CharKeyOpenHashMap(CharHashFunction keyhash, int capacity) {
        this(keyhash, capacity, 0, 1.0, 10, 0.75);
    }

    public CharKeyOpenHashMap(CharHashFunction keyhash, double loadFactor) {
        this(keyhash, 11, 0, 1.0, 10, loadFactor);
    }

    public CharKeyOpenHashMap(CharHashFunction keyhash, int capacity, double loadFactor) {
        this(keyhash, capacity, 0, 1.0, 10, loadFactor);
    }

    public CharKeyOpenHashMap(CharHashFunction keyhash, int capacity, double loadFactor, double growthFactor) {
        this(keyhash, capacity, 0, growthFactor, 10, loadFactor);
    }

    public CharKeyOpenHashMap(CharHashFunction keyhash, int capacity, double loadFactor, int growthChunk) {
        this(keyhash, capacity, 1, 1.0, growthChunk, loadFactor);
    }

    private void ensureCapacity(int elements) {
        if (elements >= this.expandAt) {
            int newcapacity = this.growthPolicy == 0 ? (int)((double)this.keys.length * (1.0 + this.growthFactor)) : this.keys.length + this.growthChunk;
            if ((double)newcapacity * this.loadFactor < (double)elements) {
                newcapacity = (int)Math.round((double)elements / this.loadFactor);
            }
            newcapacity = Primes.nextPrime(newcapacity);
            this.expandAt = (int)Math.round(this.loadFactor * (double)newcapacity);
            char[] newkeys = new char[newcapacity];
            Object[] newvalues = new Object[newcapacity];
            byte[] newstates = new byte[newcapacity];
            this.used = 0;
            int i = 0;
            while (i < this.keys.length) {
                if (this.states[i] == 1) {
                    ++this.used;
                    char k = this.keys[i];
                    E v = this.values[i];
                    int h = Math.abs(this.keyhash.hash(k));
                    int n = h % newcapacity;
                    if (newstates[n] == 1) {
                        int c = 1 + h % (newcapacity - 2);
                        do {
                            if ((n -= c) >= 0) continue;
                            n += newcapacity;
                        } while (newstates[n] != 0);
                    }
                    newstates[n] = 1;
                    newvalues[n] = v;
                    newkeys[n] = k;
                }
                ++i;
            }
            this.keys = newkeys;
            this.values = newvalues;
            this.states = newstates;
        }
    }

    @Override
    public CharSet keySet() {
        if (this.ckeys == null) {
            this.ckeys = new KeySet();
        }
        return this.ckeys;
    }

    @Override
    public E put(char key, E value) {
        int i;
        block5: {
            int h = Math.abs(this.keyhash.hash(key));
            i = h % this.keys.length;
            if (this.states[i] == 1) {
                if (this.keys[i] == key) {
                    E oldValue = this.values[i];
                    this.values[i] = value;
                    return oldValue;
                }
                int c = 1 + h % (this.keys.length - 2);
                do {
                    if ((i -= c) < 0) {
                        i += this.keys.length;
                    }
                    if (this.states[i] == 0 || this.states[i] == 2) break block5;
                } while (this.states[i] != 1 || this.keys[i] != key);
                E oldValue = this.values[i];
                this.values[i] = value;
                return oldValue;
            }
        }
        if (this.states[i] == 0) {
            ++this.used;
        }
        this.states[i] = 1;
        this.keys[i] = key;
        this.values[i] = value;
        ++this.size;
        this.ensureCapacity(this.used);
        return null;
    }

    @Override
    public Collection<E> values() {
        if (this.cvalues == null) {
            this.cvalues = new ValueCollection();
        }
        return this.cvalues;
    }

    public CharKeyOpenHashMap<E> clone() {
        try {
            CharKeyOpenHashMap c = (CharKeyOpenHashMap)super.clone();
            c.keys = new char[this.keys.length];
            System.arraycopy(this.keys, 0, c.keys, 0, this.keys.length);
            c.values = new Object[this.values.length];
            System.arraycopy(this.values, 0, c.values, 0, this.values.length);
            c.states = new byte[this.states.length];
            System.arraycopy(this.states, 0, c.states, 0, this.states.length);
            c.cvalues = null;
            c.ckeys = null;
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            return null;
        }
    }

    public /* synthetic */ Object clone() {
        return this.clone();
    }

    @Override
    public CharKeyMapIterator<E> entries() {
        return new 1();
    }

    @Override
    public void clear() {
        Arrays.fill(this.states, (byte)0);
        Arrays.fill(this.values, null);
        this.size = 0;
        this.used = 0;
    }

    @Override
    public boolean containsKey(char key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                return true;
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                return false;
            } while (this.states[i] != 1 || this.keys[i] != key);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int i = 0;
            while (i < this.states.length) {
                if (this.states[i] == 1 && this.values[i] == null) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.states.length) {
                if (this.states[i] == 1 && value.equals(this.values[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public E get(char key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                return this.values[i];
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                return null;
            } while (this.states[i] != 1 || this.keys[i] != key);
            return this.values[i];
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public E remove(char key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                E oldValue = this.values[i];
                this.values[i] = null;
                this.states[i] = 2;
                this.size += -1;
                return oldValue;
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                return null;
            } while (this.states[i] != 1 || this.keys[i] != key);
            E oldValue = this.values[i];
            this.values[i] = null;
            this.states[i] = 2;
            this.size += -1;
            return oldValue;
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.keys.length);
        CharKeyMapIterator<E> i = this.entries();
        while (i.hasNext()) {
            i.next();
            s.writeChar(i.getKey());
            s.writeObject(i.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.keys = new char[s.readInt()];
        this.states = new byte[this.keys.length];
        this.values = new Object[this.keys.length];
        this.used = this.size;
        int n = 0;
        while (n < this.size) {
            char key = s.readChar();
            Object value = s.readObject();
            int h = Math.abs(this.keyhash.hash(key));
            int i = h % this.keys.length;
            if (this.states[i] != 0) {
                int c = 1 + h % (this.keys.length - 2);
                do {
                    if ((i -= c) >= 0) continue;
                    i += this.keys.length;
                } while (this.states[i] != 0);
            }
            this.states[i] = 1;
            this.keys[i] = key;
            this.values[i] = value;
            ++n;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class 1
    implements CharKeyMapIterator<E> {
        int nextEntry = this.nextEntry(0);
        int lastEntry = -1;

        1() {
        }

        int nextEntry(int index) {
            while (index < CharKeyOpenHashMap.this.keys.length && CharKeyOpenHashMap.this.states[index] != 1) {
                ++index;
            }
            return index;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry < CharKeyOpenHashMap.this.keys.length;
        }

        @Override
        public void next() {
            if (!this.hasNext()) {
                Exceptions.endOfIterator();
            }
            this.lastEntry = this.nextEntry;
            this.nextEntry = this.nextEntry(this.nextEntry + 1);
        }

        @Override
        public void remove() {
            if (this.lastEntry == -1) {
                Exceptions.noElementToRemove();
            }
            ((CharKeyOpenHashMap)CharKeyOpenHashMap.this).states[this.lastEntry] = 2;
            ((CharKeyOpenHashMap)CharKeyOpenHashMap.this).values[this.lastEntry] = null;
            CharKeyOpenHashMap charKeyOpenHashMap = CharKeyOpenHashMap.this;
            charKeyOpenHashMap.size = charKeyOpenHashMap.size + -1;
            this.lastEntry = -1;
        }

        @Override
        public char getKey() {
            if (this.lastEntry == -1) {
                Exceptions.noElementToGet();
            }
            return CharKeyOpenHashMap.this.keys[this.lastEntry];
        }

        @Override
        public E getValue() {
            if (this.lastEntry == -1) {
                Exceptions.noElementToGet();
            }
            return CharKeyOpenHashMap.this.values[this.lastEntry];
        }

        static /* synthetic */ CharKeyOpenHashMap access$0(1 var0) {
            return var0.CharKeyOpenHashMap.this;
        }
    }

    private class KeySet
    extends AbstractCharSet {
        public void clear() {
            CharKeyOpenHashMap.this.clear();
        }

        public boolean contains(char v) {
            return CharKeyOpenHashMap.this.containsKey(v);
        }

        public CharIterator iterator() {
            return new 2();
        }

        public boolean remove(char v) {
            boolean result = CharKeyOpenHashMap.this.containsKey(v);
            if (result) {
                CharKeyOpenHashMap.this.remove(v);
            }
            return result;
        }

        public int size() {
            return CharKeyOpenHashMap.this.size;
        }

        class 2
        implements CharIterator {
            int nextEntry = this.nextEntry(0);
            int lastEntry = -1;

            2() {
            }

            int nextEntry(int index) {
                while (index < CharKeyOpenHashMap.this.keys.length && CharKeyOpenHashMap.this.states[index] != 1) {
                    ++index;
                }
                return index;
            }

            public boolean hasNext() {
                return this.nextEntry < CharKeyOpenHashMap.this.keys.length;
            }

            public char next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastEntry = this.nextEntry;
                this.nextEntry = this.nextEntry(this.nextEntry + 1);
                return CharKeyOpenHashMap.this.keys[this.lastEntry];
            }

            public void remove() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToRemove();
                }
                ((CharKeyOpenHashMap)((KeySet)KeySet.this).CharKeyOpenHashMap.this).states[this.lastEntry] = 2;
                ((CharKeyOpenHashMap)((KeySet)KeySet.this).CharKeyOpenHashMap.this).values[this.lastEntry] = null;
                CharKeyOpenHashMap charKeyOpenHashMap = CharKeyOpenHashMap.this;
                charKeyOpenHashMap.size = charKeyOpenHashMap.size + -1;
                this.lastEntry = -1;
            }

            static /* synthetic */ KeySet access$0(2 var0) {
                return var0.KeySet.this;
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueCollection
    extends AbstractCollection<E> {
        @Override
        public void clear() {
            CharKeyOpenHashMap.this.clear();
        }

        @Override
        public boolean contains(Object v) {
            return CharKeyOpenHashMap.this.containsValue(v);
        }

        @Override
        public Iterator<E> iterator() {
            return new 4();
        }

        @Override
        public int size() {
            return CharKeyOpenHashMap.this.size;
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class 4
        implements Iterator<E> {
            int nextEntry = this.nextEntry(0);
            int lastEntry = -1;

            4() {
            }

            int nextEntry(int index) {
                while (index < CharKeyOpenHashMap.this.keys.length && CharKeyOpenHashMap.this.states[index] != 1) {
                    ++index;
                }
                return index;
            }

            @Override
            public boolean hasNext() {
                return this.nextEntry < CharKeyOpenHashMap.this.keys.length;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastEntry = this.nextEntry;
                this.nextEntry = this.nextEntry(this.nextEntry + 1);
                return CharKeyOpenHashMap.this.values[this.lastEntry];
            }

            @Override
            public void remove() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToRemove();
                }
                ((CharKeyOpenHashMap)((ValueCollection)ValueCollection.this).CharKeyOpenHashMap.this).states[this.lastEntry] = 2;
                ((CharKeyOpenHashMap)((ValueCollection)ValueCollection.this).CharKeyOpenHashMap.this).values[this.lastEntry] = null;
                CharKeyOpenHashMap charKeyOpenHashMap = CharKeyOpenHashMap.this;
                charKeyOpenHashMap.size = charKeyOpenHashMap.size + -1;
                this.lastEntry = -1;
            }

            static /* synthetic */ ValueCollection access$0(4 var0) {
                return var0.ValueCollection.this;
            }
        }
    }
}

