/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.mail.executors;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.Datasources;
import com.uwyn.rife.database.DbBeanFetcher;
import com.uwyn.rife.database.DbQueryManager;
import com.uwyn.rife.database.DbRowProcessor;
import com.uwyn.rife.database.queries.Delete;
import com.uwyn.rife.database.queries.Update;
import com.uwyn.rife.database.querymanagers.generic.GenericQueryManager;
import com.uwyn.rife.database.querymanagers.generic.GenericQueryManagerFactory;
import com.uwyn.rife.database.querymanagers.generic.RestoreQuery;
import com.uwyn.rife.mail.MailQueueExecutor;
import com.uwyn.rife.mail.dao.Email;
import com.uwyn.rife.scheduler.Executor;
import com.uwyn.rife.scheduler.Task;
import com.uwyn.rife.scheduler.exceptions.SchedulerException;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class DatabaseMailQueueExecutor
extends Executor
implements MailQueueExecutor {
    private static Object sRunningMonitor = new Object();
    private static boolean sRunning = false;

    public boolean isDeliveryAllowed(Email email) {
        return true;
    }

    public boolean executeTask(Task task) {
        Class<?> clazz;
        Logger.getLogger("com.uwyn.rife.mail").finest("Running MailQueueExecutor.");
        String datasource_name = null;
        try {
            datasource_name = task.getTaskoptionValue("datasource");
        }
        catch (SchedulerException e) {
            Logger.getLogger("com.uwyn.rife.mail").severe("Unexpected error while obtaining the MailQueueExecutor's 'datasource' task option value.\n" + ExceptionUtils.getExceptionStackTrace(e));
        }
        if (datasource_name == null) {
            Logger.getLogger("com.uwyn.rife.mail").severe("Missing 'datasource' task option for the MailQueueExecutor.");
            return false;
        }
        String smtp_server = null;
        try {
            smtp_server = task.getTaskoptionValue("smtp_server");
        }
        catch (SchedulerException e) {
            Logger.getLogger("com.uwyn.rife.mail").severe("Unexpected error while obtaining the MailQueueExecutor's 'smtp_server' task option value.\n" + ExceptionUtils.getExceptionStackTrace(e));
        }
        String smtp_port = null;
        try {
            smtp_port = task.getTaskoptionValue("smtp_port");
        }
        catch (SchedulerException e) {
            Logger.getLogger("com.uwyn.rife.mail").severe("Unexpected error while obtaining the MailQueueExecutor's 'smtp_port' task option value.\n" + ExceptionUtils.getExceptionStackTrace(e));
        }
        if (smtp_port == null) {
            smtp_port = "25";
        }
        Datasource datasource = Datasources.getRepInstance().getDatasource(datasource_name);
        try {
            clazz = Class.forName("com.uwyn.rife.mail.dao.Email");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        GenericQueryManager<?> emails = GenericQueryManagerFactory.getInstance(datasource, clazz);
        Object object = sRunningMonitor;
        synchronized (object) {
            if (!sRunning) {
                Logger.getLogger("com.uwyn.rife.mail").finest("MailQueueExecutor not currently running, starting a new one.");
                sRunning = true;
                try {
                    Update flag_messages = new Update(datasource).table(emails.getTable()).field("queueFlag", true);
                    new DbQueryManager(datasource).executeUpdate(flag_messages);
                    Logger.getLogger("com.uwyn.rife.mail").finest("MailQueueExecutor's flags set, starting processing.");
                    Session session = null;
                    if (smtp_server != null && smtp_server.length() > 0) {
                        Properties props = new Properties();
                        props.put("mail.smtp.host", smtp_server);
                        props.put("mail.smtp.port", smtp_port);
                        session = Session.getDefaultInstance((Properties)props, null);
                    }
                    SendEmails send_emails = new SendEmails(datasource, session);
                    emails.restore((RestoreQuery)emails.getRestoreQuery().where("queueFlag", "=", true), (DbRowProcessor)send_emails);
                    Logger.getLogger("com.uwyn.rife.mail").info(send_emails.getCount() + " mails were sent successfully");
                    Delete delete_flagged = (Delete)new Delete(datasource).from(emails.getTable()).where("queueFlag", "=", true);
                    new DbQueryManager(datasource).executeUpdate(delete_flagged);
                    Logger.getLogger("com.uwyn.rife.mail").finest("MailQueueExecutor's queue cleared.");
                }
                finally {
                    sRunning = false;
                }
            } else {
                Logger.getLogger("com.uwyn.rife.mail").finest("MailQueueExecutor is currently RUNNING, not running another");
            }
        }
        Logger.getLogger("com.uwyn.rife.mail").finest("MailQueueExecutor run finished.");
        return true;
    }

    public String getHandledTasktype() {
        return "MailQueue";
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SendEmails
    extends DbBeanFetcher<Email> {
        private Session mSession;
        private int mCount;

        SendEmails(Datasource datasource, Session session) {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.mail.dao.Email");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            super(datasource, clazz);
            this.mSession = null;
            this.mCount = 0;
            this.mSession = session;
        }

        int getCount() {
            return this.mCount;
        }

        @Override
        public void gotBeanInstance(Email email) {
            block11: {
                if (this.mSession == null) {
                    Logger.getLogger("com.uwyn.rife.mail").warning(new StringBuffer().append("Email not sent since no 'smtp_server' task option has not been provided to the MailQueueExecutor.\n").append(email.toString()).toString());
                    return;
                }
                if (!DatabaseMailQueueExecutor.this.isDeliveryAllowed(email)) {
                    return;
                }
                MimeMessage message = new MimeMessage(this.mSession);
                try {
                    message.setFrom((Address)new InternetAddress(email.getFromAddress()));
                    message.setSubject(email.getSubject());
                    message.setText(email.getBody(), "UTF-8");
                    message.setSentDate(new Date());
                    int to_count = 0;
                    ArrayList<String> to_list = StringUtils.split(email.getToAddresses(), ",");
                    InternetAddress[] to_array = new InternetAddress[to_list.size()];
                    for (String to : (Collection)to_list) {
                        to_array[to_count++] = new InternetAddress(to);
                    }
                    message.setRecipients(Message.RecipientType.TO, (Address[])to_array);
                    int cc_count = 0;
                    ArrayList<String> cc_list = StringUtils.split(email.getCcAddresses(), ",");
                    InternetAddress[] cc_array = new InternetAddress[cc_list.size()];
                    for (String cc : (Collection)cc_list) {
                        cc_array[cc_count++] = new InternetAddress(cc);
                    }
                    message.setRecipients(Message.RecipientType.CC, (Address[])cc_array);
                    int bcc_count = 0;
                    ArrayList<String> bcc_list = StringUtils.split(email.getBccAddresses(), ",");
                    InternetAddress[] bcc_array = new InternetAddress[bcc_list.size()];
                    for (String bcc : (Collection)bcc_list) {
                        bcc_array[bcc_count++] = new InternetAddress(bcc);
                    }
                    message.setRecipients(Message.RecipientType.BCC, (Address[])bcc_array);
                }
                catch (MessagingException e) {
                    Logger.getLogger("com.uwyn.rife.mail").warning(new StringBuffer().append("Email not sent due to an error while building the message.\n").append(email.toString()).toString());
                }
                try {
                    Transport.send((Message)message);
                    ++this.mCount;
                    try {
                        Thread.currentThread();
                        Thread.sleep(300);
                        if (0 != this.mCount % 100) break block11;
                        Thread.currentThread();
                        Thread.sleep(10000);
                    }
                    catch (InterruptedException e3) {
                    }
                }
                catch (MessagingException e) {
                    Logger.getLogger("com.uwyn.rife.mail").severe(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Unexpected error while sending the MailQueueExecutor's email message '").append(message.toString()).toString()).append("'.\n").toString()).append(ExceptionUtils.getExceptionStackTrace(e)).toString());
                }
            }
        }

        @Override
        public /* synthetic */ void gotBeanInstance(Object object) {
            this.gotBeanInstance((Email)object);
        }

        static /* synthetic */ DatabaseMailQueueExecutor access$0(SendEmails sendEmails) {
            return sendEmails.DatabaseMailQueueExecutor.this;
        }
    }
}

