/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine.exceptions;

import com.uwyn.rife.engine.exceptions.EngineException;

public class DataLinkAmbiguousTargetException
extends EngineException {
    private String mSiteDeclarationName = null;
    private String mElementId = null;
    private String mOutputName = null;
    private String mOutbeanName = null;
    private String mInputName = null;
    private String mInbeanName = null;

    public DataLinkAmbiguousTargetException(String siteDeclarationName, String elementId, String outputName, String outbeanName, String inputName, String inbeanName) {
        super("The site '" + siteDeclarationName + "' has ambiguous targets defined for the datalink that originates at the " + (outputName == null ? "outbean '" + outbeanName + "'" : "output '" + outputName + "'") + " of element '" + elementId + "'" + (inputName == null && inbeanName == null ? "" : " towards " + (inputName == null ? "inbean '" + inbeanName + "'" : "input '" + inputName + "'")) + ". It points to an element id and snaps back at the same time.");
        this.mSiteDeclarationName = siteDeclarationName;
        this.mElementId = elementId;
        this.mOutputName = outputName;
        this.mOutbeanName = outbeanName;
        this.mInputName = inputName;
        this.mInbeanName = inbeanName;
    }

    public String getSiteDeclarationName() {
        return this.mSiteDeclarationName;
    }

    public String getElementId() {
        return this.mElementId;
    }

    public String getOutputName() {
        return this.mOutputName;
    }

    public String getOutbeanName() {
        return this.mOutbeanName;
    }

    public String getInputName() {
        return this.mInputName;
    }

    public String getInbeanName() {
        return this.mInbeanName;
    }
}

