/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine.elements;

import com.uwyn.rife.engine.Element;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.exceptions.PropertyRequiredException;
import com.uwyn.rife.tools.Localization;

public class Redirect
extends Element {
    public void processElement() {
        String url = null;
        String to = null;
        if (this.hasProperty("to")) {
            to = this.getPropertyString("to");
        }
        if ((to = Localization.extractLocalizedUrl(to)) == null) {
            throw new PropertyRequiredException(this.getDeclarationName(), "to");
        }
        String type = "url";
        if (this.hasProperty("type")) {
            type = this.getPropertyString("type");
        }
        if (type.equals("url")) {
            url = to;
        } else if (type.equals("element")) {
            ElementInfo element_info = this.getSite().resolveId(to, this.getElementInfo());
            if (element_info == null) {
                throw new IllegalArgumentException("The element '" + this.getDeclarationName() + "' specified an unknown element id '" + to + "' for redirection.");
            }
            url = element_info.getUrl();
        }
        if (url == null) {
            throw new IllegalArgumentException("The element '" + this.getDeclarationName() + "' declared an unsupported redirect type '" + type + "'.");
        }
        String redirect = null;
        if (url.startsWith("http:")) {
            redirect = url;
        } else {
            StringBuffer buffer;
            if (url.startsWith("/")) {
                StringBuffer buffer2;
                String root = this.getWebappRootUrl();
                root = root.substring(0, root.length() - 1);
                StringBuffer stringBuffer = buffer2 = new StringBuffer(root);
                synchronized (stringBuffer) {
                    buffer2.append(url);
                    redirect = buffer2.toString();
                }
            }
            String root = this.getWebappRootUrl();
            StringBuffer stringBuffer = buffer = new StringBuffer(root);
            synchronized (stringBuffer) {
                String element_url = this.getElementInfo().getUrl();
                int last_slash = element_url.lastIndexOf("/");
                if (last_slash != -1) {
                    buffer.append(element_url.substring(0, last_slash));
                }
                buffer.append(url);
                redirect = buffer.toString();
            }
        }
        this.sendRedirect(redirect);
    }
}

