/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.config.Config;
import com.uwyn.rife.engine.ElementInfoBuilder;
import com.uwyn.rife.engine.Scope;
import com.uwyn.rife.engine.SubmissionBuilder;
import com.uwyn.rife.engine.exceptions.ParsingErrorException;
import com.uwyn.rife.xml.Xml2Data;
import java.util.ArrayList;
import org.xml.sax.Attributes;

class XmlElementInfoProcessor
extends Xml2Data {
    private ElementInfoBuilder mElementInfoBuilder = null;
    private StringBuffer mCharacterData = null;
    private String mCurrentStaticProperty = null;
    private String mCurrentInput = null;
    private String mCurrentOutput = null;
    private String mCurrentIncookie = null;
    private String mCurrentOutcookie = null;
    private String mCurrentParameter = null;
    private ArrayList<String> mDefaults = null;
    private SubmissionBuilder mSubmissionBuilder = null;

    XmlElementInfoProcessor(ElementInfoBuilder builder) {
        this.mElementInfoBuilder = builder;
    }

    public void startDocument() {
        this.mCharacterData = null;
    }

    public void endDocument() {
        this.mCharacterData = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (qName.equals("element")) {
            this.mElementInfoBuilder.setImplementation(atts.getValue("implementation")).extendsFrom(atts.getValue("extends")).setContentType(atts.getValue("contenttype"));
            return;
        } else if (qName.equals("property")) {
            this.mCurrentStaticProperty = atts.getValue("name");
            this.mCharacterData = new StringBuffer();
            return;
        } else if (qName.equals("config")) {
            if (this.mCharacterData == null || !Config.hasRepInstance()) return;
            this.mCharacterData.append(Config.getRepInstance().getString(atts.getValue("param"), ""));
            return;
        } else if (qName.equals("input")) {
            this.mCurrentInput = atts.getValue("name");
            this.mDefaults = new ArrayList();
            return;
        } else if (qName.equals("inbean")) {
            String classname = atts.getValue("classname");
            String prefix = atts.getValue("prefix");
            String name = atts.getValue("name");
            this.mElementInfoBuilder.addInBean(classname, prefix, name);
            return;
        } else if (qName.equals("output")) {
            this.mCurrentOutput = atts.getValue("name");
            this.mDefaults = new ArrayList();
            return;
        } else if (qName.equals("outbean")) {
            String classname = atts.getValue("classname");
            String prefix = atts.getValue("prefix");
            String name = atts.getValue("name");
            this.mElementInfoBuilder.addOutBean(classname, prefix, name);
            return;
        } else if (qName.equals("incookie")) {
            this.mCurrentIncookie = atts.getValue("name");
            this.mDefaults = new ArrayList();
            return;
        } else if (qName.equals("outcookie")) {
            this.mCurrentOutcookie = atts.getValue("name");
            this.mDefaults = new ArrayList();
            return;
        } else if (qName.equals("childtrigger")) {
            this.mElementInfoBuilder.addChildTrigger(atts.getValue("name"));
            return;
        } else if (qName.equals("submission")) {
            this.mSubmissionBuilder = this.mElementInfoBuilder.enterSubmission(atts.getValue("name"));
            String scope_attr = atts.getValue("scope");
            this.mSubmissionBuilder.setScope(Scope.getScope(scope_attr));
            return;
        } else if (qName.equals("param")) {
            if (atts.getValue("name") != null && atts.getValue("regexp") != null) {
                throw new ParsingErrorException("element", this.getXmlPath(), "A submission parameter can't have both a name and a regexp attribute.", null);
            }
            if (atts.getValue("name") != null) {
                this.mCurrentParameter = atts.getValue("name");
                this.mDefaults = new ArrayList();
                return;
            } else {
                if (atts.getValue("regexp") == null) throw new ParsingErrorException("element", this.getXmlPath(), "A submission parameter needs either a name or a regexp attribute.", null);
                this.mSubmissionBuilder.addParameterRegexp(atts.getValue("regexp"));
                this.mDefaults = null;
            }
            return;
        } else if (qName.equals("bean")) {
            String classname = atts.getValue("classname");
            String prefix = atts.getValue("prefix");
            String name = atts.getValue("name");
            this.mSubmissionBuilder.addBean(classname, prefix, name);
            return;
        } else if (qName.equals("file")) {
            this.mSubmissionBuilder.addFile(atts.getValue("name"));
            return;
        } else if (qName.equals("default")) {
            this.mCharacterData = new StringBuffer();
            return;
        } else {
            if (!qName.equals("exit")) throw new ParsingErrorException("element", this.getXmlPath(), "Unsupport element name '" + qName + "'.", null);
            this.mElementInfoBuilder.addExit(atts.getValue("name"));
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (qName.equals("property")) {
            this.mElementInfoBuilder.addStaticProperty(this.mCurrentStaticProperty, this.mCharacterData.toString());
            this.mCharacterData = null;
        } else if (qName.equals("input")) {
            String[] defaults = null;
            if (this.mDefaults.size() > 0) {
                defaults = new String[this.mDefaults.size()];
                defaults = this.mDefaults.toArray(defaults);
            }
            this.mElementInfoBuilder.addInput(this.mCurrentInput, defaults);
            this.mCurrentInput = null;
            this.mDefaults = null;
        } else if (qName.equals("output")) {
            String[] defaults = null;
            if (this.mDefaults.size() > 0) {
                defaults = new String[this.mDefaults.size()];
                defaults = this.mDefaults.toArray(defaults);
            }
            this.mElementInfoBuilder.addOutput(this.mCurrentOutput, defaults);
            this.mCurrentOutput = null;
            this.mDefaults = null;
        } else if (qName.equals("incookie")) {
            String defaultValue = null;
            if (this.mDefaults.size() > 0) {
                defaultValue = this.mDefaults.get(0);
            }
            this.mElementInfoBuilder.addIncookie(this.mCurrentIncookie, defaultValue);
            this.mCurrentIncookie = null;
            this.mDefaults = null;
        } else if (qName.equals("outcookie")) {
            String defaultValue = null;
            if (this.mDefaults.size() > 0) {
                defaultValue = this.mDefaults.get(0);
            }
            this.mElementInfoBuilder.addOutcookie(this.mCurrentOutcookie, defaultValue);
            this.mCurrentOutcookie = null;
            this.mDefaults = null;
        } else if (qName.equals("submission")) {
            this.mSubmissionBuilder.leaveSubmission();
        } else if (qName.equals("param")) {
            if (this.mDefaults != null) {
                String[] defaults = null;
                if (this.mDefaults.size() > 0) {
                    defaults = new String[this.mDefaults.size()];
                    defaults = this.mDefaults.toArray(defaults);
                }
                this.mSubmissionBuilder.addParameter(this.mCurrentParameter, defaults);
            }
            this.mCurrentParameter = null;
            this.mDefaults = null;
        } else if (qName.equals("default")) {
            if (this.mDefaults == null) {
                throw new ParsingErrorException("element", this.getXmlPath(), "A submission parameter that's defined by a regular expression can't have default values.", null);
            }
            this.mDefaults.add(this.mCharacterData.toString());
            this.mCharacterData = null;
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (length > 0 && this.mCharacterData != null) {
            this.mCharacterData.append(String.copyValueOf(ch, start, length));
        }
    }
}

