/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.tools.ExceptionUtils;
import java.io.File;
import java.util.logging.Logger;

public class UploadedFile
implements Cloneable {
    private File mTempFile = null;
    private String mFilename = null;
    private String mType = null;
    private boolean mSizeExceeded = false;
    private static /* synthetic */ boolean $assertionsDisabled;

    UploadedFile(String filename, String type) {
        this.mFilename = filename;
        this.mType = type;
    }

    protected void finalize() throws Throwable {
        if (this.mTempFile != null) {
            this.mTempFile.delete();
        }
        super.finalize();
    }

    void setTempFile(File tempFile) {
        if (!$assertionsDisabled && tempFile == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !tempFile.exists()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !tempFile.isFile()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !tempFile.canRead()) {
            throw new AssertionError();
        }
        this.mTempFile = tempFile;
        this.mTempFile.deleteOnExit();
    }

    void setSizeExceeded(boolean exceeded) {
        this.mSizeExceeded = exceeded;
    }

    public String getType() {
        return this.mType;
    }

    public String getName() {
        return this.mFilename;
    }

    public File getFile() {
        return this.mTempFile;
    }

    public boolean wasSizeExceeded() {
        return this.mSizeExceeded;
    }

    public UploadedFile clone() {
        try {
            return (UploadedFile)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.site").severe(ExceptionUtils.getExceptionStackTrace(e));
            return null;
        }
    }

    public /* synthetic */ Object clone() {
        return this.clone();
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.UploadedFile");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

