/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.ElementInfo;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TriggerContext {
    private String mDeclarationName = null;
    private int mType = -1;
    private String mTriggerName = "";
    private String[] mTriggerValues = null;
    private Map<String, String[]> mParameters = new HashMap<String, String[]>();
    static final int TRIGGER_CHILD = 1;
    static final int TRIGGER_EXIT = 2;

    TriggerContext() {
        this.mTriggerValues = new String[0];
    }

    TriggerContext(String declarationName, int type) {
        this();
        this.mDeclarationName = declarationName;
        this.mType = type;
    }

    static TriggerContext generateChildTrigger(ElementInfo elementInfo, String name, String[] values, Map<String, String[]> inputs) {
        TriggerContext trigger_context = new TriggerContext(elementInfo.getDeclarationName(), 1);
        trigger_context.setTriggerName(name);
        trigger_context.setTriggerValues(values);
        trigger_context.setParameters(inputs);
        return trigger_context;
    }

    static TriggerContext generateExitTrigger(ElementInfo elementInfo, String name, Map<String, String[]> inputs) {
        TriggerContext trigger_context = new TriggerContext(elementInfo.getDeclarationName(), 2);
        trigger_context.setTriggerName(name);
        trigger_context.setParameters(inputs);
        return trigger_context;
    }

    void setDeclarationName(String declarationName) {
        this.mDeclarationName = declarationName;
    }

    String getDeclarationName() {
        return this.mDeclarationName;
    }

    void setType(int type) {
        this.mType = type;
    }

    int getType() {
        return this.mType;
    }

    void setTriggerName(String triggerName) {
        this.mTriggerName = triggerName;
    }

    String getTriggerName() {
        return this.mTriggerName;
    }

    void setTriggerValues(String[] triggerValues) {
        this.mTriggerValues = triggerValues;
    }

    String[] getTriggerValues() {
        return this.mTriggerValues;
    }

    void setParameters(Map<String, String[]> parameters) {
        this.mParameters = parameters;
    }

    Map<String, String[]> getParameters() {
        return this.mParameters;
    }

    String[] getParameterValues() {
        if (0 == this.mParameters.size()) {
            return null;
        }
        return this.mParameters.values().iterator().next();
    }
}

