/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.datastructures.EnumClass;
import com.uwyn.rife.engine.Groovy2Site;
import com.uwyn.rife.engine.Janino2Site;
import com.uwyn.rife.engine.SiteProcessor;
import com.uwyn.rife.engine.Xml2Site;
import java.util.Collection;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteProcessorFactory
extends EnumClass<String> {
    public static final String MANUAL_IDENTIFIER = "manual";
    public static final String XML_IDENTIFIER = "xml";
    public static final String GROOVY_IDENTIFIER = "groovy";
    public static final String JANINO_IDENTIFIER = "janino";
    public static final SiteProcessorFactory MANUAL = new SiteProcessorFactory("manual", null, null);
    public static final SiteProcessorFactory XML = new SiteProcessorFactory("xml", "xml", new Xml2Site());
    public static final SiteProcessorFactory GROOVY = new SiteProcessorFactory("groovy", "groovy", new Groovy2Site());
    public static final SiteProcessorFactory JANINO = new SiteProcessorFactory("janino", "janino", new Janino2Site());
    private String mExtension = null;
    private SiteProcessor mProcessor = null;

    public SiteProcessorFactory(String identifier, String extension, SiteProcessor processor) {
        super(identifier);
        this.mExtension = extension;
        this.mProcessor = processor;
    }

    public String getExtension() {
        return this.mExtension;
    }

    public SiteProcessor getProcessor() {
        return this.mProcessor;
    }

    public static SiteProcessorFactory getSiteProcessorFactory(String identifier) {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.SiteProcessorFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return (SiteProcessorFactory)EnumClass.getMember(clazz, identifier);
    }

    public static Collection<SiteProcessorFactory> getSiteProcessorFactories() {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.SiteProcessorFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return EnumClass.getMembers(clazz);
    }
}

