/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.engine.BeanDeclaration;
import com.uwyn.rife.engine.DataLink;
import com.uwyn.rife.engine.DataLinkDeclaration;
import com.uwyn.rife.engine.ElementDeclaration;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.ElementInfoBuilder;
import com.uwyn.rife.engine.FlowLink;
import com.uwyn.rife.engine.FlowLinkDeclaration;
import com.uwyn.rife.engine.GlobalExit;
import com.uwyn.rife.engine.GlobalVar;
import com.uwyn.rife.engine.GroupDeclaration;
import com.uwyn.rife.engine.Site;
import com.uwyn.rife.engine.SiteProcessor;
import com.uwyn.rife.engine.SiteProcessorFactory;
import com.uwyn.rife.engine.StateStore;
import com.uwyn.rife.engine.StateStoreFactory;
import com.uwyn.rife.engine.SubsiteDeclaration;
import com.uwyn.rife.engine.exceptions.CircularSubsitesException;
import com.uwyn.rife.engine.exceptions.DataLinkBeanErrorException;
import com.uwyn.rife.engine.exceptions.DataLinkUnknownDestInbeanException;
import com.uwyn.rife.engine.exceptions.DataLinkUnknownSrcOutbeanException;
import com.uwyn.rife.engine.exceptions.ElementIdNotFoundInSiteException;
import com.uwyn.rife.engine.exceptions.ElementIdNotFoundSiteIdExistsException;
import com.uwyn.rife.engine.exceptions.ElementUrlInvalidException;
import com.uwyn.rife.engine.exceptions.GlobalBeanErrorException;
import com.uwyn.rife.engine.exceptions.GlobalBeanNotFoundException;
import com.uwyn.rife.engine.exceptions.GlobalExitAmbiguousTargetException;
import com.uwyn.rife.engine.exceptions.GlobalExitTargetRequiredException;
import com.uwyn.rife.engine.exceptions.LocalElementIdRequiredException;
import com.uwyn.rife.engine.exceptions.MissingImplementationException;
import com.uwyn.rife.engine.exceptions.SiteProcessorExtensionUnsupportedException;
import com.uwyn.rife.engine.exceptions.SiteProcessorIdentifierUnsupportedException;
import com.uwyn.rife.engine.exceptions.StateStoreUnknownException;
import com.uwyn.rife.engine.exceptions.SubsiteIdInvalidException;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.site.Constrained;
import com.uwyn.rife.site.ConstrainedUtils;
import com.uwyn.rife.tools.BeanUtils;
import com.uwyn.rife.tools.FileUtils;
import com.uwyn.rife.tools.Localization;
import com.uwyn.rife.tools.StringUtils;
import com.uwyn.rife.tools.exceptions.BeanUtilsException;
import com.uwyn.rife.xml.exceptions.XmlErrorException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.Stack;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteBuilder {
    private ResourceFinder mResourceFinder = null;
    private SiteBuilder mParent = null;
    private SubsiteDeclaration mSubsiteDeclaration = null;
    private boolean mProcessed = false;
    private String mDeclarationName = null;
    private String mSiteId = null;
    private String mUrlPrefix = null;
    private Stack<StateStore> mStateStores = null;
    private HashSet<String> mSubsiteHistory = null;
    private Site mSite = null;
    private Stack<GroupDeclaration> mGroupDeclarationsStack = null;
    private ArrayList<GroupDeclaration> mGroupDeclarations = null;
    private String mFallbackElementId = null;
    private String mArrivalElementId = null;
    private ElementDeclaration mArrivalElementDeclaration = null;
    private ArrayList<String> mDepartureIds = null;
    private HashMap<String, ElementDeclaration> mElementIdMapping = null;
    private ArrayList<ElementDeclaration> mElementDeclarations = null;
    private HashMap<String, SubsiteDeclaration> mSubsiteIdMapping = null;
    private ArrayList<SubsiteDeclaration> mSubsiteDeclarations = null;
    private HashMap<String, HashSet<DataLinkDeclaration>> mDataLinkMapping = null;
    private HashMap<String, HashSet<FlowLinkDeclaration>> mFlowLinkMapping = null;
    private HashMap<String, Object> mProperties = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    public SiteBuilder(String declarationName, ResourceFinder resourceFinder) {
        if (declarationName == null) {
            throw new IllegalArgumentException("declarationName can't be null.");
        }
        if (resourceFinder == null) {
            throw new IllegalArgumentException("resourceFinder can't be null.");
        }
        this.mResourceFinder = resourceFinder;
        this.initialize(declarationName);
    }

    SiteBuilder(String declarationName, ResourceFinder resourceFinder, SiteBuilder parent, SubsiteDeclaration subsite) {
        if (!$assertionsDisabled && declarationName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && resourceFinder == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parent == this) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && subsite == null) {
            throw new AssertionError();
        }
        this.mResourceFinder = resourceFinder;
        this.mParent = parent;
        this.mSubsiteDeclaration = subsite;
        this.initialize(declarationName);
    }

    private SiteBuilder initialize(String declarationName) {
        this.mDeclarationName = declarationName;
        if (this.getParent() == null) {
            this.mSite = new Site();
            this.mSite.setDeclarationName(this.mDeclarationName);
            if (RifeConfig.Engine.getSiteAutoReload()) {
                this.mSite.setResourceFinder(this.mResourceFinder);
            }
            this.mStateStores = new Stack();
            this.mStateStores.push(StateStoreFactory.getInstance("query"));
            this.mGroupDeclarationsStack = new Stack();
            this.mGroupDeclarations = new ArrayList();
            this.mSubsiteHistory = new HashSet();
            this.addGroupDeclaration(new GroupDeclaration(this, declarationName));
        } else {
            this.mSite = this.mParent.mSite;
            this.mStateStores = this.mSubsiteDeclaration.getStateStores();
            this.mSubsiteHistory = new HashSet<String>(this.getParent().mSubsiteHistory);
            this.mGroupDeclarationsStack = new Stack();
            this.mGroupDeclarations = new ArrayList();
            this.addGroupDeclaration(this.mSubsiteDeclaration.getGroupDeclaration());
        }
        if (this.mSubsiteHistory.contains(declarationName)) {
            throw new CircularSubsitesException(declarationName);
        }
        this.mSubsiteHistory.add(declarationName);
        this.mFallbackElementId = null;
        this.mArrivalElementId = null;
        this.mArrivalElementDeclaration = null;
        this.mDepartureIds = new ArrayList();
        this.mElementIdMapping = new HashMap();
        this.mElementDeclarations = new ArrayList();
        this.mSubsiteIdMapping = new HashMap();
        this.mSubsiteDeclarations = new ArrayList();
        this.mDataLinkMapping = new HashMap();
        this.mFlowLinkMapping = new HashMap();
        return this;
    }

    public synchronized Site getSite() {
        SiteBuilder root = this.getRoot();
        if (!this.mProcessed) {
            root.process();
        }
        return root.mSite;
    }

    private synchronized void process() {
        String declaration = this.mDeclarationName;
        SiteProcessorFactory processor_factory = null;
        String identifier = "manual";
        int identifier_index = this.mDeclarationName.indexOf(":");
        int extension_index = this.mDeclarationName.lastIndexOf(".");
        if (identifier_index != -1) {
            identifier = this.mDeclarationName.substring(0, identifier_index);
            declaration = this.mDeclarationName.substring(identifier_index + 1);
            processor_factory = SiteProcessorFactory.getSiteProcessorFactory(identifier);
        } else if (extension_index != -1) {
            String extension = this.mDeclarationName.substring(extension_index + 1);
            Collection<SiteProcessorFactory> factories = SiteProcessorFactory.getSiteProcessorFactories();
            for (SiteProcessorFactory factory : factories) {
                if (factory.getExtension() == null || !factory.getExtension().equals(extension)) continue;
                processor_factory = factory;
                break;
            }
            if (processor_factory == null) {
                throw new SiteProcessorExtensionUnsupportedException(this.mDeclarationName, extension);
            }
        } else {
            processor_factory = SiteProcessorFactory.getSiteProcessorFactory(identifier);
        }
        if (processor_factory == null) {
            throw new SiteProcessorIdentifierUnsupportedException(this.mDeclarationName, identifier);
        }
        SiteProcessor processor = processor_factory.getProcessor();
        if (processor != null) {
            processor.processSite(this, declaration, this.mResourceFinder);
        }
        this.finish();
        this.mProcessed = true;
    }

    private synchronized void finish() {
        this.setupData();
        if (this.getParent() == null) {
            this.processData();
            this.createInheritanceStacks();
            this.createPrecedenceStacks();
        }
    }

    public SiteBuilder setFallback(String fallbackElementId) {
        this.mFallbackElementId = this.ensureLocalElementId(fallbackElementId);
        return this;
    }

    public SiteBuilder enterSubsite(String declarationName) {
        GroupDeclaration group_declaration = new GroupDeclaration(this, declarationName, this.getCurrentGroupDeclaration());
        SubsiteDeclaration subsite_declaration = new SubsiteDeclaration(declarationName, group_declaration, this.mStateStores);
        this.mSubsiteDeclarations.add(subsite_declaration);
        SiteBuilder builder = new SiteBuilder(subsite_declaration.getDeclarationName(), this.mResourceFinder, this, subsite_declaration);
        subsite_declaration.setSiteBuilder(builder);
        group_declaration.setActiveSiteBuilder(builder);
        return builder;
    }

    public SiteBuilder setId(String id) {
        if (id != null && 0 == id.length()) {
            throw new SubsiteIdInvalidException(id);
        }
        if (this.mSubsiteDeclaration != null) {
            this.mSubsiteDeclaration.setId(id);
        }
        return this;
    }

    public SiteBuilder setUrlPrefix(String urlPrefix) {
        if (this.mSubsiteDeclaration != null) {
            this.mSubsiteDeclaration.setUrlPrefix(Localization.extractLocalizedUrl(urlPrefix));
        }
        return this;
    }

    public SiteBuilder leaveSubsite() {
        return this.mParent;
    }

    public SiteBuilder enterGroup() {
        this.addGroupDeclaration(new GroupDeclaration(this, this.mDeclarationName, this.getCurrentGroupDeclaration()));
        return this;
    }

    public SiteBuilder leaveGroup() {
        this.mGroupDeclarationsStack.pop();
        return this;
    }

    public SiteBuilder setInherits(String inherits) {
        this.getCurrentGroupDeclaration().setInherits(inherits);
        return this;
    }

    public SiteBuilder setPre(String pre) {
        this.getCurrentGroupDeclaration().setPre(pre);
        return this;
    }

    public SiteBuilder addGlobalBean(String classname, String prefix, String name) {
        GroupDeclaration group = this.getCurrentGroupDeclaration();
        try {
            Class<?> bean_class = Class.forName(classname);
            if (name != null) {
                group.addNamedGlobalBean(name, new BeanDeclaration(classname, prefix));
            }
            try {
                Constrained constrained = ConstrainedUtils.getConstrainedInstance(bean_class);
                SortedSet<String> properties = BeanUtils.getPropertyNames(bean_class, null, null, prefix);
                for (String property : (Collection)properties) {
                    if (!ConstrainedUtils.editConstrainedProperty(constrained, property, prefix)) continue;
                    group.addGlobalVar(property, new GlobalVar(null));
                }
            }
            catch (BeanUtilsException e) {
                throw new GlobalBeanErrorException(this.mDeclarationName, classname, e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new GlobalBeanNotFoundException(this.mDeclarationName, classname, e);
        }
        return this;
    }

    public SiteBuilder addGlobalExit(String name, String destId) {
        return this.addGlobalExit(name, destId, false, false, false, false);
    }

    public SiteBuilder addReflectiveGlobalExit(String name) {
        return this.addGlobalExit(name, null, true, false, false, false);
    }

    public SiteBuilder addSnapbackGlobalExit(String name) {
        return this.addGlobalExit(name, null, false, true, false, false);
    }

    public SiteBuilder addRedirectGlobalExit(String name) {
        return this.addGlobalExit(name, null, false, false, false, true);
    }

    public SiteBuilder addGlobalExit(String name, String destId, boolean reflective, boolean snapback, boolean cancelInheritance, boolean redirect) {
        if (destId == null && !reflective && !snapback) {
            throw new GlobalExitTargetRequiredException(this.mDeclarationName, name);
        }
        if (destId == null && reflective && snapback) {
            throw new GlobalExitAmbiguousTargetException(this.mDeclarationName, name);
        }
        if (destId != null && (reflective || snapback)) {
            throw new GlobalExitAmbiguousTargetException(this.mDeclarationName, name);
        }
        GlobalExit globalexit = new GlobalExit(destId, reflective, snapback, cancelInheritance, redirect);
        this.getCurrentGroupDeclaration().addGlobalExit(name, globalexit);
        return this;
    }

    public SiteBuilder setArrival(String destId) {
        this.mArrivalElementId = this.ensureLocalElementId(destId);
        return this;
    }

    public SiteBuilder addDeparture(String srcId) {
        this.mDepartureIds.add(this.ensureLocalElementId(srcId));
        return this;
    }

    public SiteBuilder enterState(String store) {
        StateStore state_store = StateStoreFactory.getInstance(store);
        if (state_store == null) {
            throw new StateStoreUnknownException(this.mDeclarationName, store);
        }
        this.mStateStores.push(state_store);
        return this;
    }

    public SiteBuilder leaveState() {
        this.mStateStores.pop();
        return this;
    }

    public ElementInfoBuilder enterElement(String declarationName) {
        ElementDeclaration declaration = new ElementDeclaration(this, this.mResourceFinder, this.getCurrentGroupDeclaration(), this.mStateStores.peek(), declarationName);
        this.addElementDeclaration(declaration);
        return declaration.getElementInfoBuilder();
    }

    public SiteBuilder addGlobalVar(String name) {
        return this.addGlobalVar(name, null);
    }

    public SiteBuilder addGlobalVar(String name, String[] defaultValues) {
        this.getCurrentGroupDeclaration().addGlobalVar(name, new GlobalVar(defaultValues));
        return this;
    }

    public SiteBuilder addGlobalCookie(String name) {
        return this.addGlobalCookie(name, null);
    }

    public SiteBuilder addGlobalCookie(String name, String defaultValue) {
        this.getCurrentGroupDeclaration().addGlobalCookie(name, defaultValue);
        return this;
    }

    public SiteBuilder addProperty(String name, Object value) {
        if (this.mProperties == null) {
            this.mProperties = new HashMap();
        }
        this.mProperties.put(name, value);
        return this;
    }

    private SiteBuilder addGroupDeclaration(GroupDeclaration groupDeclaration) {
        this.mGroupDeclarationsStack.push(groupDeclaration);
        this.mGroupDeclarations.add(groupDeclaration);
        return this;
    }

    private void addElementDeclaration(ElementDeclaration elementDeclaration) {
        this.mElementDeclarations.add(elementDeclaration);
    }

    private GroupDeclaration getCurrentGroupDeclaration() {
        return this.mGroupDeclarationsStack.peek();
    }

    private String getFallbackElementId() {
        return this.mFallbackElementId;
    }

    private String getId() {
        if (this.mSiteId != null) {
            return this.mSiteId;
        }
        this.mSiteId = this.mParent == null ? "." : new StringBuffer().append(new StringBuffer().append(this.getParent().getId()).append(this.mSubsiteDeclaration.getId()).toString()).append(".").toString();
        return this.mSiteId;
    }

    private SiteBuilder getRoot() {
        SiteBuilder current = this;
        while (current.getParent() != null) {
            current = current.getParent();
        }
        return current;
    }

    private SiteBuilder getParent() {
        return this.mParent;
    }

    private Collection<ElementDeclaration> getElementDeclarations() {
        return this.mElementDeclarations;
    }

    private Collection<SubsiteDeclaration> getSubsiteDeclarations() {
        return this.mSubsiteDeclarations;
    }

    private ElementDeclaration getArrival() {
        return this.mArrivalElementDeclaration;
    }

    private ElementDeclaration getGlobalElementDeclaration(String id) {
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError();
        }
        if (!id.startsWith(".")) {
            id = new StringBuffer().append(this.getId()).append(id).toString();
        }
        id = Site.getCanonicalId(id);
        ArrayList<String> id_parts = StringUtils.split(id, ".");
        int id_part_counter = 0;
        SiteBuilder current_site = this.getRoot();
        id_parts.remove(0);
        for (String id_part : (Collection)id_parts) {
            if (++id_part_counter < id_parts.size()) {
                String element_injection = id.substring(current_site.getId().length());
                if (current_site.mElementIdMapping.containsKey(element_injection)) {
                    return current_site.mElementIdMapping.get(element_injection);
                }
                if (current_site.mSubsiteIdMapping.containsKey(id_part)) {
                    current_site = current_site.mSubsiteIdMapping.get(id_part).getSiteBuilder();
                    continue;
                }
                return null;
            }
            if (current_site.mElementIdMapping.containsKey(id_part)) {
                return current_site.mElementIdMapping.get(id_part);
            }
            if (!current_site.mSubsiteIdMapping.containsKey(id_part)) continue;
            return current_site.mSubsiteIdMapping.get(id_part).getSiteBuilder().getArrival();
        }
        return null;
    }

    private ElementDeclaration getElementDeclaration(String id) {
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError();
        }
        if (this.mElementIdMapping.containsKey(id)) {
            return this.mElementIdMapping.get(id);
        }
        if (this.mSubsiteIdMapping.containsKey(id)) {
            return this.mSubsiteIdMapping.get(id).getSiteBuilder().getArrival();
        }
        return null;
    }

    private ElementInfo getElementInfo(String id) {
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError();
        }
        ElementDeclaration element_declaration = this.getElementDeclaration(id);
        if (element_declaration != null) {
            return element_declaration.getElementInfo();
        }
        return null;
    }

    private void setupElements() {
        ElementInfo element_info = null;
        for (ElementDeclaration element_declaration : this.getElementDeclarations()) {
            if (this.mElementIdMapping.containsKey(element_declaration.getId())) {
                throw new XmlErrorException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Element id '").append(element_declaration.getId()).toString()).append("' has already been registered to the element '").toString()).append(this.mElementIdMapping.get(element_declaration.getId()).getDeclarationName()).toString()).append("', it's not possible to register it again for element '").toString()).append(element_declaration.getDeclarationName()).toString()).append("'.").toString());
            }
            if (this.mSubsiteIdMapping.containsKey(element_declaration.getId())) {
                throw new XmlErrorException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Element id '").append(element_declaration.getId()).toString()).append("' has already been registered to the subsite '").toString()).append(this.mSubsiteIdMapping.get(element_declaration.getId()).getDeclarationName()).toString()).append("'.").toString());
            }
            if (this.mProperties != null) {
                for (Map.Entry entry : (Collection)this.mProperties.entrySet()) {
                    element_declaration.addProperty((String)entry.getKey(), entry.getValue());
                }
            }
            ElementInfoBuilder builder = element_declaration.getElementInfoBuilder();
            builder.process();
            element_info = builder.getElementInfo(element_declaration.getGroup().getGlobalExitsMerged(), element_declaration.getGroup().getGlobalVarsMerged(), element_declaration.getGroup().getGlobalCookiesMerged(), element_declaration.getGroup().getNamedGlobalBeansMerged());
            element_info.setGroupId(element_declaration.getGroup().getGroupId());
            String element_url = element_declaration.getUrl();
            if (element_url != null) {
                String url_prefix;
                if (element_url.endsWith("/") || 0 == element_url.length()) {
                    throw new ElementUrlInvalidException(element_declaration.getId(), element_url);
                }
                if (element_url.length() > 0 && !element_url.startsWith("/")) {
                    element_url = new StringBuffer().append("/").append(element_url).toString();
                }
                if ((url_prefix = this.getUrlPrefix()).endsWith("/") && element_url.startsWith("/")) {
                    StringBuffer buffer;
                    url_prefix = StringUtils.stripFromEnd(url_prefix, "/");
                    element_url = StringUtils.stripFromFront(element_url, "/");
                    StringBuffer stringBuffer = buffer = new StringBuffer(url_prefix);
                    synchronized (stringBuffer) {
                        buffer.append("/");
                        buffer.append(element_url);
                        element_url = buffer.toString();
                    }
                } else {
                    element_url = new StringBuffer().append(url_prefix).append(element_url).toString();
                }
                if (element_url.endsWith("/*")) {
                    element_url = element_url.substring(0, element_url.length() - 2);
                    element_info.setPathInfoUsed(true);
                }
            }
            if (element_info.getImplementation() == null) {
                throw new MissingImplementationException(element_declaration.getDeclarationName());
            }
            element_info.setProperties(element_declaration.getProperties());
            element_info.setStateStore(element_declaration.getStateStore());
            element_declaration.setElementInfo(element_info);
            this.mSite.addElementInfo(new StringBuffer().append(this.getId()).append(element_declaration.getId()).toString(), element_info, element_url);
            this.mElementIdMapping.put(element_declaration.getId(), element_declaration);
            element_info.deploy();
        }
    }

    private void setupSubsites() {
        for (SubsiteDeclaration subsite : (Collection)this.mSubsiteDeclarations) {
            SiteBuilder subsite_builder = subsite.getSiteBuilder();
            if (this.mProperties != null) {
                for (Map.Entry entry : (Collection)this.mProperties.entrySet()) {
                    subsite_builder.addProperty((String)entry.getKey(), entry.getValue());
                }
            }
            subsite_builder.process();
            if (this.mElementIdMapping.containsKey(subsite.getId())) {
                throw new XmlErrorException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Subsite id '").append(subsite.getId()).toString()).append("' has already been registered to the element '").toString()).append(this.mElementIdMapping.get(subsite.getId()).getDeclarationName()).toString()).append("'.").toString());
            }
            if (this.mSubsiteIdMapping.containsKey(subsite.getId())) {
                throw new XmlErrorException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Subsite id '").append(subsite.getId()).toString()).append("' has already been registered to the subsite '").toString()).append(this.mSubsiteIdMapping.get(subsite.getId()).getDeclarationName()).toString()).append("'.").toString());
            }
            this.mSubsiteIdMapping.put(subsite.getId(), subsite);
        }
    }

    private void setupArrivalElement() {
        if (this.mArrivalElementId != null) {
            this.mArrivalElementDeclaration = this.getElementDeclaration(this.mArrivalElementId);
            if (this.mArrivalElementDeclaration == null) {
                this.elementIdNotFound(this.mArrivalElementId);
            }
            this.mArrivalElementDeclaration = this.mArrivalElementDeclaration.clone();
            this.mArrivalElementDeclaration.setId("");
            this.addElementDeclaration(this.mArrivalElementDeclaration);
            this.mElementIdMapping.put("", this.mArrivalElementDeclaration);
        }
    }

    private void processSubsites() {
        for (SubsiteDeclaration subsite : (Collection)this.mSubsiteDeclarations) {
            subsite.getSiteBuilder().processData();
        }
    }

    private void processGlobalExits() {
        ElementInfo element_info = null;
        for (ElementDeclaration element_declaration : this.getElementDeclarations()) {
            element_info = element_declaration.getElementInfo();
            LinkedHashMap<String, GlobalExit> global_exits = element_declaration.getGroup().getGlobalExitsMerged();
            String global_exit_name = null;
            GlobalExit global_exit = null;
            FlowLink flowlink = null;
            for (Map.Entry global_exit_entry : (Collection)global_exits.entrySet()) {
                global_exit_name = (String)global_exit_entry.getKey();
                global_exit = (GlobalExit)global_exit_entry.getValue();
                element_info.addExit(global_exit_name);
                HashSet<FlowLinkDeclaration> flowlinks = this.mFlowLinkMapping.get(element_declaration.getId());
                if (flowlinks == null) {
                    flowlinks = new HashSet();
                    this.mFlowLinkMapping.put(element_declaration.getId(), flowlinks);
                }
                if (global_exit.isReflective()) {
                    flowlink = new FlowLink(global_exit_name, element_info, false, false, global_exit.isRedirect());
                    element_info.setFlowLink(flowlink);
                    Collection<String> input_names = element_info.getInputNames();
                    Collection<String> output_names = element_info.getOutputNames();
                    DataLinkDeclaration datalink = null;
                    for (String input_name : input_names) {
                        if (!output_names.contains(input_name)) continue;
                        datalink = new DataLinkDeclaration(input_name, null, element_declaration.getId(), false, input_name, null);
                        HashSet<DataLinkDeclaration> datalinks = this.mDataLinkMapping.get(element_declaration.getId());
                        if (datalinks == null) {
                            datalinks = new HashSet();
                            this.mDataLinkMapping.put(element_declaration.getId(), datalinks);
                        }
                        if (datalinks.contains(datalink)) continue;
                        datalinks.add(datalink);
                    }
                    continue;
                }
                ElementDeclaration target_elementdeclaration = null;
                String globalexit_destid = global_exit.getDestId();
                if (globalexit_destid != null) {
                    target_elementdeclaration = this.getGlobalElementDeclaration(globalexit_destid);
                    if (target_elementdeclaration == null) {
                        this.elementIdNotFound(global_exit.getDestId());
                    }
                    global_exit.setTarget(target_elementdeclaration.getElementInfo());
                }
                flowlinks.add(new FlowLinkDeclaration(global_exit_name, globalexit_destid, global_exit.isSnapback(), global_exit.cancelInheritance(), global_exit.isRedirect()));
            }
        }
    }

    private void elementIdNotFound(String elementId) {
        if (this.mSubsiteIdMapping.containsKey(elementId)) {
            throw new ElementIdNotFoundSiteIdExistsException(this.mSiteId, elementId);
        }
        throw new ElementIdNotFoundInSiteException(this.mSiteId, elementId);
    }

    private void processFlowLinks() {
        ElementDeclaration current_elementdeclaration = null;
        ElementDeclaration target_elementdeclaration = null;
        HashSet<FlowLinkDeclaration> flowlinks = null;
        String flowlink_destid = null;
        ElementInfo flowlink_target_elementinfo = null;
        boolean flowlink_snapback = false;
        FlowLink flowlink = null;
        for (String current_elementid : (Collection)this.mFlowLinkMapping.keySet()) {
            current_elementdeclaration = this.getElementDeclaration(current_elementid);
            flowlinks = this.mFlowLinkMapping.get(current_elementid);
            for (FlowLinkDeclaration flowlink_declaration : (Collection)flowlinks) {
                flowlink_destid = flowlink_declaration.getDestId();
                flowlink_snapback = flowlink_declaration.isSnapback();
                flowlink_target_elementinfo = null;
                if (flowlink_destid != null) {
                    target_elementdeclaration = this.getGlobalElementDeclaration(flowlink_destid);
                    if (target_elementdeclaration == null) {
                        this.elementIdNotFound(flowlink_declaration.getDestId());
                    }
                    flowlink_target_elementinfo = target_elementdeclaration.getElementInfo();
                }
                flowlink = new FlowLink(flowlink_declaration.getSrcExit(), flowlink_target_elementinfo, flowlink_snapback, flowlink_declaration.cancelInheritance(), flowlink_declaration.isRedirect());
                current_elementdeclaration.getElementInfo().setFlowLink(flowlink);
            }
        }
    }

    private void processDataLinks() {
        ElementDeclaration current_elementdeclaration = null;
        ElementDeclaration target_elementdeclaration = null;
        HashSet<DataLinkDeclaration> datalinks = null;
        String datalink_destid = null;
        DataLink datalink = null;
        for (String current_elementid : (Collection)this.mDataLinkMapping.keySet()) {
            current_elementdeclaration = this.getElementDeclaration(current_elementid);
            datalinks = this.mDataLinkMapping.get(current_elementid);
            for (DataLinkDeclaration datalink_declaration : (Collection)datalinks) {
                if (datalink_declaration.isSnapback()) {
                    target_elementdeclaration = current_elementdeclaration;
                } else {
                    datalink_destid = datalink_declaration.getDestId();
                    target_elementdeclaration = this.getGlobalElementDeclaration(datalink_destid);
                    if (target_elementdeclaration == null) {
                        this.elementIdNotFound(datalink_declaration.getDestId());
                    }
                }
                if (datalink_declaration.transfersBean()) {
                    if (!current_elementdeclaration.getElementInfo().containsNamedOutbean(datalink_declaration.getSrcOutbean())) {
                        throw new DataLinkUnknownSrcOutbeanException(this.mDeclarationName, datalink_declaration.getSrcOutbean(), current_elementid, datalink_declaration.getDestId(), datalink_declaration.isSnapback());
                    }
                    if (!target_elementdeclaration.getElementInfo().containsNamedInbean(datalink_declaration.getDestInbean())) {
                        throw new DataLinkUnknownDestInbeanException(this.mDeclarationName, datalink_declaration.getDestInbean(), current_elementid, datalink_declaration.getDestId(), datalink_declaration.isSnapback());
                    }
                    BeanDeclaration srcoutbean = current_elementdeclaration.getElementInfo().getNamedOutbeanInfo(datalink_declaration.getSrcOutbean());
                    BeanDeclaration destinbean = target_elementdeclaration.getElementInfo().getNamedInbeanInfo(datalink_declaration.getDestInbean());
                    Class<?> srcoutbean_class = null;
                    Class<?> destinbean_class = null;
                    try {
                        srcoutbean_class = Class.forName(srcoutbean.getClassname());
                        destinbean_class = Class.forName(destinbean.getClassname());
                    }
                    catch (ClassNotFoundException e) {
                        throw new DataLinkBeanErrorException(this.mDeclarationName, datalink_declaration.getSrcOutbean(), current_elementid, datalink_declaration.getDestId(), datalink_declaration.isSnapback(), datalink_declaration.getDestInbean(), e);
                    }
                    Constrained constrained_destinbean = ConstrainedUtils.getConstrainedInstance(destinbean_class);
                    SortedSet<String> srcoutbean_properties = null;
                    SortedSet<String> destinbean_properties = null;
                    try {
                        srcoutbean_properties = BeanUtils.getPropertyNames(srcoutbean_class, null, null, srcoutbean.getPrefix());
                        destinbean_properties = BeanUtils.getPropertyNames(destinbean_class, null, null, destinbean.getPrefix());
                    }
                    catch (BeanUtilsException e) {
                        throw new DataLinkBeanErrorException(this.mDeclarationName, datalink_declaration.getSrcOutbean(), current_elementid, datalink_declaration.getDestId(), datalink_declaration.isSnapback(), datalink_declaration.getDestInbean(), e);
                    }
                    for (String srcoutbean_property : (Collection)srcoutbean_properties) {
                        if (!destinbean_properties.contains(srcoutbean_property) || !ConstrainedUtils.editConstrainedProperty(constrained_destinbean, srcoutbean_property, srcoutbean.getPrefix())) continue;
                        datalink = datalink_declaration.isSnapback() ? new DataLink(srcoutbean_property, null, datalink_declaration.isSnapback(), srcoutbean_property) : new DataLink(srcoutbean_property, target_elementdeclaration.getElementInfo(), datalink_declaration.isSnapback(), srcoutbean_property);
                        current_elementdeclaration.getElementInfo().addDataLink(datalink);
                    }
                    continue;
                }
                datalink = datalink_declaration.isSnapback() ? new DataLink(datalink_declaration.getSrcOutput(), null, datalink_declaration.isSnapback(), datalink_declaration.getDestInput()) : new DataLink(datalink_declaration.getSrcOutput(), target_elementdeclaration.getElementInfo(), false, datalink_declaration.getDestInput());
                current_elementdeclaration.getElementInfo().addDataLink(datalink);
            }
        }
    }

    private void processFallbackElement() {
        if (this.mFallbackElementId != null) {
            ElementInfo fallback_elementinfo = this.getElementInfo(this.mFallbackElementId);
            if (fallback_elementinfo == null) {
                this.elementIdNotFound(this.mFallbackElementId);
            }
            this.mSite.addFallback(fallback_elementinfo, this.getUrlPrefix());
        }
    }

    private void processArrivalElement() {
        if (this.mArrivalElementDeclaration != null) {
            ElementDeclaration target_element_declaration = this.getElementDeclaration(this.mArrivalElementId);
            this.mArrivalElementDeclaration.getElementInfo().populateFrom(target_element_declaration.getElementInfo());
            this.mArrivalElementDeclaration.setGroup(target_element_declaration.getGroup());
            String arrival_id = this.mSiteId;
            String arrival_url = null;
            if ((this.mParent == null || target_element_declaration.getUrl() != null || !this.getUrlPrefix().equals(this.mParent.getUrlPrefix())) && (arrival_url = this.getUrlPrefix()).endsWith("/")) {
                arrival_url = StringUtils.stripFromEnd(arrival_url, "/");
            }
            ElementInfo arrival_elementinfo = this.mArrivalElementDeclaration.getElementInfo();
            arrival_elementinfo.setId(null);
            arrival_elementinfo.setUrl(null);
            this.mSite.addElementInfo(arrival_id, arrival_elementinfo, arrival_url);
            if (arrival_url != null && arrival_url.length() > 0) {
                this.mSite.mapElementId(arrival_id, new StringBuffer().append(arrival_url).append("/").toString());
            }
        }
    }

    private void processDepartureElements() {
        if (this.mDepartureIds.size() > 0) {
            ElementDeclaration departure_elementdeclaration = null;
            for (String departure_id : (Collection)this.mDepartureIds) {
                departure_elementdeclaration = this.getElementDeclaration(departure_id);
                if (departure_elementdeclaration == null) {
                    this.elementIdNotFound(departure_id);
                }
                ArrayList<String> departure_vars = new ArrayList<String>(departure_elementdeclaration.getGroup().getGlobalVarsLocal().keySet());
                departure_elementdeclaration.getElementInfo().setDepartureVars(departure_vars);
            }
        }
    }

    private void processInheritsStack() {
        String parent_id = null;
        ElementDeclaration parent_elementdeclaration = null;
        for (ElementDeclaration element_declaration : this.getElementDeclarations()) {
            parent_id = element_declaration.getInherits();
            if (parent_id == null) continue;
            parent_elementdeclaration = element_declaration.getSiteBuilder().getGlobalElementDeclaration(parent_id);
            if (parent_elementdeclaration == null) {
                this.elementIdNotFound(parent_id);
            }
            element_declaration.getParentStack().push(parent_elementdeclaration);
        }
        Stack<ArrayList<GroupDeclaration>> groupdeclarations_stack = null;
        GroupDeclaration child_groupdeclaration = null;
        ArrayList child_groupdeclarations = null;
        for (GroupDeclaration groupdeclaration : (Collection)this.mGroupDeclarations) {
            parent_id = groupdeclaration.getInherits();
            if (parent_id == null) continue;
            parent_elementdeclaration = groupdeclaration.getDeclaringSiteBuilder().getGlobalElementDeclaration(parent_id);
            if (parent_elementdeclaration == null) {
                this.elementIdNotFound(parent_id);
            }
            groupdeclarations_stack = new Stack<ArrayList<GroupDeclaration>>();
            child_groupdeclarations = new ArrayList();
            child_groupdeclarations.add(groupdeclaration);
            groupdeclarations_stack.push(child_groupdeclarations);
            while (groupdeclarations_stack.size() > 0) {
                child_groupdeclarations = (ArrayList)groupdeclarations_stack.pop();
                while (child_groupdeclarations.size() > 0) {
                    child_groupdeclaration = (GroupDeclaration)child_groupdeclarations.remove(0);
                    for (ElementDeclaration child_elementdeclaration : child_groupdeclaration.getElementDeclarations()) {
                        child_elementdeclaration.getParentStack().push(parent_elementdeclaration);
                    }
                    if (child_groupdeclaration.getChildGroupDeclarations().size() <= 0) continue;
                    groupdeclarations_stack.push(new ArrayList<GroupDeclaration>(child_groupdeclaration.getChildGroupDeclarations()));
                }
            }
        }
    }

    private void processPreStack() {
        String pre_id = null;
        ElementDeclaration pre_elementdeclaration = null;
        for (ElementDeclaration element_declaration : this.getElementDeclarations()) {
            pre_id = element_declaration.getPre();
            if (pre_id == null) continue;
            pre_elementdeclaration = element_declaration.getSiteBuilder().getGlobalElementDeclaration(pre_id);
            if (pre_elementdeclaration == null) {
                this.elementIdNotFound(pre_id);
            }
            element_declaration.getPreStack().push(pre_elementdeclaration);
        }
        Stack<ArrayList<GroupDeclaration>> groupdeclarations_stack = null;
        GroupDeclaration child_groupdeclaration = null;
        ArrayList child_groupdeclarations = null;
        for (GroupDeclaration groupdeclaration : (Collection)this.mGroupDeclarations) {
            pre_id = groupdeclaration.getPre();
            if (pre_id == null) continue;
            pre_elementdeclaration = groupdeclaration.getDeclaringSiteBuilder().getGlobalElementDeclaration(pre_id);
            if (pre_elementdeclaration == null) {
                this.elementIdNotFound(pre_id);
            }
            groupdeclarations_stack = new Stack<ArrayList<GroupDeclaration>>();
            child_groupdeclarations = new ArrayList();
            child_groupdeclarations.add(groupdeclaration);
            groupdeclarations_stack.push(child_groupdeclarations);
            while (groupdeclarations_stack.size() > 0) {
                child_groupdeclarations = (ArrayList)groupdeclarations_stack.pop();
                while (child_groupdeclarations.size() > 0) {
                    child_groupdeclaration = (GroupDeclaration)child_groupdeclarations.remove(0);
                    for (ElementDeclaration child_elementdeclaration : child_groupdeclaration.getElementDeclarations()) {
                        child_elementdeclaration.getPreStack().push(pre_elementdeclaration);
                    }
                    if (child_groupdeclaration.getChildGroupDeclarations().size() <= 0) continue;
                    groupdeclarations_stack.push(new ArrayList<GroupDeclaration>(child_groupdeclaration.getChildGroupDeclarations()));
                }
            }
        }
    }

    private void createInheritanceStacks() {
        for (SubsiteDeclaration subsitedeclaration : (Collection)this.mSubsiteDeclarations) {
            subsitedeclaration.getSiteBuilder().createInheritanceStacks();
        }
        Stack<ElementInfo> inheritance_stack = null;
        String parent_id = null;
        for (ElementDeclaration current_elementdeclaration : this.getElementDeclarations()) {
            if (current_elementdeclaration.getParentStack().size() <= 0) continue;
            inheritance_stack = new Stack<ElementInfo>();
            inheritance_stack.push(current_elementdeclaration.getElementInfo());
            for (ElementDeclaration parent_elementdeclaration : (Collection)current_elementdeclaration.getParentStack()) {
                while (parent_elementdeclaration != null) {
                    inheritance_stack.push(parent_elementdeclaration.getElementInfo());
                    parent_id = parent_elementdeclaration.getInherits();
                    parent_elementdeclaration = parent_id == null ? null : parent_elementdeclaration.getSiteBuilder().getGlobalElementDeclaration(parent_id);
                }
            }
            current_elementdeclaration.getElementInfo().setInheritanceStack(inheritance_stack);
        }
    }

    private void createPrecedenceStacks() {
        for (SubsiteDeclaration subsitedeclaration : (Collection)this.mSubsiteDeclarations) {
            subsitedeclaration.getSiteBuilder().createPrecedenceStacks();
        }
        Stack<ElementInfo> precedence_stack = null;
        for (ElementDeclaration current_elementdeclaration : this.getElementDeclarations()) {
            if (current_elementdeclaration.getPreStack().size() <= 0) continue;
            precedence_stack = new Stack<ElementInfo>();
            precedence_stack.push(current_elementdeclaration.getElementInfo());
            for (ElementDeclaration pre_elementdeclaration : (Collection)current_elementdeclaration.getPreStack()) {
                precedence_stack.push(pre_elementdeclaration.getElementInfo());
            }
            current_elementdeclaration.getElementInfo().setPrecedenceStack(precedence_stack);
        }
    }

    private void setupData() {
        this.setupElements();
        this.setupSubsites();
        this.setupArrivalElement();
    }

    private void processData() {
        this.processSubsites();
        this.processGlobalExits();
        this.processFlowLinks();
        this.processDataLinks();
        this.processFallbackElement();
        this.processArrivalElement();
        this.processDepartureElements();
        this.processInheritsStack();
        this.processPreStack();
        this.mArrivalElementId = null;
        this.mDepartureIds = null;
        this.mDataLinkMapping = null;
        this.mFlowLinkMapping = null;
    }

    private String getUrlPrefix() {
        if (this.mUrlPrefix != null) {
            return this.mUrlPrefix;
        }
        if (this.mParent == null) {
            this.mUrlPrefix = "/";
        } else {
            String url_prefix = this.getParent().getUrlPrefix();
            if (this.mSubsiteDeclaration.getUrlPrefix() != null) {
                String subsite_url_prefix = this.mSubsiteDeclaration.getUrlPrefix();
                if (url_prefix.endsWith("/") && subsite_url_prefix.startsWith("/")) {
                    StringBuffer buffer;
                    url_prefix = StringUtils.stripFromEnd(url_prefix, "/");
                    subsite_url_prefix = StringUtils.stripFromFront(subsite_url_prefix, "/");
                    StringBuffer stringBuffer = buffer = new StringBuffer(url_prefix);
                    synchronized (stringBuffer) {
                        buffer.append("/");
                        buffer.append(subsite_url_prefix);
                        url_prefix = buffer.toString();
                    }
                }
                if (url_prefix.endsWith("/") || subsite_url_prefix.startsWith("/")) {
                    url_prefix = new StringBuffer().append(url_prefix).append(subsite_url_prefix).toString();
                } else {
                    StringBuffer buffer;
                    StringBuffer stringBuffer = buffer = new StringBuffer(url_prefix);
                    synchronized (stringBuffer) {
                        buffer.append("/");
                        buffer.append(subsite_url_prefix);
                        url_prefix = buffer.toString();
                    }
                }
            }
            this.mUrlPrefix = url_prefix;
        }
        return this.mUrlPrefix;
    }

    String getDeclarationName() {
        return this.mDeclarationName;
    }

    void addDataLink(String srcId, DataLinkDeclaration dataLink) {
        HashSet<DataLinkDeclaration> datalinks = this.mDataLinkMapping.get(srcId);
        if (datalinks == null) {
            datalinks = new HashSet();
            this.mDataLinkMapping.put(srcId, datalinks);
        }
        datalinks.add(dataLink);
    }

    void addFlowLink(String srcId, FlowLinkDeclaration flowLink) {
        HashSet<FlowLinkDeclaration> flowlinks = this.mFlowLinkMapping.get(srcId);
        if (flowlinks == null) {
            flowlinks = new HashSet();
            this.mFlowLinkMapping.put(srcId, flowlinks);
        }
        flowlinks.add(flowLink);
    }

    String ensureLocalElementId(String id) {
        if (id != null && (id.indexOf(".") != -1 || id.indexOf("^") != -1)) {
            throw new LocalElementIdRequiredException(id);
        }
        return id;
    }

    String makeAbsoluteElementId(String id) {
        if (id == null) {
            return null;
        }
        if (!id.startsWith(".")) {
            id = new StringBuffer().append(this.getId()).append(id).toString();
        }
        return id;
    }

    static String generateId(String declarationName) {
        int index;
        if (declarationName == null) {
            return null;
        }
        String id = FileUtils.getBaseName(declarationName);
        if (id == null) {
            id = declarationName;
        }
        if (-1 == (index = id.lastIndexOf("/"))) {
            index = id.lastIndexOf(":");
        }
        if (index != -1) {
            id = index == id.length() - 1 ? null : id.substring(index + 1);
        }
        return id;
    }

    public SiteBuilder addResourceModificationTime(URL resource, long modificationTime) {
        this.mSite.addResourceModificationTime(resource, modificationTime);
        return this;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.SiteBuilder");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

