/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import bsh.TargetError;
import com.uwyn.rife.engine.ScriptedEngine;
import com.uwyn.rife.engine.exceptions.EngineException;
import com.uwyn.rife.engine.exceptions.ScriptErrorException;
import java.lang.reflect.InvocationTargetException;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyJavaInstance;

class ScriptedEngineBSF
extends ScriptedEngine {
    protected BSFManager mManager = new BSFManager();
    protected BSFEngine mEngine = null;

    ScriptedEngineBSF(String language, String code) {
        super(language, code);
        try {
            this.mEngine = this.mManager.loadScriptingEngine(this.mLanguage);
        }
        catch (BSFException e) {
            e.fillInStackTrace();
            throw new EngineException(e);
        }
    }

    void processElement() {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.engine.ElementScripted");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.mManager.declareBean("element", (Object)this.getElement(), clazz);
            this.mManager.exec(this.mLanguage, this.getElement().getElementInfo().getImplementation(), 0, 0, (Object)this.mCode);
            this.mManager.undeclareBean("element");
            this.mEngine = null;
            this.mManager.terminate();
            this.mManager = null;
        }
        catch (BSFException e) {
            this.extractEngineException(e);
        }
    }

    boolean childTriggered(String name, String[] values) {
        try {
            Object result = null;
            result = this.mEngine.call(null, "childTriggered", new Object[]{name, values});
            return result != null && (result.toString().equals("true") || result.toString().equals("1"));
        }
        catch (BSFException e) {
            this.extractEngineException(e);
        }
        finally {
            return false;
        }
    }

    private void extractEngineException(BSFException e) {
        if (e.getTargetException() != null) {
            if (e.getTargetException() instanceof EngineException) {
                throw (EngineException)e.getTargetException();
            }
            if (e.getTargetException().getClass().getName().equals("org.python.core.PyException")) {
                ElementJythonExceptionHandler python_handler = new ElementJythonExceptionHandler();
                python_handler.execute(e);
            }
            if (e.getTargetException().getClass().getName().equals("org.jruby.exceptions.RaiseException") && e.getTargetException().getCause() != null && e.getTargetException().getCause() instanceof EngineException) {
                throw (EngineException)e.getTargetException().getCause();
            }
            if (e.getTargetException().getClass().getName().equals("tcl.lang.ReflectException") && e.getTargetException().getCause() != null && e.getTargetException().getCause() instanceof InvocationTargetException && e.getTargetException().getCause().getCause() != null && e.getTargetException().getCause().getCause() instanceof EngineException) {
                throw (EngineException)e.getTargetException().getCause().getCause();
            }
            if (e.getTargetException().getClass().getName().equals("bsh.TargetError") && ((TargetError)e.getTargetException()).getTarget() != null && ((TargetError)e.getTargetException()).getTarget() instanceof EngineException) {
                throw (EngineException)((TargetError)e.getTargetException()).getTarget();
            }
        }
        throw new ScriptErrorException(this.getElement().getElementInfo().getDeclarationName(), e);
    }

    private class ElementJythonExceptionHandler {
        private void execute(BSFException e) {
            PyException python_exception = (PyException)e.getTargetException();
            try {
                Class<?> clazz;
                try {
                    clazz = Class.forName("com.uwyn.rife.engine.exceptions.EngineException");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                Object converted = ((PyJavaInstance)python_exception.value).__tojava__(clazz);
                if (converted == Py.NoConversion) {
                    throw new ScriptErrorException(ScriptedEngineBSF.this.getElement().getElementInfo().getDeclarationName(), (Throwable)e);
                }
                throw (EngineException)converted;
            }
            catch (ClassCastException e2) {
                throw new EngineException((Throwable)e);
            }
        }

        static /* synthetic */ ScriptedEngineBSF access$0(ElementJythonExceptionHandler elementJythonExceptionHandler) {
            return elementJythonExceptionHandler.ScriptedEngineBSF.this;
        }
    }
}

