/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.ElementAware;
import com.uwyn.rife.engine.ElementFactory;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.exceptions.ElementImplementationInstantiationException;
import com.uwyn.rife.engine.exceptions.ElementImplementationNotFoundException;
import com.uwyn.rife.resources.ResourceFinder;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.Scanner;

class ScriptLoaderJanino {
    private ResourceFinder mResourceFinder = null;
    private HashMap<String, Long> mScriptsModification = new HashMap();
    private HashMap<String, Class> mScriptsCache = new HashMap();

    ScriptLoaderJanino(ResourceFinder resourceFinder) {
        this.mResourceFinder = resourceFinder;
    }

    ElementAware getInstance(ElementInfo elementInfo) {
        try {
            URL resource = this.mResourceFinder.getResource(elementInfo.getImplementation());
            long current_modification = -1;
            if (resource != null) {
                current_modification = this.mResourceFinder.getModificationTime(elementInfo.getImplementation());
            } else {
                resource = this.mResourceFinder.getResource("implementations/" + elementInfo.getImplementation());
                current_modification = this.mResourceFinder.getModificationTime("implementations/" + elementInfo.getImplementation());
            }
            if (resource == null) {
                throw new ElementImplementationNotFoundException(elementInfo.getDeclarationName(), elementInfo.getImplementation(), null);
            }
            String implementation = elementInfo.getImplementation();
            Long previous_modification = this.mScriptsModification.get(implementation);
            Class element_class = null;
            if (this.mScriptsCache.containsKey(implementation) && (previous_modification == null || previous_modification == current_modification)) {
                element_class = this.mScriptsCache.get(implementation);
            } else {
                try {
                    Class<?> clazz;
                    InputStream script_stream = ElementFactory.getScriptUrl(this.mResourceFinder, elementInfo).openStream();
                    try {
                        clazz = Class.forName("com.uwyn.rife.engine.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    element_class = new ClassBodyEvaluator(new Scanner(null, script_stream), clazz, new Class[0], this.getClass().getClassLoader()).evaluate();
                }
                catch (Throwable e) {
                    throw new ElementImplementationInstantiationException(elementInfo.getDeclarationName(), elementInfo.getImplementation(), e);
                }
                if (previous_modification == null || previous_modification != current_modification) {
                    this.mScriptsModification.put(implementation, new Long(current_modification));
                    this.mScriptsCache.put(implementation, element_class);
                }
            }
            return (ElementAware)element_class.newInstance();
        }
        catch (Throwable e) {
            throw new ElementImplementationInstantiationException(elementInfo.getDeclarationName(), elementInfo.getImplementation(), e);
        }
    }
}

