/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.engine.Request;
import com.uwyn.rife.engine.exceptions.EmbeddedElementCantSetContentLengthException;
import com.uwyn.rife.engine.exceptions.EngineException;
import com.uwyn.rife.engine.exceptions.ResponseOutputStreamRetrievalErrorException;
import com.uwyn.rife.template.InternalString;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Response {
    private Request mRequest = null;
    private HttpServletResponse mResponse = null;
    private boolean mEmbedded = false;
    private String mContentType = null;
    private boolean mTextBufferEnabled = true;
    private ArrayList<CharSequence> mTextBuffer = null;
    private OutputStream mResponseOutputStream = null;
    private ByteArrayOutputStream mGzipByteOutputStream = null;
    private GZIPOutputStream mGzipOutputStream = null;
    private OutputStream mOutputStream = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    Response(Request request, HttpServletResponse response, boolean embedded) {
        if (!$assertionsDisabled && request == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && response == null) {
            throw new AssertionError();
        }
        this.mRequest = request;
        this.mResponse = response;
        this.mEmbedded = embedded;
    }

    void setContentType(String contentType) {
        if (contentType == null) {
            return;
        }
        if (-1 == contentType.indexOf("; charset=")) {
            contentType = new StringBuffer().append(contentType).append("; charset=UTF-8").toString();
        }
        this.mContentType = contentType;
        this.mResponse.setContentType(contentType);
    }

    void enableTextBuffer(boolean enabled) {
        if (!this.mTextBufferEnabled ? enabled : !enabled) {
            this.flush();
        }
        this.mTextBufferEnabled = enabled;
    }

    boolean isTextBufferEnabled() {
        return this.mTextBufferEnabled;
    }

    void print(Object value) {
        if (value == null) {
            return;
        }
        String text = String.valueOf(value);
        if (this.mTextBufferEnabled) {
            if (this.mOutputStream != null) {
                try {
                    this.mOutputStream.flush();
                }
                catch (IOException e) {
                    throw new EngineException(e);
                }
            }
            if (this.mTextBuffer == null) {
                this.mTextBuffer = new ArrayList();
            }
            this.mTextBuffer.add(text);
        } else {
            this.ensureOutputStream();
            try {
                this.mOutputStream.write(text.getBytes(this.getCharacterEncoding()));
                this.mOutputStream.flush();
            }
            catch (IOException e) {
                throw new EngineException(e);
            }
        }
    }

    void print(Collection<CharSequence> deferredContent) {
        if (deferredContent == null || 0 == deferredContent.size()) {
            return;
        }
        if (this.mTextBufferEnabled) {
            if (this.mOutputStream != null) {
                try {
                    this.mOutputStream.flush();
                }
                catch (IOException e) {
                    throw new EngineException(e);
                }
            }
            if (this.mTextBuffer == null) {
                this.mTextBuffer = new ArrayList();
            }
            this.mTextBuffer.addAll(deferredContent);
        } else {
            this.writeDeferredContent(deferredContent);
        }
    }

    void setLocale(Locale locale) {
        this.mResponse.setLocale(locale);
    }

    Locale getLocale() {
        return this.mResponse.getLocale();
    }

    String getCharacterEncoding() {
        if (this.mEmbedded) {
            return EmbeddedStream.ENCODING;
        }
        String encoding = this.mResponse.getCharacterEncoding();
        if (encoding == null) {
            encoding = StringUtils.ENCODING_UTF_8;
        }
        return encoding;
    }

    private void writeDeferredContent(Collection<CharSequence> deferredContent) {
        this.ensureOutputStream();
        String encoding = this.getCharacterEncoding();
        try {
            this.mOutputStream.flush();
            if (this.mEmbedded) {
                EmbeddedStream embedded_stream = (EmbeddedStream)this.mOutputStream;
                for (CharSequence charsequence : deferredContent) {
                    embedded_stream.write(charsequence);
                }
            } else {
                for (CharSequence charsequence : deferredContent) {
                    if (charsequence instanceof InternalString) {
                        this.mOutputStream.write(((InternalString)charsequence).getBytes(encoding));
                        continue;
                    }
                    if (!(charsequence instanceof String)) continue;
                    this.mOutputStream.write(((String)charsequence).getBytes(encoding));
                }
            }
            this.mOutputStream.flush();
        }
        catch (IOException e) {}
    }

    void flush() {
        block3: {
            if (this.mTextBuffer != null && this.mTextBuffer.size() > 0) {
                this.writeDeferredContent(this.mTextBuffer);
                this.mTextBuffer.clear();
            }
            if (this.mOutputStream == null) break block3;
            try {
                this.mOutputStream.flush();
            }
            catch (IOException e) {}
        }
    }

    void close() {
        block5: {
            this.flush();
            if (this.mEmbedded || this.mOutputStream == null) break block5;
            try {
                if (this.mGzipOutputStream != null) {
                    this.mGzipOutputStream.flush();
                    this.mGzipOutputStream.finish();
                    byte[] bytes = this.mGzipByteOutputStream.toByteArray();
                    this.mGzipOutputStream = null;
                    this.mGzipByteOutputStream = null;
                    this.setContentLength(bytes.length);
                    this.addHeader("Content-Encoding", "gzip");
                    this.mResponseOutputStream.write(bytes);
                    this.mOutputStream = this.mResponseOutputStream;
                }
                try {
                    this.mOutputStream.flush();
                    this.mOutputStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.mOutputStream = null;
            }
            catch (IOException e) {}
        }
    }

    ArrayList<CharSequence> getEmbeddedContent() {
        if (!this.mEmbedded) {
            return null;
        }
        if (this.mOutputStream == null) {
            return this.mTextBuffer;
        }
        this.flush();
        return ((EmbeddedStream)this.mOutputStream).getEmbeddedContent();
    }

    boolean isEmbedded() {
        return this.mEmbedded;
    }

    OutputStream getOutputStream() {
        this.ensureOutputStream();
        return this.mOutputStream;
    }

    void setContentLength(int length) {
        if (!$assertionsDisabled && length < 0) {
            throw new AssertionError();
        }
        if (this.mEmbedded) {
            throw new EmbeddedElementCantSetContentLengthException();
        }
        this.mResponse.setContentLength(length);
    }

    void setCookie(Cookie cookie) {
        this.mResponse.addCookie(cookie);
    }

    void addHeader(String name, String value) {
        this.mResponse.addHeader(name, value);
    }

    void addDateHeader(String name, long date) {
        this.mResponse.addDateHeader(name, date);
    }

    void addIntHeader(String name, int integer) {
        this.mResponse.addIntHeader(name, integer);
    }

    boolean containsHeader(String name) {
        return this.mResponse.containsHeader(name);
    }

    void sendError(int statusCode) {
        try {
            this.mResponse.sendError(statusCode);
        }
        catch (IOException e) {
            throw new EngineException(e);
        }
    }

    void sendError(int statusCode, String message) {
        try {
            this.mResponse.sendError(statusCode, message);
        }
        catch (IOException e) {
            throw new EngineException(e);
        }
    }

    void sendRedirect(String location) {
        String user_agent = this.mRequest.getHttpServletRequest().getHeader("User-Agent");
        if (user_agent != null && location.indexOf("#") != -1 && user_agent.indexOf("MSIE") != -1) {
            this.setHeader("Refresh", new StringBuffer().append("0; URL=").append(location).toString());
        } else {
            try {
                this.mResponse.sendRedirect(location);
            }
            catch (IOException e) {
                throw new EngineException(e);
            }
        }
    }

    void setDateHeader(String name, long date) {
        this.mResponse.setDateHeader(name, date);
    }

    void setHeader(String name, String value) {
        this.mResponse.setHeader(name, value);
    }

    void setIntHeader(String name, int value) {
        this.mResponse.setIntHeader(name, value);
    }

    void setStatus(int statusCode) {
        this.mResponse.setStatus(statusCode);
    }

    HttpServletResponse getHttpServletResponse() {
        return this.mResponse;
    }

    private void ensureOutputStream() {
        if (this.mOutputStream == null) {
            if (this.mEmbedded) {
                this.mOutputStream = new EmbeddedStream();
            } else {
                if (this.mResponseOutputStream == null) {
                    try {
                        this.mResponseOutputStream = this.mResponse.getOutputStream();
                        if (this.mContentType != null) {
                            String accept_encoding;
                            String content_type = this.mContentType;
                            int charset_index = content_type.indexOf("; charset=");
                            if (charset_index != -1) {
                                content_type = content_type.substring(0, charset_index);
                            }
                            if (RifeConfig.Engine.getGzipCompression() && RifeConfig.Engine.getGzipCompressionTypes().contains(content_type) && (accept_encoding = this.mRequest.getHttpServletRequest().getHeader("Accept-Encoding")) != null && accept_encoding.indexOf("gzip") != -1) {
                                this.mGzipByteOutputStream = new ByteArrayOutputStream();
                                this.mGzipOutputStream = new GZIPOutputStream(this.mGzipByteOutputStream);
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new ResponseOutputStreamRetrievalErrorException(e);
                    }
                }
                this.mOutputStream = this.mGzipOutputStream != null ? this.mGzipOutputStream : this.mResponseOutputStream;
            }
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.Response");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EmbeddedStream
    extends ByteArrayOutputStream {
        static final String ENCODING = StringUtils.ENCODING_UTF_8;
        private ArrayList<CharSequence> mEmbeddedContent = new ArrayList();

        public void write(CharSequence chars) {
            this.mEmbeddedContent.add(chars);
        }

        @Override
        public void flush() throws IOException {
            try {
                this.write(this.toString(ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                Logger.getLogger("com.uwyn.rife.engine").severe(ExceptionUtils.getExceptionStackTrace(e));
            }
            this.reset();
        }

        ArrayList<CharSequence> getEmbeddedContent() {
            return this.mEmbeddedContent;
        }
    }
}

