/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.CallState;
import com.uwyn.rife.engine.ContinuationContext;
import com.uwyn.rife.engine.ElementContext;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.ElementState;
import com.uwyn.rife.engine.ElementSupport;
import com.uwyn.rife.engine.EmbeddingContext;
import com.uwyn.rife.engine.InitConfig;
import com.uwyn.rife.engine.OutcookieListener;
import com.uwyn.rife.engine.OutputListener;
import com.uwyn.rife.engine.Request;
import com.uwyn.rife.engine.RequestMethod;
import com.uwyn.rife.engine.Response;
import com.uwyn.rife.engine.Site;
import com.uwyn.rife.engine.TriggerContext;
import com.uwyn.rife.engine.TriggerListEncoder;
import com.uwyn.rife.engine.UploadedFile;
import com.uwyn.rife.engine.exceptions.AnswerException;
import com.uwyn.rife.engine.exceptions.EmbedPropertiesErrorException;
import com.uwyn.rife.engine.exceptions.EngineException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.servlet.http.Cookie;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RequestState {
    private InitConfig mInitConfig = null;
    private Site mSite = null;
    private Request mRequest = null;
    private String mGateUrl = null;
    private ElementInfo mTarget = null;
    private ElementInfo mSnapback = null;
    private EmbeddingContext mEmbeddingContext = null;
    private ElementInfo mPrecedenceTarget = null;
    private Map<String, Cookie> mStateCookies = null;
    private ElementState mElementState = null;
    private String mContinuationId = null;
    private ContinuationContext mContinuationContext = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    RequestState(InitConfig initConfig, Site site, Request request, String gateUrl, String pathInfo, ElementInfo target, EmbeddingContext embeddingContext) {
        if (!$assertionsDisabled && initConfig == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && request == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && gateUrl == null) {
            throw new AssertionError();
        }
        this.mInitConfig = initConfig;
        this.mGateUrl = gateUrl;
        this.mSite = site;
        this.mEmbeddingContext = embeddingContext;
        this.setRequest(request);
        this.mElementState = new ElementState(this);
        this.mElementState.setPathInfo(pathInfo);
        this.setupContinuations();
        this.setTarget(target);
        this.setSnapback(target);
    }

    void setupContinuations() {
        this.mContinuationId = null;
        this.mContinuationContext = null;
        String[] continuation_id_values = this.mElementState.getRequestParameters().get("contid");
        if (continuation_id_values != null && continuation_id_values.length > 0) {
            this.mContinuationId = continuation_id_values[0];
        }
    }

    String getContinuationId() {
        return this.mContinuationId;
    }

    ContinuationContext getContinuationContext(ElementInfo elementInfo) {
        if (this.mContinuationId != null && this.mContinuationContext == null) {
            try {
                this.mContinuationContext = this.mSite.getContinuationManager().getContext(this.mContinuationId);
            }
            catch (CloneNotSupportedException e) {
                throw new EngineException(e);
            }
        }
        if (this.mContinuationContext != null && this.mContinuationContext.isCorrespondingElement(elementInfo)) {
            return this.mContinuationContext;
        }
        return null;
    }

    ElementContext getElementContext(ElementInfo elementInfo, Response response) {
        ElementSupport element = null;
        ContinuationContext context = this.getContinuationContext(elementInfo);
        element = context != null ? this.mContinuationContext.getElement() : elementInfo.getElement();
        if (element == null) {
            throw new EngineException(new StringBuffer().append(new StringBuffer().append("Error while instantiating the element '").append(elementInfo.getDeclarationName()).toString()).append("' at url.").toString());
        }
        ElementContext element_context = new ElementContext(element, this, response);
        if (element_context == null) {
            throw new EngineException(new StringBuffer().append(new StringBuffer().append("Error while constructing the context for the element '").append(elementInfo.getDeclarationName()).toString()).append("'.").toString());
        }
        if (context != null) {
            element_context.setActiveCallState(context.getActiveCallState());
        }
        return element_context;
    }

    void handlePrecedence(Response response, ElementInfo precedenceTarget) {
        Stack<ElementInfo> precedence_stack = precedenceTarget.getPrecedenceStack();
        if (precedence_stack != null && precedence_stack.size() > 0) {
            ElementInfo original_target = this.getTarget();
            Stack<ElementInfo> original_inheritance_stack = this.mElementState.getInheritanceStack();
            RequestMethod original_method = this.mElementState.getMethod();
            if (this.getPrecedenceTarget() == null) {
                this.setPrecedenceTarget(precedenceTarget);
                this.mElementState.setMethod(RequestMethod.PRECEDENCE);
            }
            ElementInfo active_element = null;
            int i = precedence_stack.size() - 1;
            while (i >= 0) {
                active_element = (ElementInfo)precedence_stack.get(i);
                if (active_element == precedenceTarget) break;
                this.setTarget(active_element);
                this.service(response);
                --i;
            }
            if (precedenceTarget == this.getPrecedenceTarget()) {
                this.setPrecedenceTarget(null);
            }
            this.setTarget(original_target);
            this.mElementState.setInheritanceStack(original_inheritance_stack);
            this.mElementState.setMethod(original_method);
        }
    }

    void service(Response response) {
        ElementInfo element_info = null;
        element_info = this.mElementState.inInheritanceStructure() ? this.mElementState.getInheritanceStack().pop() : this.mTarget;
        ContinuationContext previous_context = ContinuationContext.currentContext();
        Object call_answer = null;
        ElementContext element_context = this.getElementContext(element_info, response);
        while (true) {
            try {
                ContinuationContext.setContext(null);
                ElementContext next_element_context = element_context.processContext();
                while (next_element_context != null) {
                    element_context = next_element_context;
                    ContinuationContext.setContext(null);
                    next_element_context = element_context.processContext();
                }
                call_answer = null;
            }
            catch (AnswerException e) {
                element_context = e.getElementContext();
                call_answer = e.getCallAnswer();
                if (element_context == null || element_context.getActiveCallState() == null) continue;
                CallState call_state = element_context.getActiveCallState();
                String element_id = call_state.getElementId();
                this.mContinuationContext = null;
                this.mContinuationId = call_state.getContinuationId();
                this.mElementState = call_state.getElementState();
                this.mElementState.setRequestState(this);
                element_info = this.mSite.resolveId(element_id);
                ContinuationContext continuation_context = this.getContinuationContext(element_info);
                if (continuation_context == null) break;
                continuation_context.setCallAnswer(call_answer);
                this.setTarget(element_info);
                element_context = this.getElementContext(element_info, response);
                continue;
            }
            break;
        }
        ContinuationContext.setContext(previous_context);
    }

    void setTarget(ElementInfo targetElement) {
        if (!$assertionsDisabled && targetElement == null) {
            throw new AssertionError();
        }
        this.mTarget = targetElement;
        Stack<ElementInfo> target_inheritancestack = this.mTarget.getInheritanceStack();
        this.mElementState.setInheritanceStack(null);
        if (target_inheritancestack != null) {
            Stack<ElementInfo> inheritance_stack = new Stack<ElementInfo>();
            inheritance_stack.addAll(target_inheritancestack);
            this.mElementState.setInheritanceStack(inheritance_stack);
        }
        if (this.mElementState.inInheritanceStructure() && !this.mElementState.hasTriggerList()) {
            if (this.isEmbedded()) {
                this.mElementState.setTriggerList(new ArrayList<TriggerContext>());
            } else {
                this.mElementState.setTriggerList(TriggerListEncoder.decode(this.mElementState.getParameterValues("triggerlist")));
            }
        }
    }

    void setSnapback(ElementInfo snapbackElement) {
        if (!$assertionsDisabled && snapbackElement == null) {
            throw new AssertionError();
        }
        this.mSnapback = snapbackElement;
    }

    InitConfig getInitConfig() {
        return this.mInitConfig;
    }

    Site getSite() {
        return this.mSite;
    }

    void setRequest(Request request) {
        this.mRequest = request;
    }

    Request getRequest() {
        return this.mRequest;
    }

    ElementInfo getTarget() {
        return this.mTarget;
    }

    ElementInfo getSnapback() {
        return this.mSnapback;
    }

    EmbeddingContext getEmbeddingContext() {
        return this.mEmbeddingContext;
    }

    boolean isEmbedded() {
        return this.mEmbeddingContext != null;
    }

    String getEmbedValue() {
        if (this.mEmbeddingContext == null) {
            return null;
        }
        return this.mEmbeddingContext.getValue();
    }

    Properties getEmbedProperties() {
        if (this.mEmbeddingContext == null) {
            return null;
        }
        try {
            return this.mEmbeddingContext.getEmbedProperties();
        }
        catch (IOException e) {
            throw new EmbedPropertiesErrorException(this.mTarget.getDeclarationName(), this.mEmbeddingContext.getValue(), e);
        }
    }

    void setPrecedenceTarget(ElementInfo elementInfo) {
        this.mPrecedenceTarget = elementInfo;
    }

    ElementInfo getPrecedenceTarget() {
        return this.mPrecedenceTarget;
    }

    boolean isPreceeding() {
        return this.mPrecedenceTarget != null;
    }

    String getGateUrl() {
        return this.mGateUrl;
    }

    ElementState getElementState() {
        return this.mElementState;
    }

    Object getRequestAttribute(String name) {
        return this.mRequest.getHttpServletRequest().getAttribute(name);
    }

    boolean hasRequestAttribute(String name) {
        return this.getRequestAttribute(name) != null;
    }

    Enumeration getRequestAttributeNames() {
        return this.mRequest.getHttpServletRequest().getAttributeNames();
    }

    String getCharacterEncoding() {
        return this.mRequest.getHttpServletRequest().getCharacterEncoding();
    }

    String getContentType() {
        return this.mRequest.getHttpServletRequest().getContentType();
    }

    long getDateHeader(String name) {
        return this.mRequest.getHttpServletRequest().getDateHeader(name);
    }

    String getHeader(String name) {
        return this.mRequest.getHttpServletRequest().getHeader(name);
    }

    Enumeration getHeaderNames() {
        return this.mRequest.getHttpServletRequest().getHeaderNames();
    }

    Enumeration getHeaders(String name) {
        return this.mRequest.getHttpServletRequest().getHeaders(name);
    }

    int getIntHeader(String name) {
        return this.mRequest.getHttpServletRequest().getIntHeader(name);
    }

    Locale getLocale() {
        return this.mRequest.getHttpServletRequest().getLocale();
    }

    Enumeration getLocales() {
        return this.mRequest.getHttpServletRequest().getLocales();
    }

    String getProtocol() {
        return this.mRequest.getHttpServletRequest().getProtocol();
    }

    String getRemoteAddr() {
        return this.mRequest.getHttpServletRequest().getRemoteAddr();
    }

    String getRemoteUser() {
        return this.mRequest.getHttpServletRequest().getRemoteUser();
    }

    String getRemoteHost() {
        return this.mRequest.getHttpServletRequest().getRemoteHost();
    }

    int getServerPort() {
        if (this.mRequest == null || this.mRequest.getHttpServletRequest() == null) {
            return -1;
        }
        return this.mRequest.getHttpServletRequest().getServerPort();
    }

    String getScheme() {
        return this.mRequest.getHttpServletRequest().getScheme();
    }

    String getServerName() {
        if (this.mRequest == null || this.mRequest.getHttpServletRequest() == null) {
            return null;
        }
        return this.mRequest.getHttpServletRequest().getServerName();
    }

    boolean isSecure() {
        return this.mRequest.getHttpServletRequest().isSecure();
    }

    void removeRequestAttribute(String name) {
        this.mRequest.getHttpServletRequest().removeAttribute(name);
    }

    void setRequestAttribute(String name, Object object) {
        this.mRequest.getHttpServletRequest().setAttribute(name, object);
    }

    boolean hasUploadedFile(String name) {
        return this.mRequest.hasUploadedFile(name);
    }

    UploadedFile getUploadedFile(String name) {
        return this.mRequest.getUploadedFile(name);
    }

    UploadedFile[] getUploadedFiles(String name) {
        return this.mRequest.getUploadedFiles(name);
    }

    void setStateCookies(Map<String, Cookie> stateCookies) {
        this.mStateCookies = stateCookies;
    }

    Map<String, Cookie> getStateCookies() {
        return this.mStateCookies;
    }

    void setStateCookie(Cookie cookie) {
        if (!$assertionsDisabled && cookie == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cookie.getName() == null) {
            throw new AssertionError();
        }
        if (this.mStateCookies == null) {
            this.mStateCookies = new HashMap<String, Cookie>();
        }
        this.mStateCookies.put(cookie.getName(), cookie);
    }

    boolean hasCookie(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (this.mStateCookies != null && this.mStateCookies.containsKey(name)) {
            return true;
        }
        return this.mRequest.hasCookie(name);
    }

    Cookie getCookie(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (this.mStateCookies != null && this.mStateCookies.containsKey(name)) {
            return this.mStateCookies.get(name);
        }
        return this.mRequest.getCookie(name);
    }

    HashMap<String, Cookie> getCookies() {
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        Cookie[] request_cookies = this.mRequest.getCookies();
        if (request_cookies != null) {
            Cookie[] cookieArray = request_cookies;
            int n = 0;
            while (n < cookieArray.length) {
                Cookie cookie = cookieArray[n];
                cookies.put(cookie.getName(), cookie);
                ++n;
            }
        }
        if (this.mStateCookies != null) {
            cookies.putAll(this.mStateCookies);
        }
        return cookies;
    }

    EmbeddingListener getEmbeddingListener() {
        return new EmbeddingListener(this);
    }

    PrecedenceListener getPrecedenceListener() {
        return new PrecedenceListener(this);
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.RequestState");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    static class EmbeddingListener
    implements OutputListener,
    OutcookieListener {
        private RequestState mState = null;
        private static /* synthetic */ boolean $assertionsDisabled;

        EmbeddingListener(RequestState state) {
            if (!$assertionsDisabled && state == null) {
                throw new AssertionError();
            }
            this.mState = state;
        }

        public void outputValueSet(String name, String[] values) {
            if (!this.mState.isEmbedded()) {
                return;
            }
            if (!this.mState.getEmbeddingContext().getElementContext().getElementInfo().containsGlobalVar(name)) {
                return;
            }
            this.mState.getEmbeddingContext().getElementContext().setOutputValues(name, values);
        }

        public void outputValueRemoved(String name) {
            if (!this.mState.isEmbedded()) {
                return;
            }
            if (!this.mState.getEmbeddingContext().getElementContext().getElementInfo().containsGlobalVar(name)) {
                return;
            }
            this.mState.getEmbeddingContext().getElementContext().removeOutputValue(name);
        }

        public void outcookieSet(Cookie cookie) {
            if (!this.mState.isEmbedded()) {
                return;
            }
            if (!this.mState.getEmbeddingContext().getElementContext().getElementInfo().containsIncookie(cookie.getName()) && !this.mState.getEmbeddingContext().getElementContext().getElementInfo().containsGlobalCookie(cookie.getName())) {
                return;
            }
            this.mState.getEmbeddingContext().getElementContext().setCookie(cookie);
            this.mState.getEmbeddingContext().getElementContext().getRequestState().setStateCookie(cookie);
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.engine.RequestState$EmbeddingListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }
    }

    static class PrecedenceListener
    implements OutputListener,
    OutcookieListener {
        private RequestState mState = null;
        private static /* synthetic */ boolean $assertionsDisabled;

        PrecedenceListener(RequestState state) {
            if (!$assertionsDisabled && state == null) {
                throw new AssertionError();
            }
            this.mState = state;
        }

        public void outputValueSet(String name, String[] values) {
            if (!this.mState.isPreceeding()) {
                return;
            }
            if (!this.mState.getPrecedenceTarget().containsGlobalVar(name)) {
                return;
            }
            this.mState.getElementState().getRequestParameters().put(name, values);
        }

        public void outputValueRemoved(String name) {
            if (!this.mState.isPreceeding()) {
                return;
            }
            if (!this.mState.getPrecedenceTarget().containsGlobalVar(name)) {
                return;
            }
            this.mState.getElementState().getRequestParameters().remove(name);
        }

        public void outcookieSet(Cookie cookie) {
            if (!this.mState.isPreceeding()) {
                return;
            }
            if (!this.mState.getPrecedenceTarget().containsIncookie(cookie.getName()) && !this.mState.getPrecedenceTarget().containsGlobalCookie(cookie.getName())) {
                return;
            }
            this.mState.setStateCookie(cookie);
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.engine.RequestState$PrecedenceListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }
    }
}

