/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.engine.UploadedFile;
import com.uwyn.rife.engine.exceptions.MultipartCorruptContentDispositionException;
import com.uwyn.rife.engine.exceptions.MultipartCorruptContentTypeException;
import com.uwyn.rife.engine.exceptions.MultipartFileErrorException;
import com.uwyn.rife.engine.exceptions.MultipartFileTooBigException;
import com.uwyn.rife.engine.exceptions.MultipartInputErrorException;
import com.uwyn.rife.engine.exceptions.MultipartInvalidBoundaryException;
import com.uwyn.rife.engine.exceptions.MultipartInvalidContentDispositionException;
import com.uwyn.rife.engine.exceptions.MultipartInvalidContentTypeException;
import com.uwyn.rife.engine.exceptions.MultipartInvalidUploadDirectoryException;
import com.uwyn.rife.engine.exceptions.MultipartMissingBoundaryException;
import com.uwyn.rife.engine.exceptions.MultipartUnexpectedEndingException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultipartRequest {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String MULTIPART_CONTENT_TYPE = "multipart/form-data";
    private static final String BOUNDARY_PREFIX = "boundary=";
    private static final int BOUNDARY_PREFIX_LENGTH;
    private static final String CONTENT_DISPOSITION_PREFIX = "content-disposition: ";
    private static final int CONTENT_DISPOSITION_PREFIX_LENGTH;
    private static final String FIELD_NAME_PREFIX = "name=\"";
    private static final int FIELD_NAME_PREFIX_LENGTH;
    private static final String FILENAME_PREFIX = "filename=\"";
    private static final int FILENAME_PREFIX_LENGTH;
    private static final String QUOTE = "\"";
    private static final String FORM_DATA_DISPOSITION = "form-data";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private File mUploadDirectory = null;
    private HttpServletRequest mRequest = null;
    private String mBoundary = null;
    private ServletInputStream mInput = null;
    private byte[] mParameterBuffer = null;
    private byte[] mFileBuffer = null;
    private String mEncoding = "UTF-8";
    private HashMap<String, String[]> mParameters = null;
    private HashMap<String, UploadedFile[]> mFiles = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    MultipartRequest(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request can't be null");
        }
        this.mRequest = request;
        this.mParameters = new HashMap();
        this.mFiles = new HashMap();
        this.mParameterBuffer = new byte[8192];
        this.mFileBuffer = new byte[102400];
        this.checkUploadDirectory();
        this.initialize();
        this.checkInputStart();
        this.readParts();
    }

    static boolean isValidContentType(String type) {
        return type != null && type.toLowerCase().startsWith(MULTIPART_CONTENT_TYPE);
    }

    Map<String, String[]> getParameterMap() {
        return this.mParameters;
    }

    Map<String, UploadedFile[]> getFileMap() {
        return this.mFiles;
    }

    void setEncoding(String encoding) {
        if (!$assertionsDisabled && encoding == null) {
            throw new AssertionError();
        }
        this.mEncoding = encoding;
    }

    private void checkUploadDirectory() {
        this.mUploadDirectory = new File(RifeConfig.Engine.getFileUploadPath());
        this.mUploadDirectory.mkdirs();
        if (!(this.mUploadDirectory.exists() && this.mUploadDirectory.isDirectory() && this.mUploadDirectory.canWrite())) {
            throw new MultipartInvalidUploadDirectoryException(this.mUploadDirectory);
        }
    }

    private void initialize() {
        String type = null;
        String type_header = this.mRequest.getHeader(CONTENT_TYPE_HEADER);
        String type_method = this.mRequest.getContentType();
        if (type_header == null && type_method != null) {
            type = type_method;
        } else if (type_method == null && type_header != null) {
            type = type_header;
        } else if (type_header != null && type_method != null) {
            String string = type = type_header.length() > type_method.length() ? type_header : type_method;
        }
        if (!MultipartRequest.isValidContentType(type)) {
            throw new MultipartInvalidContentTypeException(type);
        }
        this.mBoundary = this.extractBoundary(type);
        if (this.mBoundary == null) {
            throw new MultipartMissingBoundaryException();
        }
        try {
            this.mInput = this.mRequest.getInputStream();
        }
        catch (IOException e) {
            throw new MultipartInputErrorException(e);
        }
    }

    private void checkInputStart() {
        String line = this.readLine();
        if (line == null) {
            throw new MultipartUnexpectedEndingException();
        }
        if (!line.startsWith(this.mBoundary)) {
            throw new MultipartInvalidBoundaryException(this.mBoundary, line);
        }
    }

    private void readParts() {
        boolean more_parts = true;
        while (more_parts) {
            more_parts = this.readNextPart();
        }
    }

    private String extractBoundary(String line) {
        int index = line.lastIndexOf(BOUNDARY_PREFIX);
        if (-1 == index) {
            return null;
        }
        String boundary = line.substring(index + BOUNDARY_PREFIX_LENGTH);
        if ('\"' == boundary.charAt(0)) {
            index = boundary.lastIndexOf(34);
            boundary = boundary.substring(1, index);
        }
        boundary = new StringBuffer().append("--").append(boundary).toString();
        return boundary;
    }

    private String readLine() {
        StringBuffer line_buffer = new StringBuffer();
        int result = 0;
        do {
            try {
                result = this.mInput.readLine(this.mParameterBuffer, 0, this.mParameterBuffer.length);
            }
            catch (IOException e) {
                throw new MultipartInputErrorException(e);
            }
            if (result == -1) continue;
            try {
                line_buffer.append(new String(this.mParameterBuffer, 0, result, this.mEncoding));
            }
            catch (UnsupportedEncodingException e) {
                throw new MultipartInputErrorException(e);
            }
        } while (result == this.mParameterBuffer.length);
        if (line_buffer.length() == 0) {
            return null;
        }
        int line_length = line_buffer.length();
        if (line_length >= 2 && '\r' == line_buffer.charAt(line_length - 2)) {
            line_buffer.setLength(line_length - 2);
        } else if (line_length >= 1 && '\n' == line_buffer.charAt(line_length - 1)) {
            line_buffer.setLength(line_length - 1);
        }
        return line_buffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private boolean readNextPart() {
        headers = new ArrayList<String>();
        line = this.readLine();
        if (line != null && 0 != line.length()) ** GOTO lbl17
        return false;
lbl-1000:
        // 1 sources

        {
            next_line = null;
            obtain_next_line = true;
            while (obtain_next_line) {
                next_line = this.readLine();
                if (next_line != null && (next_line.startsWith(" ") || next_line.startsWith("\t"))) {
                    line = new StringBuffer().append(line).append(next_line).toString();
                    continue;
                }
                obtain_next_line = false;
            }
            headers.add(line);
            line = next_line;
lbl17:
            // 2 sources

            ** while (line != null && line.length() > 0)
        }
lbl18:
        // 1 sources

        if (line == null) {
            return false;
        }
        fieldname = null;
        filename = null;
        content_type = "text/plain";
        disposition_info = null;
        for (String headerline : (Collection)headers) {
            if (headerline.toLowerCase().startsWith("content-disposition: ")) {
                disposition_info = this.extractDispositionInfo(headerline);
                fieldname = disposition_info[0];
                filename = disposition_info[1];
                continue;
            }
            if (!headerline.toLowerCase().startsWith("Content-Type") || (type = this.extractContentType(headerline)) == null) continue;
            content_type = type;
        }
        if (filename == null) {
            new_value = this.readParameter();
            values = this.mParameters.get(fieldname);
            new_values = null;
            if (values == null) {
                new_values = new String[1];
            } else {
                new_values = new String[values.length + 1];
                System.arraycopy(values, 0, new_values, 0, values.length);
            }
            new_values[new_values.length - 1] = new_value;
            this.mParameters.put(fieldname, new_values);
        } else {
            if (filename.equals("")) {
                filename = null;
            }
            new_file = new UploadedFile(filename, content_type);
            this.readAndSaveFile(new_file, fieldname);
            files = this.mFiles.get(fieldname);
            new_files = null;
            if (files == null) {
                new_files = new UploadedFile[1];
            } else {
                new_files = new UploadedFile[files.length + 1];
                System.arraycopy(files, 0, new_files, 0, files.length);
            }
            new_files[new_files.length - 1] = new_file;
            this.mFiles.put(fieldname, new_files);
        }
        return true;
    }

    private String[] extractDispositionInfo(String dispositionLine) {
        int last_slash;
        String[] result = new String[3];
        String lowcase_line = dispositionLine.toLowerCase();
        String fieldname = null;
        String filename = null;
        String filename_full = null;
        int start = lowcase_line.indexOf(CONTENT_DISPOSITION_PREFIX);
        int end = lowcase_line.indexOf(";");
        if (-1 == start || -1 == end) {
            throw new MultipartCorruptContentDispositionException(dispositionLine);
        }
        String disposition = lowcase_line.substring(start + CONTENT_DISPOSITION_PREFIX_LENGTH, end);
        if (!disposition.equals(FORM_DATA_DISPOSITION)) {
            throw new MultipartInvalidContentDispositionException(dispositionLine);
        }
        start = lowcase_line.indexOf(FIELD_NAME_PREFIX, end);
        end = lowcase_line.indexOf(QUOTE, start + FIELD_NAME_PREFIX_LENGTH);
        if (-1 == start || -1 == end) {
            throw new MultipartCorruptContentDispositionException(dispositionLine);
        }
        fieldname = dispositionLine.substring(start + FIELD_NAME_PREFIX_LENGTH, end);
        start = lowcase_line.indexOf(FILENAME_PREFIX, end + 2);
        end = lowcase_line.indexOf(QUOTE, start + FILENAME_PREFIX_LENGTH);
        if (start != -1 && end != -1 && (last_slash = Math.max((filename = (filename_full = dispositionLine.substring(start + FILENAME_PREFIX_LENGTH, end))).lastIndexOf(47), filename.lastIndexOf(92))) > -1) {
            filename = filename.substring(last_slash + 1);
        }
        result[0] = fieldname;
        result[1] = filename;
        result[2] = filename_full;
        return result;
    }

    private String extractContentType(String contentTypeLine) {
        String result = null;
        String lowcase_line = contentTypeLine.toLowerCase();
        if (lowcase_line.startsWith(CONTENT_TYPE_HEADER)) {
            int seperator_location = lowcase_line.indexOf(" ");
            if (-1 == seperator_location) {
                throw new MultipartCorruptContentTypeException(contentTypeLine);
            }
            result = lowcase_line.substring(seperator_location + 1);
        } else if (lowcase_line.length() != 0) {
            throw new MultipartCorruptContentTypeException(contentTypeLine);
        }
        return result;
    }

    private String readParameter() {
        StringBuffer result = new StringBuffer();
        String line = null;
        StringBuffer stringBuffer = result;
        synchronized (stringBuffer) {
            while ((line = this.readLine()) != null) {
                if (line.startsWith(this.mBoundary)) break;
                result.append(new StringBuffer().append(line).append("\r\n").toString());
            }
            if (0 == result.length()) {
                return null;
            }
            result.setLength(result.length() - 2);
            return result.toString();
        }
    }

    private void readAndSaveFile(UploadedFile file, String name) {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        File tmp_file = null;
        FileOutputStream output_stream = null;
        BufferedOutputStream output = null;
        try {
            tmp_file = File.createTempFile("upl", ".tmp", this.mUploadDirectory);
        }
        catch (IOException e) {
            throw new MultipartFileErrorException(name, e);
        }
        try {
            output_stream = new FileOutputStream(tmp_file);
        }
        catch (FileNotFoundException e) {
            throw new MultipartFileErrorException(name, e);
        }
        output = new BufferedOutputStream(output_stream, 8192);
        int downloaded_size = 0;
        int result = -1;
        String line = null;
        int line_length = 0;
        boolean rnflag = false;
        try {
            try {
                while ((result = this.mInput.readLine(this.mFileBuffer, 0, this.mFileBuffer.length)) != -1) {
                    if (result > 2 && 45 == this.mFileBuffer[0] && 45 == this.mFileBuffer[1]) {
                        try {
                            line = new String(this.mFileBuffer, 0, result, this.mEncoding);
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new MultipartFileErrorException(name, e);
                        }
                        if (line.startsWith(this.mBoundary)) {
                            break;
                        }
                    }
                    if (rnflag && output != null) {
                        output.write(13);
                        output.write(10);
                        rnflag = false;
                    }
                    if (result >= 2 && 13 == this.mFileBuffer[result - 2] && 10 == this.mFileBuffer[result - 1]) {
                        line_length = result - 2;
                        rnflag = true;
                    } else {
                        line_length = result;
                    }
                    if (output != null && RifeConfig.Engine.getFileuploadSizeCheck() && (downloaded_size += line_length) > RifeConfig.Engine.getFileuploadSizeLimit()) {
                        file.setSizeExceeded(true);
                        output.close();
                        output = null;
                        tmp_file.delete();
                        tmp_file = null;
                        if (RifeConfig.Engine.getFileUploadSizeException()) {
                            throw new MultipartFileTooBigException(name, RifeConfig.Engine.getFileuploadSizeLimit());
                        }
                    }
                    if (output == null) continue;
                    output.write(this.mFileBuffer, 0, line_length);
                }
            }
            catch (IOException e) {
                throw new MultipartFileErrorException(name, e);
            }
        }
        finally {
            try {
                if (output != null) {
                    output.flush();
                    output.close();
                    output_stream.close();
                }
            }
            catch (IOException e) {
                throw new MultipartFileErrorException(name, e);
            }
        }
        if (tmp_file != null) {
            file.setTempFile(tmp_file);
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.MultipartRequest");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        BOUNDARY_PREFIX_LENGTH = BOUNDARY_PREFIX.length();
        CONTENT_DISPOSITION_PREFIX_LENGTH = CONTENT_DISPOSITION_PREFIX.length();
        FIELD_NAME_PREFIX_LENGTH = FIELD_NAME_PREFIX.length();
        FILENAME_PREFIX_LENGTH = FILENAME_PREFIX.length();
    }
}

