/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.asm.AnnotationVisitor;
import com.uwyn.rife.asm.Attribute;
import com.uwyn.rife.asm.ClassVisitor;
import com.uwyn.rife.asm.FieldVisitor;
import com.uwyn.rife.asm.MethodVisitor;
import com.uwyn.rife.engine.ContinuationDebug;
import com.uwyn.rife.engine.MetricsMethodVisitor;
import java.util.ArrayList;
import java.util.logging.Level;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetricsClassVisitor
implements ClassVisitor {
    private String mClassName = null;
    private String mEntryMethod = null;
    private int mMaxLocals = -1;
    private int mPauseCount = -1;
    private ArrayList<String> mExceptionTypes = null;

    public MetricsClassVisitor(String className, String entryMethod) {
        this.mClassName = className;
        this.mEntryMethod = entryMethod;
    }

    void setMaxLocals(int maxLocals) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append("maxlocals = ").append(maxLocals).toString());
        }
        this.mMaxLocals = maxLocals;
    }

    int getMaxLocals() {
        return this.mMaxLocals;
    }

    void setPauseCount(int pauseCount) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append("pauseCount = ").append(pauseCount).toString());
        }
        this.mPauseCount = pauseCount;
    }

    void setExceptionTypes(ArrayList<String> exceptionTypes) {
        this.mExceptionTypes = exceptionTypes;
    }

    String nextExceptionType() {
        return this.mExceptionTypes.remove(0);
    }

    int getPauseCount() {
        return this.mPauseCount;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.mEntryMethod.equals(new StringBuffer().append(name).append(desc).toString())) {
            return new MetricsMethodVisitor(this, this.mClassName);
        }
        return null;
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public void visitSource(String source, String debug) {
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    @Override
    public void visitEnd() {
    }
}

