/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.engine.ElementInfoBuilder;
import com.uwyn.rife.engine.ElementInfoProcessor;
import com.uwyn.rife.engine.exceptions.NotFoundProcessingErrorException;
import com.uwyn.rife.engine.exceptions.ParsingErrorException;
import com.uwyn.rife.engine.exceptions.ProcessingErrorException;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.resources.exceptions.ResourceFinderErrorException;
import com.uwyn.rife.tools.InputStreamUser;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.ScriptEvaluator;

class Janino2ElementInfo
implements ElementInfoProcessor {
    Janino2ElementInfo() {
    }

    public void processElementInfo(ElementInfoBuilder builder, String declarationName, ResourceFinder resourceFinder) {
        JaninoProcessor processor = new JaninoProcessor(builder);
        String processed_path = null;
        try {
            try {
                processed_path = declarationName;
                processor.processJanino(processed_path, resourceFinder);
            }
            catch (NotFoundProcessingErrorException e) {
                processed_path = "elements/" + declarationName;
                processor.processJanino(processed_path, resourceFinder);
            }
        }
        catch (Exception e) {
            throw new ProcessingErrorException("element", declarationName, e);
        }
        if (RifeConfig.Engine.getSiteAutoReload()) {
            URL resource = resourceFinder.getResource(processed_path);
            if (resource == null) {
                throw new NotFoundProcessingErrorException("element", processed_path, null);
            }
            try {
                builder.addResourceModificationTime(resource, resourceFinder.getModificationTime(resource));
            }
            catch (ResourceFinderErrorException e) {
                throw new ProcessingErrorException("element", declarationName, "Error while retrieving the modification time.", e);
            }
        }
    }

    private class JaninoProcessor {
        private ElementInfoBuilder mElementInfoBuilder = null;

        JaninoProcessor(ElementInfoBuilder builder) {
            this.mElementInfoBuilder = builder;
        }

        public synchronized void processJanino(String janinoPath, ResourceFinder resourceFinder) {
            if (janinoPath == null) {
                throw new IllegalArgumentException("janinoPath can't be null.");
            }
            if (janinoPath.length() == 0) {
                throw new IllegalArgumentException("janinoPath can't be empty.");
            }
            if (resourceFinder == null) {
                throw new IllegalArgumentException("resourceFinder can't be null.");
            }
            ScriptEvaluator evaluator = null;
            try {
                evaluator = (ScriptEvaluator)resourceFinder.useStream(janinoPath, (InputStreamUser)new 1(janinoPath));
            }
            catch (ResourceFinderErrorException e) {
                throw new NotFoundProcessingErrorException("element", janinoPath, e);
            }
            try {
                evaluator.evaluate(new Object[]{this.mElementInfoBuilder});
            }
            catch (InvocationTargetException e) {
                throw new ProcessingErrorException("element", janinoPath, e);
            }
        }

        static /* synthetic */ Janino2ElementInfo access$0(JaninoProcessor janinoProcessor) {
            return janinoProcessor.Janino2ElementInfo.this;
        }

        class 1
        extends InputStreamUser {
            private final /* synthetic */ String val$janinoPath;

            1(String string) {
                this.val$janinoPath = string;
            }

            public ScriptEvaluator useInputStream(InputStream stream) {
                if (stream == null) {
                    throw new NotFoundProcessingErrorException("element", this.val$janinoPath, null);
                }
                Object evaluator = null;
                try {
                    Class<?> clazz;
                    Class[] classArray = new Class[1];
                    try {
                        clazz = Class.forName("com.uwyn.rife.engine.ElementInfoBuilder");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    classArray[0] = clazz;
                    return new ScriptEvaluator(new Scanner(this.val$janinoPath, stream), Void.TYPE, new String[]{"builder"}, classArray, new Class[0], this.getClass().getClassLoader());
                }
                catch (Throwable e) {
                    throw new ParsingErrorException("element", this.val$janinoPath, e);
                }
            }

            public /* synthetic */ Object useInputStream(InputStream inputStream) {
                return this.useInputStream(inputStream);
            }

            static /* synthetic */ JaninoProcessor access$0(1 var0) {
                return var0.JaninoProcessor.this;
            }
        }
    }
}

