/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.ParameterMapEncoder;
import com.uwyn.rife.engine.RequestMethod;
import com.uwyn.rife.engine.RequestState;
import com.uwyn.rife.engine.TriggerContext;
import com.uwyn.rife.engine.TriggerListEncoder;
import com.uwyn.rife.tools.ExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ElementState
implements Cloneable {
    private RequestState mRequestState = null;
    private RequestMethod mMethod = null;
    private String mPathInfo = null;
    private Stack<ElementInfo> mInheritanceStack = null;
    private Map<String, String[]> mRequestParameters = null;
    private Map<String, String[]> mInputs = null;
    private HashSet<String> mNonParameterInputs = null;
    private ArrayList<TriggerContext> mTriggerList = null;
    private ArrayList<TriggerContext> mTriggerListState = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    ElementState(RequestState requestState) {
        this.setRequestState(requestState);
        if (this.mRequestState.getRequest() != null) {
            this.setMethod(this.mRequestState.getRequest().getMethod());
        }
        this.setupPreservedInputs();
    }

    void setRequestState(RequestState request) {
        this.mRequestState = request;
    }

    void setPathInfo(String pathInfo) {
        this.mPathInfo = pathInfo;
    }

    String getPathInfo() {
        return this.mPathInfo;
    }

    void setMethod(RequestMethod method) {
        if (!$assertionsDisabled && method == null) {
            throw new AssertionError();
        }
        this.mMethod = method;
    }

    void setInheritanceStack(Stack<ElementInfo> inheritanceStack) {
        this.mInheritanceStack = inheritanceStack;
    }

    Stack<ElementInfo> getInheritanceStack() {
        return this.mInheritanceStack;
    }

    void setInputs(Map<String, String[]> inputs) {
        this.mInputs = inputs;
    }

    Map<String, String[]> getInputs() {
        return this.mInputs;
    }

    void setNonParameterInputs(HashSet<String> nonParameterInputs) {
        this.mNonParameterInputs = nonParameterInputs;
    }

    boolean isInheritanceTarget() {
        return this.mInheritanceStack != null && 0 == this.mInheritanceStack.size();
    }

    boolean inInheritanceStructure() {
        return this.mInheritanceStack != null && this.mInheritanceStack.size() > 0;
    }

    private boolean isNonParameterInput(String name) {
        if (this.mNonParameterInputs == null) {
            return false;
        }
        return this.mNonParameterInputs.contains(name);
    }

    boolean hasInputValue(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (this.isInheritanceTarget()) {
            if (this.mInputs != null && this.mInputs.containsKey(name)) {
                return true;
            }
            if (this.isNonParameterInput(name)) {
                return false;
            }
            return this.hasParameterValue(name);
        }
        if (this.mInputs != null) {
            return this.mInputs.containsKey(name);
        }
        if (this.isNonParameterInput(name)) {
            return false;
        }
        return this.hasParameterValue(name);
    }

    String getInput(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        String input_value = null;
        if (this.isInheritanceTarget()) {
            String[] input_values_list;
            if (this.mInputs != null && (input_values_list = this.mInputs.get(name)) != null) {
                input_value = input_values_list[0];
            }
            if (input_value == null && !this.isNonParameterInput(name)) {
                input_value = this.getParameter(name);
            }
        } else if (this.mInputs != null) {
            String[] input_values_list = this.mInputs.get(name);
            if (input_values_list != null) {
                input_value = input_values_list[0];
            }
        } else if (!this.isNonParameterInput(name)) {
            input_value = this.getParameter(name);
        }
        return input_value;
    }

    String[] getInputValues(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        String[] input_values = null;
        if (this.isInheritanceTarget()) {
            if (this.mInputs != null) {
                input_values = this.mInputs.get(name);
            }
            if (input_values == null && !this.isNonParameterInput(name)) {
                input_values = this.getParameterValues(name);
            }
        } else if (this.mInputs != null) {
            input_values = this.mInputs.get(name);
        } else if (!this.isNonParameterInput(name)) {
            input_values = this.getParameterValues(name);
        }
        return input_values;
    }

    Set<Map.Entry<String, String[]>> getInputEntries() {
        Set<Map.Entry<String, Object>> input_entries = null;
        if (this.isInheritanceTarget()) {
            HashMap<String, String[]> inputs_merge = new HashMap<String, String[]>();
            inputs_merge.putAll(this.getRequestParameters());
            if (this.mNonParameterInputs != null) {
                for (String non_input_param : (Collection)this.mNonParameterInputs) {
                    inputs_merge.remove(non_input_param);
                }
            }
            inputs_merge.putAll(this.mInputs);
            input_entries = inputs_merge.entrySet();
        } else if (this.mInputs != null) {
            input_entries = this.mInputs.entrySet();
        } else if (input_entries == null) {
            if (this.mNonParameterInputs != null && this.mNonParameterInputs.size() > 0) {
                HashMap<String, String[]> filtered_parameters = new HashMap<String, String[]>(this.getRequestParameters());
                for (String non_input_param : (Collection)this.mNonParameterInputs) {
                    filtered_parameters.remove(non_input_param);
                }
                input_entries = filtered_parameters.entrySet();
            } else {
                input_entries = this.getParameterEntries();
            }
        }
        return input_entries;
    }

    boolean isNextTrigger(ElementInfo elementInfo) {
        if (!$assertionsDisabled && elementInfo == null) {
            throw new AssertionError();
        }
        return this.mTriggerListState != null && this.mTriggerListState.size() > 0 && this.mTriggerListState.get(0).getDeclarationName().equals(elementInfo.getDeclarationName());
    }

    boolean isNextChildTrigger(ElementInfo elementInfo, String childName) {
        if (!$assertionsDisabled && elementInfo == null) {
            throw new AssertionError();
        }
        if (childName == null) {
            return false;
        }
        return this.isNextTrigger(elementInfo) && this.mTriggerListState.get(0).getType() == 1 && this.mTriggerListState.get(0).getTriggerName() == childName;
    }

    boolean isNextExitTrigger(ElementInfo elementInfo, String exitName) {
        if (!$assertionsDisabled && elementInfo == null) {
            throw new AssertionError();
        }
        if (exitName == null) {
            return false;
        }
        return this.isNextTrigger(elementInfo) && this.mTriggerListState.get(0).getType() == 2 && this.mTriggerListState.get(0).getTriggerName() == exitName;
    }

    String getNextTriggerName() {
        return this.mTriggerListState.get(0).getTriggerName();
    }

    int getNextTriggerType() {
        return this.mTriggerListState.get(0).getType();
    }

    String[] getNextTriggerValues() {
        return this.mTriggerListState.get(0).getTriggerValues();
    }

    boolean hasTriggerList() {
        return this.mTriggerList != null;
    }

    void setTriggerList(ArrayList<TriggerContext> triggerList) {
        this.mTriggerList = triggerList;
        this.mTriggerListState = new ArrayList<TriggerContext>(this.mTriggerList);
    }

    void addTrigger(TriggerContext triggerContext) {
        if (!$assertionsDisabled && triggerContext == null) {
            throw new AssertionError();
        }
        this.mTriggerList.add(triggerContext);
    }

    TriggerContext nextTrigger() {
        TriggerContext next_trigger = this.mTriggerListState.get(0);
        this.mTriggerListState.remove(0);
        return next_trigger;
    }

    String encodeTriggerList() {
        return TriggerListEncoder.encode(this.mTriggerList);
    }

    ArrayList<TriggerContext> cloneTriggerList() {
        return new ArrayList<TriggerContext>(this.mTriggerList);
    }

    RequestMethod getMethod() {
        return this.mMethod;
    }

    void setRequestParameters(Map<String, String[]> parameters) {
        this.mRequestParameters = parameters;
        this.mRequestState.setupContinuations();
        this.setupPreservedInputs();
    }

    Map<String, String[]> getRequestParameters() {
        if (this.mRequestParameters == null) {
            return this.mRequestState.getRequest().getParameters();
        }
        return this.mRequestParameters;
    }

    Collection<String> getParameterNames() {
        return this.getRequestParameters().keySet();
    }

    boolean hasParameterValue(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        return this.getRequestParameters().containsKey(name);
    }

    String getParameter(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        String[] parameters = this.getRequestParameters().get(name);
        if (parameters == null) {
            return null;
        }
        return parameters[0];
    }

    String[] getParameterValues(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        return this.getRequestParameters().get(name);
    }

    Set<Map.Entry<String, String[]>> getParameterEntries() {
        return this.getRequestParameters().entrySet();
    }

    private void setupPreservedInputs() {
        Map<String, String[]> inputs;
        String inputs_encoded = this.getParameter("inputs");
        if (inputs_encoded != null && (inputs = ParameterMapEncoder.decodeFromBase64String(inputs_encoded)) != null) {
            this.mInputs = inputs;
        }
    }

    public ElementState clone() {
        ElementState new_elementstate = null;
        try {
            new_elementstate = (ElementState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.site").severe(ExceptionUtils.getExceptionStackTrace(e));
            return null;
        }
        new_elementstate.mRequestState = null;
        if (this.mInheritanceStack != null) {
            new_elementstate.mInheritanceStack = new Stack();
            new_elementstate.mInheritanceStack.addAll(this.mInheritanceStack);
        }
        new_elementstate.mRequestParameters = this.mRequestParameters == null ? new HashMap<String, String[]>(this.mRequestState.getRequest().getParameters()) : new HashMap<String, String[]>(this.mRequestParameters);
        if (this.mInputs != null) {
            new_elementstate.mInputs = new HashMap<String, String[]>(this.mInputs);
        }
        if (this.mNonParameterInputs != null) {
            new_elementstate.mNonParameterInputs = new HashSet<String>(this.mNonParameterInputs);
        }
        if (this.mTriggerList != null) {
            new_elementstate.mTriggerList = new ArrayList<TriggerContext>(this.mTriggerList);
        }
        if (this.mTriggerListState != null) {
            new_elementstate.mTriggerListState = new ArrayList<TriggerContext>(this.mTriggerListState);
        }
        return new_elementstate;
    }

    public /* synthetic */ Object clone() {
        return this.clone();
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.ElementState");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

