/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.BeanDeclaration;
import com.uwyn.rife.engine.DataLinkDeclaration;
import com.uwyn.rife.engine.ElementDeclaration;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.ElementInfoProcessor;
import com.uwyn.rife.engine.ElementInfoProcessorFactory;
import com.uwyn.rife.engine.FlowLinkDeclaration;
import com.uwyn.rife.engine.GlobalExit;
import com.uwyn.rife.engine.GlobalVar;
import com.uwyn.rife.engine.Site;
import com.uwyn.rife.engine.SiteBuilder;
import com.uwyn.rife.engine.SubmissionBuilder;
import com.uwyn.rife.engine.exceptions.DataLinkAmbiguousInputException;
import com.uwyn.rife.engine.exceptions.DataLinkAmbiguousOutputException;
import com.uwyn.rife.engine.exceptions.DataLinkAmbiguousTargetException;
import com.uwyn.rife.engine.exceptions.DataLinkIncompatibleInputOutputException;
import com.uwyn.rife.engine.exceptions.DataLinkInputRequiredException;
import com.uwyn.rife.engine.exceptions.DataLinkOutputRequiredException;
import com.uwyn.rife.engine.exceptions.DataLinkTargetRequiredException;
import com.uwyn.rife.engine.exceptions.ElementIdInvalidException;
import com.uwyn.rife.engine.exceptions.ElementInfoProcessorExtensionUnsupportedException;
import com.uwyn.rife.engine.exceptions.ElementInfoProcessorIdentifierUnsupportedException;
import com.uwyn.rife.engine.exceptions.EngineException;
import com.uwyn.rife.engine.exceptions.FlowLinkAmbiguousTargetException;
import com.uwyn.rife.engine.exceptions.FlowLinkTargetRequiredException;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.site.Constrained;
import com.uwyn.rife.site.ConstrainedUtils;
import com.uwyn.rife.tools.BeanUtils;
import com.uwyn.rife.tools.Localization;
import com.uwyn.rife.tools.exceptions.BeanUtilsException;
import com.uwyn.rife.xml.exceptions.XmlErrorException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementInfoBuilder {
    private SiteBuilder mSiteBuilder = null;
    private ResourceFinder mResourceFinder = null;
    private ElementDeclaration mDeclaration = null;
    private String mExtendsFrom = null;
    private String mContentType = null;
    private String mImplementation = null;
    private String mInherits = null;
    private String mPre = null;
    private ArrayList<DataLinkDeclaration> mDataLinks = null;
    private ArrayList<FlowLinkDeclaration> mFlowLinks = null;
    private LinkedHashMap<BeanDeclaration, String> mInbeans = null;
    private LinkedHashMap<BeanDeclaration, String> mOutbeans = null;
    private LinkedHashMap<String, Object> mStaticProperties = null;
    private LinkedHashMap<String, String[]> mInputs = null;
    private LinkedHashMap<String, String[]> mOutputs = null;
    private LinkedHashMap<String, String> mIncookies = null;
    private LinkedHashMap<String, String> mOutcookies = null;
    private ArrayList<String> mExits = null;
    private ArrayList<String> mChildTriggers = null;
    private ArrayList<SubmissionBuilder> mSubmissionBuilders = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    ElementInfoBuilder(SiteBuilder siteBuilder, ResourceFinder resourceFinder, ElementDeclaration declaration) {
        if (!$assertionsDisabled && siteBuilder == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && resourceFinder == null) {
            throw new AssertionError();
        }
        this.mSiteBuilder = siteBuilder;
        this.mResourceFinder = resourceFinder;
        this.mDeclaration = declaration;
    }

    void process() {
        this.process(this.mDeclaration.getDeclarationName());
    }

    void process(String declarationName) {
        String declaration_name_part = declarationName;
        ElementInfoProcessorFactory processor_factory = null;
        String identifier = "manual";
        int identifier_index = declarationName.indexOf(":");
        int extension_index = declarationName.lastIndexOf(".");
        if (identifier_index != -1) {
            identifier = declarationName.substring(0, identifier_index);
            declaration_name_part = declarationName.substring(identifier_index + 1);
            processor_factory = ElementInfoProcessorFactory.getElementInfoProcessorFactory(identifier);
        } else if (extension_index != -1) {
            String extension = declarationName.substring(extension_index + 1);
            Collection<ElementInfoProcessorFactory> factories = ElementInfoProcessorFactory.getElementInfoProcessorFactories();
            for (ElementInfoProcessorFactory factory : factories) {
                if (factory.getExtension() == null || !factory.getExtension().equals(extension)) continue;
                processor_factory = factory;
                break;
            }
            if (processor_factory == null) {
                throw new ElementInfoProcessorExtensionUnsupportedException(declarationName, extension);
            }
        } else {
            processor_factory = ElementInfoProcessorFactory.getElementInfoProcessorFactory(identifier);
        }
        if (processor_factory == null) {
            throw new ElementInfoProcessorIdentifierUnsupportedException(declarationName, identifier);
        }
        ElementInfoProcessor processor = processor_factory.getProcessor();
        if (processor != null) {
            processor.processElementInfo(this, declaration_name_part, this.mResourceFinder);
        }
    }

    ElementInfo getElementInfo(HashMap<String, GlobalExit> globalExits, HashMap<String, GlobalVar> globalVars, HashMap<String, String> globalCookies, HashMap<String, BeanDeclaration> namedGlobalBeans) {
        SortedSet<String> properties;
        Constrained constrained;
        Class<?> bean_class;
        BeanDeclaration declaration;
        String name;
        ElementInfo element_info = new ElementInfo();
        if (this.mDeclaration != null) {
            element_info.setDeclarationName(this.mDeclaration.getDeclarationName());
        }
        element_info.setGlobalExits(globalExits);
        element_info.setGlobalVars(globalVars);
        element_info.setGlobalCookies(globalCookies);
        element_info.setNamedGlobalBeans(namedGlobalBeans);
        if (this.mExtendsFrom != null) {
            Iterator builder = new ElementInfoBuilder(this.mSiteBuilder, this.mResourceFinder, null);
            ((ElementInfoBuilder)((Object)builder)).process(this.mExtendsFrom);
            ElementInfo extended_element_info = ((ElementInfoBuilder)((Object)builder)).getElementInfo(globalExits, globalVars, globalCookies, namedGlobalBeans);
            extended_element_info.getDeclarationName();
            element_info.extendFrom(extended_element_info);
        }
        element_info.setContentType(this.mContentType);
        if (this.mImplementation != null) {
            element_info.setImplementation(this.mImplementation);
        }
        if (this.mInherits != null) {
            this.mInherits = this.mSiteBuilder.makeAbsoluteElementId(this.mInherits);
            this.mInherits = Site.getCanonicalId(this.mInherits);
            this.mDeclaration.setInherits(this.mInherits);
        }
        if (this.mPre != null) {
            this.mPre = this.mSiteBuilder.makeAbsoluteElementId(this.mPre);
            this.mPre = Site.getCanonicalId(this.mPre);
            this.mDeclaration.setPre(this.mPre);
        }
        if (this.mDataLinks != null) {
            for (DataLinkDeclaration datalink : (Collection)this.mDataLinks) {
                datalink.makeAbsoluteDestId(this.mSiteBuilder);
                this.mSiteBuilder.addDataLink(this.mDeclaration.getId(), datalink);
            }
        }
        if (this.mFlowLinks != null) {
            for (Iterator flowlink : (Collection)this.mFlowLinks) {
                ((FlowLinkDeclaration)((Object)flowlink)).makeAbsoluteDestId(this.mSiteBuilder);
                this.mSiteBuilder.addFlowLink(this.mDeclaration.getId(), (FlowLinkDeclaration)((Object)flowlink));
            }
        }
        if (this.mInbeans != null) {
            name = null;
            declaration = null;
            for (Map.Entry inbean : (Collection)this.mInbeans.entrySet()) {
                name = (String)inbean.getValue();
                declaration = (BeanDeclaration)inbean.getKey();
                try {
                    bean_class = Class.forName(declaration.getClassname());
                    if (name != null) {
                        try {
                            element_info.addNamedInbean(name, declaration);
                        }
                        catch (EngineException e) {
                            throw new XmlErrorException(new StringBuffer().append(new StringBuffer().append("The input bean with name '").append(name).toString()).append("' already exists.").toString());
                        }
                    }
                    try {
                        constrained = ConstrainedUtils.getConstrainedInstance(bean_class);
                        properties = BeanUtils.getPropertyNames(bean_class, null, null, declaration.getPrefix());
                        for (String property : (Collection)properties) {
                            if (!ConstrainedUtils.editConstrainedProperty(constrained, property, declaration.getPrefix()) || element_info.containsInput(property)) continue;
                            element_info.addInput(property, null);
                        }
                    }
                    catch (BeanUtilsException e) {
                        throw new XmlErrorException(new StringBuffer().append(new StringBuffer().append("Unexpected error while obtaining the properties of the input bean with class '").append(declaration.getClassname()).toString()).append("'.").toString(), e);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new XmlErrorException(new StringBuffer().append(new StringBuffer().append("The input bean with class '").append(declaration.getClassname()).toString()).append("' could not be found.").toString());
                }
            }
        }
        if (this.mOutbeans != null) {
            name = null;
            declaration = null;
            for (Map.Entry outbean : (Collection)this.mOutbeans.entrySet()) {
                name = (String)outbean.getValue();
                declaration = (BeanDeclaration)outbean.getKey();
                try {
                    bean_class = Class.forName(declaration.getClassname());
                    if (name != null) {
                        try {
                            element_info.addNamedOutbean(name, declaration);
                        }
                        catch (EngineException e) {
                            throw new XmlErrorException(new StringBuffer().append(new StringBuffer().append("The output bean with name '").append(name).toString()).append("' already exists.").toString());
                        }
                    }
                    try {
                        constrained = ConstrainedUtils.getConstrainedInstance(bean_class);
                        properties = BeanUtils.getPropertyNames(bean_class, null, null, declaration.getPrefix());
                        for (String property : (Collection)properties) {
                            if (!ConstrainedUtils.editConstrainedProperty(constrained, property, declaration.getPrefix()) || element_info.containsOutput(property)) continue;
                            element_info.addOutput(property, null);
                        }
                    }
                    catch (BeanUtilsException e) {
                        throw new XmlErrorException(new StringBuffer().append(new StringBuffer().append("Unexpected error while obtaining the properties of the output bean with class '").append(declaration.getClassname()).toString()).append("'.").toString(), e);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new XmlErrorException(new StringBuffer().append(new StringBuffer().append("The output bean with class '").append(declaration.getClassname()).toString()).append("' could not be found.").toString());
                }
            }
        }
        if (this.mStaticProperties != null) {
            for (Map.Entry property : (Collection)this.mStaticProperties.entrySet()) {
                element_info.addStaticProperty((String)property.getKey(), property.getValue());
            }
        }
        if (this.mInputs != null) {
            for (Map.Entry input : (Collection)this.mInputs.entrySet()) {
                element_info.addInput((String)input.getKey(), (String[])input.getValue());
            }
        }
        if (this.mOutputs != null) {
            for (Map.Entry output : (Collection)this.mOutputs.entrySet()) {
                element_info.addOutput((String)output.getKey(), (String[])output.getValue());
            }
        }
        if (this.mIncookies != null) {
            for (Map.Entry incookie : (Collection)this.mIncookies.entrySet()) {
                element_info.addIncookie((String)incookie.getKey(), (String)incookie.getValue());
            }
        }
        if (this.mOutcookies != null) {
            for (Map.Entry outcookie : (Collection)this.mOutcookies.entrySet()) {
                element_info.addOutcookie((String)outcookie.getKey(), (String)outcookie.getValue());
            }
        }
        if (this.mExits != null) {
            for (String exit : (Collection)this.mExits) {
                element_info.addExit(exit);
            }
        }
        if (this.mChildTriggers != null) {
            for (String name2 : (Collection)this.mChildTriggers) {
                element_info.addChildTrigger(name2);
            }
        }
        if (this.mSubmissionBuilders != null) {
            for (SubmissionBuilder builder : (Collection)this.mSubmissionBuilders) {
                builder.getSubmission(element_info);
            }
        }
        return element_info;
    }

    public ElementInfoBuilder setId(String id) {
        if (id != null && 0 == id.length()) {
            throw new ElementIdInvalidException(id);
        }
        this.mDeclaration.setId(id);
        return this;
    }

    public ElementInfoBuilder extendsFrom(String extendsFrom) {
        this.mExtendsFrom = extendsFrom;
        return this;
    }

    public ElementInfoBuilder setContentType(String contentType) {
        this.mContentType = contentType;
        return this;
    }

    public ElementInfoBuilder setImplementation(String implementation) {
        this.mImplementation = implementation;
        return this;
    }

    public ElementInfoBuilder setUrl(String url) {
        if (url != null) {
            this.mDeclaration.setUrl(Localization.extractLocalizedUrl(url));
        }
        return this;
    }

    public ElementInfoBuilder setInherits(String inherits) {
        this.mInherits = inherits;
        return this;
    }

    public ElementInfoBuilder setPre(String pre) {
        this.mPre = pre;
        return this;
    }

    public ElementInfoBuilder addProperty(String name, Object value) {
        this.mDeclaration.addProperty(name, value);
        return this;
    }

    public ElementInfoBuilder addDataLink(String srcOutput, String destId, String destInput) {
        this.addDataLink(srcOutput, null, destId, false, destInput, null);
        return this;
    }

    public ElementInfoBuilder addSnapbackDataLink(String srcOutput, String destInput) {
        this.addDataLink(srcOutput, null, null, true, destInput, null);
        return this;
    }

    public ElementInfoBuilder addDataLinkBean(String srcOutbean, String destId, String destInbean) {
        this.addDataLink(null, srcOutbean, destId, false, null, destInbean);
        return this;
    }

    public ElementInfoBuilder addSnapbackDataLinkBean(String srcOutbean, String destInbean) {
        this.addDataLink(null, srcOutbean, null, true, null, destInbean);
        return this;
    }

    public ElementInfoBuilder addDataLink(String srcOutput, String srcOutbean, String destId, boolean snapback, String destInput, String destInbean) {
        if (srcOutput == null && srcOutbean == null) {
            throw new DataLinkOutputRequiredException(this.mSiteBuilder.getDeclarationName(), this.mDeclaration.getId());
        }
        if (srcOutput != null && srcOutbean != null) {
            throw new DataLinkAmbiguousOutputException(this.mSiteBuilder.getDeclarationName(), this.mDeclaration.getId());
        }
        if (destId == null && !snapback) {
            throw new DataLinkTargetRequiredException(this.mSiteBuilder.getDeclarationName(), this.mDeclaration.getId(), srcOutput, srcOutbean, destInput, destInbean);
        }
        if (destId != null && snapback) {
            throw new DataLinkAmbiguousTargetException(this.mSiteBuilder.getDeclarationName(), this.mDeclaration.getId(), srcOutput, srcOutbean, destInput, destInbean);
        }
        if (destInput == null && destInbean == null) {
            throw new DataLinkInputRequiredException(this.mSiteBuilder.getDeclarationName(), this.mDeclaration.getId(), destId, snapback);
        }
        if (destInput != null && destInbean != null) {
            throw new DataLinkAmbiguousInputException(this.mSiteBuilder.getDeclarationName(), this.mDeclaration.getId(), destId, snapback);
        }
        if (srcOutput != null && destInbean != null || srcOutbean != null && destInput != null) {
            throw new DataLinkIncompatibleInputOutputException(this.mSiteBuilder.getDeclarationName(), this.mDeclaration.getId(), destId, snapback);
        }
        if (this.mDataLinks == null) {
            this.mDataLinks = new ArrayList();
        }
        this.mDataLinks.add(new DataLinkDeclaration(srcOutput, srcOutbean, destId, snapback, destInput, destInbean));
        return this;
    }

    public ElementInfoBuilder addFlowLink(String srcExit, String destId) {
        this.addFlowLink(srcExit, destId, false, false, false);
        return this;
    }

    public ElementInfoBuilder addFlowLink(String srcExit, String destId, boolean cancelInheritance) {
        this.addFlowLink(srcExit, destId, false, cancelInheritance, false);
        return this;
    }

    public ElementInfoBuilder addSnapbackFlowLink(String srcExit, boolean cancelInheritance) {
        this.addFlowLink(srcExit, null, true, cancelInheritance, false);
        return this;
    }

    public ElementInfoBuilder addRedirectFlowLink(String srcExit, String destId) {
        this.addFlowLink(srcExit, destId, false, false, true);
        return this;
    }

    public ElementInfoBuilder addFlowLink(String srcExit, String destId, boolean snapback, boolean cancelInheritance, boolean redirect) {
        if (destId == null && !snapback) {
            throw new FlowLinkTargetRequiredException(this.mSiteBuilder.getDeclarationName(), this.mDeclaration.getId(), srcExit);
        }
        if (destId != null && snapback) {
            throw new FlowLinkAmbiguousTargetException(this.mSiteBuilder.getDeclarationName(), this.mDeclaration.getId(), srcExit);
        }
        if (this.mFlowLinks == null) {
            this.mFlowLinks = new ArrayList();
        }
        this.mFlowLinks.add(new FlowLinkDeclaration(srcExit, destId, snapback, cancelInheritance, redirect));
        return this;
    }

    public ElementInfoBuilder addInBean(String classname) {
        return this.addInBean(classname, null, null);
    }

    public ElementInfoBuilder addInBean(String classname, String prefix, String name) {
        if (this.mInbeans == null) {
            this.mInbeans = new LinkedHashMap();
        }
        this.mInbeans.put(new BeanDeclaration(classname, prefix), name);
        return this;
    }

    public ElementInfoBuilder addOutBean(String classname) {
        return this.addOutBean(classname, null, null);
    }

    public ElementInfoBuilder addOutBean(String classname, String prefix, String name) {
        if (this.mOutbeans == null) {
            this.mOutbeans = new LinkedHashMap();
        }
        this.mOutbeans.put(new BeanDeclaration(classname, prefix), name);
        return this;
    }

    public ElementInfoBuilder addStaticProperty(String name, Object value) {
        if (this.mStaticProperties == null) {
            this.mStaticProperties = new LinkedHashMap();
        }
        this.mStaticProperties.put(name, value);
        return this;
    }

    public ElementInfoBuilder addInput(String name) {
        return this.addInput(name, null);
    }

    public ElementInfoBuilder addInput(String name, String[] defaultValues) {
        if (this.mInputs == null) {
            this.mInputs = new LinkedHashMap();
        }
        this.mInputs.put(name, defaultValues);
        return this;
    }

    public ElementInfoBuilder addOutput(String name) {
        return this.addOutput(name, null);
    }

    public ElementInfoBuilder addOutput(String name, String[] defaultValues) {
        if (this.mOutputs == null) {
            this.mOutputs = new LinkedHashMap();
        }
        this.mOutputs.put(name, defaultValues);
        return this;
    }

    public ElementInfoBuilder addIncookie(String name) {
        return this.addIncookie(name, null);
    }

    public ElementInfoBuilder addIncookie(String name, String defaultValue) {
        if (this.mIncookies == null) {
            this.mIncookies = new LinkedHashMap();
        }
        this.mIncookies.put(name, defaultValue);
        return this;
    }

    public ElementInfoBuilder addOutcookie(String name) {
        return this.addOutcookie(name, null);
    }

    public ElementInfoBuilder addOutcookie(String name, String defaultValue) {
        if (this.mOutcookies == null) {
            this.mOutcookies = new LinkedHashMap();
        }
        this.mOutcookies.put(name, defaultValue);
        return this;
    }

    public ElementInfoBuilder addExit(String name) {
        if (this.mExits == null) {
            this.mExits = new ArrayList();
        }
        this.mExits.add(name);
        return this;
    }

    public ElementInfoBuilder addChildTrigger(String name) {
        if (this.mChildTriggers == null) {
            this.mChildTriggers = new ArrayList();
        }
        this.mChildTriggers.add(name);
        return this;
    }

    public SubmissionBuilder enterSubmission(String name) {
        if (this.mSubmissionBuilders == null) {
            this.mSubmissionBuilders = new ArrayList();
        }
        SubmissionBuilder builder = new SubmissionBuilder(this, name);
        this.mSubmissionBuilders.add(builder);
        return builder;
    }

    public ElementInfoBuilder addResourceModificationTime(URL resource, long modificationTime) {
        this.mSiteBuilder.addResourceModificationTime(resource, modificationTime);
        return this;
    }

    public SiteBuilder leaveElement() {
        return this.mSiteBuilder;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.ElementInfoBuilder");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

