/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.ElementAware;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.ElementScripted;
import com.uwyn.rife.engine.ElementSupport;
import com.uwyn.rife.engine.ElementType;
import com.uwyn.rife.engine.EngineClassLoader;
import com.uwyn.rife.engine.ScriptLoaderGroovy;
import com.uwyn.rife.engine.ScriptLoaderJanino;
import com.uwyn.rife.engine.ScriptedEngineBSF;
import com.uwyn.rife.engine.ScriptedEngineRhino;
import com.uwyn.rife.engine.exceptions.ElementCompilationFailedException;
import com.uwyn.rife.engine.exceptions.ElementImplementationInstantiationException;
import com.uwyn.rife.engine.exceptions.ElementImplementationNotFoundException;
import com.uwyn.rife.engine.exceptions.ElementImplementationUnreadableException;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.resources.ResourceFinderClasspath;
import com.uwyn.rife.tools.FileUtils;
import com.uwyn.rife.tools.exceptions.FileUtilsErrorException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

class ElementFactory {
    static final ElementFactory INSTANCE = new ElementFactory();
    private static final String SCRIPT_EXT_JAVASCRIPT = ".js";
    private static final String SCRIPT_EXT_JACL = ".jacl";
    private static final String SCRIPT_EXT_JYTHON = ".py";
    private static final String SCRIPT_EXT_PNUTS = ".pnut";
    private static final String SCRIPT_EXT_RUBY = ".rb";
    private static final String SCRIPT_EXT_BEANSHELL = ".bsh";
    private static final String SCRIPT_EXT_GROOVY = ".groovy";
    private static final String SCRIPT_EXT_JANINO = ".janino";
    private static final String[] SCRIPT_EXTENSIONS = new String[]{".js", ".jacl", ".py", ".pnut", ".rb", ".bsh", ".groovy", ".janino"};
    private static String mJythonClassPath = "";
    private static ScriptLoaderGroovy mScriptLoaderGroovy = null;
    private static ScriptLoaderJanino mScriptLoaderJanino = null;
    private ResourceFinder mResourceFinder = ResourceFinderClasspath.getInstance();

    ElementFactory() {
    }

    static ElementType getElementType(String implementation) {
        if (implementation == null) {
            return null;
        }
        if (implementation.indexOf("/") != -1) {
            return ElementType.SCRIPT;
        }
        int i = 0;
        while (i < SCRIPT_EXTENSIONS.length) {
            if (implementation.endsWith(SCRIPT_EXTENSIONS[i])) {
                return ElementType.SCRIPT;
            }
            ++i;
        }
        return ElementType.JAVA;
    }

    private ElementAware getJavaInstance(ElementInfo elementInfo) {
        ElementAware element = null;
        try {
            String classname = elementInfo.getImplementation();
            Class element_class = null;
            element_class = ((EngineClassLoader)this.getClass().getClassLoader()).loadClass(classname, true, true);
            element = (ElementAware)element_class.newInstance();
        }
        catch (ClassNotFoundException e2) {
            throw new ElementImplementationNotFoundException(elementInfo.getDeclarationName(), elementInfo.getImplementation(), e2);
        }
        catch (IllegalAccessException e2) {
            throw new ElementImplementationInstantiationException(elementInfo.getDeclarationName(), elementInfo.getImplementation(), e2);
        }
        catch (InstantiationException e2) {
            throw new ElementImplementationInstantiationException(elementInfo.getDeclarationName(), elementInfo.getImplementation(), e2);
        }
        return element;
    }

    public ElementSupport getInstance(ElementInfo elementInfo) {
        if (elementInfo == null) {
            throw new IllegalArgumentException("elementInfo can't be null.");
        }
        ElementAware element_aware = null;
        if (ElementType.JAVA == elementInfo.getType()) {
            try {
                element_aware = this.getJavaInstance(elementInfo);
            }
            catch (ElementCompilationFailedException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ElementImplementationInstantiationException(elementInfo.getDeclarationName(), elementInfo.getImplementation(), e);
            }
        } else if (ElementType.SCRIPT == elementInfo.getType()) {
            if (elementInfo.getImplementation().endsWith(SCRIPT_EXT_GROOVY)) {
                if (mScriptLoaderGroovy == null) {
                    mScriptLoaderGroovy = new ScriptLoaderGroovy(this.mResourceFinder);
                }
                element_aware = mScriptLoaderGroovy.getInstance(elementInfo);
            } else if (elementInfo.getImplementation().endsWith(SCRIPT_EXT_JANINO)) {
                if (mScriptLoaderJanino == null) {
                    mScriptLoaderJanino = new ScriptLoaderJanino(this.mResourceFinder);
                }
                element_aware = mScriptLoaderJanino.getInstance(elementInfo);
            } else if (elementInfo.getImplementation().endsWith(SCRIPT_EXT_JAVASCRIPT)) {
                String code = ElementFactory.getScriptCode(this.mResourceFinder, elementInfo);
                ScriptedEngineRhino engine = new ScriptedEngineRhino(code);
                element_aware = new ElementScripted(engine);
            } else {
                String language = null;
                if (elementInfo.getImplementation().endsWith(SCRIPT_EXT_JACL)) {
                    language = "jacl";
                } else if (elementInfo.getImplementation().endsWith(SCRIPT_EXT_JYTHON)) {
                    language = "jython";
                    this.addRifeJarsToClasspathProperty();
                } else if (elementInfo.getImplementation().endsWith(SCRIPT_EXT_PNUTS)) {
                    language = "pnuts";
                } else if (elementInfo.getImplementation().endsWith(SCRIPT_EXT_RUBY)) {
                    language = "ruby";
                } else if (elementInfo.getImplementation().endsWith(SCRIPT_EXT_BEANSHELL)) {
                    language = "beanshell";
                }
                String code = ElementFactory.getScriptCode(this.mResourceFinder, elementInfo);
                ScriptedEngineBSF engine = new ScriptedEngineBSF(language, code);
                element_aware = new ElementScripted(engine);
            }
        }
        ElementSupport element = null;
        element = element_aware instanceof ElementSupport ? (ElementSupport)((Object)element_aware) : new ElementSupport();
        element.setElementAware(element_aware);
        element.setElementInfo(elementInfo);
        return element;
    }

    static URL getScriptUrl(ResourceFinder resourceFinder, ElementInfo elementInfo) {
        URL sourcename_url = resourceFinder.getResource(elementInfo.getImplementation());
        if (sourcename_url == null) {
            sourcename_url = resourceFinder.getResource("implementations/" + elementInfo.getImplementation());
        }
        if (sourcename_url == null) {
            throw new ElementImplementationNotFoundException(elementInfo.getDeclarationName(), elementInfo.getImplementation(), null);
        }
        return sourcename_url;
    }

    static String getScriptCode(ResourceFinder resourceFinder, ElementInfo elementInfo) {
        URL sourcename_url = ElementFactory.getScriptUrl(resourceFinder, elementInfo);
        try {
            return FileUtils.readString(sourcename_url);
        }
        catch (FileUtilsErrorException e) {
            throw new ElementImplementationUnreadableException(elementInfo.getDeclarationName(), elementInfo.getImplementation(), e);
        }
    }

    private void addRifeJarsToClasspathProperty() {
        if (mJythonClassPath != null) {
            if (0 == mJythonClassPath.length()) {
                URL resource = this.getClass().getClassLoader().getResource("com/uwyn/rife/engine/ElementFactory.class");
                if (resource != null && resource.getProtocol().equals("jar")) {
                    String resource_path = null;
                    try {
                        resource_path = URLDecoder.decode(resource.getPath(), "ISO-8859-1");
                        String prefix = "file:";
                        String jar_filename = resource_path.substring(prefix.length(), resource_path.indexOf(33));
                        File jar_file = new File(jar_filename);
                        File jar_directory = jar_file.getParentFile();
                        if (jar_directory != null && jar_directory.isDirectory()) {
                            StringBuffer java_class_path;
                            StringBuffer stringBuffer = java_class_path = new StringBuffer(System.getProperty("java.class.path"));
                            synchronized (stringBuffer) {
                                String jar_directory_path = URLDecoder.decode(jar_directory.getPath(), "ISO-8859-1");
                                if (-1 == java_class_path.indexOf(jar_directory_path)) {
                                    String[] jar_filenames;
                                    String[] stringArray = jar_filenames = jar_directory.list();
                                    int n = 0;
                                    while (n < stringArray.length) {
                                        String jar_filenames_entry = stringArray[n];
                                        if (jar_filenames_entry.endsWith(".jar")) {
                                            java_class_path.append(File.pathSeparator);
                                            java_class_path.append(jar_directory_path);
                                            java_class_path.append(File.separator);
                                            java_class_path.append(jar_filenames_entry);
                                        }
                                        ++n;
                                    }
                                    if (jar_directory_path.endsWith("WEB-INF/lib")) {
                                        StringBuffer classes_directory_path = new StringBuffer(jar_directory.getParent());
                                        classes_directory_path.append(File.separator);
                                        classes_directory_path.append("classes");
                                        File classes_directory = new File(classes_directory_path.toString());
                                        if (classes_directory.exists() && classes_directory.isDirectory()) {
                                            java_class_path.append(File.pathSeparator);
                                            java_class_path.append(classes_directory_path);
                                        }
                                    }
                                    mJythonClassPath = java_class_path.toString();
                                }
                                System.setProperty("java.class.path", mJythonClassPath);
                                return;
                            }
                        }
                    }
                    catch (UnsupportedEncodingException e) {}
                }
            } else {
                System.setProperty("java.class.path", mJythonClassPath);
                return;
            }
            mJythonClassPath = null;
        }
    }
}

