/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.asm.AnnotationVisitor;
import com.uwyn.rife.asm.Attribute;
import com.uwyn.rife.asm.ClassReader;
import com.uwyn.rife.asm.ClassVisitor;
import com.uwyn.rife.asm.FieldVisitor;
import com.uwyn.rife.asm.MethodVisitor;
import com.uwyn.rife.engine.EngineClassLoader;

class ElementDetectionClassVisitor
implements ClassVisitor {
    private final String ELEMENT_INTERNAL_NAME = "com/uwyn/rife/engine/Element".intern();
    private final String ELEMENTAWARE_INTERNAL_NAME = "com/uwyn/rife/engine/ElementAware".intern();
    private final String OBJECT_INTERNAL_NAME = "java/lang/Object".intern();
    private final String OBJECT_NAME = "java.lang.Object".intern();
    private EngineClassLoader mClassLoader = null;
    private boolean mIsElement = false;
    private String mSuperName = null;

    public ElementDetectionClassVisitor(EngineClassLoader classLoader) {
        this.mClassLoader = classLoader;
    }

    boolean isElement(boolean doAutoReload, byte[] bytes) throws ClassNotFoundException {
        ClassReader detection_reader = null;
        while (!this.mIsElement) {
            detection_reader = new ClassReader(bytes);
            try {
                detection_reader.accept(this, true);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (this.mSuperName == null || this.OBJECT_NAME == this.mSuperName) break;
            if (this.mIsElement) continue;
            bytes = this.mClassLoader.getClassBytes(doAutoReload, this.mSuperName, false);
        }
        return this.mIsElement;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.ELEMENT_INTERNAL_NAME == superName.intern()) {
            this.mIsElement = true;
        } else {
            String[] stringArray = interfaces;
            int n = 0;
            while (n < stringArray.length) {
                String interface_name = stringArray[n];
                if (this.ELEMENTAWARE_INTERNAL_NAME == interface_name.intern()) {
                    this.mIsElement = true;
                    break;
                }
                ++n;
            }
            this.mSuperName = superName == null ? null : (this.OBJECT_INTERNAL_NAME == superName.intern() ? this.OBJECT_NAME : superName.replace('/', '.').intern());
        }
        throw new RuntimeException("handled visit");
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return null;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }

    public void visitSource(String source, String debug) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitEnd() {
    }
}

