/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.engine.CallState;
import com.uwyn.rife.engine.ContinuationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Random;
import java.util.WeakHashMap;

class ContinuationManager {
    private WeakHashMap<String, ContinuationContext> mContexts = null;
    private long mContinuationDuration = RifeConfig.Engine.getContinuationDuration();
    private int mContinuationPurgeFrequency = RifeConfig.Engine.getContinuationPurgeFrequency();
    private int mContinuationPurgeScale = RifeConfig.Engine.getContinuationPurgeScale();
    private Random mRandom = new Random();

    static /* synthetic */ void access$S1000000(ContinuationManager continuationManager, WeakHashMap weakHashMap) {
        continuationManager.mContexts = weakHashMap;
    }

    static /* synthetic */ void access$S1000001(ContinuationManager continuationManager, long l) {
        continuationManager.mContinuationDuration = l;
    }

    ContinuationManager() {
        this.mContexts = new WeakHashMap();
    }

    void purgeContinuations() {
        int purge_decision = -1;
        purge_decision = this.mRandom.nextInt(this.mContinuationPurgeScale);
        if (purge_decision <= this.mContinuationPurgeFrequency) {
            new PurgeContinuations().start();
        }
    }

    void addContext(ContinuationContext context) {
        if (context == null) {
            return;
        }
        ContinuationManager continuationManager = this;
        synchronized (continuationManager) {
            this.mContexts.put(context.getId(), context);
        }
    }

    void removeContext(ContinuationContext context) {
        if (context == null) {
            return;
        }
        ContinuationManager continuationManager = this;
        synchronized (continuationManager) {
            this.mContexts.remove(context.getId());
        }
    }

    ContinuationContext getContext(String id) throws CloneNotSupportedException {
        ContinuationManager continuationManager = this;
        synchronized (continuationManager) {
            ContinuationContext result = null;
            this.purgeContinuations();
            ContinuationContext context = this.mContexts.get(id);
            if (context != null) {
                result = context.getElement().cloneContinuations() ? this.cloneContext(id, context) : this.reuseContext(id, context);
            }
            return result;
        }
    }

    CallState getCreatedCallState(String id) {
        ContinuationManager continuationManager = this;
        synchronized (continuationManager) {
            CallState result = null;
            this.purgeContinuations();
            ContinuationContext context = this.mContexts.get(id);
            if (context != null) {
                result = context.getCreatedCallState();
            }
            return result;
        }
    }

    private ContinuationContext reuseContext(String id, ContinuationContext context) {
        this.mContexts.remove(id);
        context.resetId();
        this.addContext(context);
        return context;
    }

    private ContinuationContext cloneContext(String id, ContinuationContext context) throws CloneNotSupportedException {
        context = context.clone();
        context.resetId();
        this.addContext(context);
        return context;
    }

    private class PurgeContinuations
    extends Thread {
        public void run() {
            this.purge();
        }

        private void purge() {
            ArrayList<String> stale_continuations = new ArrayList<String>();
            try {
                ContinuationContext context = null;
                Iterator iterator = ContinuationManager.this.mContexts.values().iterator();
                while (iterator.hasNext()) {
                    ContinuationContext reference = (ContinuationContext)iterator.next();
                    if (reference == null || (context = reference) == null || context.getStart() > System.currentTimeMillis() - ContinuationManager.this.mContinuationDuration) continue;
                    stale_continuations.add(context.getId());
                }
            }
            catch (ConcurrentModificationException e) {
                int old_priority = Thread.currentThread().getPriority();
                Thread.currentThread().setPriority(10);
                try {
                    PurgeContinuations purgeContinuations = this;
                    synchronized (purgeContinuations) {
                        stale_continuations = null;
                        this.purge();
                        // MONITOREXIT @DISABLED, blocks:[1, 2, 3, 4] lbl21 : MonitorExitStatement: MONITOREXIT : var8_7
                    }
                }
                finally {
                    Thread.currentThread().setPriority(old_priority);
                }
            }
            if (stale_continuations != null) {
                Iterator iterator = ((Collection)stale_continuations).iterator();
                while (iterator.hasNext()) {
                    String id = (String)iterator.next();
                    ContinuationManager.this.mContexts.remove(id);
                }
            }
        }

        static /* synthetic */ ContinuationManager access$0(PurgeContinuations purgeContinuations) {
            return purgeContinuations.ContinuationManager.this;
        }
    }
}

