/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database.querymanagers.generic;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.DbQueryManager;
import com.uwyn.rife.database.DbRowProcessor;
import com.uwyn.rife.database.DbTransactionUser;
import com.uwyn.rife.database.DbTransactionUserWithoutResult;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.CreateSequence;
import com.uwyn.rife.database.queries.CreateTable;
import com.uwyn.rife.database.queries.Delete;
import com.uwyn.rife.database.queries.DropSequence;
import com.uwyn.rife.database.queries.DropTable;
import com.uwyn.rife.database.queries.Insert;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.database.queries.SequenceValue;
import com.uwyn.rife.database.queries.Update;
import com.uwyn.rife.database.querymanagers.generic.CountQuery;
import com.uwyn.rife.database.querymanagers.generic.GenericQueryManager;
import com.uwyn.rife.engine.exceptions.EngineException;
import com.uwyn.rife.site.Constrained;
import com.uwyn.rife.site.ConstrainedBean;
import com.uwyn.rife.site.ConstrainedProperty;
import com.uwyn.rife.site.ConstrainedUtils;
import com.uwyn.rife.site.Validated;
import com.uwyn.rife.site.ValidationError;
import com.uwyn.rife.tools.BeanUtils;
import com.uwyn.rife.tools.StringUtils;
import com.uwyn.rife.tools.exceptions.BeanUtilsException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenericQueryManager<BeanType>
extends DbQueryManager
implements GenericQueryManager<BeanType> {
    protected Class<BeanType> mBaseClass = null;
    protected String mPrimaryKey = null;
    protected Method mGetPrimaryKeyMethod = null;
    protected Method mSetPrimaryKeyMethod = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    public AbstractGenericQueryManager(Datasource datasource, Class<BeanType> beanClass, String primaryKey) {
        super(datasource);
        this.mBaseClass = beanClass;
        this.mPrimaryKey = primaryKey;
        try {
            String capitalized_primary_key = StringUtils.capitalize(this.mPrimaryKey);
            this.mGetPrimaryKeyMethod = this.mBaseClass.getMethod(new StringBuffer().append("get").append(capitalized_primary_key).toString(), null);
            this.mSetPrimaryKeyMethod = this.mBaseClass.getMethod(new StringBuffer().append("set").append(capitalized_primary_key).toString(), Integer.TYPE);
        }
        catch (Throwable e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public Class getBaseClass() {
        return this.mBaseClass;
    }

    @Override
    public String getIdentifierName() {
        return this.mPrimaryKey;
    }

    @Override
    public int getIdentifierValue(BeanType bean) {
        try {
            Integer id = (Integer)this.mGetPrimaryKeyMethod.invoke(bean, (Object[])null);
            if (id == null) {
                return -1;
            }
            return id;
        }
        catch (Throwable e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void validate(Validated validated) {
        if (validated == null) {
            return;
        }
        Constrained constrained = ConstrainedUtils.makeConstrainedInstance(validated);
        if (constrained != null) {
            boolean identifier_exists = false;
            int identifier_value = this.getIdentifierValue((Object)validated);
            if (identifier_value >= 0) {
                identifier_exists = true;
            }
            for (ConstrainedProperty property : constrained.getConstrainedProperties()) {
                Object property_value;
                if (property.isUnique()) {
                    property_value = null;
                    try {
                        property_value = BeanUtils.getPropertyValue(constrained, property.getPropertyName());
                    }
                    catch (BeanUtilsException e) {
                        throw new EngineException(e);
                    }
                    if (property_value != null) {
                        CountQuery count_query = (CountQuery)this.getCountQuery().where(property.getPropertyName(), "=", property_value);
                        if (identifier_exists) {
                            count_query.whereAnd(this.mPrimaryKey, "!=", identifier_value);
                        }
                        if (this.count(count_query) > 0) {
                            validated.addValidationError(new ValidationError.UNICITY(property.getPropertyName()));
                        }
                    }
                }
                if (!property.hasManyToOne()) continue;
                property_value = null;
                try {
                    property_value = BeanUtils.getPropertyValue(constrained, property.getPropertyName());
                }
                catch (BeanUtilsException e) {
                    throw new EngineException(e);
                }
                if (property_value == null) continue;
                ConstrainedProperty.ManyToOne many_to_one = property.getManyToOne();
                if (this.executeHasResultRows((Select)new Select(this.getDatasource()).from(many_to_one.getTable()).where(many_to_one.getColumn(), "=", property_value))) continue;
                validated.addValidationError(new ValidationError.INVALID(property.getPropertyName()));
            }
            ConstrainedBean constrained_bean = (ConstrainedBean)constrained.getConstrainedBean();
            if (constrained_bean != null && constrained_bean.hasUniques()) {
                for (String[] uniques : (Collection)constrained_bean.getUniques()) {
                    CountQuery count_query = this.getCountQuery();
                    if (identifier_exists) {
                        count_query.where(this.mPrimaryKey, "!=", identifier_value);
                    }
                    String[] stringArray = uniques;
                    int n = 0;
                    while (n < stringArray.length) {
                        String unique = stringArray[n];
                        Object property_value = null;
                        try {
                            property_value = BeanUtils.getPropertyValue(constrained, unique);
                        }
                        catch (BeanUtilsException e) {
                            throw new EngineException(e);
                        }
                        if (property_value == null) {
                            count_query = null;
                            break;
                        }
                        count_query.where(unique, "=", property_value);
                        ++n;
                    }
                    if (count_query == null || this.count(count_query) <= 0) continue;
                    String[] stringArray2 = uniques;
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        String unique = stringArray2[n2];
                        validated.addValidationError(new ValidationError.UNICITY(unique));
                        ++n2;
                    }
                }
            }
        }
    }

    protected int _save(SequenceValue nextId, Insert save, Update saveUpdate, BeanType bean) {
        if (!$assertionsDisabled && nextId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && save == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && saveUpdate == null) {
            throw new AssertionError();
        }
        int value = -1;
        value = (Integer)this.inTransaction(new 3(bean, saveUpdate, nextId, save));
        if (value != -1) {
            try {
                this.mSetPrimaryKeyMethod.invoke(bean, new Integer(value));
            }
            catch (Throwable e) {
                throw new DatabaseException(e);
            }
        }
        return value;
    }

    protected boolean _delete(Delete delete2) {
        if (!$assertionsDisabled && delete2 == null) {
            throw new AssertionError();
        }
        boolean result = true;
        if (0 == this.executeUpdate(delete2)) {
            result = false;
        }
        return result;
    }

    protected boolean _delete(Delete delete2, int objectId) {
        if (!$assertionsDisabled && delete2 == null) {
            throw new AssertionError();
        }
        boolean result = true;
        if (0 == this.executeUpdate(delete2, new 4(objectId))) {
            result = false;
        }
        return result;
    }

    protected BeanType _restore(Select restore, int objectId) {
        if (!$assertionsDisabled && restore == null) {
            throw new AssertionError();
        }
        BeanType result = null;
        result = this.executeFetchFirstBean(restore, this.mBaseClass, new 5(objectId));
        return result;
    }

    protected BeanType _restoreFirst(Select restore) {
        if (!$assertionsDisabled && restore == null) {
            throw new AssertionError();
        }
        return this.executeFetchFirstBean(restore, this.mBaseClass);
    }

    protected List<BeanType> _restore(Select restore) {
        if (!$assertionsDisabled && restore == null) {
            throw new AssertionError();
        }
        return this.executeFetchAllBeans(restore, this.mBaseClass);
    }

    protected boolean _restore(Select restore, DbRowProcessor rowProcessor) {
        if (!$assertionsDisabled && restore == null) {
            throw new AssertionError();
        }
        return this.executeFetchAll(restore, rowProcessor);
    }

    protected int _count(Select count) {
        return this.executeGetFirstInt(count);
    }

    protected void _install(CreateSequence createSequence, CreateTable createTable) {
        if (!$assertionsDisabled && createSequence == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && createTable == null) {
            throw new AssertionError();
        }
        this.inTransaction(new 6(createSequence, createTable));
    }

    protected void _remove(DropSequence dropSequence, DropTable dropTable) {
        if (!$assertionsDisabled && dropTable == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dropSequence == null) {
            throw new AssertionError();
        }
        this.inTransaction(new 7(dropTable, dropSequence));
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.database.querymanagers.generic.AbstractGenericQueryManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    class 3
    extends DbTransactionUser {
        private final /* synthetic */ Object val$bean;
        private final /* synthetic */ Update val$saveUpdate;
        private final /* synthetic */ SequenceValue val$nextId;
        private final /* synthetic */ Insert val$save;

        3(Object object, Update update2, SequenceValue sequenceValue, Insert insert2) {
            this.val$bean = object;
            this.val$saveUpdate = update2;
            this.val$nextId = sequenceValue;
            this.val$save = insert2;
        }

        public Integer useTransaction() {
            int result = -1;
            boolean update2 = false;
            result = AbstractGenericQueryManager.this.getIdentifierValue(this.val$bean);
            if (result >= 0) {
                update2 = true;
            }
            if (update2 && 0 == AbstractGenericQueryManager.this.executeUpdate(this.val$saveUpdate, new 1(this.val$bean))) {
                result = -1;
            }
            if (-1 == result) {
                int primary_key_id = result = AbstractGenericQueryManager.this.executeGetFirstInt(this.val$nextId);
                AbstractGenericQueryManager.this.executeUpdate(this.val$save, new 2(this.val$bean, primary_key_id));
            }
            return new Integer(result);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        class 1
        extends DbPreparedStatementHandler {
            private final /* synthetic */ Object val$bean;

            1(Object object) {
                this.val$bean = object;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setBean(this.val$bean);
            }

            static /* synthetic */ 3 access$0(1 var0) {
                return var0.3.this;
            }
        }

        class 2
        extends DbPreparedStatementHandler {
            private final /* synthetic */ Object val$bean;
            private final /* synthetic */ int val$primary_key_id;

            2(Object object, int n) {
                this.val$bean = object;
                this.val$primary_key_id = n;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setBean(this.val$bean).setInt(((3)3.this).AbstractGenericQueryManager.this.mPrimaryKey, this.val$primary_key_id);
            }

            static /* synthetic */ 3 access$0(2 var0) {
                return var0.3.this;
            }
        }
    }

    class 4
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$objectId;

        4(int n) {
            this.val$objectId = n;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt(AbstractGenericQueryManager.this.mPrimaryKey, this.val$objectId);
        }

        static /* synthetic */ AbstractGenericQueryManager access$0(4 var0) {
            return var0.AbstractGenericQueryManager.this;
        }
    }

    class 5
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$objectId;

        5(int n) {
            this.val$objectId = n;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt(AbstractGenericQueryManager.this.mPrimaryKey, this.val$objectId);
        }

        static /* synthetic */ AbstractGenericQueryManager access$0(5 var0) {
            return var0.AbstractGenericQueryManager.this;
        }
    }

    class 6
    extends DbTransactionUserWithoutResult {
        private final /* synthetic */ CreateSequence val$createSequence;
        private final /* synthetic */ CreateTable val$createTable;

        6(CreateSequence createSequence, CreateTable createTable) {
            this.val$createSequence = createSequence;
            this.val$createTable = createTable;
        }

        public void useTransactionWithoutResult() {
            AbstractGenericQueryManager.this.executeUpdate(this.val$createSequence);
            AbstractGenericQueryManager.this.executeUpdate(this.val$createTable);
        }

        static /* synthetic */ AbstractGenericQueryManager access$0(6 var0) {
            return var0.AbstractGenericQueryManager.this;
        }
    }

    class 7
    extends DbTransactionUserWithoutResult {
        private final /* synthetic */ DropTable val$dropTable;
        private final /* synthetic */ DropSequence val$dropSequence;

        7(DropTable dropTable, DropSequence dropSequence) {
            this.val$dropTable = dropTable;
            this.val$dropSequence = dropSequence;
        }

        public void useTransactionWithoutResult() {
            AbstractGenericQueryManager.this.executeUpdate(this.val$dropTable);
            AbstractGenericQueryManager.this.executeUpdate(this.val$dropSequence);
        }

        static /* synthetic */ AbstractGenericQueryManager access$0(7 var0) {
            return var0.AbstractGenericQueryManager.this;
        }
    }
}

