/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database.queries;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.capabilities.Capabilities;
import com.uwyn.rife.database.capabilities.Capability;
import com.uwyn.rife.database.exceptions.UnsupportedSqlFeatureException;
import com.uwyn.rife.database.queries.AbstractWhereQuery;
import com.uwyn.rife.database.queries.QueryHelper;
import com.uwyn.rife.database.queries.ReadQuery;
import com.uwyn.rife.datastructures.EnumClass;
import com.uwyn.rife.site.Constrained;
import com.uwyn.rife.site.ConstrainedBean;
import com.uwyn.rife.site.ConstrainedUtils;
import com.uwyn.rife.template.Template;
import com.uwyn.rife.template.TemplateFactory;
import com.uwyn.rife.tools.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Select
extends AbstractWhereQuery<Select>
implements Cloneable,
ReadQuery {
    private ArrayList<String> mFields = null;
    private String mFrom = null;
    private ArrayList<Join> mJoins = null;
    private ArrayList<String> mGroupBy = null;
    private ArrayList<String> mHaving = null;
    private boolean mDistinct = false;
    private ArrayList<String> mDistinctOn = null;
    private ArrayList<String> mUnions = null;
    private ArrayList<OrderBy> mOrderBy = null;
    private int mLimit = -1;
    private int mOffset = -1;
    private Capabilities mCapabilities = null;
    private Class mConstrainedClass = null;
    public static final JoinCondition NATURAL;
    public static final JoinCondition ON;
    public static final JoinCondition USING;
    public static final JoinType LEFT;
    public static final JoinType RIGHT;
    public static final JoinType FULL;
    public static final OrderByDirection ASC;
    public static final OrderByDirection DESC;
    private static /* synthetic */ boolean $assertionsDisabled;

    public Select(Datasource datasource) {
        this(datasource, null);
    }

    public Select(Datasource datasource, Class constrainedClass) {
        super(datasource);
        if (datasource == null) {
            throw new IllegalArgumentException("datasource can't be null.");
        }
        this.mConstrainedClass = constrainedClass;
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.mFields = new ArrayList();
        this.mFrom = null;
        this.mJoins = new ArrayList();
        this.mGroupBy = new ArrayList();
        this.mHaving = new ArrayList();
        this.mDistinct = false;
        this.mDistinctOn = new ArrayList();
        this.mUnions = new ArrayList();
        this.mOrderBy = new ArrayList();
        this.mLimit = -1;
        this.mOffset = -1;
        this.mCapabilities = null;
        if (!$assertionsDisabled && 0 != this.mFields.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 0 != this.mJoins.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 0 != this.mGroupBy.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 0 != this.mHaving.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 0 != this.mDistinctOn.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 0 != this.mOrderBy.size()) {
            throw new AssertionError();
        }
    }

    @Override
    public void clearGenerated() {
        super.clearGenerated();
        this.mCapabilities = null;
    }

    public Collection<String> getFields() {
        return this.mFields;
    }

    public boolean isDistinct() {
        return this.mDistinct;
    }

    public Collection<String> getDistinctOn() {
        return this.mDistinctOn;
    }

    public String getFrom() {
        return this.mFrom;
    }

    public Collection<Join> getJoins() {
        return this.mJoins;
    }

    public Collection<String> getGroupBy() {
        return this.mGroupBy;
    }

    public Collection<String> getHaving() {
        return this.mHaving;
    }

    public Collection<String> getUnions() {
        return this.mUnions;
    }

    public Collection<OrderBy> getOrderBy() {
        return this.mOrderBy;
    }

    public int getLimit() {
        return this.mLimit;
    }

    public int getOffset() {
        return this.mOffset;
    }

    protected Template getTemplate() {
        return TemplateFactory.SQL.get(new StringBuffer().append(new StringBuffer().append("sql.").append(StringUtils.encodeClassname(this.mDatasource.getAliasedDriver())).toString()).append(".select").toString());
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.mCapabilities == null) {
            Capabilities capabilities = null;
            if (this.getLimit() != -1) {
                if (capabilities == null) {
                    capabilities = new Capabilities();
                }
                capabilities.put(Capability.LIMIT, new Integer(this.getLimit()));
            }
            if (this.getLimitParameter() != null) {
                if (capabilities == null) {
                    capabilities = new Capabilities();
                }
                capabilities.put(Capability.LIMIT_PARAMETER, this.getLimitParameter());
            }
            if (this.getOffset() != -1) {
                if (capabilities == null) {
                    capabilities = new Capabilities();
                }
                capabilities.put(Capability.OFFSET, new Integer(this.getOffset()));
            }
            if (this.getOffsetParameter() != null) {
                if (capabilities == null) {
                    capabilities = new Capabilities();
                }
                capabilities.put(Capability.OFFSET_PARAMETER, this.getOffsetParameter());
            }
            this.mCapabilities = capabilities;
        }
        return this.mCapabilities;
    }

    @Override
    public String getSql() {
        ConstrainedBean constrained_bean;
        Constrained constrained = ConstrainedUtils.getConstrainedInstance(this.mConstrainedClass);
        if (constrained != null && (constrained_bean = (ConstrainedBean)constrained.getConstrainedBean()) != null && constrained_bean.hasDefaultOrdering() && 0 == this.mOrderBy.size()) {
            Iterator<ConstrainedBean.Order> ordering_it = constrained_bean.getDefaultOrdering().iterator();
            ConstrainedBean.Order order = null;
            while (ordering_it.hasNext()) {
                order = ordering_it.next();
                this.orderBy(order.getPropertyName(), OrderByDirection.getDirection(order.getDirection().toString()));
            }
        }
        if (this.mFrom == null && 0 == this.mFields.size()) {
            return null;
        }
        if (this.mSql == null) {
            Template template2 = this.getTemplate();
            String block = null;
            if (this.mDistinct) {
                if (0 == this.mDistinctOn.size()) {
                    block = template2.getBlock("DISTINCT");
                    if (0 == block.length()) {
                        throw new UnsupportedSqlFeatureException("DISTINCT", this.mDatasource.getAliasedDriver());
                    }
                    template2.setValue("DISTINCT", block);
                } else {
                    if (template2.hasValueId("COLUMNS")) {
                        template2.setValue("COLUMNS", StringUtils.join(this.mDistinctOn, template2.getBlock("SEPERATOR")));
                    }
                    if (0 == (block = template2.getBlock("DISTINCTON")).length()) {
                        throw new UnsupportedSqlFeatureException("DISTINCT ON", this.mDatasource.getAliasedDriver());
                    }
                    template2.setValue("DISTINCT", block);
                }
            }
            if (0 == this.mFields.size()) {
                template2.setValue("FIELDS", template2.getBlock("ALLFIELDS"));
            } else {
                template2.setValue("FIELDS", StringUtils.join(this.mFields, template2.getBlock("SEPERATOR")));
            }
            if (this.mFrom != null) {
                template2.setValue("TABLE", this.mFrom);
                block = template2.getBlock("FROM");
                if (0 == block.length()) {
                    throw new UnsupportedSqlFeatureException("FROM", this.mDatasource.getAliasedDriver());
                }
                template2.setValue("FROM", block);
            }
            if (this.mJoins.size() > 0) {
                ArrayList<String> join_list = new ArrayList<String>();
                for (Join join : (Collection)this.mJoins) {
                    join_list.add(join.getSql(template2));
                }
                template2.setValue("JOINS", StringUtils.join(join_list, ""));
            }
            if (this.mWhere.length() > 0) {
                template2.setValue("CONDITION", this.mWhere);
                block = template2.getBlock("WHERE");
                if (0 == block.length()) {
                    throw new UnsupportedSqlFeatureException("WHERE", this.mDatasource.getAliasedDriver());
                }
                template2.setValue("WHERE", block);
            }
            if (this.mGroupBy.size() > 0) {
                template2.setValue("EXPRESSION", StringUtils.join(this.mGroupBy, template2.getBlock("SEPERATOR")));
                block = template2.getBlock("GROUPBY");
                if (0 == block.length()) {
                    throw new UnsupportedSqlFeatureException("GROUP BY", this.mDatasource.getAliasedDriver());
                }
                template2.setValue("GROUPBY", block);
            }
            if (this.mHaving.size() > 0) {
                template2.setValue("EXPRESSION", StringUtils.join(this.mHaving, template2.getBlock("SEPERATOR")));
                block = template2.getBlock("HAVING");
                if (0 == block.length()) {
                    throw new UnsupportedSqlFeatureException("HAVING", this.mDatasource.getAliasedDriver());
                }
                template2.setValue("HAVING", block);
            }
            if (this.mUnions != null) {
                for (String union : (Collection)this.mUnions) {
                    template2.setValue("EXPRESSION", union);
                    block = template2.getBlock("UNION");
                    if (0 == block.length()) {
                        throw new UnsupportedSqlFeatureException("UNION", this.mDatasource.getAliasedDriver());
                    }
                    template2.appendBlock("UNION", "UNION");
                }
            }
            if (this.mOrderBy.size() > 0) {
                ArrayList<String> orderby_list = new ArrayList<String>();
                for (OrderBy order_by : (Collection)this.mOrderBy) {
                    orderby_list.add(order_by.getSql(template2));
                }
                template2.setValue("ORDERBY_PARTS", StringUtils.join(orderby_list, template2.getBlock("SEPERATOR")));
                block = template2.getBlock("ORDERBY");
                if (0 == block.length()) {
                    throw new UnsupportedSqlFeatureException("ORDER BY", this.mDatasource.getAliasedDriver());
                }
                template2.setValue("ORDERBY", block);
            }
            if (this.mLimit != -1 || this.getLimitParameter() != null) {
                String offset_value;
                if (-1 == this.mOffset && template2.hasValueId("OFFSET_VALUE") && (offset_value = template2.getValue("OFFSET_VALUE")) != null && offset_value.trim().length() > 0) {
                    this.mOffset = Integer.parseInt(offset_value);
                }
                if (this.mOffset > -1 || this.getOffsetParameter() != null) {
                    if (template2.hasValueId("OFFSET_VALUE")) {
                        if (this.getOffsetParameter() != null) {
                            template2.setValue("OFFSET_VALUE", "?");
                        } else {
                            template2.setValue("OFFSET_VALUE", this.mOffset);
                        }
                    }
                    if (0 == (block = template2.getBlock("OFFSET")).length()) {
                        if (!this.mExcludeUnsupportedCapabilities) {
                            throw new UnsupportedSqlFeatureException("OFFSET", this.mDatasource.getAliasedDriver());
                        }
                    } else {
                        template2.setValue("OFFSET", block);
                    }
                }
                if (template2.hasValueId("LIMIT_VALUE")) {
                    if (this.getLimitParameter() != null) {
                        template2.setValue("LIMIT_VALUE", "?");
                    } else {
                        template2.setValue("LIMIT_VALUE", this.mLimit);
                    }
                }
                if (0 == (block = template2.getBlock("LIMIT")).length()) {
                    if (!this.mExcludeUnsupportedCapabilities) {
                        throw new UnsupportedSqlFeatureException("LIMIT", this.mDatasource.getAliasedDriver());
                    }
                } else {
                    template2.setValue("LIMIT", block);
                }
            }
            this.mSql = template2.getBlock("QUERY");
            if (!$assertionsDisabled && this.mSql == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mSql.length() <= 0) {
                throw new AssertionError();
            }
        }
        return this.mSql;
    }

    public Select field(String field) {
        if (field == null) {
            throw new IllegalArgumentException("field can't be null.");
        }
        if (0 == field.length()) {
            throw new IllegalArgumentException("field can't be empty.");
        }
        this.clearGenerated();
        this.mFields.add(field);
        return this;
    }

    public Select field(String alias, Select query) {
        StringBuffer buffer;
        if (alias == null) {
            throw new IllegalArgumentException("alias can't be null.");
        }
        if (0 == alias.length()) {
            throw new IllegalArgumentException("alias can't be empty.");
        }
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        StringBuffer stringBuffer = buffer = new StringBuffer();
        synchronized (stringBuffer) {
            buffer.append("(");
            buffer.append(query.toString());
            buffer.append(") AS ");
            buffer.append(alias);
            this.field(buffer.toString());
        }
        this.fieldSubselect(query);
        return this;
    }

    public Select fields(Class beanClass) {
        return this.fieldsExcluded(null, beanClass, null);
    }

    public Select fieldsExcluded(Class beanClass, String[] excludedFields) {
        return this.fieldsExcluded(null, beanClass, excludedFields);
    }

    public Select fields(String table, Class beanClass) {
        return this.fieldsExcluded(table, beanClass, null);
    }

    public Select fieldsExcluded(String table, Class beanClass, String[] excludedFields) {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass can't be null.");
        }
        SortedSet<String> property_names = QueryHelper.getBeanPropertyNames(beanClass, excludedFields);
        Constrained constrained = ConstrainedUtils.getConstrainedInstance(beanClass);
        for (String property_name : (Collection)property_names) {
            if (!ConstrainedUtils.persistConstrainedProperty(constrained, property_name, null)) continue;
            if (table == null) {
                this.field(property_name);
                continue;
            }
            this.field(new StringBuffer().append(new StringBuffer().append(table).append(".").toString()).append(property_name).toString());
        }
        return this;
    }

    public Select fields(String[] fields2) {
        if (fields2 == null) {
            throw new IllegalArgumentException("fields can't be null.");
        }
        if (fields2.length > 0) {
            this.clearGenerated();
            this.mFields.addAll(Arrays.asList(fields2));
        }
        return this;
    }

    public Select distinct() {
        this.clearGenerated();
        this.mDistinct = true;
        return this;
    }

    public Select distinctOn(String column) {
        if (column == null) {
            throw new IllegalArgumentException("column can't be null.");
        }
        if (0 == column.length()) {
            throw new IllegalArgumentException("column can't be empty.");
        }
        this.clearGenerated();
        this.mDistinct = true;
        this.mDistinctOn.add(column);
        return this;
    }

    public Select distinctOn(String[] columns) {
        if (columns == null) {
            throw new IllegalArgumentException("columns can't be null.");
        }
        if (columns.length > 0) {
            this.clearGenerated();
            this.mDistinct = true;
            this.mDistinctOn.addAll(Arrays.asList(columns));
        }
        return this;
    }

    public Select from(String from) {
        if (from == null) {
            throw new IllegalArgumentException("from can't be null.");
        }
        if (0 == from.length()) {
            throw new IllegalArgumentException("from can't be empty.");
        }
        this.clearGenerated();
        this.mFrom = from;
        return this;
    }

    public Select from(Select query) {
        StringBuffer buffer;
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        StringBuffer stringBuffer = buffer = new StringBuffer();
        synchronized (stringBuffer) {
            buffer.append("(");
            buffer.append(query.toString());
            buffer.append(")");
            this.from(buffer.toString());
        }
        this._tableSubselect(query);
        return this;
    }

    public Select from(String alias, Select query) {
        StringBuffer buffer;
        if (alias == null) {
            throw new IllegalArgumentException("alias can't be null.");
        }
        if (0 == alias.length()) {
            throw new IllegalArgumentException("alias can't be empty.");
        }
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        StringBuffer stringBuffer = buffer = new StringBuffer();
        synchronized (stringBuffer) {
            buffer.append("(");
            buffer.append(query.toString());
            buffer.append(") ");
            buffer.append(alias);
            this.from(buffer.toString());
        }
        this._tableSubselect(query);
        return this;
    }

    public Select join(String table) {
        if (table == null) {
            throw new IllegalArgumentException("table can't be null.");
        }
        if (0 == table.length()) {
            throw new IllegalArgumentException("table can't be empty.");
        }
        this.clearGenerated();
        this.mJoins.add(new JoinDefault(table));
        return this;
    }

    public Select join(String alias, Select query) {
        StringBuffer buffer;
        if (alias == null) {
            throw new IllegalArgumentException("alias can't be null.");
        }
        if (0 == alias.length()) {
            throw new IllegalArgumentException("alias can't be empty.");
        }
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        StringBuffer stringBuffer = buffer = new StringBuffer();
        synchronized (stringBuffer) {
            buffer.append("(");
            buffer.append(query.toString());
            buffer.append(") ");
            buffer.append(alias);
            this.join(buffer.toString());
        }
        this.tableSubselect(query);
        return this;
    }

    public Select joinCustom(String customJoin) {
        if (customJoin == null) {
            throw new IllegalArgumentException("customJoin can't be null.");
        }
        if (0 == customJoin.length()) {
            throw new IllegalArgumentException("customJoin can't be empty.");
        }
        this.clearGenerated();
        this.mJoins.add(new JoinCustom(customJoin));
        return this;
    }

    public Select joinCross(String table) {
        if (table == null) {
            throw new IllegalArgumentException("table can't be null.");
        }
        if (0 == table.length()) {
            throw new IllegalArgumentException("table can't be empty.");
        }
        this.clearGenerated();
        this.mJoins.add(new JoinCross(table));
        return this;
    }

    public Select joinInner(String table, JoinCondition condition, String conditionExpression) {
        if (table == null) {
            throw new IllegalArgumentException("table can't be null.");
        }
        if (0 == table.length()) {
            throw new IllegalArgumentException("table can't be empty.");
        }
        if (condition == null) {
            throw new IllegalArgumentException("condition can't be null.");
        }
        if (NATURAL == condition && conditionExpression != null) {
            throw new IllegalArgumentException("a NATURAL join condition can't have a join expression.");
        }
        if (NATURAL != condition && conditionExpression == null) {
            throw new IllegalArgumentException("conditionExpression can't be null.");
        }
        if (NATURAL != condition && 0 == conditionExpression.length()) {
            throw new IllegalArgumentException("conditionExpression can't be empty.");
        }
        this.clearGenerated();
        this.mJoins.add(new JoinInner(table, condition, conditionExpression));
        return this;
    }

    public Select joinOuter(String table, JoinType type, JoinCondition condition, String conditionExpression) {
        if (table == null) {
            throw new IllegalArgumentException("table can't be null.");
        }
        if (0 == table.length()) {
            throw new IllegalArgumentException("table can't be empty.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type can't be null.");
        }
        if (condition == null) {
            throw new IllegalArgumentException("condition can't be null.");
        }
        if (NATURAL == condition && conditionExpression != null) {
            throw new IllegalArgumentException("a NATURAL join condition can't have a join expression.");
        }
        if (NATURAL != condition && conditionExpression == null) {
            throw new IllegalArgumentException("conditionExpression can't be null.");
        }
        if (NATURAL != condition && 0 == conditionExpression.length()) {
            throw new IllegalArgumentException("conditionExpression can't be empty.");
        }
        this.clearGenerated();
        this.mJoins.add(new JoinOuter(table, type, condition, conditionExpression));
        return this;
    }

    public Select fieldSubselect(Select query) {
        this._fieldSubselect(query);
        return this;
    }

    public Select tableSubselect(Select query) {
        this._tableSubselect(query);
        return this;
    }

    public Select groupBy(String groupBy) {
        if (groupBy == null) {
            throw new IllegalArgumentException("groupBy can't be null.");
        }
        if (0 == groupBy.length()) {
            throw new IllegalArgumentException("groupBy can't be empty.");
        }
        this.clearGenerated();
        this.mGroupBy.add(groupBy);
        return this;
    }

    public Select groupBy(Class beanClass) {
        return this.groupByExcluded(beanClass, null);
    }

    public Select groupByExcluded(Class beanClass, String[] excludedFields) {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass can't be null.");
        }
        SortedSet<String> property_names = QueryHelper.getBeanPropertyNames(beanClass, excludedFields);
        this.clearGenerated();
        for (String property_name : (Collection)property_names) {
            this.mGroupBy.add(property_name);
        }
        return this;
    }

    public Select having(String having) {
        if (having == null) {
            throw new IllegalArgumentException("having can't be null.");
        }
        if (0 == having.length()) {
            throw new IllegalArgumentException("having can't be empty.");
        }
        this.clearGenerated();
        this.mHaving.add(having);
        return this;
    }

    public Select union(String union) {
        if (union == null) {
            throw new IllegalArgumentException("union can't be null.");
        }
        if (0 == union.length()) {
            throw new IllegalArgumentException("union can't be empty.");
        }
        this.clearGenerated();
        this.mUnions.add(union);
        return this;
    }

    public Select union(Select union) {
        if (union == null) {
            throw new IllegalArgumentException("union can't be null.");
        }
        this.union(union.getSql());
        this._unionSubselect(union);
        return this;
    }

    public Select orderBy(String column) {
        this.clearGenerated();
        return this.orderBy(column, ASC);
    }

    public Select orderBy(String column, OrderByDirection direction) {
        if (column == null) {
            throw new IllegalArgumentException("column can't be null.");
        }
        if (0 == column.length()) {
            throw new IllegalArgumentException("column can't be empty.");
        }
        if (direction == null) {
            throw new IllegalArgumentException("direction can't be null.");
        }
        OrderBy orderby = new OrderBy(column, direction);
        this.clearGenerated();
        this.mOrderBy.add(orderby);
        return this;
    }

    public Select limit(int limit) {
        if (limit < 1) {
            throw new IllegalArgumentException("limit must be at least 1.");
        }
        this.clearGenerated();
        this.mLimit = limit;
        this.setLimitParameter(null);
        return this;
    }

    public Select limitParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.clearGenerated();
        this.mLimit = -1;
        this.setLimitParameter(name);
        return this;
    }

    public Select offset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset must be at least 0.");
        }
        this.clearGenerated();
        this.mOffset = offset;
        this.setOffsetParameter(null);
        return this;
    }

    @Override
    protected boolean isLimitBeforeOffset() {
        Template template2 = this.getTemplate();
        if (!template2.hasValueId("OFFSET") || !template2.hasValueId("LIMIT_VALUE")) {
            return super.isLimitBeforeOffset();
        }
        String offset = template2.getValue("OFFSET");
        String limit_value = template2.getValue("LIMIT_VALUE");
        template2.setValue("OFFSET", "offset");
        template2.setValue("LIMIT_VALUE", "limit");
        String limit = template2.getBlock("LIMIT");
        template2.setValue("OFFSET", offset);
        template2.setValue("LIMIT_VALUE", limit_value);
        return limit.indexOf("offset") >= limit.indexOf("limit");
    }

    public Select offsetParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.clearGenerated();
        this.mOffset = -1;
        this.setOffsetParameter(name);
        return this;
    }

    @Override
    public Select clone() {
        Select new_instance = (Select)super.clone();
        if (new_instance != null) {
            if (this.mFields != null) {
                new_instance.mFields = new ArrayList();
                new_instance.mFields.addAll(this.mFields);
            }
            if (this.mJoins != null) {
                new_instance.mJoins = new ArrayList();
                for (Join join : (Collection)this.mJoins) {
                    new_instance.mJoins.add(join.clone());
                }
            }
            if (this.mUnions != null) {
                new_instance.mUnions = new ArrayList();
                new_instance.mUnions.addAll(this.mUnions);
            }
            if (this.mGroupBy != null) {
                new_instance.mGroupBy = new ArrayList();
                new_instance.mGroupBy.addAll(this.mGroupBy);
            }
            if (this.mHaving != null) {
                new_instance.mHaving = new ArrayList();
                new_instance.mHaving.addAll(this.mHaving);
            }
            if (this.mDistinctOn != null) {
                new_instance.mDistinctOn = new ArrayList();
                new_instance.mDistinctOn.addAll(this.mDistinctOn);
            }
            if (this.mOrderBy != null) {
                new_instance.mOrderBy = new ArrayList();
                for (OrderBy order_by : (Collection)this.mOrderBy) {
                    new_instance.mOrderBy.add(order_by.clone());
                }
            }
        }
        return new_instance;
    }

    @Override
    public /* synthetic */ Object clone() {
        return this.clone();
    }

    @Override
    public /* synthetic */ AbstractWhereQuery clone() {
        return this.clone();
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.database.queries.Select");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        NATURAL = new JoinCondition("NATURAL");
        ON = new JoinCondition("ON");
        USING = new JoinCondition("USING");
        LEFT = new JoinType("LEFT");
        RIGHT = new JoinType("RIGHT");
        FULL = new JoinType("FULL");
        ASC = new OrderByDirection("ASC");
        DESC = new OrderByDirection("DESC");
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OrderByDirection
    extends EnumClass<String> {
        OrderByDirection(String identifier) {
            super(identifier);
        }

        public static OrderByDirection getDirection(String identifier) {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.database.queries.Select$OrderByDirection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return (OrderByDirection)EnumClass.getMember(clazz, identifier);
        }
    }

    public abstract class Join
    implements Cloneable {
        private String mData = null;
        private static /* synthetic */ boolean $assertionsDisabled;

        Join(String data) {
            if (!$assertionsDisabled && data == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && data.length() <= 0) {
                throw new AssertionError();
            }
            this.setData(data);
        }

        abstract String getSql(Template var1);

        public String getData() {
            return this.mData;
        }

        void setData(String data) {
            if (!$assertionsDisabled && data == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && data.length() <= 0) {
                throw new AssertionError();
            }
            this.mData = data;
        }

        public Join clone() {
            Join new_instance = null;
            try {
                new_instance = (Join)super.clone();
            }
            catch (CloneNotSupportedException e) {
                new_instance = null;
            }
            return new_instance;
        }

        public /* synthetic */ Object clone() {
            return this.clone();
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.database.queries.Select$Join");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        static /* synthetic */ Select access$0(Join join) {
            return join.Select.this;
        }
    }

    public class OrderBy
    implements Cloneable {
        private String mColumn = null;
        private OrderByDirection mDirection = null;
        private static /* synthetic */ boolean $assertionsDisabled;

        OrderBy(String column, OrderByDirection direction) {
            if (!$assertionsDisabled && column == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && column.length() <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && direction == null) {
                throw new AssertionError();
            }
            this.setColumn(column);
            this.setDirection(direction);
        }

        String getSql(Template template2) {
            if (!$assertionsDisabled && template2 == null) {
                throw new AssertionError();
            }
            String result = null;
            template2.setValue("COLUMN", this.getColumn());
            template2.setValue("DIRECTION", template2.getBlock("ORDERBY_" + this.getDirection().toString()));
            result = template2.getBlock("ORDERBY_PART");
            template2.removeValue("COLUMN");
            template2.removeValue("DIRECTION");
            if (!$assertionsDisabled && result == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && result.length() <= 0) {
                throw new AssertionError();
            }
            return result;
        }

        public String getColumn() {
            return this.mColumn;
        }

        void setColumn(String column) {
            if (!$assertionsDisabled && column == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && column.length() <= 0) {
                throw new AssertionError();
            }
            this.mColumn = column;
        }

        public OrderByDirection getDirection() {
            return this.mDirection;
        }

        void setDirection(OrderByDirection direction) {
            if (!$assertionsDisabled && direction == null) {
                throw new AssertionError();
            }
            this.mDirection = direction;
        }

        public OrderBy clone() {
            OrderBy new_instance = null;
            try {
                new_instance = (OrderBy)super.clone();
            }
            catch (CloneNotSupportedException e) {
                new_instance = null;
            }
            return new_instance;
        }

        public /* synthetic */ Object clone() {
            return this.clone();
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.database.queries.Select$OrderBy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        static /* synthetic */ Select access$0(OrderBy orderBy) {
            return orderBy.Select.this;
        }
    }

    public class JoinDefault
    extends Join
    implements Cloneable {
        private static /* synthetic */ boolean $assertionsDisabled;

        JoinDefault(String table) {
            super(table);
        }

        String getSql(Template template2) {
            if (!$assertionsDisabled && template2 == null) {
                throw new AssertionError();
            }
            String result = null;
            template2.setValue("TABLE", this.getData());
            result = template2.getBlock("JOIN_DEFAULT");
            template2.removeValue("TABLE");
            if (!$assertionsDisabled && result == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && result.length() <= 0) {
                throw new AssertionError();
            }
            return result;
        }

        public JoinDefault clone() {
            JoinDefault new_instance = (JoinDefault)super.clone();
            return new_instance;
        }

        public /* synthetic */ Object clone() {
            return this.clone();
        }

        public /* synthetic */ Join clone() {
            return this.clone();
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.database.queries.Select$JoinDefault");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        static /* synthetic */ Select access$0(JoinDefault joinDefault) {
            return joinDefault.Select.this;
        }
    }

    public class JoinCustom
    extends Join {
        JoinCustom(String customJoin) {
            super(customJoin);
        }

        String getSql(Template template2) {
            return " " + this.getData();
        }

        static /* synthetic */ Select access$0(JoinCustom joinCustom) {
            return joinCustom.Select.this;
        }
    }

    public class JoinCross
    extends Join
    implements Cloneable {
        private static /* synthetic */ boolean $assertionsDisabled;

        JoinCross(String table) {
            super(table);
        }

        String getSql(Template template2) {
            if (!$assertionsDisabled && template2 == null) {
                throw new AssertionError();
            }
            String result = null;
            template2.setValue("TABLE", this.getData());
            result = template2.getBlock("JOIN_CROSS");
            if (0 == result.length()) {
                throw new UnsupportedSqlFeatureException("CROSS JOIN", Select.this.mDatasource.getAliasedDriver());
            }
            template2.removeValue("TABLE");
            if (!$assertionsDisabled && result == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && result.length() <= 0) {
                throw new AssertionError();
            }
            return result;
        }

        public JoinCross clone() {
            JoinCross new_instance = (JoinCross)super.clone();
            return new_instance;
        }

        public /* synthetic */ Object clone() {
            return this.clone();
        }

        public /* synthetic */ Join clone() {
            return this.clone();
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.database.queries.Select$JoinCross");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        static /* synthetic */ Select access$0(JoinCross joinCross) {
            return joinCross.Select.this;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JoinCondition
    extends EnumClass<String> {
        JoinCondition(String identifier) {
            super(identifier);
        }
    }

    public class JoinInner
    extends Join
    implements Cloneable {
        private JoinCondition mCondition;
        private String mExpression;
        private static /* synthetic */ boolean $assertionsDisabled;

        JoinInner(String table, JoinCondition condition, String expression) {
            super(table);
            this.mCondition = null;
            this.mExpression = null;
            if (!$assertionsDisabled && condition == null) {
                throw new AssertionError();
            }
            if (!($assertionsDisabled || condition == NATURAL || expression != null && expression.length() > 0)) {
                throw new AssertionError();
            }
            this.setCondition(condition);
            this.setExpression(expression);
        }

        String getSql(Template template2) {
            if (!$assertionsDisabled && template2 == null) {
                throw new AssertionError();
            }
            String condition = null;
            String result = null;
            template2.setValue("TABLE", this.getData());
            if (this.getExpression() != null) {
                template2.setValue("EXPRESSION", this.getExpression());
            }
            if (0 == (condition = template2.getBlock("JOIN_INNER_" + this.getCondition().toString())).length()) {
                throw new UnsupportedSqlFeatureException(this.getCondition().toString() + " for INNER JOIN", Select.this.mDatasource.getAliasedDriver());
            }
            template2.setValue("JOIN_INNER_" + this.getCondition().toString(), condition);
            result = template2.getBlock("JOIN_INNER");
            if (0 == result.length()) {
                throw new UnsupportedSqlFeatureException("INNER JOIN", Select.this.mDatasource.getAliasedDriver());
            }
            template2.removeValue("TABLE");
            template2.removeValue("EXPRESSION");
            template2.removeValue("JOIN_INNER_" + this.getCondition().toString());
            if (!$assertionsDisabled && result == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && result.length() <= 0) {
                throw new AssertionError();
            }
            return result;
        }

        public JoinCondition getCondition() {
            return this.mCondition;
        }

        void setCondition(JoinCondition condition) {
            if (!$assertionsDisabled && condition == null) {
                throw new AssertionError();
            }
            this.mCondition = condition;
        }

        public String getExpression() {
            return this.mExpression;
        }

        void setExpression(String expression) {
            this.mExpression = expression;
        }

        public JoinInner clone() {
            JoinInner new_instance = (JoinInner)super.clone();
            return new_instance;
        }

        public /* synthetic */ Object clone() {
            return this.clone();
        }

        public /* synthetic */ Join clone() {
            return this.clone();
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.database.queries.Select$JoinInner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        static /* synthetic */ Select access$0(JoinInner joinInner) {
            return joinInner.Select.this;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JoinType
    extends EnumClass<String> {
        JoinType(String identifier) {
            super(identifier);
        }
    }

    public class JoinOuter
    extends Join
    implements Cloneable {
        private JoinType mType;
        private JoinCondition mCondition;
        private String mExpression;
        private static /* synthetic */ boolean $assertionsDisabled;

        JoinOuter(String table, JoinType type, JoinCondition condition, String expression) {
            super(table);
            this.mType = null;
            this.mCondition = null;
            this.mExpression = null;
            if (!$assertionsDisabled && type == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && condition == null) {
                throw new AssertionError();
            }
            if (!($assertionsDisabled || condition == NATURAL || expression != null && expression.length() > 0)) {
                throw new AssertionError();
            }
            this.setType(type);
            this.setCondition(condition);
            this.setExpression(expression);
        }

        String getSql(Template template2) {
            if (!$assertionsDisabled && template2 == null) {
                throw new AssertionError();
            }
            String type = null;
            String condition = null;
            String result = null;
            template2.setValue("TABLE", this.getData());
            if (this.getType() != null) {
                type = template2.getBlock("JOIN_OUTER_" + this.getType().toString());
                if (0 == type.length()) {
                    throw new UnsupportedSqlFeatureException(this.getType().toString() + " for OUTER JOIN", Select.this.mDatasource.getAliasedDriver());
                }
                template2.setValue("JOIN_OUTER_TYPE", type);
            }
            if (this.getExpression() != null) {
                template2.setValue("EXPRESSION", this.getExpression());
            }
            if (0 == (condition = template2.getBlock("JOIN_OUTER_" + this.getCondition().toString())).length()) {
                throw new UnsupportedSqlFeatureException(this.getCondition().toString() + " for OUTER JOIN", Select.this.mDatasource.getAliasedDriver());
            }
            template2.setValue("JOIN_OUTER_" + this.getCondition().toString(), condition);
            result = template2.getBlock("JOIN_OUTER");
            if (0 == result.length()) {
                throw new UnsupportedSqlFeatureException("OUTER JOIN", Select.this.mDatasource.getAliasedDriver());
            }
            template2.removeValue("TABLE");
            template2.removeValue("EXPRESSION");
            template2.removeValue("JOIN_OUTER_" + this.getCondition().toString());
            template2.removeValue("JOIN_OUTER_TYPE");
            if (!$assertionsDisabled && result == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && result.length() <= 0) {
                throw new AssertionError();
            }
            return result;
        }

        public JoinType getType() {
            return this.mType;
        }

        void setType(JoinType type) {
            if (!$assertionsDisabled && type == null) {
                throw new AssertionError();
            }
            this.mType = type;
        }

        public JoinCondition getCondition() {
            return this.mCondition;
        }

        void setCondition(JoinCondition condition) {
            if (!$assertionsDisabled && condition == null) {
                throw new AssertionError();
            }
            this.mCondition = condition;
        }

        public String getExpression() {
            return this.mExpression;
        }

        void setExpression(String expression) {
            this.mExpression = expression;
        }

        public JoinOuter clone() {
            JoinOuter new_instance = (JoinOuter)super.clone();
            return new_instance;
        }

        public /* synthetic */ Object clone() {
            return this.clone();
        }

        public /* synthetic */ Join clone() {
            return this.clone();
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.database.queries.Select$JoinOuter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        static /* synthetic */ Select access$0(JoinOuter joinOuter) {
            return joinOuter.Select.this;
        }
    }
}

