/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database.queries;

import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.AbstractParametrizedQuery;
import com.uwyn.rife.database.queries.QueryParameterType;
import com.uwyn.rife.pcj.map.IntKeyIntMap;
import com.uwyn.rife.pcj.map.IntKeyIntOpenHashMap;
import com.uwyn.rife.tools.ArrayUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryParameters
implements Cloneable {
    private AbstractParametrizedQuery mQuery = null;
    private HashMap<QueryParameterType, Object> mParameters = null;
    private ArrayList<String> mCombinedParameters = null;
    private String[] mCombinedParametersArray = null;

    public QueryParameters(AbstractParametrizedQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null");
        }
        this.mQuery = query;
    }

    public QueryParameters getNewInstance() {
        return new QueryParameters(this.mQuery);
    }

    public int getNumberOfTypes() {
        if (this.mParameters == null) {
            return 0;
        }
        return this.mParameters.size();
    }

    public void clear() {
        this.mParameters = null;
        this.mCombinedParameters = null;
        this.mCombinedParametersArray = null;
    }

    public boolean hasParameter(QueryParameterType type, String value) {
        if (type == null || value == null || this.mParameters == null) {
            return false;
        }
        if (!this.mParameters.containsKey(type)) {
            return false;
        }
        if (type.isSingular()) {
            return value.equals(this.mParameters.get(type));
        }
        List list = (List)this.mParameters.get(type);
        if (list == null) {
            return false;
        }
        return list.contains(value);
    }

    public Set<String> getDistinctNames() {
        if (this.mParameters == null || 0 == this.mParameters.size()) {
            return null;
        }
        HashSet<String> names = new HashSet<String>();
        for (Map.Entry entry : (Collection)this.mParameters.entrySet()) {
            if (((QueryParameterType)entry.getKey()).isSingular()) {
                names.add((String)entry.getValue());
                continue;
            }
            names.addAll((List)entry.getValue());
        }
        return names;
    }

    public List<String> getOrderedNames() {
        if (this.mCombinedParameters == null) {
            ArrayList<String> combined_parameters = null;
            if (this.mParameters != null && this.mParameters.size() > 0) {
                if (this.mParameters.containsKey(QueryParameterType.FIELD)) {
                    combined_parameters = new ArrayList<String>();
                    for (String parameter : (Collection)((List)this.mParameters.get(QueryParameterType.FIELD))) {
                        combined_parameters.add(parameter);
                    }
                }
                if (this.mParameters.containsKey(QueryParameterType.TABLE)) {
                    if (combined_parameters == null) {
                        combined_parameters = new ArrayList();
                    }
                    for (String parameter : (Collection)((List)this.mParameters.get(QueryParameterType.TABLE))) {
                        combined_parameters.add(parameter);
                    }
                }
                if (this.mParameters.containsKey(QueryParameterType.WHERE)) {
                    if (combined_parameters == null) {
                        combined_parameters = new ArrayList();
                    }
                    for (String parameter : (Collection)((List)this.mParameters.get(QueryParameterType.WHERE))) {
                        combined_parameters.add(parameter);
                    }
                }
                if (this.mParameters.containsKey(QueryParameterType.UNION)) {
                    if (combined_parameters == null) {
                        combined_parameters = new ArrayList();
                    }
                    for (String parameter : (Collection)((List)this.mParameters.get(QueryParameterType.UNION))) {
                        combined_parameters.add(parameter);
                    }
                }
                if (this.mParameters.containsKey(QueryParameterType.LIMIT) || this.mParameters.containsKey(QueryParameterType.OFFSET)) {
                    String value;
                    if (this.mQuery.isLimitBeforeOffset()) {
                        if (this.mParameters.containsKey(QueryParameterType.LIMIT)) {
                            if (combined_parameters == null) {
                                combined_parameters = new ArrayList();
                            }
                            value = (String)this.mParameters.get(QueryParameterType.LIMIT);
                            combined_parameters.add(value);
                        }
                        if (this.mParameters.containsKey(QueryParameterType.OFFSET)) {
                            if (combined_parameters == null) {
                                combined_parameters = new ArrayList();
                            }
                            value = (String)this.mParameters.get(QueryParameterType.OFFSET);
                            combined_parameters.add(value);
                        }
                    } else {
                        if (this.mParameters.containsKey(QueryParameterType.OFFSET)) {
                            if (combined_parameters == null) {
                                combined_parameters = new ArrayList();
                            }
                            value = (String)this.mParameters.get(QueryParameterType.OFFSET);
                            combined_parameters.add(value);
                        }
                        if (this.mParameters.containsKey(QueryParameterType.LIMIT)) {
                            if (combined_parameters == null) {
                                combined_parameters = new ArrayList();
                            }
                            value = (String)this.mParameters.get(QueryParameterType.LIMIT);
                            combined_parameters.add(value);
                        }
                    }
                }
            }
            this.mCombinedParameters = combined_parameters;
            this.mCombinedParametersArray = null;
        }
        return this.mCombinedParameters;
    }

    private void addVirtualIndexMapping(QueryParameters virtualParameters, IntKeyIntMap map, int[] parameterIndex, int[] realIndex, QueryParameterType type, String parameter) {
        if (virtualParameters.hasParameter(type, parameter)) {
            map.put(parameterIndex[0], -1);
        } else {
            map.put(parameterIndex[0], realIndex[0]);
            realIndex[0] = realIndex[0] + 1;
        }
        parameterIndex[0] = parameterIndex[0] + 1;
    }

    public IntKeyIntMap getVirtualIndexMapping(QueryParameters virtualParameters) {
        IntKeyIntOpenHashMap map = null;
        if (this.mParameters != null && this.mParameters.size() > 0 && virtualParameters != null && virtualParameters.getNumberOfTypes() > 0) {
            map = new IntKeyIntOpenHashMap();
            int[] parameter_index = new int[]{1};
            int[] real_index = new int[]{1};
            if (this.mParameters.containsKey(QueryParameterType.FIELD)) {
                for (String parameter : (Collection)((List)this.mParameters.get(QueryParameterType.FIELD))) {
                    this.addVirtualIndexMapping(virtualParameters, map, parameter_index, real_index, QueryParameterType.FIELD, parameter);
                }
            }
            if (this.mParameters.containsKey(QueryParameterType.TABLE)) {
                for (String parameter : (Collection)((List)this.mParameters.get(QueryParameterType.TABLE))) {
                    this.addVirtualIndexMapping(virtualParameters, map, parameter_index, real_index, QueryParameterType.TABLE, parameter);
                }
            }
            if (this.mParameters.containsKey(QueryParameterType.WHERE)) {
                for (String parameter : (Collection)((List)this.mParameters.get(QueryParameterType.WHERE))) {
                    this.addVirtualIndexMapping(virtualParameters, map, parameter_index, real_index, QueryParameterType.WHERE, parameter);
                }
            }
            if (this.mParameters.containsKey(QueryParameterType.UNION)) {
                for (String parameter : (Collection)((List)this.mParameters.get(QueryParameterType.UNION))) {
                    this.addVirtualIndexMapping(virtualParameters, map, parameter_index, real_index, QueryParameterType.UNION, parameter);
                }
            }
            if (this.mParameters.containsKey(QueryParameterType.LIMIT) || this.mParameters.containsKey(QueryParameterType.OFFSET)) {
                String parameter;
                if (this.mQuery.isLimitBeforeOffset()) {
                    if (this.mParameters.containsKey(QueryParameterType.LIMIT)) {
                        parameter = (String)this.mParameters.get(QueryParameterType.LIMIT);
                        this.addVirtualIndexMapping(virtualParameters, map, parameter_index, real_index, QueryParameterType.LIMIT, parameter);
                    }
                    if (this.mParameters.containsKey(QueryParameterType.OFFSET)) {
                        parameter = (String)this.mParameters.get(QueryParameterType.OFFSET);
                        this.addVirtualIndexMapping(virtualParameters, map, parameter_index, real_index, QueryParameterType.OFFSET, parameter);
                    }
                } else {
                    if (this.mParameters.containsKey(QueryParameterType.OFFSET)) {
                        parameter = (String)this.mParameters.get(QueryParameterType.OFFSET);
                        this.addVirtualIndexMapping(virtualParameters, map, parameter_index, real_index, QueryParameterType.OFFSET, parameter);
                    }
                    if (this.mParameters.containsKey(QueryParameterType.LIMIT)) {
                        parameter = (String)this.mParameters.get(QueryParameterType.LIMIT);
                        this.addVirtualIndexMapping(virtualParameters, map, parameter_index, real_index, QueryParameterType.LIMIT, parameter);
                    }
                }
            }
        }
        return map;
    }

    public String[] getOrderedNamesArray() {
        if (this.mParameters == null || 0 == this.mParameters.size()) {
            return null;
        }
        if (this.mCombinedParametersArray == null) {
            String[] array = new String[]{};
            for (String parameter_name : (Collection)this.getOrderedNames()) {
                array = ArrayUtils.join(array, parameter_name);
            }
            this.mCombinedParametersArray = array;
        }
        return this.mCombinedParametersArray;
    }

    private void clearCombinedParameters() {
        this.mCombinedParameters = null;
        this.mCombinedParametersArray = null;
    }

    public void clearTypedParameters(QueryParameterType type) {
        if (type == null) {
            throw new IllegalArgumentException("the parameter type can't be null");
        }
        if (this.mParameters == null) {
            return;
        }
        this.mParameters.remove(type);
        this.clearCombinedParameters();
    }

    public <T> T getTypedParameters(QueryParameterType type) {
        if (type == null) {
            throw new IllegalArgumentException("the parameter type can't be null");
        }
        if (this.mParameters == null) {
            return null;
        }
        return (T)this.mParameters.get(type);
    }

    public void addTypedParameters(QueryParameterType type, List<String> parameters) {
        if (type == null) {
            throw new IllegalArgumentException("the parameter type can't be null");
        }
        if (type.isSingular()) {
            throw new IllegalArgumentException(new StringBuffer().append(new StringBuffer().append("the parameter type '").append(type).toString()).append("' only supports a singular value").toString());
        }
        if (parameters == null || 0 == parameters.size()) {
            return;
        }
        ArrayList<String> typed_parameters = null;
        if (this.mParameters == null) {
            this.mParameters = new HashMap();
        } else {
            typed_parameters = (ArrayList<String>)this.mParameters.get(type);
        }
        boolean new_collection = false;
        if (typed_parameters == null) {
            typed_parameters = new ArrayList<String>();
            new_collection = true;
        }
        typed_parameters.addAll(parameters);
        if (new_collection) {
            this.mParameters.put(type, typed_parameters);
        }
        this.clearCombinedParameters();
    }

    public void addTypedParameter(QueryParameterType type, String value) {
        if (type == null) {
            throw new IllegalArgumentException("the parameter type can't be null");
        }
        if (value != null) {
            if (this.mParameters == null) {
                this.mParameters = new HashMap();
            }
            if (value.indexOf(".") != -1) {
                value = value.substring(value.lastIndexOf(".") + 1);
            }
        }
        if (type.isSingular()) {
            if (value == null) {
                if (this.mParameters == null) {
                    return;
                }
                this.mParameters.remove(type);
            } else {
                this.mParameters.put(type, value);
            }
        } else {
            if (value == null) {
                return;
            }
            ArrayList<String> typed_parameters = (ArrayList<String>)this.mParameters.get(type);
            boolean new_collection = false;
            if (typed_parameters == null) {
                typed_parameters = new ArrayList<String>();
                new_collection = true;
            }
            typed_parameters.add(value);
            if (new_collection) {
                this.mParameters.put(type, typed_parameters);
            }
        }
        this.clearCombinedParameters();
    }

    public QueryParameters clone() {
        QueryParameters new_instance = null;
        try {
            new_instance = (QueryParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new DatabaseException(e);
        }
        if (new_instance != null) {
            if (this.mCombinedParameters != null) {
                new_instance.mCombinedParameters = new ArrayList();
                new_instance.mCombinedParameters.addAll(this.mCombinedParameters);
            }
            if (this.mParameters != null) {
                new_instance.mParameters = new HashMap();
                for (Map.Entry entry : (Collection)this.mParameters.entrySet()) {
                    if (((QueryParameterType)entry.getKey()).isSingular()) {
                        new_instance.mParameters.put((QueryParameterType)entry.getKey(), entry.getValue());
                        continue;
                    }
                    ArrayList values = new ArrayList();
                    values.addAll((List)entry.getValue());
                    new_instance.mParameters.put((QueryParameterType)entry.getKey(), values);
                }
            }
        }
        return new_instance;
    }

    public /* synthetic */ Object clone() {
        return this.clone();
    }
}

