/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database.queries;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.capabilities.Capabilities;
import com.uwyn.rife.database.exceptions.UnsupportedSqlFeatureException;
import com.uwyn.rife.database.queries.AbstractParametrizedQuery;
import com.uwyn.rife.database.queries.QueryHelper;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.database.types.SqlNull;
import com.uwyn.rife.site.Constrained;
import com.uwyn.rife.site.ConstrainedUtils;
import com.uwyn.rife.template.Template;
import com.uwyn.rife.template.TemplateFactory;
import com.uwyn.rife.tools.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Insert
extends AbstractParametrizedQuery
implements Cloneable {
    private String mInto = null;
    private LinkedHashMap<String, ArrayList<Object>> mFields = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    public Insert(Datasource datasource) {
        super(datasource);
        if (datasource == null) {
            throw new IllegalArgumentException("datasource can't be null.");
        }
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.mFields = new LinkedHashMap();
        this.mInto = null;
        if (!$assertionsDisabled && 0 != this.mFields.size()) {
            throw new AssertionError();
        }
    }

    public String getInto() {
        return this.mInto;
    }

    public Map<String, ArrayList<Object>> getFields() {
        return this.mFields;
    }

    @Override
    public Capabilities getCapabilities() {
        return null;
    }

    @Override
    public String getSql() {
        if (this.mSql == null) {
            if (this.mInto == null || 0 == this.mFields.size()) {
                return null;
            }
            Template template2 = TemplateFactory.SQL.get(new StringBuffer().append(new StringBuffer().append("sql.").append(StringUtils.encodeClassname(this.mDatasource.getAliasedDriver())).toString()).append(".insert").toString());
            template2.setValue("INTO", this.mInto);
            int maximum_number_of_value_rows = 0;
            for (ArrayList<Object> values : this.mFields.values()) {
                if (values.size() <= maximum_number_of_value_rows) continue;
                maximum_number_of_value_rows = values.size();
            }
            ArrayList<String> value_rows = new ArrayList<String>();
            ArrayList<String> value_row = null;
            Object[] column_names = this.mFields.keySet().toArray();
            String column_name = null;
            int current_value_row = 0;
            while (current_value_row < maximum_number_of_value_rows) {
                value_row = new ArrayList<String>();
                int i = 0;
                while (i < column_names.length) {
                    column_name = (String)column_names[i];
                    if (current_value_row <= this.mFields.get(column_name).size() - 1) {
                        value_row.add(this.mFields.get(column_name).get(current_value_row).toString());
                    } else {
                        value_row.add("NULL");
                    }
                    ++i;
                }
                template2.setValue("VALUES", StringUtils.join(value_row, template2.getBlock("SEPERATOR")));
                value_rows.add(template2.getBlock("VALUE_ROW"));
                ++current_value_row;
            }
            template2.setValue("COLUMNS", StringUtils.join(column_names, template2.getBlock("SEPERATOR")));
            if (1 == value_rows.size()) {
                template2.setValue("DATA", (String)value_rows.get(0));
            } else {
                String block;
                if (template2.hasValueId("VALUE_ROWS")) {
                    template2.setValue("VALUE_ROWS", StringUtils.join(value_rows, template2.getBlock("SEPERATOR")));
                }
                if (0 == (block = template2.getBlock("VALUE_ROWS")).length()) {
                    throw new UnsupportedSqlFeatureException("MULTIPLE INSERT ROWS", this.mDatasource.getAliasedDriver());
                }
                template2.setValue("DATA", block);
            }
            this.mSql = template2.getBlock("QUERY");
            if (!$assertionsDisabled && this.mSql == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mSql.length() <= 0) {
                throw new AssertionError();
            }
        }
        return this.mSql;
    }

    public Insert into(String into) {
        if (into == null) {
            throw new IllegalArgumentException("into can't be null.");
        }
        if (0 == into.length()) {
            throw new IllegalArgumentException("into can't be empty.");
        }
        this.clearGenerated();
        this.mInto = into;
        return this;
    }

    public Insert fieldSubselect(Select query) {
        this._fieldSubselect(query);
        return this;
    }

    protected Insert _field(String field, Object value) {
        if (!$assertionsDisabled && field == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && field.length() <= 0) {
            throw new AssertionError();
        }
        this.clearGenerated();
        if (!this.mFields.containsKey(field)) {
            this.mFields.put(field, new ArrayList());
        }
        if (value == null) {
            this.mFields.get(field).add(SqlNull.NULL);
        } else {
            this.mFields.get(field).add(value);
        }
        return this;
    }

    public Insert fieldParameter(String field) {
        return this.fieldParameter(field, field);
    }

    public Insert fieldParameter(String field, String alias) {
        if (field == null) {
            throw new IllegalArgumentException("field can't be null.");
        }
        if (0 == field.length()) {
            throw new IllegalArgumentException("field can't be empty.");
        }
        if (alias == null) {
            throw new IllegalArgumentException("alias can't be null.");
        }
        if (0 == alias.length()) {
            throw new IllegalArgumentException("alias can't be empty.");
        }
        this.clearGenerated();
        this.addFieldParameter(alias);
        return this._field(field, "?");
    }

    public Insert field(String field, char value) {
        return this.field(field, new Character(value));
    }

    public Insert field(String field, boolean value) {
        return this.field(field, new Boolean(value));
    }

    public Insert field(String field, byte value) {
        return this.field(field, new Byte(value));
    }

    public Insert field(String field, double value) {
        return this.field(field, new Double(value));
    }

    public Insert field(String field, float value) {
        return this.field(field, new Float(value));
    }

    public Insert field(String field, int value) {
        return this.field(field, new Integer(value));
    }

    public Insert field(String field, long value) {
        return this.field(field, new Long(value));
    }

    public Insert field(String field, short value) {
        return this.field(field, new Short(value));
    }

    public Insert field(String field, Select query) {
        StringBuffer buffer;
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        StringBuffer stringBuffer = buffer = new StringBuffer();
        synchronized (stringBuffer) {
            buffer.append("(");
            buffer.append(query.toString());
            buffer.append(")");
            this.fieldCustom(field, buffer.toString());
        }
        this._fieldSubselect(query);
        return this;
    }

    public Insert field(String field, Object value) {
        if (field == null) {
            throw new IllegalArgumentException("field can't be null.");
        }
        if (0 == field.length()) {
            throw new IllegalArgumentException("field can't be empty.");
        }
        if (value == null) {
            return this._field(field, null);
        }
        return this._field(field, this.mDatasource.getSqlConversion().getSqlValue(value));
    }

    public Insert fieldCustom(String field, String expression) {
        if (field == null) {
            throw new IllegalArgumentException("field can't be null.");
        }
        if (0 == field.length()) {
            throw new IllegalArgumentException("field can't be empty.");
        }
        if (expression == null) {
            return this._field(field, null);
        }
        return this._field(field, expression);
    }

    public Insert fields(Object[] keyValues) {
        if (keyValues == null) {
            throw new IllegalArgumentException("keyValues can't be null.");
        }
        if (0 == keyValues.length) {
            throw new IllegalArgumentException("keyValues can't be empty.");
        }
        int i = 0;
        while (i < keyValues.length) {
            if (keyValues[i] != null) {
                this.field(keyValues[i].toString(), keyValues[i + 1]);
            }
            i += 2;
        }
        return this;
    }

    public Insert fields(Object bean) {
        return this.fieldsFiltered(bean, null, null);
    }

    public Insert fieldsIncluded(Object bean, String[] includedFields) {
        return this.fieldsFiltered(bean, includedFields, null);
    }

    public Insert fieldsExcluded(Object bean, String[] excludedFields) {
        return this.fieldsFiltered(bean, null, excludedFields);
    }

    public Insert fieldsFiltered(Object bean, String[] includedFields, String[] excludedFields) {
        if (bean == null) {
            throw new IllegalArgumentException("bean can't be null.");
        }
        Constrained constrained = ConstrainedUtils.makeConstrainedInstance(bean);
        Map<String, String> property_values = QueryHelper.getBeanPropertyValues(bean, includedFields, excludedFields, this.getDatasource());
        for (String property_name : (Collection)property_values.keySet()) {
            if (!ConstrainedUtils.saveConstrainedProperty(constrained, property_name, null)) continue;
            this._field(property_name, property_values.get(property_name));
        }
        return this;
    }

    public Insert fieldsParameters(Class beanClass) {
        return this.fieldsParametersExcluded(beanClass, null);
    }

    public Insert fieldsParametersExcluded(Class beanClass, String[] excludedFields) {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass can't be null.");
        }
        this.clearGenerated();
        Constrained constrained = ConstrainedUtils.getConstrainedInstance(beanClass);
        SortedSet<String> property_names = QueryHelper.getBeanPropertyNames(beanClass, excludedFields);
        for (String property_name : (Collection)property_names) {
            if (!ConstrainedUtils.saveConstrainedProperty(constrained, property_name, null)) continue;
            this.addFieldParameter(property_name);
            this._field(property_name, "?");
        }
        return this;
    }

    @Override
    public Insert clone() {
        Insert new_instance = (Insert)super.clone();
        if (new_instance != null && this.mFields != null) {
            new_instance.mFields = new LinkedHashMap();
            ArrayList<Object> values = null;
            for (String field : (Collection)this.mFields.keySet()) {
                values = this.mFields.get(field);
                if (values != null) {
                    values = new ArrayList<Object>(values);
                }
                new_instance.mFields.put(field, values);
            }
        }
        return new_instance;
    }

    @Override
    public /* synthetic */ Object clone() {
        return this.clone();
    }

    @Override
    public /* synthetic */ AbstractParametrizedQuery clone() {
        return this.clone();
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.database.queries.Insert");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

