/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database.queries;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.capabilities.Capabilities;
import com.uwyn.rife.database.exceptions.UnsupportedSqlFeatureException;
import com.uwyn.rife.database.queries.AbstractQuery;
import com.uwyn.rife.template.Template;
import com.uwyn.rife.template.TemplateFactory;
import com.uwyn.rife.tools.StringUtils;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropTable
extends AbstractQuery
implements Cloneable {
    private ArrayList<String> mTables = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    public DropTable(Datasource datasource) {
        super(datasource);
        if (datasource == null) {
            throw new IllegalArgumentException("datasource can't be null.");
        }
        this.clear();
    }

    public Collection<String> getTables() {
        return this.mTables;
    }

    @Override
    public void clear() {
        super.clear();
        this.mTables = new ArrayList();
        if (!$assertionsDisabled && 0 != this.mTables.size()) {
            throw new AssertionError();
        }
    }

    @Override
    public Capabilities getCapabilities() {
        return null;
    }

    @Override
    public String getSql() {
        if (this.mSql == null) {
            if (0 == this.mTables.size()) {
                return null;
            }
            Template template2 = TemplateFactory.SQL.get(new StringBuffer().append(new StringBuffer().append("sql.").append(StringUtils.encodeClassname(this.mDatasource.getAliasedDriver())).toString()).append(".drop_table").toString());
            if (1 == this.mTables.size()) {
                template2.setValue("EXPRESSION", this.mTables.get(0));
            } else {
                String block;
                if (template2.hasValueId("TABLES")) {
                    template2.setValue("TABLES", StringUtils.join(this.mTables, template2.getBlock("SEPERATOR")));
                }
                if (0 == (block = template2.getBlock("TABLES")).length()) {
                    throw new UnsupportedSqlFeatureException("MULTIPLE TABLE DROP", this.mDatasource.getAliasedDriver());
                }
                template2.setValue("EXPRESSION", block);
            }
            this.mSql = template2.getBlock("QUERY");
            if (template2.hasValueId("TABLES")) {
                template2.removeValue("TABLES");
            }
            template2.removeValue("EXPRESSION");
            if (!$assertionsDisabled && this.mSql == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mSql.length() <= 0) {
                throw new AssertionError();
            }
        }
        return this.mSql;
    }

    public DropTable table(String table) {
        if (table == null) {
            throw new IllegalArgumentException("table can't be null.");
        }
        if (0 == table.length()) {
            throw new IllegalArgumentException("table can't be empty.");
        }
        this.mTables.add(table);
        this.clearGenerated();
        return this;
    }

    @Override
    public DropTable clone() {
        DropTable new_instance = (DropTable)super.clone();
        if (new_instance != null && this.mTables != null) {
            new_instance.mTables = new ArrayList();
            new_instance.mTables.addAll(this.mTables);
        }
        return new_instance;
    }

    @Override
    public /* synthetic */ Object clone() {
        return this.clone();
    }

    @Override
    public /* synthetic */ AbstractQuery clone() {
        return this.clone();
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.database.queries.DropTable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

