/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database.queries;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.capabilities.Capabilities;
import com.uwyn.rife.database.exceptions.UnsupportedSqlFeatureException;
import com.uwyn.rife.database.queries.AbstractQuery;
import com.uwyn.rife.database.queries.QueryHelper;
import com.uwyn.rife.datastructures.EnumClass;
import com.uwyn.rife.site.Constrained;
import com.uwyn.rife.site.ConstrainedBean;
import com.uwyn.rife.site.ConstrainedProperty;
import com.uwyn.rife.site.ConstrainedUtils;
import com.uwyn.rife.template.Template;
import com.uwyn.rife.template.TemplateFactory;
import com.uwyn.rife.tools.ClassUtils;
import com.uwyn.rife.tools.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.SortedMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTable
extends AbstractQuery
implements Cloneable {
    private String mTable = null;
    private boolean mTemporary = false;
    private LinkedHashMap<String, Column> mColumnMapping = null;
    private ArrayList<PrimaryKey> mPrimaryKeys = null;
    private ArrayList<ForeignKey> mForeignKeys = null;
    private ArrayList<UniqueConstraint> mUniqueConstraints = null;
    private ArrayList<CheckConstraint> mCheckConstraints = null;
    public static final Nullable NULL;
    public static final Nullable NOTNULL;
    public static final ViolationAction NOACTION;
    public static final ViolationAction RESTRICT;
    public static final ViolationAction CASCADE;
    public static final ViolationAction SETNULL;
    public static final ViolationAction SETDEFAULT;
    private static /* synthetic */ boolean $assertionsDisabled;

    public CreateTable(Datasource datasource) {
        super(datasource);
        if (datasource == null) {
            throw new IllegalArgumentException("datasource can't be null.");
        }
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.mTable = null;
        this.mTemporary = false;
        this.mColumnMapping = new LinkedHashMap();
        this.mPrimaryKeys = new ArrayList();
        this.mForeignKeys = new ArrayList();
        this.mUniqueConstraints = new ArrayList();
        this.mCheckConstraints = new ArrayList();
        if (!$assertionsDisabled && 0 != this.mColumnMapping.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 0 != this.mPrimaryKeys.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 0 != this.mForeignKeys.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 0 != this.mUniqueConstraints.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 0 != this.mCheckConstraints.size()) {
            throw new AssertionError();
        }
    }

    @Override
    public Capabilities getCapabilities() {
        return null;
    }

    public String getTable() {
        return this.mTable;
    }

    public boolean isTemporary() {
        return this.mTemporary;
    }

    public LinkedHashMap<String, Column> getColumnMapping() {
        return this.mColumnMapping;
    }

    public ArrayList<PrimaryKey> getPrimaryKeys() {
        return this.mPrimaryKeys;
    }

    public ArrayList<ForeignKey> getForeignKeys() {
        return this.mForeignKeys;
    }

    public ArrayList<UniqueConstraint> getUniqueConstraints() {
        return this.mUniqueConstraints;
    }

    public ArrayList<CheckConstraint> getCheckConstraints() {
        return this.mCheckConstraints;
    }

    @Override
    public String getSql() {
        if (this.mSql == null) {
            if (this.getTable() == null || 0 == this.mColumnMapping.size()) {
                return null;
            }
            Template template2 = TemplateFactory.SQL.get(new StringBuffer().append(new StringBuffer().append("sql.").append(StringUtils.encodeClassname(this.mDatasource.getAliasedDriver())).toString()).append(".create_table").toString());
            String block = null;
            String sql = null;
            String columns = null;
            ArrayList<String> column_list = new ArrayList<String>();
            for (Column column : this.mColumnMapping.values()) {
                column_list.add(column.getSql(template2));
            }
            columns = StringUtils.join(column_list, template2.getBlock("SEPERATOR"));
            if (this.mTemporary) {
                block = template2.getBlock("TEMPORARY");
                if (0 == block.length()) {
                    throw new UnsupportedSqlFeatureException("TEMPORARY", this.mDatasource.getAliasedDriver());
                }
                template2.setValue("TEMPORARY", block);
            }
            String primary = "";
            if (this.mPrimaryKeys.size() > 0) {
                ArrayList<String> constraints = new ArrayList<String>();
                for (Object primary_key : (Collection)this.mPrimaryKeys) {
                    sql = ((PrimaryKey)primary_key).getSql(template2);
                    if (sql.length() <= 0) continue;
                    constraints.add(sql);
                }
                if (constraints.size() > 0) {
                    primary = new StringBuffer().append(template2.getBlock("SEPERATOR")).append(StringUtils.join(constraints, template2.getBlock("SEPERATOR"))).toString();
                }
            }
            String foreign = "";
            if (this.mForeignKeys.size() > 0) {
                ArrayList<String> constraints = new ArrayList<String>();
                for (ForeignKey foreign_key : (Collection)this.mForeignKeys) {
                    sql = foreign_key.getSql(template2);
                    if (sql.length() <= 0) continue;
                    constraints.add(sql);
                }
                if (constraints.size() > 0) {
                    foreign = new StringBuffer().append(template2.getBlock("SEPERATOR")).append(StringUtils.join(constraints, template2.getBlock("SEPERATOR"))).toString();
                }
            }
            String unique = "";
            if (this.mUniqueConstraints.size() > 0) {
                ArrayList<String> constraints = new ArrayList<String>();
                for (UniqueConstraint unique_constraint : (Collection)this.mUniqueConstraints) {
                    sql = unique_constraint.getSql(template2);
                    if (sql.length() <= 0) continue;
                    constraints.add(sql);
                }
                if (constraints.size() > 0) {
                    unique = new StringBuffer().append(template2.getBlock("SEPERATOR")).append(StringUtils.join(constraints, template2.getBlock("SEPERATOR"))).toString();
                }
            }
            String check = "";
            if (this.mCheckConstraints.size() > 0) {
                ArrayList<String> constraints = new ArrayList<String>();
                for (CheckConstraint check_constraint : (Collection)this.mCheckConstraints) {
                    sql = check_constraint.getSql(template2);
                    if (sql.length() <= 0) continue;
                    constraints.add(sql);
                }
                if (constraints.size() > 0) {
                    check = new StringBuffer().append(template2.getBlock("SEPERATOR")).append(StringUtils.join(constraints, template2.getBlock("SEPERATOR"))).toString();
                }
            }
            template2.setValue("TABLE", this.mTable);
            template2.setValue("COLUMNS", columns);
            template2.setValue("PRIMARY_KEYS", primary);
            template2.setValue("FOREIGN_KEYS", foreign);
            template2.setValue("UNIQUE_CONSTRAINTS", unique);
            template2.setValue("CHECKS", check);
            this.mSql = template2.getBlock("QUERY");
            if (!$assertionsDisabled && this.mSql == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mSql.length() <= 0) {
                throw new AssertionError();
            }
        }
        return this.mSql;
    }

    public CreateTable table(String table) {
        if (table == null) {
            throw new IllegalArgumentException("table can't be null.");
        }
        if (0 == table.length()) {
            throw new IllegalArgumentException("table can't be empty.");
        }
        this.mTable = table;
        this.clearGenerated();
        return this;
    }

    public CreateTable temporary(boolean temporary) {
        this.mTemporary = temporary;
        this.clearGenerated();
        return this;
    }

    public CreateTable column(String name, Class type) {
        return this.column(name, type, -1, -1, null, null);
    }

    public CreateTable column(String name, Class type, String typeAttribute) {
        return this.column(name, type, -1, -1, typeAttribute, null);
    }

    public CreateTable column(String name, Class type, int precision) {
        return this.column(name, type, precision, -1, null, null);
    }

    public CreateTable column(String name, Class type, int precision, String typeAttribute) {
        return this.column(name, type, precision, -1, typeAttribute, null);
    }

    public CreateTable column(String name, Class type, int precision, int scale) {
        return this.column(name, type, precision, scale, null, null);
    }

    public CreateTable column(String name, Class type, int precision, int scale, String typeAttribute) {
        return this.column(name, type, precision, scale, typeAttribute, null);
    }

    public CreateTable column(String name, Class type, Nullable nullable) {
        return this.column(name, type, -1, -1, null, nullable);
    }

    public CreateTable column(String name, Class type, String typeAttribute, Nullable nullable) {
        return this.column(name, type, -1, -1, typeAttribute, nullable);
    }

    public CreateTable column(String name, Class type, int precision, Nullable nullable) {
        return this.column(name, type, precision, -1, null, nullable);
    }

    public CreateTable column(String name, Class type, int precision, String typeAttribute, Nullable nullable) {
        return this.column(name, type, precision, -1, typeAttribute, nullable);
    }

    public CreateTable column(String name, Class type, int precision, int scale, Nullable nullable) {
        return this.column(name, type, precision, scale, null, nullable);
    }

    public CreateTable column(String name, Class type, int precision, int scale, String typeAttribute, Nullable nullable) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type can't be null.");
        }
        this.mColumnMapping.put(name, new Column(name, type, precision, scale, typeAttribute, nullable));
        this.clearGenerated();
        return this;
    }

    public CreateTable columns(Object[] keyValues) {
        if (keyValues == null) {
            throw new IllegalArgumentException("keyValues can't be null.");
        }
        int i = 0;
        while (i < keyValues.length) {
            if (keyValues[i] != null) {
                this.column(keyValues[i].toString(), (Class)keyValues[i + 1]);
            }
            i += 2;
        }
        return this;
    }

    public CreateTable precision(String name, int precision) {
        return this.precision(name, precision, -1);
    }

    public CreateTable precision(String name, int precision, int scale) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (!this.mColumnMapping.containsKey(name)) {
            throw new IllegalArgumentException(new StringBuffer().append(new StringBuffer().append("the '").append(name).toString()).append("' column hasn't been defined.").toString());
        }
        Column column = this.mColumnMapping.get(name);
        column.setPrecision(precision);
        column.setScale(scale);
        return this;
    }

    public CreateTable nullable(String name, Nullable nullable) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (!this.mColumnMapping.containsKey(name)) {
            throw new IllegalArgumentException(new StringBuffer().append(new StringBuffer().append("the '").append(name).toString()).append("' column hasn't been defined.").toString());
        }
        Column column = this.mColumnMapping.get(name);
        column.setNullable(nullable);
        return this;
    }

    public CreateTable defaultValue(String name, char value) {
        return this.defaultValue(name, new Character(value));
    }

    public CreateTable defaultValue(String name, boolean value) {
        return this.defaultValue(name, new Boolean(value));
    }

    public CreateTable defaultValue(String name, byte value) {
        return this.defaultValue(name, new Byte(value));
    }

    public CreateTable defaultValue(String name, double value) {
        return this.defaultValue(name, new Double(value));
    }

    public CreateTable defaultValue(String name, float value) {
        return this.defaultValue(name, new Float(value));
    }

    public CreateTable defaultValue(String name, int value) {
        return this.defaultValue(name, new Integer(value));
    }

    public CreateTable defaultValue(String name, long value) {
        return this.defaultValue(name, new Long(value));
    }

    public CreateTable defaultValue(String name, short value) {
        return this.defaultValue(name, new Short(value));
    }

    public CreateTable defaultValue(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (!this.mColumnMapping.containsKey(name)) {
            throw new IllegalArgumentException(new StringBuffer().append(new StringBuffer().append("the '").append(name).toString()).append("' column hasn't been defined.").toString());
        }
        Column column = this.mColumnMapping.get(name);
        column.setDefault(this.mDatasource.getSqlConversion().getSqlValue(value));
        return this;
    }

    public CreateTable defaultFunction(String name, String defaultFunction) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (!this.mColumnMapping.containsKey(name)) {
            throw new IllegalArgumentException(new StringBuffer().append(new StringBuffer().append("the '").append(name).toString()).append("' column hasn't been defined.").toString());
        }
        if (defaultFunction == null) {
            throw new IllegalArgumentException("defaultFunction can't be null.");
        }
        if (0 == defaultFunction.length()) {
            throw new IllegalArgumentException("defaultFunction can't be empty.");
        }
        Column column = this.mColumnMapping.get(name);
        column.setDefault(defaultFunction);
        return this;
    }

    public CreateTable customAttribute(String name, String attribute) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (!this.mColumnMapping.containsKey(name)) {
            throw new IllegalArgumentException(new StringBuffer().append(new StringBuffer().append("the '").append(name).toString()).append("' column hasn't been defined.").toString());
        }
        Column column = this.mColumnMapping.get(name);
        column.addCustomAttribute(attribute);
        return this;
    }

    public CreateTable columns(Class beanClass) {
        return this.columnsFiltered(beanClass, null, null);
    }

    public CreateTable columnsIncluded(Class beanClass, String[] includedFields) {
        return this.columnsFiltered(beanClass, includedFields, null);
    }

    public CreateTable columnsExcluded(Class beanClass, String[] excludedFields) {
        return this.columnsFiltered(beanClass, null, excludedFields);
    }

    public CreateTable columnsFiltered(Class beanClass, String[] includedFields, String[] excludedFields) {
        ConstrainedBean constrained_bean;
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass can't be null.");
        }
        Constrained constrained = ConstrainedUtils.getConstrainedInstance(beanClass);
        if (constrained != null && (constrained_bean = (ConstrainedBean)constrained.getConstrainedBean()) != null && constrained_bean.hasUniques()) {
            Iterator<String[]> uniques_it = constrained_bean.getUniques().iterator();
            while (uniques_it.hasNext()) {
                this.unique(uniques_it.next());
            }
        }
        ConstrainedProperty constrained_property = null;
        SortedMap<String, Class> column_types = QueryHelper.getBeanPropertyTypes(beanClass, includedFields, excludedFields);
        Class column_type = null;
        Column column = null;
        for (String column_name : (Collection)column_types.keySet()) {
            if (!ConstrainedUtils.persistConstrainedProperty(constrained, column_name, null)) continue;
            column_type = (Class)column_types.get(column_name);
            column = new Column(column_name, column_type);
            this.mColumnMapping.put(column_name, column);
            if (constrained == null || (constrained_property = (ConstrainedProperty)constrained.getConstrainedProperty(column_name)) == null) continue;
            if (constrained_property.isNotNull()) {
                this.nullable(column_name, NOTNULL);
            }
            if (constrained_property.isIdentifier()) {
                this.primaryKey(column_name);
            }
            if (constrained_property.isUnique()) {
                this.unique(column_name);
            }
            if (constrained_property.isNotEmpty()) {
                if (ClassUtils.isNumeric(column_type)) {
                    this.check(new StringBuffer().append(column_name).append(" != 0").toString());
                } else if (ClassUtils.isText(column_type)) {
                    this.check(new StringBuffer().append(column_name).append(" != ''").toString());
                }
            }
            if (constrained_property.isNotEqual()) {
                if (ClassUtils.isNumeric(column_type)) {
                    this.check(new StringBuffer().append(new StringBuffer().append(column_name).append(" != ").toString()).append(constrained_property.getNotEqual()).toString());
                } else if (ClassUtils.isText(column_type)) {
                    this.check(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(column_name).append(" != '").toString()).append(StringUtils.encodeSql(constrained_property.getNotEqual().toString())).toString()).append("'").toString());
                }
            }
            if (constrained_property.hasPrecision()) {
                if (constrained_property.hasScale()) {
                    this.precision(column_name, constrained_property.getPrecision(), constrained_property.getScale());
                } else {
                    this.precision(column_name, constrained_property.getPrecision());
                }
            }
            if (constrained_property.isInList()) {
                Object[] list = (String[])constrained_property.getInList().clone();
                int i = 0;
                while (i < list.length) {
                    list[i] = StringUtils.encodeSql(list[i]);
                    ++i;
                }
                if (ClassUtils.isNumeric(column_type)) {
                    this.check(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(column_name).append(" IN (").toString()).append(StringUtils.join(list, ",")).toString()).append(")").toString());
                } else if (ClassUtils.isText(column_type)) {
                    this.check(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(column_name).append(" IN ('").toString()).append(StringUtils.join(list, "','")).toString()).append("')").toString());
                }
            }
            if (constrained_property.hasDefaultValue()) {
                this.defaultValue(column_name, constrained_property.getDefaultValue());
            }
            if (!constrained_property.hasManyToOne()) continue;
            ConstrainedProperty.ManyToOne many_to_one = constrained_property.getManyToOne();
            this.foreignKey(many_to_one.getTable(), constrained_property.getPropertyName(), many_to_one.getColumn(), many_to_one.getOnUpdate(), many_to_one.getOnDelete());
        }
        this.clearGenerated();
        return this;
    }

    public CreateTable primaryKey(String column) {
        return this.primaryKey(null, column);
    }

    public CreateTable primaryKey(String[] columns) {
        return this.primaryKey(null, columns);
    }

    public CreateTable primaryKey(String name, String column) {
        return this.primaryKey(name, new String[]{column});
    }

    public CreateTable primaryKey(String name, String[] columns) {
        if (name != null && 0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (columns == null) {
            throw new IllegalArgumentException("columns array can't be null.");
        }
        if (0 == columns.length) {
            throw new IllegalArgumentException("columns array can't be empty.");
        }
        String[] stringArray = columns;
        int n = 0;
        while (n < stringArray.length) {
            String column = stringArray[n];
            this.nullable(column, NOTNULL);
            ++n;
        }
        this.mPrimaryKeys.add(new PrimaryKey(name, columns));
        this.clearGenerated();
        return this;
    }

    public CreateTable foreignKey(String foreignTable, String localColumn, String foreignColumn) {
        return this.foreignKey(null, foreignTable, localColumn, foreignColumn, null, null);
    }

    public CreateTable foreignKey(String foreignTable, String localColumn, String foreignColumn, ViolationAction onUpdate, ViolationAction onDelete) {
        return this.foreignKey(null, foreignTable, new String[]{localColumn, foreignColumn}, onUpdate, onDelete);
    }

    public CreateTable foreignKey(String foreignTable, String[] columnsMapping) {
        return this.foreignKey(null, foreignTable, columnsMapping, null, null);
    }

    public CreateTable foreignKey(String foreignTable, String[] columnsMapping, ViolationAction onUpdate, ViolationAction onDelete) {
        return this.foreignKey(null, foreignTable, columnsMapping, onUpdate, onDelete);
    }

    public CreateTable foreignKey(String name, String foreignTable, String localColumn, String foreignColumn) {
        return this.foreignKey(name, foreignTable, localColumn, foreignColumn, null, null);
    }

    public CreateTable foreignKey(String name, String foreignTable, String localColumn, String foreignColumn, ViolationAction onUpdate, ViolationAction onDelete) {
        return this.foreignKey(name, foreignTable, new String[]{localColumn, foreignColumn}, onUpdate, onDelete);
    }

    public CreateTable foreignKey(String name, String foreignTable, String[] columnsMapping) {
        return this.foreignKey(name, foreignTable, columnsMapping, null, null);
    }

    public CreateTable foreignKey(String name, String foreignTable, String[] columnsMapping, ViolationAction onUpdate, ViolationAction onDelete) {
        if (name != null && 0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (foreignTable == null) {
            throw new IllegalArgumentException("foreignTable can't be null.");
        }
        if (0 == foreignTable.length()) {
            throw new IllegalArgumentException("foreignTable can't be empty.");
        }
        if (columnsMapping == null) {
            throw new IllegalArgumentException("columnsMapping array can't be null.");
        }
        if (0 == columnsMapping.length) {
            throw new IllegalArgumentException("columnsMapping array can't be empty.");
        }
        if (columnsMapping.length % 2 != 0) {
            throw new IllegalArgumentException("columnsMapping array isn't valid, each local column should be mapped to a foreign one.");
        }
        this.mForeignKeys.add(new ForeignKey(name, foreignTable, columnsMapping, onUpdate, onDelete));
        this.clearGenerated();
        return this;
    }

    public CreateTable unique(String column) {
        return this.unique(null, column);
    }

    public CreateTable unique(String[] columns) {
        return this.unique(null, columns);
    }

    public CreateTable unique(String name, String column) {
        return this.unique(name, new String[]{column});
    }

    public CreateTable unique(String name, String[] columns) {
        if (name != null && 0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (columns == null) {
            throw new IllegalArgumentException("columns array can't be null.");
        }
        if (0 == columns.length) {
            throw new IllegalArgumentException("columns array can't be empty.");
        }
        this.mUniqueConstraints.add(new UniqueConstraint(name, columns));
        this.clearGenerated();
        return this;
    }

    public CreateTable check(String expression) {
        return this.check(null, expression);
    }

    public CreateTable check(String name, String expression) {
        if (name != null && 0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (expression == null) {
            throw new IllegalArgumentException("expression can't be null.");
        }
        if (0 == expression.length()) {
            throw new IllegalArgumentException("expression can't be empty.");
        }
        this.mCheckConstraints.add(new CheckConstraint(name, expression));
        this.clearGenerated();
        return this;
    }

    @Override
    public CreateTable clone() {
        CreateTable new_instance = (CreateTable)super.clone();
        if (new_instance != null) {
            if (this.mColumnMapping != null) {
                new_instance.mColumnMapping = new LinkedHashMap();
                Column column = null;
                for (String name : (Collection)this.mColumnMapping.keySet()) {
                    column = this.mColumnMapping.get(name);
                    new_instance.mColumnMapping.put(name, column.clone());
                }
            }
            if (this.mPrimaryKeys != null) {
                new_instance.mPrimaryKeys = new ArrayList();
                for (PrimaryKey primary_key : (Collection)this.mPrimaryKeys) {
                    new_instance.mPrimaryKeys.add(primary_key.clone());
                }
            }
            if (this.mForeignKeys != null) {
                new_instance.mForeignKeys = new ArrayList();
                for (ForeignKey foreign_key : (Collection)this.mForeignKeys) {
                    new_instance.mForeignKeys.add(foreign_key.clone());
                }
            }
            if (this.mUniqueConstraints != null) {
                new_instance.mUniqueConstraints = new ArrayList();
                for (UniqueConstraint unique_constraint : (Collection)this.mUniqueConstraints) {
                    new_instance.mUniqueConstraints.add(unique_constraint.clone());
                }
            }
            if (this.mCheckConstraints != null) {
                new_instance.mCheckConstraints = new ArrayList();
                for (CheckConstraint check_constraint : (Collection)this.mCheckConstraints) {
                    new_instance.mCheckConstraints.add(check_constraint.clone());
                }
            }
        }
        return new_instance;
    }

    @Override
    public /* synthetic */ Object clone() {
        return this.clone();
    }

    @Override
    public /* synthetic */ AbstractQuery clone() {
        return this.clone();
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.database.queries.CreateTable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        NULL = new Nullable("NULL");
        NOTNULL = new Nullable("NOTNULL");
        NOACTION = new ViolationAction("NOACTION");
        RESTRICT = new ViolationAction("RESTRICT");
        CASCADE = new ViolationAction("CASCADE");
        SETNULL = new ViolationAction("SETNULL");
        SETDEFAULT = new ViolationAction("SETDEFAULT");
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Column
    implements Cloneable {
        private String mName = null;
        private Class mType = null;
        private int mPrecision = -1;
        private int mScale = -1;
        private String mTypeAttribute = null;
        private Nullable mNullable = null;
        private String mDefault = null;
        private ArrayList<String> mCustomAttributes = new ArrayList();
        private static /* synthetic */ boolean $assertionsDisabled;

        Column(String name, Class type) {
            this.setName(name);
            this.setType(type);
        }

        Column(String name, Class type, int precision, int scale, String typeAttribute, Nullable nullable) {
            this.setName(name);
            this.setType(type);
            this.setPrecision(precision);
            this.setScale(scale);
            this.setTypeAttribute(typeAttribute);
            this.setNullable(nullable);
        }

        String getSql(Template template2) {
            if (!$assertionsDisabled && template2 == null) {
                throw new AssertionError();
            }
            String block = null;
            String result = null;
            template2.setValue("NAME", this.getName());
            template2.setValue("TYPE", CreateTable.this.mDatasource.getSqlConversion().getSqlType(this.getType(), this.getPrecision(), this.getScale()));
            if (this.mTypeAttribute != null) {
                template2.appendValue("TYPE", " ");
                template2.appendValue("TYPE", this.mTypeAttribute);
            }
            if (this.getNullable() != null) {
                block = template2.getBlock(this.getNullable().toString());
                if (0 == block.length()) {
                    throw new UnsupportedSqlFeatureException(new StringBuffer().append("NULLABLE ").append(this.getNullable().toString()).toString(), CreateTable.this.mDatasource.getAliasedDriver());
                }
                template2.setValue("NULLABLE", block);
            }
            if (this.getDefault() != null) {
                template2.setValue("V", this.getDefault());
                block = template2.getBlock("DEFAULT");
                if (0 == block.length()) {
                    throw new UnsupportedSqlFeatureException("DEFAULT", CreateTable.this.mDatasource.getAliasedDriver());
                }
                template2.setValue("DEFAULT", block);
                template2.removeValue("V");
            }
            if (this.getCustomAttributes().size() > 0) {
                template2.setValue("V", StringUtils.join(this.getCustomAttributes(), " "));
                block = template2.getBlock("CUSTOM_ATTRIBUTES");
                if (0 == block.length()) {
                    throw new UnsupportedSqlFeatureException("CUSTOM_ATTRIBUTES", CreateTable.this.mDatasource.getAliasedDriver());
                }
                template2.setValue("CUSTOM_ATTRIBUTES", block);
                template2.removeValue("V");
            }
            if (0 == (result = template2.getBlock("COLUMN")).length()) {
                throw new UnsupportedSqlFeatureException("COLUMN", CreateTable.this.mDatasource.getAliasedDriver());
            }
            template2.removeValue("NAME");
            template2.removeValue("TYPE");
            template2.removeValue("NULLABLE");
            template2.removeValue("DEFAULT");
            template2.removeValue("CUSTOM_ATTRIBUTES");
            if (!$assertionsDisabled && result == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && result.length() <= 0) {
                throw new AssertionError();
            }
            return result;
        }

        public String getName() {
            return this.mName;
        }

        void setName(String name) {
            if (!$assertionsDisabled && name == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && name.length() <= 0) {
                throw new AssertionError();
            }
            this.mName = name;
        }

        public Class getType() {
            return this.mType;
        }

        void setType(Class type) {
            if (!$assertionsDisabled && type == null) {
                throw new AssertionError();
            }
            this.mType = type;
        }

        public int getPrecision() {
            return this.mPrecision;
        }

        void setPrecision(int precision) {
            if (!$assertionsDisabled && precision < -1) {
                throw new AssertionError();
            }
            this.mPrecision = precision;
        }

        public int getScale() {
            return this.mScale;
        }

        void setScale(int scale) {
            if (!$assertionsDisabled && scale < -1) {
                throw new AssertionError();
            }
            this.mScale = scale;
        }

        public String getTypeAttribute() {
            return this.mTypeAttribute;
        }

        void setTypeAttribute(String typeAttribute) {
            this.mTypeAttribute = typeAttribute;
        }

        public Nullable getNullable() {
            return this.mNullable;
        }

        void setNullable(Nullable nullable) {
            this.mNullable = nullable;
        }

        public String getDefault() {
            return this.mDefault;
        }

        void setDefault(String defaultStatement) {
            this.mDefault = defaultStatement;
        }

        void addCustomAttribute(String attribute) {
            if (!$assertionsDisabled && attribute == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && attribute.length() <= 0) {
                throw new AssertionError();
            }
            this.mCustomAttributes.add(attribute);
        }

        public ArrayList<String> getCustomAttributes() {
            return this.mCustomAttributes;
        }

        public Column clone() {
            Column new_instance = null;
            try {
                new_instance = (Column)super.clone();
                if (this.mCustomAttributes != null) {
                    new_instance.mCustomAttributes = new ArrayList();
                    new_instance.mCustomAttributes.addAll(this.mCustomAttributes);
                }
            }
            catch (CloneNotSupportedException e) {
                new_instance = null;
            }
            return new_instance;
        }

        public /* synthetic */ Object clone() {
            return this.clone();
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.database.queries.CreateTable$Column");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        static /* synthetic */ CreateTable access$0(Column column) {
            return column.CreateTable.this;
        }
    }

    public class PrimaryKey
    extends ColumnsConstraint
    implements Cloneable {
        private static /* synthetic */ boolean $assertionsDisabled;

        PrimaryKey(String name, String[] columns) {
            super(name, columns);
        }

        String getSql(Template template2) {
            if (!$assertionsDisabled && template2 == null) {
                throw new AssertionError();
            }
            String result = null;
            if (this.getName() != null && template2.hasValueId("PRIMARY_KEY_NAME")) {
                template2.setValue("NAME", this.getName());
                template2.setValue("PRIMARY_KEY_NAME", template2.getBlock("PRIMARY_KEY_NAME"));
            }
            template2.setValue("COLUMN_NAMES", StringUtils.join(this.getColumns(), template2.getBlock("SEPERATOR")));
            result = template2.getBlock("PRIMARY_KEY");
            if (0 == result.length()) {
                throw new UnsupportedSqlFeatureException("PRIMARY KEY", CreateTable.this.mDatasource.getAliasedDriver());
            }
            if (!$assertionsDisabled && result == null) {
                throw new AssertionError();
            }
            return result;
        }

        public PrimaryKey clone() {
            PrimaryKey new_instance = (PrimaryKey)super.clone();
            return new_instance;
        }

        public /* synthetic */ Object clone() {
            return this.clone();
        }

        public /* synthetic */ ColumnsConstraint clone() {
            return this.clone();
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.database.queries.CreateTable$PrimaryKey");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        static /* synthetic */ CreateTable access$0(PrimaryKey primaryKey) {
            return primaryKey.CreateTable.this;
        }
    }

    public class ForeignKey
    extends ColumnsConstraint
    implements Cloneable {
        private String mForeignTable;
        private ViolationAction mOnUpdate;
        private ViolationAction mOnDelete;
        private static /* synthetic */ boolean $assertionsDisabled;

        ForeignKey(String name, String foreignTable, String[] columnsMapping, ViolationAction onUpdate, ViolationAction onDelete) {
            super(name, columnsMapping);
            this.mForeignTable = null;
            this.mOnUpdate = null;
            this.mOnDelete = null;
            this.setForeignTable(foreignTable);
            this.setOnUpdate(onUpdate);
            this.setOnDelete(onDelete);
        }

        String getSql(Template template2) {
            if (!$assertionsDisabled && template2 == null) {
                throw new AssertionError();
            }
            String block = null;
            String result = null;
            if (this.getName() != null) {
                template2.setValue("NAME", this.getName());
                template2.setValue("FOREIGN_KEY_NAME", template2.getBlock("FOREIGN_KEY_NAME"));
            }
            template2.setValue("FOREIGN_TABLE", this.getForeignTable());
            String violations_actions = "";
            if (this.getOnUpdate() != null) {
                block = template2.getBlock("ON_UPDATE_" + this.getOnUpdate().toString());
                if (0 == block.length()) {
                    throw new UnsupportedSqlFeatureException("ON UPDATE " + this.getOnUpdate().toString(), CreateTable.this.mDatasource.getAliasedDriver());
                }
                template2.setValue("ON_UPDATE_ACTION", block);
                block = template2.getBlock("ON_UPDATE");
                if (0 == block.length()) {
                    throw new UnsupportedSqlFeatureException("ON UPDATE", CreateTable.this.mDatasource.getAliasedDriver());
                }
                violations_actions = violations_actions + block;
            }
            if (this.getOnDelete() != null) {
                block = template2.getBlock("ON_DELETE_" + this.getOnDelete().toString());
                if (0 == block.length()) {
                    throw new UnsupportedSqlFeatureException("ON DELETE " + this.getOnDelete().toString(), CreateTable.this.mDatasource.getAliasedDriver());
                }
                template2.setValue("ON_DELETE_ACTION", block);
                block = template2.getBlock("ON_DELETE");
                if (0 == block.length()) {
                    throw new UnsupportedSqlFeatureException("ON DELETE", CreateTable.this.mDatasource.getAliasedDriver());
                }
                violations_actions = violations_actions + block;
            }
            template2.setValue("VIOLATION_ACTIONS", violations_actions);
            Object[] local_columns = new String[this.getColumns().length / 2];
            Object[] foreign_columns = new String[this.getColumns().length / 2];
            int i = 0;
            while (i < this.getColumns().length) {
                local_columns[i / 2] = this.getColumns()[i];
                foreign_columns[i / 2] = this.getColumns()[i + 1];
                i += 2;
            }
            template2.setValue("LOCAL_COLUMN_NAMES", StringUtils.join(local_columns, template2.getBlock("SEPERATOR")));
            template2.setValue("FOREIGN_COLUMN_NAMES", StringUtils.join(foreign_columns, template2.getBlock("SEPERATOR")));
            result = template2.getBlock("FOREIGN_KEY");
            if (0 == result.length()) {
                throw new UnsupportedSqlFeatureException("FOREIGN KEY", CreateTable.this.mDatasource.getAliasedDriver());
            }
            if (!$assertionsDisabled && result == null) {
                throw new AssertionError();
            }
            return result;
        }

        public String getForeignTable() {
            return this.mForeignTable;
        }

        void setForeignTable(String foreignTable) {
            if (!$assertionsDisabled && foreignTable == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && foreignTable.length() <= 0) {
                throw new AssertionError();
            }
            this.mForeignTable = foreignTable;
        }

        public ViolationAction getOnUpdate() {
            return this.mOnUpdate;
        }

        void setOnUpdate(ViolationAction onUpdate) {
            this.mOnUpdate = onUpdate;
        }

        public ViolationAction getOnDelete() {
            return this.mOnDelete;
        }

        void setOnDelete(ViolationAction onDelete) {
            this.mOnDelete = onDelete;
        }

        public ForeignKey clone() {
            ForeignKey new_instance = (ForeignKey)super.clone();
            return new_instance;
        }

        public /* synthetic */ Object clone() {
            return this.clone();
        }

        public /* synthetic */ ColumnsConstraint clone() {
            return this.clone();
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.database.queries.CreateTable$ForeignKey");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        static /* synthetic */ CreateTable access$0(ForeignKey foreignKey) {
            return foreignKey.CreateTable.this;
        }
    }

    public class UniqueConstraint
    extends ColumnsConstraint
    implements Cloneable {
        private static /* synthetic */ boolean $assertionsDisabled;

        UniqueConstraint(String name, String[] columns) {
            super(name, columns);
        }

        String getSql(Template template2) {
            if (!$assertionsDisabled && template2 == null) {
                throw new AssertionError();
            }
            String result = null;
            if (this.getName() != null) {
                template2.setValue("NAME", this.getName());
                template2.setValue("UNIQUE_CONSTRAINT_NAME", template2.getBlock("UNIQUE_CONSTRAINT_NAME"));
            }
            template2.setValue("COLUMN_NAMES", StringUtils.join(this.getColumns(), template2.getBlock("SEPERATOR")));
            result = template2.getBlock("UNIQUE_CONSTRAINT");
            if (0 == result.length()) {
                throw new UnsupportedSqlFeatureException("UNIQUE", CreateTable.this.mDatasource.getAliasedDriver());
            }
            if (!$assertionsDisabled && result == null) {
                throw new AssertionError();
            }
            return result;
        }

        public UniqueConstraint clone() {
            UniqueConstraint new_instance = (UniqueConstraint)super.clone();
            return new_instance;
        }

        public /* synthetic */ Object clone() {
            return this.clone();
        }

        public /* synthetic */ ColumnsConstraint clone() {
            return this.clone();
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.database.queries.CreateTable$UniqueConstraint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        static /* synthetic */ CreateTable access$0(UniqueConstraint uniqueConstraint) {
            return uniqueConstraint.CreateTable.this;
        }
    }

    public class CheckConstraint
    extends Constraint
    implements Cloneable {
        private String mExpression;
        private static /* synthetic */ boolean $assertionsDisabled;

        CheckConstraint(String name, String expression) {
            super(name);
            this.mExpression = null;
            this.setExpression(expression);
        }

        String getSql(Template template2) {
            if (!$assertionsDisabled && template2 == null) {
                throw new AssertionError();
            }
            String result = null;
            if (this.getName() != null && template2.hasValueId("CHECK_NAME")) {
                template2.setValue("NAME", this.getName());
                template2.setValue("CHECK_NAME", template2.getBlock("CHECK_NAME"));
            }
            if (template2.hasValueId("EXPRESSION")) {
                template2.setValue("EXPRESSION", this.getExpression());
            }
            if (0 == (result = template2.getBlock("CHECK")).length()) {
                throw new UnsupportedSqlFeatureException("CHECK", CreateTable.this.mDatasource.getAliasedDriver());
            }
            if (!$assertionsDisabled && result == null) {
                throw new AssertionError();
            }
            return result;
        }

        public String getExpression() {
            return this.mExpression;
        }

        void setExpression(String expression) {
            this.mExpression = expression;
        }

        public CheckConstraint clone() {
            CheckConstraint new_instance = (CheckConstraint)super.clone();
            return new_instance;
        }

        public /* synthetic */ Object clone() {
            return this.clone();
        }

        public /* synthetic */ Constraint clone() {
            return this.clone();
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.database.queries.CreateTable$CheckConstraint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        static /* synthetic */ CreateTable access$0(CheckConstraint checkConstraint) {
            return checkConstraint.CreateTable.this;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Nullable
    extends EnumClass<String> {
        Nullable(String identifier) {
            super(identifier);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViolationAction
    extends EnumClass<String> {
        ViolationAction(String identifier) {
            super(identifier);
        }
    }

    public abstract class ColumnsConstraint
    extends Constraint
    implements Cloneable {
        private String[] mColumns;
        private static /* synthetic */ boolean $assertionsDisabled;

        ColumnsConstraint(String name, String[] columns) {
            super(name);
            this.mColumns = null;
            this.setColumns(columns);
        }

        public String[] getColumns() {
            return this.mColumns;
        }

        void setColumns(String[] columns) {
            if (!$assertionsDisabled && columns == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && columns.length <= 0) {
                throw new AssertionError();
            }
            this.mColumns = columns;
        }

        public ColumnsConstraint clone() {
            ColumnsConstraint new_instance = (ColumnsConstraint)super.clone();
            return new_instance;
        }

        public /* synthetic */ Object clone() {
            return this.clone();
        }

        public /* synthetic */ Constraint clone() {
            return this.clone();
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.database.queries.CreateTable$ColumnsConstraint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        static /* synthetic */ CreateTable access$0(ColumnsConstraint columnsConstraint) {
            return columnsConstraint.CreateTable.this;
        }
    }

    public abstract class Constraint
    implements Cloneable {
        private String mName = null;
        private static /* synthetic */ boolean $assertionsDisabled;

        Constraint(String name) {
            this.setName(name);
        }

        abstract String getSql(Template var1);

        public String getName() {
            return this.mName;
        }

        void setName(String name) {
            if (!$assertionsDisabled && name != null && name.length() <= 0) {
                throw new AssertionError();
            }
            this.mName = name;
        }

        public Constraint clone() {
            Constraint new_instance = null;
            try {
                new_instance = (Constraint)super.clone();
            }
            catch (CloneNotSupportedException e) {
                new_instance = null;
            }
            return new_instance;
        }

        public /* synthetic */ Object clone() {
            return this.clone();
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.database.queries.CreateTable$Constraint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        static /* synthetic */ CreateTable access$0(Constraint constraint) {
            return constraint.CreateTable.this;
        }
    }
}

