/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database.queries;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.queries.AbstractParametrizedQuery;
import com.uwyn.rife.database.queries.QueryHelper;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.database.queries.WhereGroupAnd;
import com.uwyn.rife.database.queries.WhereGroupOr;
import com.uwyn.rife.database.queries.WhereQuery;
import com.uwyn.rife.site.Constrained;
import com.uwyn.rife.site.ConstrainedUtils;
import com.uwyn.rife.tools.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWhereQuery<QueryType extends AbstractWhereQuery>
extends AbstractParametrizedQuery
implements WhereQuery<QueryType>,
Cloneable {
    protected StringBuffer mWhere = null;

    AbstractWhereQuery(Datasource datasource) {
        super(datasource);
        if (datasource == null) {
            throw new IllegalArgumentException("datasource can't be null.");
        }
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.mWhere = new StringBuffer();
    }

    public String getWhere() {
        return this.mWhere.toString();
    }

    @Override
    public QueryType whereSubselect(Select query) {
        this._whereSubselect(query);
        return (QueryType)this;
    }

    @Override
    public /* synthetic */ WhereQuery whereSubselect(Select select2) {
        return this.whereSubselect(select2);
    }

    @Override
    public QueryType where(String where) {
        if (where == null) {
            throw new IllegalArgumentException("where can't be null.");
        }
        if (0 == where.length()) {
            throw new IllegalArgumentException("where can't be empty.");
        }
        this.clearGenerated();
        this.clearWhereParameters();
        this.mWhere = new StringBuffer(where);
        return (QueryType)this;
    }

    @Override
    public /* synthetic */ WhereQuery where(String string) {
        return this.where(string);
    }

    @Override
    public QueryType whereAnd(String where) {
        if (where == null) {
            throw new IllegalArgumentException("where can't be null.");
        }
        if (0 == where.length()) {
            throw new IllegalArgumentException("where can't be empty.");
        }
        if (0 == this.mWhere.length()) {
            throw new IllegalArgumentException("can't perform whereAnd as initial where operation.");
        }
        this.clearGenerated();
        StringBuffer stringBuffer = this.mWhere;
        synchronized (stringBuffer) {
            this.mWhere.append(" AND ");
            this.mWhere.append(where);
        }
        return (QueryType)this;
    }

    @Override
    public /* synthetic */ WhereQuery whereAnd(String string) {
        return this.whereAnd(string);
    }

    @Override
    public WhereGroupAnd<QueryType> startWhereAnd() {
        return new WhereGroupAnd(this.getDatasource(), this);
    }

    @Override
    public QueryType whereOr(String where) {
        if (where == null) {
            throw new IllegalArgumentException("where can't be null.");
        }
        if (0 == where.length()) {
            throw new IllegalArgumentException("where can't be empty.");
        }
        if (0 == this.mWhere.length()) {
            throw new IllegalArgumentException("can't perform whereOr as initial where operation.");
        }
        this.clearGenerated();
        StringBuffer stringBuffer = this.mWhere;
        synchronized (stringBuffer) {
            this.mWhere.append(" OR ");
            this.mWhere.append(where);
        }
        return (QueryType)this;
    }

    @Override
    public /* synthetic */ WhereQuery whereOr(String string) {
        return this.whereOr(string);
    }

    @Override
    public WhereGroupOr<QueryType> startWhereOr() {
        return new WhereGroupOr(this.getDatasource(), this);
    }

    @Override
    public QueryType where(String field, String operator, char value) {
        return (QueryType)((AbstractWhereQuery)this.where(field, operator, new Character(value)));
    }

    @Override
    public /* synthetic */ WhereQuery where(String string, String string2, char c) {
        return this.where(string, string2, c);
    }

    @Override
    public QueryType where(String field, String operator, boolean value) {
        return (QueryType)((AbstractWhereQuery)this.where(field, operator, new Boolean(value)));
    }

    @Override
    public /* synthetic */ WhereQuery where(String string, String string2, boolean bl) {
        return this.where(string, string2, bl);
    }

    @Override
    public QueryType where(String field, String operator, byte value) {
        return (QueryType)((AbstractWhereQuery)this.where(field, operator, new Byte(value)));
    }

    @Override
    public /* synthetic */ WhereQuery where(String string, String string2, byte by) {
        return this.where(string, string2, by);
    }

    @Override
    public QueryType where(String field, String operator, double value) {
        return (QueryType)((AbstractWhereQuery)this.where(field, operator, new Double(value)));
    }

    @Override
    public /* synthetic */ WhereQuery where(String string, String string2, double d) {
        return this.where(string, string2, d);
    }

    @Override
    public QueryType where(String field, String operator, float value) {
        return (QueryType)((AbstractWhereQuery)this.where(field, operator, new Float(value)));
    }

    @Override
    public /* synthetic */ WhereQuery where(String string, String string2, float f) {
        return this.where(string, string2, f);
    }

    @Override
    public QueryType where(String field, String operator, int value) {
        return (QueryType)((AbstractWhereQuery)this.where(field, operator, new Integer(value)));
    }

    @Override
    public /* synthetic */ WhereQuery where(String string, String string2, int n) {
        return this.where(string, string2, n);
    }

    @Override
    public QueryType where(String field, String operator, long value) {
        return (QueryType)((AbstractWhereQuery)this.where(field, operator, new Long(value)));
    }

    @Override
    public /* synthetic */ WhereQuery where(String string, String string2, long l) {
        return this.where(string, string2, l);
    }

    @Override
    public QueryType where(String field, String operator, short value) {
        return (QueryType)((AbstractWhereQuery)this.where(field, operator, new Short(value)));
    }

    @Override
    public /* synthetic */ WhereQuery where(String string, String string2, short s) {
        return this.where(string, string2, s);
    }

    @Override
    public QueryType where(String field, String operator, Select query) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        StringBuffer stringBuffer = this.mWhere;
        synchronized (stringBuffer) {
            this.mWhere.append(field);
            this.mWhere.append(" ");
            this.mWhere.append(operator);
            this.mWhere.append(" ");
            this.mWhere.append("(");
            this.mWhere.append(query.toString());
            this.mWhere.append(")");
        }
        this.whereSubselect(query);
        return (QueryType)this;
    }

    @Override
    public /* synthetic */ WhereQuery where(String string, String string2, Select select2) {
        return this.where(string, string2, select2);
    }

    @Override
    public QueryType where(String field, String operator, Object value) {
        if (field == null) {
            throw new IllegalArgumentException("field can't be null.");
        }
        if (0 == field.length()) {
            throw new IllegalArgumentException("field can't be empty.");
        }
        if (operator == null) {
            throw new IllegalArgumentException("operator can't be null.");
        }
        if (0 == operator.length()) {
            throw new IllegalArgumentException("operator can't be empty.");
        }
        this.clearGenerated();
        this.clearWhereParameters();
        StringBuffer stringBuffer = this.mWhere = new StringBuffer();
        synchronized (stringBuffer) {
            this._where(field, operator, value);
        }
        return (QueryType)this;
    }

    @Override
    public /* synthetic */ WhereQuery where(String string, String string2, Object object) {
        return this.where(string, string2, object);
    }

    @Override
    public QueryType whereAnd(String field, String operator, char value) {
        return (QueryType)((AbstractWhereQuery)this.whereAnd(field, operator, new Character(value)));
    }

    @Override
    public /* synthetic */ WhereQuery whereAnd(String string, String string2, char c) {
        return this.whereAnd(string, string2, c);
    }

    @Override
    public QueryType whereAnd(String field, String operator, boolean value) {
        return (QueryType)((AbstractWhereQuery)this.whereAnd(field, operator, new Boolean(value)));
    }

    @Override
    public /* synthetic */ WhereQuery whereAnd(String string, String string2, boolean bl) {
        return this.whereAnd(string, string2, bl);
    }

    @Override
    public QueryType whereAnd(String field, String operator, byte value) {
        return (QueryType)((AbstractWhereQuery)this.whereAnd(field, operator, new Byte(value)));
    }

    @Override
    public /* synthetic */ WhereQuery whereAnd(String string, String string2, byte by) {
        return this.whereAnd(string, string2, by);
    }

    @Override
    public QueryType whereAnd(String field, String operator, double value) {
        return (QueryType)((AbstractWhereQuery)this.whereAnd(field, operator, new Double(value)));
    }

    @Override
    public /* synthetic */ WhereQuery whereAnd(String string, String string2, double d) {
        return this.whereAnd(string, string2, d);
    }

    @Override
    public QueryType whereAnd(String field, String operator, float value) {
        return (QueryType)((AbstractWhereQuery)this.whereAnd(field, operator, new Float(value)));
    }

    @Override
    public /* synthetic */ WhereQuery whereAnd(String string, String string2, float f) {
        return this.whereAnd(string, string2, f);
    }

    @Override
    public QueryType whereAnd(String field, String operator, int value) {
        return (QueryType)((AbstractWhereQuery)this.whereAnd(field, operator, new Integer(value)));
    }

    @Override
    public /* synthetic */ WhereQuery whereAnd(String string, String string2, int n) {
        return this.whereAnd(string, string2, n);
    }

    @Override
    public QueryType whereAnd(String field, String operator, long value) {
        return (QueryType)((AbstractWhereQuery)this.whereAnd(field, operator, new Long(value)));
    }

    @Override
    public /* synthetic */ WhereQuery whereAnd(String string, String string2, long l) {
        return this.whereAnd(string, string2, l);
    }

    @Override
    public QueryType whereAnd(String field, String operator, short value) {
        return (QueryType)((AbstractWhereQuery)this.whereAnd(field, operator, new Short(value)));
    }

    @Override
    public /* synthetic */ WhereQuery whereAnd(String string, String string2, short s) {
        return this.whereAnd(string, string2, s);
    }

    @Override
    public QueryType whereAnd(String field, String operator, Select query) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        StringBuffer stringBuffer = this.mWhere;
        synchronized (stringBuffer) {
            this.mWhere.append(" AND ");
            this.mWhere.append(field);
            this.mWhere.append(" ");
            this.mWhere.append(operator);
            this.mWhere.append(" ");
            this.mWhere.append("(");
            this.mWhere.append(query.toString());
            this.mWhere.append(")");
        }
        this.whereSubselect(query);
        return (QueryType)this;
    }

    @Override
    public /* synthetic */ WhereQuery whereAnd(String string, String string2, Select select2) {
        return this.whereAnd(string, string2, select2);
    }

    @Override
    public QueryType whereAnd(String field, String operator, Object value) {
        if (field == null) {
            throw new IllegalArgumentException("field can't be null.");
        }
        if (0 == field.length()) {
            throw new IllegalArgumentException("field can't be empty.");
        }
        if (operator == null) {
            throw new IllegalArgumentException("operator can't be null.");
        }
        if (0 == operator.length()) {
            throw new IllegalArgumentException("operator can't be empty.");
        }
        this.clearGenerated();
        StringBuffer stringBuffer = this.mWhere;
        synchronized (stringBuffer) {
            this.mWhere.append(" AND ");
            this._where(field, operator, value);
        }
        return (QueryType)this;
    }

    @Override
    public /* synthetic */ WhereQuery whereAnd(String string, String string2, Object object) {
        return this.whereAnd(string, string2, object);
    }

    @Override
    public QueryType whereOr(String field, String operator, char value) {
        return (QueryType)((AbstractWhereQuery)this.whereOr(field, operator, new Character(value)));
    }

    @Override
    public /* synthetic */ WhereQuery whereOr(String string, String string2, char c) {
        return this.whereOr(string, string2, c);
    }

    @Override
    public QueryType whereOr(String field, String operator, boolean value) {
        return (QueryType)((AbstractWhereQuery)this.whereOr(field, operator, new Boolean(value)));
    }

    @Override
    public /* synthetic */ WhereQuery whereOr(String string, String string2, boolean bl) {
        return this.whereOr(string, string2, bl);
    }

    @Override
    public QueryType whereOr(String field, String operator, byte value) {
        return (QueryType)((AbstractWhereQuery)this.whereOr(field, operator, new Byte(value)));
    }

    @Override
    public /* synthetic */ WhereQuery whereOr(String string, String string2, byte by) {
        return this.whereOr(string, string2, by);
    }

    @Override
    public QueryType whereOr(String field, String operator, double value) {
        return (QueryType)((AbstractWhereQuery)this.whereOr(field, operator, new Double(value)));
    }

    @Override
    public /* synthetic */ WhereQuery whereOr(String string, String string2, double d) {
        return this.whereOr(string, string2, d);
    }

    @Override
    public QueryType whereOr(String field, String operator, float value) {
        return (QueryType)((AbstractWhereQuery)this.whereOr(field, operator, new Float(value)));
    }

    @Override
    public /* synthetic */ WhereQuery whereOr(String string, String string2, float f) {
        return this.whereOr(string, string2, f);
    }

    @Override
    public QueryType whereOr(String field, String operator, int value) {
        return (QueryType)((AbstractWhereQuery)this.whereOr(field, operator, new Integer(value)));
    }

    @Override
    public /* synthetic */ WhereQuery whereOr(String string, String string2, int n) {
        return this.whereOr(string, string2, n);
    }

    @Override
    public QueryType whereOr(String field, String operator, long value) {
        return (QueryType)((AbstractWhereQuery)this.whereOr(field, operator, new Long(value)));
    }

    @Override
    public /* synthetic */ WhereQuery whereOr(String string, String string2, long l) {
        return this.whereOr(string, string2, l);
    }

    @Override
    public QueryType whereOr(String field, String operator, short value) {
        return (QueryType)((AbstractWhereQuery)this.whereOr(field, operator, new Short(value)));
    }

    @Override
    public /* synthetic */ WhereQuery whereOr(String string, String string2, short s) {
        return this.whereOr(string, string2, s);
    }

    @Override
    public QueryType whereOr(String field, String operator, Select query) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        StringBuffer stringBuffer = this.mWhere;
        synchronized (stringBuffer) {
            this.mWhere.append(" OR ");
            this.mWhere.append(field);
            this.mWhere.append(" ");
            this.mWhere.append(operator);
            this.mWhere.append(" ");
            this.mWhere.append("(");
            this.mWhere.append(query.toString());
            this.mWhere.append(")");
        }
        this.whereSubselect(query);
        return (QueryType)this;
    }

    @Override
    public /* synthetic */ WhereQuery whereOr(String string, String string2, Select select2) {
        return this.whereOr(string, string2, select2);
    }

    @Override
    public QueryType whereOr(String field, String operator, Object value) {
        if (field == null) {
            throw new IllegalArgumentException("field can't be null.");
        }
        if (0 == field.length()) {
            throw new IllegalArgumentException("field can't be empty.");
        }
        if (operator == null) {
            throw new IllegalArgumentException("operator can't be null.");
        }
        if (0 == operator.length()) {
            throw new IllegalArgumentException("operator can't be empty.");
        }
        this.clearGenerated();
        StringBuffer stringBuffer = this.mWhere;
        synchronized (stringBuffer) {
            this.mWhere.append(" OR ");
            this._where(field, operator, value);
        }
        return (QueryType)this;
    }

    @Override
    public /* synthetic */ WhereQuery whereOr(String string, String string2, Object object) {
        return this.whereOr(string, string2, object);
    }

    private void _where(String field, String operator, Object value) {
        this.mWhere.append(field);
        this.mWhere.append(" ");
        this.mWhere.append(operator);
        this.mWhere.append(" ");
        this.mWhere.append(this.mDatasource.getSqlConversion().getSqlValue(value));
    }

    public QueryType whereParameter(String field, String operator) {
        return (QueryType)((AbstractWhereQuery)this.whereParameter(field, field, operator));
    }

    public QueryType whereParameter(String field, String alias, String operator) {
        if (field == null) {
            throw new IllegalArgumentException("field can't be null.");
        }
        if (0 == field.length()) {
            throw new IllegalArgumentException("field can't be empty.");
        }
        if (alias == null) {
            throw new IllegalArgumentException("alias can't be null.");
        }
        if (0 == alias.length()) {
            throw new IllegalArgumentException("alias can't be empty.");
        }
        if (operator == null) {
            throw new IllegalArgumentException("operator can't be null.");
        }
        if (0 == operator.length()) {
            throw new IllegalArgumentException("operator can't be empty.");
        }
        this.clearGenerated();
        this.clearWhereParameters();
        StringBuffer stringBuffer = this.mWhere = new StringBuffer(field);
        synchronized (stringBuffer) {
            this.mWhere.append(" ");
            this.mWhere.append(operator);
            this.mWhere.append(" ?");
        }
        this.addWhereParameter(alias);
        return (QueryType)this;
    }

    public QueryType whereParameterAnd(String field, String operator) {
        return (QueryType)((AbstractWhereQuery)this.whereParameterAnd(field, field, operator));
    }

    public QueryType whereParameterAnd(String field, String alias, String operator) {
        if (field == null) {
            throw new IllegalArgumentException("field can't be null.");
        }
        if (0 == field.length()) {
            throw new IllegalArgumentException("field can't be empty.");
        }
        if (alias == null) {
            throw new IllegalArgumentException("alias can't be null.");
        }
        if (0 == alias.length()) {
            throw new IllegalArgumentException("alias can't be empty.");
        }
        if (operator == null) {
            throw new IllegalArgumentException("operator can't be null.");
        }
        if (0 == operator.length()) {
            throw new IllegalArgumentException("operator can't be empty.");
        }
        if (0 == this.mWhere.length()) {
            throw new IllegalArgumentException("can't perform whereParameterAnd as initial where operation.");
        }
        this.clearGenerated();
        StringBuffer stringBuffer = this.mWhere;
        synchronized (stringBuffer) {
            this.mWhere.append(" AND ");
            this.mWhere.append(field);
            this.mWhere.append(" ");
            this.mWhere.append(operator);
            this.mWhere.append(" ?");
        }
        this.addWhereParameter(alias);
        return (QueryType)this;
    }

    public QueryType whereParameterOr(String field, String operator) {
        return (QueryType)((AbstractWhereQuery)this.whereParameterOr(field, field, operator));
    }

    public QueryType whereParameterOr(String field, String alias, String operator) {
        if (field == null) {
            throw new IllegalArgumentException("field can't be null.");
        }
        if (0 == field.length()) {
            throw new IllegalArgumentException("field can't be empty.");
        }
        if (alias == null) {
            throw new IllegalArgumentException("alias can't be null.");
        }
        if (0 == alias.length()) {
            throw new IllegalArgumentException("alias can't be empty.");
        }
        if (operator == null) {
            throw new IllegalArgumentException("operator can't be null.");
        }
        if (0 == operator.length()) {
            throw new IllegalArgumentException("operator can't be empty.");
        }
        if (0 == this.mWhere.length()) {
            throw new IllegalArgumentException("can't perform whereParameterOr as initial where operation.");
        }
        this.clearGenerated();
        StringBuffer stringBuffer = this.mWhere;
        synchronized (stringBuffer) {
            this.mWhere.append(" OR ");
            this.mWhere.append(field);
            this.mWhere.append(" ");
            this.mWhere.append(operator);
            this.mWhere.append(" ?");
        }
        this.addWhereParameter(alias);
        return (QueryType)this;
    }

    @Override
    public QueryType where(Object bean) {
        return (QueryType)((AbstractWhereQuery)this.whereFiltered(bean, null, null));
    }

    @Override
    public /* synthetic */ WhereQuery where(Object object) {
        return this.where(object);
    }

    @Override
    public QueryType whereIncluded(Object bean, String[] includedFields) {
        return (QueryType)((AbstractWhereQuery)this.whereFiltered(bean, includedFields, null));
    }

    @Override
    public /* synthetic */ WhereQuery whereIncluded(Object object, String[] stringArray) {
        return this.whereIncluded(object, stringArray);
    }

    @Override
    public QueryType whereExcluded(Object bean, String[] excludedFields) {
        return (QueryType)((AbstractWhereQuery)this.whereFiltered(bean, null, excludedFields));
    }

    @Override
    public /* synthetic */ WhereQuery whereExcluded(Object object, String[] stringArray) {
        return this.whereExcluded(object, stringArray);
    }

    @Override
    public QueryType whereFiltered(Object bean, String[] includedFields, String[] excludedFields) {
        if (bean == null) {
            throw new IllegalArgumentException("bean can't be null.");
        }
        Constrained constrained = ConstrainedUtils.makeConstrainedInstance(bean);
        ArrayList<String> where_parts = new ArrayList<String>();
        Map<String, String> property_values = QueryHelper.getBeanPropertyValues(bean, includedFields, excludedFields, this.getDatasource());
        for (String property_name : (Collection)property_values.keySet()) {
            if (!ConstrainedUtils.persistConstrainedProperty(constrained, property_name, null)) continue;
            where_parts.add(new StringBuffer().append(new StringBuffer().append(property_name).append(" = ").toString()).append(property_values.get(property_name)).toString());
        }
        this.where(StringUtils.join(where_parts, " AND "));
        return (QueryType)this;
    }

    @Override
    public /* synthetic */ WhereQuery whereFiltered(Object object, String[] stringArray, String[] stringArray2) {
        return this.whereFiltered(object, stringArray, stringArray2);
    }

    public QueryType whereParameters(Class beanClass) {
        return (QueryType)((AbstractWhereQuery)this.whereParametersExcluded(beanClass, null));
    }

    public QueryType whereParametersExcluded(Class beanClass, String[] excludedFields) {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass can't be null.");
        }
        this.clearGenerated();
        Constrained constrained = ConstrainedUtils.getConstrainedInstance(beanClass);
        SortedSet<String> property_names = QueryHelper.getBeanPropertyNames(beanClass, excludedFields);
        for (String property_name : (Collection)property_names) {
            if (!ConstrainedUtils.persistConstrainedProperty(constrained, property_name, null)) continue;
            if (this.getWhereParameters() == null) {
                this.whereParameter(property_name, "=");
                continue;
            }
            this.whereParameterAnd(property_name, "=");
        }
        return (QueryType)this;
    }

    public QueryType clone() {
        AbstractWhereQuery new_instance = (AbstractWhereQuery)super.clone();
        if (new_instance != null && this.mWhere != null) {
            new_instance.mWhere = new StringBuffer(this.mWhere.toString());
        }
        return (QueryType)new_instance;
    }

    @Override
    public /* synthetic */ Object clone() {
        return this.clone();
    }

    @Override
    public /* synthetic */ AbstractParametrizedQuery clone() {
        return this.clone();
    }
}

