/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database.exceptions;

import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.exceptions.DatabaseException;

public class UndefinedVirtualParameterException
extends DatabaseException {
    private DbPreparedStatement mPreparedStatement = null;
    private String mParameterName = null;
    private int mParameterIndex = -1;

    public UndefinedVirtualParameterException(DbPreparedStatement statement, String parameterName) {
        super("The statement with sql '" + statement.getSql() + "' requires the definition of a value for the virtual parameter with name '" + parameterName + "'.");
        this.mPreparedStatement = statement;
        this.mParameterName = parameterName;
    }

    public UndefinedVirtualParameterException(DbPreparedStatement statement, int parameterIndex) {
        super("The statement with sql '" + statement.getSql() + "' requires the definition of a value for the virtual parameter with index '" + parameterIndex + "'.");
        this.mPreparedStatement = statement;
        this.mParameterIndex = parameterIndex;
    }

    public DbPreparedStatement getPreparedStatement() {
        return this.mPreparedStatement;
    }

    public String getParameterName() {
        return this.mParameterName;
    }

    public int getParameterIndex() {
        return this.mParameterIndex;
    }
}

