/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database.capabilities;

import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbResultSet;
import com.uwyn.rife.database.VirtualParameters;
import com.uwyn.rife.database.VirtualParametersHandler;
import com.uwyn.rife.database.capabilities.Capabilities;
import com.uwyn.rife.database.capabilities.Capability;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.Query;
import com.uwyn.rife.database.queries.QueryParameterType;
import com.uwyn.rife.database.queries.QueryParameters;
import java.sql.SQLException;

public class LimitOffsetCompensator
implements VirtualParametersHandler {
    private boolean mUseRelativeForScrolling = false;

    public void setUseRelativeForScrolling(boolean useRelativeForCursors) {
        this.mUseRelativeForScrolling = useRelativeForCursors;
    }

    public void handleCapablePreparedStatement(DbPreparedStatement statement) {
        Capabilities capabilities;
        Query query = statement.getQuery();
        if (query != null && (capabilities = query.getCapabilities()) != null) {
            QueryParameters parameters;
            if (capabilities.containsKey(Capability.LIMIT)) {
                int max_rows = 0;
                int limit = (Integer)capabilities.get(Capability.LIMIT);
                statement.setFetchSize(limit);
                max_rows += limit;
                if (capabilities.containsKey(Capability.OFFSET)) {
                    max_rows += ((Integer)capabilities.get(Capability.OFFSET)).intValue();
                }
                if (max_rows != 0) {
                    statement.setMaxRows(max_rows);
                }
            } else if (capabilities.containsKey(Capability.LIMIT_PARAMETER) && (parameters = query.getParameters()) != null) {
                QueryParameters virtual_query_parameters = parameters.getNewInstance();
                virtual_query_parameters.addTypedParameter(QueryParameterType.LIMIT, (String)capabilities.get(Capability.LIMIT_PARAMETER));
                if (capabilities.containsKey(Capability.OFFSET_PARAMETER)) {
                    virtual_query_parameters.addTypedParameter(QueryParameterType.OFFSET, (String)capabilities.get(Capability.OFFSET_PARAMETER));
                }
                VirtualParameters virtual_parameters = new VirtualParameters(virtual_query_parameters, this);
                statement.setVirtualParameters(virtual_parameters);
            }
        }
    }

    public void handleValues(DbPreparedStatement statement) {
        Capabilities capabilities;
        Query query = statement.getQuery();
        if (query != null && (capabilities = query.getCapabilities()) != null && capabilities.containsKey(Capability.LIMIT_PARAMETER)) {
            int max_rows = 0;
            String limit_parameter_name = (String)capabilities.get(Capability.LIMIT_PARAMETER);
            int limit = Integer.parseInt(String.valueOf(statement.getVirtualParameterValue(limit_parameter_name)));
            statement.setFetchSize(limit);
            max_rows += limit;
            if (capabilities.containsKey(Capability.OFFSET_PARAMETER)) {
                String offset_parameter_name = (String)capabilities.get(Capability.OFFSET_PARAMETER);
                int offset = Integer.parseInt(String.valueOf(statement.getVirtualParameterValue(offset_parameter_name)));
                max_rows += offset;
            }
            if (max_rows != 0) {
                statement.setMaxRows(max_rows);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleCapableResultSet(DbPreparedStatement statement) {
        DbResultSet resultset = statement.getResultSet();
        Capabilities capabilities = statement.getQuery().getCapabilities();
        if (capabilities == null) return;
        if (!capabilities.containsKey(Capability.LIMIT)) {
            if (!capabilities.containsKey(Capability.LIMIT_PARAMETER)) return;
        }
        int offset = -1;
        if (capabilities.containsKey(Capability.OFFSET)) {
            offset = (Integer)capabilities.get(Capability.OFFSET);
        } else if (capabilities.containsKey(Capability.OFFSET_PARAMETER)) {
            String parameter_name = (String)capabilities.get(Capability.OFFSET_PARAMETER);
            offset = Integer.parseInt(String.valueOf(statement.getVirtualParameterValue(parameter_name)));
        }
        if (offset <= 0) return;
        try {
            if (this.mUseRelativeForScrolling) {
                resultset.relative(offset);
                return;
            }
            while (true) {
                if (offset <= 0) {
                    return;
                }
                resultset.next();
                --offset;
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }
}

