/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database;

import com.uwyn.rife.config.Config;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.xml.Xml2Data;
import com.uwyn.rife.xml.exceptions.XmlErrorException;
import java.util.HashMap;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xml2Datasources
extends Xml2Data {
    private Datasource mDatasource = null;
    private HashMap<String, Datasource> mDatasources = null;
    private String mNameAttribute = null;
    private StringBuffer mCharacterData = null;

    public HashMap<String, Datasource> getDatasources() {
        return this.mDatasources;
    }

    protected void clear() {
        this.mDatasource = null;
        this.mDatasources = new HashMap();
        this.mNameAttribute = null;
        this.mCharacterData = null;
    }

    @Override
    public void startDocument() {
        this.clear();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (qName.equals("datasource")) {
            this.mNameAttribute = atts.getValue("name");
            this.mDatasource = new Datasource();
        } else if (qName.equals("driver") || qName.equals("url") || qName.equals("user") || qName.equals("password") || qName.equals("poolsize")) {
            this.mCharacterData = new StringBuffer();
        } else if (qName.equals("config")) {
            if (this.mCharacterData != null && Config.hasRepInstance()) {
                this.mCharacterData.append(Config.getRepInstance().getString(atts.getValue("param"), ""));
            }
        } else if (!qName.equals("datasources")) {
            throw new XmlErrorException(new StringBuffer().append(new StringBuffer().append("Unsupport element name '").append(qName).toString()).append("'.").toString());
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (qName.equals("datasource")) {
            this.mDatasources.put(this.mNameAttribute, this.mDatasource);
        } else if (qName.equals("driver")) {
            this.mDatasource.setDriver(this.mCharacterData.toString());
        } else if (qName.equals("url")) {
            this.mDatasource.setUrl(this.mCharacterData.toString());
        } else if (qName.equals("user")) {
            this.mDatasource.setUser(this.mCharacterData.toString());
        } else if (qName.equals("password")) {
            this.mDatasource.setPassword(this.mCharacterData.toString());
        } else if (qName.equals("poolsize")) {
            try {
                this.mDatasource.setPoolsize(Integer.parseInt(this.mCharacterData.toString()));
            }
            catch (NumberFormatException e) {
                throw new XmlErrorException("The value of the poolsize isn't an integer.", e);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (length > 0) {
            this.mCharacterData.append(String.copyValueOf(ch, start, length));
        }
    }
}

