/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database;

import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.VirtualParametersHandler;
import com.uwyn.rife.database.queries.Query;
import com.uwyn.rife.database.queries.QueryParameters;
import com.uwyn.rife.pcj.map.IntKeyIntMap;
import com.uwyn.rife.pcj.map.IntKeyMap;
import com.uwyn.rife.pcj.map.IntKeyOpenHashMap;

public class VirtualParameters {
    private QueryParameters mParameters = null;
    private IntKeyIntMap mIndexMapping = null;
    private IntKeyMap mValues = null;
    private VirtualParametersHandler mHandler = null;

    public VirtualParameters(QueryParameters parameters, VirtualParametersHandler handler) {
        if (parameters == null) {
            throw new IllegalArgumentException("parameters can't be null.");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler can't be null.");
        }
        this.mParameters = parameters;
        this.mHandler = handler;
    }

    public void callHandler(DbPreparedStatement statement) {
        this.mHandler.handleValues(statement);
    }

    void setup(Query query) {
        this.mIndexMapping = query.getParameters().getVirtualIndexMapping(this.mParameters);
    }

    Object getValue(int index) {
        if (this.mValues == null) {
            return null;
        }
        return this.mValues.get(index);
    }

    boolean hasValue(int index) {
        if (this.mValues == null) {
            return false;
        }
        return this.mValues.containsKey(index);
    }

    boolean hasParameter(int index) {
        if (this.mIndexMapping == null) {
            return false;
        }
        return this.mIndexMapping.containsKey(index);
    }

    int getRealIndex(int index) {
        if (this.mIndexMapping == null) {
            return -1;
        }
        return this.mIndexMapping.get(index);
    }

    void putValue(int index, Object value) {
        if (this.mValues == null) {
            this.mValues = new IntKeyOpenHashMap();
        }
        this.mValues.put(index, value);
    }
}

