/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.database.DbConnection;
import com.uwyn.rife.database.DbResultSet;
import com.uwyn.rife.database.exceptions.BatchExecutionErrorException;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.exceptions.ExecutionErrorException;
import com.uwyn.rife.database.exceptions.MissingResultsException;
import com.uwyn.rife.database.exceptions.StatementCloseErrorException;
import com.uwyn.rife.database.queries.Query;
import com.uwyn.rife.database.queries.ReadQuery;
import com.uwyn.rife.tools.ExceptionUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DbStatement
implements Cloneable {
    private DbResultSet mResultSet = null;
    Statement mStatement = null;
    DbConnection mConnection = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    DbStatement(DbConnection connection, Statement statement) {
        if (!$assertionsDisabled && connection == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && statement == null) {
            throw new AssertionError();
        }
        this.mConnection = connection;
        this.mStatement = statement;
    }

    public void addBatch(String sql) {
        try {
            this.mStatement.addBatch(sql);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public void cancel() {
        try {
            this.mStatement.cancel();
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public void clearBatch() {
        try {
            this.mStatement.clearBatch();
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public void clearWarnings() {
        try {
            this.mStatement.clearWarnings();
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public void close() {
        try {
            this.mConnection.releaseStatement(this);
            this.cleanResultSet();
            this.mStatement.close();
        }
        catch (SQLException e) {
            throw new StatementCloseErrorException(this.mConnection.getDatasource(), (Throwable)e);
        }
    }

    protected long startTrace() {
        Logger logger = Logger.getLogger("com.uwyn.rife.database");
        if (logger.isLoggable(Level.INFO) && RifeConfig.Database.getSqlDebugTrace()) {
            return System.currentTimeMillis();
        }
        return 0;
    }

    protected void outputTrace(long start, String sql) {
        if (start != (long)0) {
            StringBuffer output;
            StringBuffer stringBuffer = output = new StringBuffer();
            synchronized (stringBuffer) {
                output.append(System.currentTimeMillis() - start);
                output.append("ms : ");
                output.append(sql);
                Logger.getLogger("com.uwyn.rife.database").info(output.toString());
            }
        }
    }

    public boolean execute(String sql) {
        try {
            this.waitForConnection();
            this.cleanResultSet();
            long start = this.startTrace();
            boolean result = this.mStatement.execute(sql);
            this.outputTrace(start, sql);
            this.setResultset(this.mStatement.getResultSet());
            return result;
        }
        catch (SQLException e) {
            this.handleException();
            throw new ExecutionErrorException(sql, this.mConnection.getDatasource(), e);
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) {
        try {
            this.waitForConnection();
            this.cleanResultSet();
            long start = this.startTrace();
            boolean result = this.mStatement.execute(sql, autoGeneratedKeys);
            this.outputTrace(start, sql);
            this.setResultset(this.mStatement.getResultSet());
            return result;
        }
        catch (SQLException e) {
            this.handleException();
            throw new ExecutionErrorException(sql, this.mConnection.getDatasource(), e);
        }
    }

    public boolean execute(String sql, int[] columnIndexes) {
        try {
            this.waitForConnection();
            this.cleanResultSet();
            long start = this.startTrace();
            boolean result = this.mStatement.execute(sql, columnIndexes);
            this.outputTrace(start, sql);
            this.setResultset(this.mStatement.getResultSet());
            return result;
        }
        catch (SQLException e) {
            this.handleException();
            throw new ExecutionErrorException(sql, this.mConnection.getDatasource(), e);
        }
    }

    public boolean execute(String sql, String[] columnNames) {
        try {
            this.waitForConnection();
            this.cleanResultSet();
            long start = this.startTrace();
            boolean result = this.mStatement.execute(sql, columnNames);
            this.outputTrace(start, sql);
            this.setResultset(this.mStatement.getResultSet());
            return result;
        }
        catch (SQLException e) {
            this.handleException();
            throw new ExecutionErrorException(sql, this.mConnection.getDatasource(), e);
        }
    }

    public int[] executeBatch() {
        try {
            this.waitForConnection();
            return this.mStatement.executeBatch();
        }
        catch (SQLException e) {
            this.handleException();
            throw new BatchExecutionErrorException(this.mConnection.getDatasource(), (Throwable)e);
        }
    }

    public void executeQuery(String sql) {
        try {
            this.waitForConnection();
            this.cleanResultSet();
            long start = this.startTrace();
            boolean result = this.mStatement.execute(sql);
            this.outputTrace(start, sql);
            this.setResultset(this.mStatement.getResultSet());
            return;
        }
        catch (SQLException e) {
            this.handleException();
            throw new ExecutionErrorException(sql, this.mConnection.getDatasource(), e);
        }
    }

    public void executeQuery(ReadQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        this.executeQuery(query.getSql());
    }

    public int executeUpdate(String sql) {
        try {
            this.waitForConnection();
            long start = this.startTrace();
            int result = this.mStatement.executeUpdate(sql);
            this.outputTrace(start, sql);
            return result;
        }
        catch (SQLException e) {
            this.handleException();
            throw new ExecutionErrorException(sql, this.mConnection.getDatasource(), e);
        }
    }

    public int executeUpdate(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        return this.executeUpdate(query.getSql());
    }

    public int getFetchDirection() {
        try {
            return this.mStatement.getFetchDirection();
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public int getFetchSize() {
        try {
            return this.mStatement.getFetchSize();
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public DbResultSet getGeneratedKeys() {
        try {
            return new DbResultSet(this, this.mStatement.getGeneratedKeys());
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public int getFirstGeneratedIntKey() {
        try {
            DbResultSet resultset = this.getGeneratedKeys();
            resultset.next();
            return resultset.getInt(1);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public int getMaxFieldSize() {
        try {
            return this.mStatement.getMaxFieldSize();
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public int getMaxRows() {
        try {
            return this.mStatement.getMaxRows();
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public boolean getMoreResults() {
        try {
            this.cleanResultSet();
            boolean result = this.mStatement.getMoreResults();
            this.setResultset(this.mStatement.getResultSet());
            return result;
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public boolean getMoreResults(int current) {
        try {
            this.cleanResultSet();
            boolean result = this.mStatement.getMoreResults(current);
            this.setResultset(this.mStatement.getResultSet());
            return result;
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public int getQueryTimeout() {
        try {
            return this.mStatement.getQueryTimeout();
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public boolean wasNull() {
        if (this.mResultSet == null) {
            throw new MissingResultsException(this.getConnection().getDatasource());
        }
        try {
            return this.mResultSet.wasNull();
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public int getResultSetConcurrency() {
        try {
            return this.mStatement.getResultSetConcurrency();
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public int getResultSetHoldability() {
        try {
            return this.mStatement.getResultSetHoldability();
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public int getResultSetType() {
        try {
            return this.mStatement.getResultSetType();
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public int getUpdateCount() {
        try {
            return this.mStatement.getUpdateCount();
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public SQLWarning getWarnings() {
        try {
            return this.mStatement.getWarnings();
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public DbResultSet getResultSet() {
        return this.mResultSet;
    }

    public void setFetchDirection(int direction) {
        try {
            this.mStatement.setFetchDirection(direction);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public void setFetchSize(int rows) {
        try {
            this.mStatement.setFetchSize(rows);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public void setMaxFieldSize(int max) {
        try {
            this.mStatement.setMaxFieldSize(max);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public void setMaxRows(int max) {
        try {
            this.mStatement.setMaxRows(max);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public void setQueryTimeout(int max) {
        try {
            this.mStatement.setQueryTimeout(max);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public DbConnection getConnection() {
        return this.mConnection;
    }

    void waitForConnection() {
        if (this.mConnection.isClosed()) {
            throw new DatabaseException("The connection is not open.");
        }
        while (!this.mConnection.isFree()) {
            try {
                DbConnection dbConnection = this.mConnection;
                synchronized (dbConnection) {
                    this.mConnection.wait();
                }
            }
            catch (InterruptedException e) {
                throw new DatabaseException("Timeout while waiting for the connection to become available.");
            }
        }
    }

    boolean hasResultset() {
        return this.mResultSet != null;
    }

    protected void setResultset(ResultSet resultSet) {
        this.mResultSet = resultSet == null ? null : new DbResultSet(this, resultSet);
    }

    void cleanResultSet() {
        if (this.mResultSet != null) {
            try {
                this.mResultSet.close();
                this.mResultSet = null;
            }
            catch (SQLException e) {
                this.mResultSet = null;
                this.close();
                throw new DatabaseException(e);
            }
        }
    }

    protected void handleException() {
        DbStatement dbStatement = this;
        synchronized (dbStatement) {
            try {
                this.close();
            }
            catch (DatabaseException e) {
                // empty catch block
            }
            if (this.mConnection.isTransactionValidForThread()) {
                this.mConnection.rollback();
            } else {
                DbConnection dbConnection = this.mConnection;
                synchronized (dbConnection) {
                    this.mConnection.notifyAll();
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.database").severe(ExceptionUtils.getExceptionStackTrace(e));
            return null;
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.database.DbStatement");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

