/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database;

import com.uwyn.rife.database.DbStatement;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.exceptions.MissingResultsException;
import com.uwyn.rife.database.exceptions.RowIndexOutOfBoundsException;
import com.uwyn.rife.tools.ExceptionUtils;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Logger;

public class DbResultSet
implements ResultSet,
Cloneable {
    private DbStatement mStatement = null;
    private ResultSet mResultSet = null;
    private boolean mFirstRowSkew = false;
    private boolean mHasResultRows = false;
    private static /* synthetic */ boolean $assertionsDisabled;

    DbResultSet(DbStatement statement, ResultSet resultSet) {
        if (!$assertionsDisabled && statement == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && resultSet == null) {
            throw new AssertionError();
        }
        this.mStatement = statement;
        this.mResultSet = resultSet;
    }

    public final boolean next() throws SQLException {
        if (this.mFirstRowSkew) {
            this.mFirstRowSkew = false;
            return true;
        }
        if (this.mResultSet.next()) {
            this.mHasResultRows = true;
            this.mFirstRowSkew = false;
            return true;
        }
        return false;
    }

    public final boolean previous() throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        if (this.mResultSet.previous()) {
            this.mHasResultRows = true;
            this.mFirstRowSkew = false;
            return true;
        }
        return false;
    }

    public final boolean absolute(int row) throws SQLException {
        if (this.mResultSet.absolute(row)) {
            this.mHasResultRows = true;
            this.mFirstRowSkew = false;
            return true;
        }
        return false;
    }

    public final boolean relative(int rows) throws SQLException {
        if (this.mFirstRowSkew) {
            if (this.mResultSet.relative(rows - 1)) {
                this.mFirstRowSkew = false;
            }
        } else if (this.mResultSet.relative(rows)) {
            this.mHasResultRows = true;
            this.mFirstRowSkew = false;
            return true;
        }
        return false;
    }

    public final void beforeFirst() throws SQLException {
        this.mFirstRowSkew = false;
        this.mResultSet.beforeFirst();
    }

    public final boolean first() throws SQLException {
        if (this.mResultSet.first()) {
            this.mHasResultRows = true;
            this.mFirstRowSkew = false;
            return true;
        }
        return false;
    }

    public final boolean last() throws SQLException {
        if (this.mResultSet.last()) {
            this.mHasResultRows = true;
            this.mFirstRowSkew = false;
            return true;
        }
        return false;
    }

    public final void afterLast() throws SQLException {
        this.mResultSet.afterLast();
    }

    public final void moveToInsertRow() throws SQLException {
        this.mResultSet.moveToInsertRow();
    }

    public final void moveToCurrentRow() throws SQLException {
        this.mResultSet.moveToCurrentRow();
    }

    public final boolean isBeforeFirst() throws SQLException {
        if (this.mFirstRowSkew) {
            return true;
        }
        return this.mResultSet.isBeforeFirst();
    }

    public final boolean isFirst() throws SQLException {
        if (this.mFirstRowSkew) {
            return false;
        }
        return this.mResultSet.isFirst();
    }

    public final boolean isLast() throws SQLException {
        if (this.mFirstRowSkew) {
            return false;
        }
        return this.mResultSet.isLast();
    }

    public final boolean isAfterLast() throws SQLException {
        if (this.mFirstRowSkew) {
            return false;
        }
        return this.mResultSet.isAfterLast();
    }

    public final int getRow() throws SQLException {
        if (this.mFirstRowSkew) {
            return this.mResultSet.getRow() - 1;
        }
        return this.mResultSet.getRow();
    }

    public final void refreshRow() throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.refreshRow();
    }

    public final void insertRow() throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.insertRow();
    }

    public final void updateRow() throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateRow();
    }

    public final void deleteRow() throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.deleteRow();
    }

    public final boolean rowInserted() throws SQLException {
        return this.mResultSet.rowInserted();
    }

    public final boolean rowUpdated() throws SQLException {
        return this.mResultSet.rowUpdated();
    }

    public final boolean rowDeleted() throws SQLException {
        return this.mResultSet.rowDeleted();
    }

    public final void close() throws SQLException {
        this.mStatement = null;
        if (this.mResultSet != null) {
            this.mResultSet.close();
        }
        this.mFirstRowSkew = false;
        this.mHasResultRows = false;
    }

    public final boolean wasNull() throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.wasNull();
    }

    public final void setFetchDirection(int direction) throws SQLException {
        this.mResultSet.setFetchDirection(direction);
    }

    public final void setFetchSize(int rows) throws SQLException {
        this.mResultSet.setFetchSize(rows);
    }

    public final void cancelRowUpdates() throws SQLException {
        this.mResultSet.cancelRowUpdates();
    }

    public final ResultSetMetaData getMetaData() throws SQLException {
        return this.mResultSet.getMetaData();
    }

    public final int getConcurrency() throws SQLException {
        return this.mResultSet.getConcurrency();
    }

    public final int getFetchDirection() throws SQLException {
        return this.mResultSet.getFetchDirection();
    }

    public final int getFetchSize() throws SQLException {
        return this.mResultSet.getFetchSize();
    }

    public final void clearWarnings() throws SQLException {
        this.mResultSet.clearWarnings();
    }

    public final SQLWarning getWarnings() throws SQLException {
        return this.mResultSet.getWarnings();
    }

    public final String getCursorName() throws SQLException {
        return this.mResultSet.getCursorName();
    }

    public final Statement getStatement() throws SQLException {
        return this.mResultSet.getStatement();
    }

    public final int getType() throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getType();
    }

    public final int findColumn(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.findColumn(columnName);
    }

    public boolean hasResultRows() {
        try {
            if (this.mResultSet != null) {
                if (this.mHasResultRows) {
                    return true;
                }
                if (this.mFirstRowSkew) {
                    return true;
                }
                if (this.next()) {
                    this.mFirstRowSkew = true;
                    this.mHasResultRows = true;
                    return true;
                }
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        return false;
    }

    public String getFirstString() {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getString(1);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public boolean getFirstBoolean() {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getBoolean(1);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public byte getFirstByte() {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getByte(1);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public short getFirstShort() {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getShort(1);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public int getFirstInt() {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getInt(1);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public long getFirstLong() {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getLong(1);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public float getFirstFloat() {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getFloat(1);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public double getFirstDouble() {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getDouble(1);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public BigDecimal getFirstBigDecimal() {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public byte[] getFirstBytes() {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getBytes(1);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public Date getFirstDate() {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getDate(1);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public Date getFirstDate(Calendar cal) {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getDate(1, cal);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public Time getFirstTime() {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getTime(1);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public Time getFirstTime(Calendar cal) {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getTime(1, cal);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public Timestamp getFirstTimestamp() {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getTimestamp(1);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public Timestamp getFirstTimestamp(Calendar cal) {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getTimestamp(1, cal);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public InputStream getFirstAsciiStream() {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getAsciiStream(1);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public Reader getFirstCharacterStream() {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getCharacterStream(1);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public InputStream getFirstBinaryStream() {
        try {
            if (this.mResultSet != null && (this.isFirst() || this.isBeforeFirst() && this.next())) {
                return this.getBinaryStream(1);
            }
        }
        catch (SQLException e) {
            this.mStatement.handleException();
            throw new DatabaseException(e);
        }
        throw new MissingResultsException(this.mStatement.getConnection().getDatasource());
    }

    public final String getString(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getString(columnIndex);
    }

    public final String getString(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getString(columnName);
    }

    public final boolean getBoolean(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getBoolean(columnIndex);
    }

    public final boolean getBoolean(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getBoolean(columnName);
    }

    public final byte getByte(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getByte(columnIndex);
    }

    public final byte getByte(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getByte(columnName);
    }

    public final short getShort(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getShort(columnIndex);
    }

    public final short getShort(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getShort(columnName);
    }

    public final int getInt(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getInt(columnIndex);
    }

    public final int getInt(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getInt(columnName);
    }

    public final long getLong(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getLong(columnIndex);
    }

    public final long getLong(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getLong(columnName);
    }

    public final float getFloat(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getFloat(columnIndex);
    }

    public final float getFloat(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getFloat(columnName);
    }

    public final double getDouble(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getDouble(columnIndex);
    }

    public final double getDouble(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getDouble(columnName);
    }

    public final BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getBigDecimal(columnIndex);
    }

    public final BigDecimal getBigDecimal(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getBigDecimal(columnName);
    }

    public final BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getBigDecimal(columnIndex, scale);
    }

    public final BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getBigDecimal(columnName, scale);
    }

    public final byte[] getBytes(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getBytes(columnIndex);
    }

    public final byte[] getBytes(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getBytes(columnName);
    }

    public final Date getDate(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getDate(columnIndex);
    }

    public final Date getDate(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getDate(columnName);
    }

    public final Date getDate(int columnIndex, Calendar cal) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getDate(columnIndex, cal);
    }

    public final Date getDate(String columnName, Calendar cal) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getDate(columnName, cal);
    }

    public final Time getTime(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getTime(columnIndex);
    }

    public final Time getTime(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getTime(columnName);
    }

    public final Time getTime(int columnIndex, Calendar cal) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getTime(columnIndex, cal);
    }

    public final Time getTime(String columnName, Calendar cal) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getTime(columnName, cal);
    }

    public final Timestamp getTimestamp(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getTimestamp(columnIndex);
    }

    public final Timestamp getTimestamp(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getTimestamp(columnName);
    }

    public final Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getTimestamp(columnIndex, cal);
    }

    public final Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getTimestamp(columnName, cal);
    }

    public final InputStream getAsciiStream(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getAsciiStream(columnIndex);
    }

    public final InputStream getAsciiStream(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getAsciiStream(columnName);
    }

    public final InputStream getUnicodeStream(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getUnicodeStream(columnIndex);
    }

    public final InputStream getUnicodeStream(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getUnicodeStream(columnName);
    }

    public final Reader getCharacterStream(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getCharacterStream(columnIndex);
    }

    public final Reader getCharacterStream(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getCharacterStream(columnName);
    }

    public final InputStream getBinaryStream(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getBinaryStream(columnIndex);
    }

    public final InputStream getBinaryStream(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getBinaryStream(columnName);
    }

    public final Ref getRef(String colName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getRef(colName);
    }

    public final Ref getRef(int i) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getRef(i);
    }

    public final Object getObject(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getObject(columnIndex);
    }

    public final Object getObject(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getObject(columnName);
    }

    public final Object getObject(int i, Map map) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getObject(i, map);
    }

    public final Object getObject(String colName, Map map) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getObject(colName, map);
    }

    public final Blob getBlob(int i) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getBlob(i);
    }

    public final Blob getBlob(String colName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getBlob(colName);
    }

    public final Clob getClob(int i) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getClob(i);
    }

    public final Clob getClob(String colName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getClob(colName);
    }

    public final Array getArray(String colName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getArray(colName);
    }

    public final Array getArray(int i) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getArray(i);
    }

    public final URL getURL(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getURL(columnIndex);
    }

    public final URL getURL(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        return this.mResultSet.getURL(columnName);
    }

    public final void updateNull(int columnIndex) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateNull(columnIndex);
    }

    public final void updateNull(String columnName) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateNull(columnName);
    }

    public final void updateString(int columnIndex, String x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateString(columnIndex, x);
    }

    public final void updateString(String columnName, String x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateString(columnName, x);
    }

    public final void updateBoolean(int columnIndex, boolean x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateBoolean(columnIndex, x);
    }

    public final void updateBoolean(String columnName, boolean x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateBoolean(columnName, x);
    }

    public final void updateByte(int columnIndex, byte x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateByte(columnIndex, x);
    }

    public final void updateByte(String columnName, byte x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateByte(columnName, x);
    }

    public final void updateShort(int columnIndex, short x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateShort(columnIndex, x);
    }

    public final void updateShort(String columnName, short x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateShort(columnName, x);
    }

    public final void updateInt(int columnIndex, int x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateInt(columnIndex, x);
    }

    public final void updateInt(String columnName, int x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateInt(columnName, x);
    }

    public final void updateLong(int columnIndex, long x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateLong(columnIndex, x);
    }

    public final void updateLong(String columnName, long x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateLong(columnName, x);
    }

    public final void updateFloat(int columnIndex, float x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateFloat(columnIndex, x);
    }

    public final void updateFloat(String columnName, float x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateFloat(columnName, x);
    }

    public final void updateDouble(int columnIndex, double x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateDouble(columnIndex, x);
    }

    public final void updateDouble(String columnName, double x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateDouble(columnName, x);
    }

    public final void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateBigDecimal(columnIndex, x);
    }

    public final void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateBigDecimal(columnName, x);
    }

    public final void updateBytes(int columnIndex, byte[] x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateBytes(columnIndex, x);
    }

    public final void updateBytes(String columnName, byte[] x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateBytes(columnName, x);
    }

    public final void updateDate(int columnIndex, Date x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateDate(columnIndex, x);
    }

    public final void updateDate(String columnName, Date x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateDate(columnName, x);
    }

    public final void updateTime(int columnIndex, Time x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateTime(columnIndex, x);
    }

    public final void updateTime(String columnName, Time x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateTime(columnName, x);
    }

    public final void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateTimestamp(columnIndex, x);
    }

    public final void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateTimestamp(columnName, x);
    }

    public final void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateAsciiStream(columnIndex, x, length);
    }

    public final void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateAsciiStream(columnName, x, length);
    }

    public final void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateCharacterStream(columnIndex, x, length);
    }

    public final void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateCharacterStream(columnName, reader, length);
    }

    public final void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateBinaryStream(columnIndex, x, length);
    }

    public final void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateBinaryStream(columnName, x, length);
    }

    public final void updateRef(int columnIndex, Ref x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateRef(columnIndex, x);
    }

    public final void updateRef(String columnName, Ref x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateRef(columnName, x);
    }

    public final void updateObject(int columnIndex, Object x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateObject(columnIndex, x);
    }

    public final void updateObject(String columnName, Object x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateObject(columnName, x);
    }

    public final void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateObject(columnIndex, x, scale);
    }

    public final void updateObject(String columnName, Object x, int scale) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateObject(columnName, x, scale);
    }

    public final void updateBlob(int columnIndex, Blob x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateBlob(columnIndex, x);
    }

    public final void updateBlob(String columnName, Blob x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateBlob(columnName, x);
    }

    public final void updateClob(int columnIndex, Clob x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateClob(columnIndex, x);
    }

    public final void updateClob(String columnName, Clob x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateClob(columnName, x);
    }

    public final void updateArray(int columnIndex, Array x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateArray(columnIndex, x);
    }

    public final void updateArray(String columnName, Array x) throws SQLException {
        if (this.mFirstRowSkew) {
            throw new RowIndexOutOfBoundsException();
        }
        this.mResultSet.updateArray(columnName, x);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.database").severe(ExceptionUtils.getExceptionStackTrace(e));
            return null;
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.database.DbResultSet");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

