/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbQueryManager;
import com.uwyn.rife.database.DbQueryManagerCache;
import com.uwyn.rife.database.exceptions.UnsupportedJdbcDriverException;
import com.uwyn.rife.tools.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class DbQueryManagerFactory {
    private static final String GENERIC_DRIVER = "generic";
    private static /* synthetic */ boolean $assertionsDisabled;

    protected static DbQueryManager getInstance(String managerPackageName, DbQueryManagerCache cache, Datasource datasource) {
        return DbQueryManagerFactory.getInstance(managerPackageName, cache, datasource, "");
    }

    protected static DbQueryManager getInstance(String managerPackageName, DbQueryManagerCache cache, Datasource datasource, String identifier) {
        if (managerPackageName == null) {
            throw new IllegalArgumentException("managerPackageName can't be null.");
        }
        if (0 == managerPackageName.length()) {
            throw new IllegalArgumentException("managerPackageName can't be empty.");
        }
        if (cache == null) {
            throw new IllegalArgumentException("cache can't be null.");
        }
        if (datasource == null) {
            throw new IllegalArgumentException("datasource can't be null.");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("identifier can't be null.");
        }
        DbQueryManager dbquery_manager = null;
        DbQueryManagerCache dbQueryManagerCache = cache;
        synchronized (dbQueryManagerCache) {
            dbquery_manager = cache.get(datasource, identifier);
            if (dbquery_manager != null) {
                return dbquery_manager;
            }
            StringBuffer package_name = new StringBuffer(managerPackageName);
            if (!managerPackageName.endsWith(".")) {
                package_name.append(".");
            }
            StringBuffer specialized_name = new StringBuffer(package_name.toString());
            String driver = datasource.getAliasedDriver();
            specialized_name.append(StringUtils.encodeClassname(driver));
            try {
                try {
                    Class<?> clazz;
                    Class<?> specialized_class = Class.forName(specialized_name.toString());
                    Class[] classArray = new Class[1];
                    try {
                        clazz = Class.forName("com.uwyn.rife.database.Datasource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    classArray[0] = clazz;
                    Constructor<?> specialized_constructor = specialized_class.getConstructor(classArray);
                    dbquery_manager = (DbQueryManager)specialized_constructor.newInstance(datasource);
                }
                catch (ClassNotFoundException e) {
                    try {
                        Class<?> clazz;
                        StringBuffer generic_name = new StringBuffer(package_name.toString());
                        generic_name.append(GENERIC_DRIVER);
                        Class<?> generic_class = Class.forName(generic_name.toString());
                        Class[] classArray = new Class[1];
                        try {
                            clazz = Class.forName("com.uwyn.rife.database.Datasource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        classArray[0] = clazz;
                        Constructor<?> generic_constructor = generic_class.getConstructor(classArray);
                        dbquery_manager = (DbQueryManager)generic_constructor.newInstance(datasource);
                    }
                    catch (ClassNotFoundException e2) {
                        throw new UnsupportedJdbcDriverException(driver, e);
                    }
                }
            }
            catch (InstantiationException e) {
                throw new UnsupportedJdbcDriverException(driver, e);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedJdbcDriverException(driver, e);
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedJdbcDriverException(driver, e);
            }
            catch (SecurityException e) {
                throw new UnsupportedJdbcDriverException(driver, e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    throw new RuntimeException(e.getTargetException());
                }
                throw new UnsupportedJdbcDriverException(driver, e);
            }
            cache.put(datasource, identifier, dbquery_manager);
        }
        if (!$assertionsDisabled && dbquery_manager == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && datasource != dbquery_manager.getDatasource()) {
            throw new AssertionError();
        }
        return dbquery_manager;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.database.DbQueryManagerFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

