/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database;

import com.uwyn.rife.database.CommittingRuntimeException;
import com.uwyn.rife.database.ConnectionPool;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbBeanFetcher;
import com.uwyn.rife.database.DbConnection;
import com.uwyn.rife.database.DbConnectionUser;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.DbResultSet;
import com.uwyn.rife.database.DbResultSetHandler;
import com.uwyn.rife.database.DbRowProcessor;
import com.uwyn.rife.database.DbStatement;
import com.uwyn.rife.database.DbTransactionUser;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.exceptions.RollbackException;
import com.uwyn.rife.database.exceptions.RowProcessorErrorException;
import com.uwyn.rife.database.queries.Query;
import com.uwyn.rife.database.queries.ReadQuery;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.InputStreamUser;
import com.uwyn.rife.tools.ReaderUser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbQueryManager
implements Cloneable {
    private Datasource mDatasource = null;

    public DbQueryManager(Datasource datasource) {
        if (datasource == null) {
            throw new IllegalArgumentException("datasource can't be null.");
        }
        this.mDatasource = datasource;
    }

    public int executeUpdate(String sql) {
        if (sql == null) {
            throw new IllegalArgumentException("sql can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbStatement statement = connection.createStatement();
            try {
                int n = statement.executeUpdate(sql);
                this.defensiveClose(statement);
                connection.close();
                return n;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public int executeUpdate(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbStatement statement = connection.createStatement();
            try {
                int n = statement.executeUpdate(query);
                this.defensiveClose(statement);
                connection.close();
                return n;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    private DbPreparedStatement getPreparedStatement(Query query, DbResultSetHandler handler, DbConnection connection) {
        return this.mDatasource.getCapabilitiesCompensator().getCapablePreparedStatement(query, handler, connection);
    }

    private void executeQuery(DbPreparedStatement statement, DbPreparedStatementHandler handler) {
        if (handler == null) {
            statement.executeQuery();
        } else {
            handler.performQuery(statement);
        }
    }

    private DbResultSet getResultSet(DbPreparedStatement statement) {
        return this.mDatasource.getCapabilitiesCompensator().getCapableResultSet(statement);
    }

    public int executeUpdate(Query query, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                if (handler == null) {
                    int n = statement.executeUpdate();
                    this.defensiveClose(statement);
                    connection.close();
                    return n;
                }
                int n = handler.performUpdate(statement);
                this.defensiveClose(statement);
                connection.close();
                return n;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    private boolean executeHasResultRows(DbPreparedStatement statement, DbPreparedStatementHandler handler) {
        this.executeQuery(statement, handler);
        return this.getResultSet(statement).hasResultRows();
    }

    public boolean executeHasResultRows(ReadQuery query) {
        return this.executeHasResultRows(query, null);
    }

    public boolean executeHasResultRows(ReadQuery query, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                boolean result = this.executeHasResultRows(statement, handler);
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                boolean bl = result;
                this.defensiveClose(statement);
                connection.close();
                return bl;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public String executeGetFirstString(ReadQuery query) {
        return this.executeGetFirstString(query, null);
    }

    public String executeGetFirstString(ReadQuery query, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                statement.setFetchSize(1);
                String result = null;
                if (this.executeHasResultRows(statement, handler)) {
                    result = this.getResultSet(statement).getFirstString();
                }
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                String string = result;
                this.defensiveClose(statement);
                connection.close();
                return string;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public boolean executeGetFirstBoolean(ReadQuery query) {
        return this.executeGetFirstBoolean(query, null);
    }

    public boolean executeGetFirstBoolean(ReadQuery query, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                statement.setFetchSize(1);
                boolean result = false;
                if (this.executeHasResultRows(statement, handler)) {
                    result = this.getResultSet(statement).getFirstBoolean();
                }
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                boolean bl = result;
                this.defensiveClose(statement);
                connection.close();
                return bl;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public byte executeGetFirstByte(ReadQuery query) {
        return this.executeGetFirstByte(query, null);
    }

    public byte executeGetFirstByte(ReadQuery query, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                statement.setFetchSize(1);
                byte result = (byte)-1;
                if (this.executeHasResultRows(statement, handler)) {
                    result = this.getResultSet(statement).getFirstByte();
                }
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                byte by = result;
                this.defensiveClose(statement);
                connection.close();
                return by;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public short executeGetFirstShort(ReadQuery query) {
        return this.executeGetFirstShort(query, null);
    }

    public short executeGetFirstShort(ReadQuery query, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                statement.setFetchSize(1);
                short result = (short)-1;
                if (this.executeHasResultRows(statement, handler)) {
                    result = this.getResultSet(statement).getFirstShort();
                }
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                short s = result;
                this.defensiveClose(statement);
                connection.close();
                return s;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public int executeGetFirstInt(ReadQuery query) {
        return this.executeGetFirstInt(query, null);
    }

    public int executeGetFirstInt(ReadQuery query, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                statement.setFetchSize(1);
                int result = -1;
                if (this.executeHasResultRows(statement, handler)) {
                    result = this.getResultSet(statement).getFirstInt();
                }
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                int n = result;
                this.defensiveClose(statement);
                connection.close();
                return n;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public long executeGetFirstLong(ReadQuery query) {
        return this.executeGetFirstLong(query, null);
    }

    public long executeGetFirstLong(ReadQuery query, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                statement.setFetchSize(1);
                long result = -1;
                if (this.executeHasResultRows(statement, handler)) {
                    result = this.getResultSet(statement).getFirstLong();
                }
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                long l = result;
                this.defensiveClose(statement);
                connection.close();
                return l;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public float executeGetFirstFloat(ReadQuery query) {
        return this.executeGetFirstFloat(query, null);
    }

    public float executeGetFirstFloat(ReadQuery query, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                statement.setFetchSize(1);
                float result = -1;
                if (this.executeHasResultRows(statement, handler)) {
                    result = this.getResultSet(statement).getFirstFloat();
                }
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                float f = result;
                this.defensiveClose(statement);
                connection.close();
                return f;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public double executeGetFirstDouble(ReadQuery query) {
        return this.executeGetFirstDouble(query, null);
    }

    public double executeGetFirstDouble(ReadQuery query, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                statement.setFetchSize(1);
                double result = -1;
                if (this.executeHasResultRows(statement, handler)) {
                    result = this.getResultSet(statement).getFirstDouble();
                }
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                double d = result;
                this.defensiveClose(statement);
                connection.close();
                return d;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public byte[] executeGetFirstBytes(ReadQuery query) {
        return this.executeGetFirstBytes(query, null);
    }

    public byte[] executeGetFirstBytes(ReadQuery query, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                statement.setFetchSize(1);
                byte[] result = null;
                if (this.executeHasResultRows(statement, handler)) {
                    result = this.getResultSet(statement).getFirstBytes();
                }
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                byte[] byArray = result;
                this.defensiveClose(statement);
                connection.close();
                return byArray;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public Date executeGetFirstDate(ReadQuery query) {
        return this.executeGetFirstDate(query, (DbPreparedStatementHandler)null);
    }

    public Date executeGetFirstDate(ReadQuery query, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                statement.setFetchSize(1);
                Date result = null;
                if (this.executeHasResultRows(statement, handler)) {
                    result = this.getResultSet(statement).getFirstDate();
                }
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                Date date = result;
                this.defensiveClose(statement);
                connection.close();
                return date;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public Date executeGetFirstDate(ReadQuery query, Calendar cal) {
        return this.executeGetFirstDate(query, cal, null);
    }

    public Date executeGetFirstDate(ReadQuery query, Calendar cal, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                statement.setFetchSize(1);
                Date result = null;
                if (this.executeHasResultRows(statement, handler)) {
                    result = this.getResultSet(statement).getFirstDate(cal);
                }
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                Date date = result;
                this.defensiveClose(statement);
                connection.close();
                return date;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public Time executeGetFirstTime(ReadQuery query) {
        return this.executeGetFirstTime(query, (DbPreparedStatementHandler)null);
    }

    public Time executeGetFirstTime(ReadQuery query, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                statement.setFetchSize(1);
                Time result = null;
                if (this.executeHasResultRows(statement, handler)) {
                    result = this.getResultSet(statement).getFirstTime();
                }
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                Time time = result;
                this.defensiveClose(statement);
                connection.close();
                return time;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public Time executeGetFirstTime(ReadQuery query, Calendar cal) {
        return this.executeGetFirstTime(query, cal, null);
    }

    public Time executeGetFirstTime(ReadQuery query, Calendar cal, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                statement.setFetchSize(1);
                Time result = null;
                if (this.executeHasResultRows(statement, handler)) {
                    result = this.getResultSet(statement).getFirstTime(cal);
                }
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                Time time = result;
                this.defensiveClose(statement);
                connection.close();
                return time;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public Timestamp executeGetFirstTimestamp(ReadQuery query) {
        return this.executeGetFirstTimestamp(query, (DbPreparedStatementHandler)null);
    }

    public Timestamp executeGetFirstTimestamp(ReadQuery query, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                statement.setFetchSize(1);
                Timestamp result = null;
                if (this.executeHasResultRows(statement, handler)) {
                    result = this.getResultSet(statement).getFirstTimestamp();
                }
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                Timestamp timestamp = result;
                this.defensiveClose(statement);
                connection.close();
                return timestamp;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public Timestamp executeGetFirstTimestamp(ReadQuery query, Calendar cal) {
        return this.executeGetFirstTimestamp(query, cal, null);
    }

    public Timestamp executeGetFirstTimestamp(ReadQuery query, Calendar cal, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                statement.setFetchSize(1);
                Timestamp result = null;
                if (this.executeHasResultRows(statement, handler)) {
                    result = this.getResultSet(statement).getFirstTimestamp(cal);
                }
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                Timestamp timestamp = result;
                this.defensiveClose(statement);
                connection.close();
                return timestamp;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public <ResultType> ResultType executeUseFirstAsciiStream(ReadQuery query, InputStreamUser user) {
        return this.executeUseFirstAsciiStream(query, user, null);
    }

    public <ResultType> ResultType executeUseFirstAsciiStream(ReadQuery query, InputStreamUser user, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        if (user == null) {
            throw new IllegalArgumentException("user can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            InputStream stream = null;
            try {
                statement.setFetchSize(1);
                if (this.executeHasResultRows(statement, handler)) {
                    stream = this.getResultSet(statement).getFirstAsciiStream();
                }
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                Object ResultType = user.useInputStream(stream);
                this.defensiveClose(stream);
                this.defensiveClose(statement);
                connection.close();
                return ResultType;
            }
            catch (Throwable throwable) {
                this.defensiveClose(stream);
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public <ResultType> ResultType executeUseFirstCharacterStream(ReadQuery query, ReaderUser user) {
        return this.executeUseFirstCharacterStream(query, user, null);
    }

    public <ResultType> ResultType executeUseFirstCharacterStream(ReadQuery query, ReaderUser user, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        if (user == null) {
            throw new IllegalArgumentException("user can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            Reader reader = null;
            try {
                statement.setFetchSize(1);
                if (this.executeHasResultRows(statement, handler)) {
                    reader = this.getResultSet(statement).getFirstCharacterStream();
                }
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                Object ResultType = user.useReader(reader);
                this.defensiveClose(reader);
                this.defensiveClose(statement);
                connection.close();
                return ResultType;
            }
            catch (Throwable throwable) {
                this.defensiveClose(reader);
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public <ResultType> ResultType executeUseFirstBinaryStream(ReadQuery query, InputStreamUser user) {
        return this.executeUseFirstBinaryStream(query, user, null);
    }

    public <ResultType> ResultType executeUseFirstBinaryStream(ReadQuery query, InputStreamUser user, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        if (user == null) {
            throw new IllegalArgumentException("user can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            InputStream stream = null;
            try {
                statement.setFetchSize(1);
                if (this.executeHasResultRows(statement, handler)) {
                    stream = this.getResultSet(statement).getFirstBinaryStream();
                }
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                Object ResultType = user.useInputStream(stream);
                this.defensiveClose(stream);
                this.defensiveClose(statement);
                connection.close();
                return ResultType;
            }
            catch (Throwable throwable) {
                this.defensiveClose(stream);
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public boolean executeFetchFirst(ReadQuery query, DbRowProcessor rowProcessor) {
        return this.executeFetchFirst(query, rowProcessor, null);
    }

    public boolean executeFetchFirst(ReadQuery query, DbRowProcessor rowProcessor, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                statement.setFetchSize(1);
                this.executeQuery(statement, handler);
                boolean result = this.fetch(this.getResultSet(statement), rowProcessor);
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                boolean bl = result;
                this.defensiveClose(statement);
                connection.close();
                return bl;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public <BeanType> BeanType executeFetchFirstBean(ReadQuery query, Class<BeanType> beanClass) {
        return this.executeFetchFirstBean(query, beanClass, null);
    }

    public <BeanType> BeanType executeFetchFirstBean(ReadQuery query, Class<BeanType> beanClass, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbBeanFetcher<BeanType> bean_fetcher = new DbBeanFetcher<BeanType>(this.getDatasource(), beanClass);
        if (this.executeFetchFirst(query, bean_fetcher, handler)) {
            return bean_fetcher.getBeanInstance();
        }
        return null;
    }

    public boolean executeFetchAll(ReadQuery query, DbRowProcessor rowProcessor) {
        return this.executeFetchAll(query, rowProcessor, null);
    }

    public boolean executeFetchAll(ReadQuery query, DbRowProcessor rowProcessor, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                this.executeQuery(statement, handler);
                boolean result = this.fetchAll(this.getResultSet(statement), rowProcessor);
                if (handler != null) {
                    try {
                        handler.concludeResults(this.getResultSet(statement));
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                boolean bl = result;
                this.defensiveClose(statement);
                connection.close();
                return bl;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public <BeanType> List<BeanType> executeFetchAllBeans(ReadQuery query, Class<BeanType> beanClass) {
        return this.executeFetchAllBeans(query, beanClass, null);
    }

    public <BeanType> List<BeanType> executeFetchAllBeans(ReadQuery query, Class<BeanType> beanClass, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbBeanFetcher<BeanType> bean_fetcher = new DbBeanFetcher<BeanType>(this.getDatasource(), beanClass, true);
        this.executeFetchAll(query, bean_fetcher, handler);
        return bean_fetcher.getCollectedInstances();
    }

    public <ResultType> ResultType executeQuery(ReadQuery query, DbPreparedStatementHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                this.executeQuery(statement, handler);
                if (handler == null) {
                    ResultType ResultType = null;
                    this.defensiveClose(statement);
                    connection.close();
                    return ResultType;
                }
                try {
                    Object object = handler.concludeResults(this.getResultSet(statement));
                    this.defensiveClose(statement);
                    connection.close();
                    return (ResultType)object;
                }
                catch (SQLException e) {
                    statement.handleException();
                    throw new DatabaseException(e);
                }
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public <ResultType> ResultType executeQuery(ReadQuery query, DbResultSetHandler handler) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbConnection connection = this.getConnection();
        try {
            DbPreparedStatement statement = this.getPreparedStatement(query, handler, connection);
            try {
                this.executeQuery(statement, null);
                if (handler != null) {
                    try {
                        Object object = handler.concludeResults(this.getResultSet(statement));
                        this.defensiveClose(statement);
                        connection.close();
                        return (ResultType)object;
                    }
                    catch (SQLException e) {
                        statement.handleException();
                        throw new DatabaseException(e);
                    }
                }
                ResultType ResultType = null;
                this.defensiveClose(statement);
                connection.close();
                return ResultType;
            }
            catch (Throwable throwable) {
                this.defensiveClose(statement);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.close();
            throw throwable;
        }
    }

    public <ResultType> ResultType reserveConnection(DbConnectionUser user) {
        ConnectionPool pool;
        if (user == null) {
            throw new IllegalArgumentException("user can't be null.");
        }
        DbConnection connection = this.mDatasource.getConnection();
        ConnectionPool connectionPool = pool = this.mDatasource.getPool();
        synchronized (connectionPool) {
            boolean does_threadconnection_exist = pool.hasThreadConnection(Thread.currentThread());
            try {
                if (!does_threadconnection_exist) {
                    pool.registerThreadConnection(Thread.currentThread(), connection);
                }
                Object ResultType = user.useConnection(connection);
                if (!does_threadconnection_exist) {
                    pool.unregisterThreadConnection(Thread.currentThread());
                }
                return ResultType;
            }
            catch (Throwable throwable) {
                if (!does_threadconnection_exist) {
                    pool.unregisterThreadConnection(Thread.currentThread());
                }
                throw throwable;
            }
        }
    }

    public <ResultType> ResultType inTransaction(DbTransactionUser user) {
        boolean started_transaction = false;
        DbConnection connection = null;
        try {
            Datasource datasource = this.mDatasource;
            synchronized (datasource) {
                connection = this.mDatasource.getConnection();
                int isolation = user.getTransactionIsolation();
                if (isolation != -1) {
                    connection.setTransactionIsolation(isolation);
                }
                started_transaction = connection.beginTransaction();
            }
            Object result = user.useTransaction();
            if (started_transaction) {
                connection.commit();
                if (!this.mDatasource.isPooled()) {
                    connection.close();
                }
            }
            return result;
        }
        catch (RollbackException e) {
            if (connection != null) {
                connection.rollback();
                if (!this.mDatasource.isPooled()) {
                    connection.close();
                }
            }
            if (started_transaction) {
                return (ResultType)((Object)null);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (started_transaction && connection != null) {
                try {
                    if (e instanceof CommittingRuntimeException) {
                        connection.commit();
                    } else {
                        connection.rollback();
                        if (!this.mDatasource.isPooled()) {
                            connection.close();
                        }
                    }
                }
                catch (DatabaseException e2) {
                    // empty catch block
                }
            }
            throw e;
        }
        catch (Error e) {
            block22: {
                if (!started_transaction || connection == null) break block22;
                try {
                    connection.rollback();
                    if (!this.mDatasource.isPooled()) {
                        connection.close();
                    }
                }
                catch (DatabaseException e2) {}
            }
            throw e;
        }
    }

    public DbStatement executeQuery(ReadQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        DbStatement statement = this.getConnection().createStatement();
        statement.executeQuery(query);
        return statement;
    }

    public boolean fetch(ResultSet resultSet) {
        return this.fetch(resultSet, null);
    }

    public boolean fetch(ResultSet resultSet, DbRowProcessor rowProcessor) {
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet can't be null.");
        }
        try {
            if (resultSet.next()) {
                if (rowProcessor != null) {
                    rowProcessor.processRowWrapper(resultSet);
                }
                return true;
            }
        }
        catch (SQLException e) {
            throw new RowProcessorErrorException(e);
        }
        return false;
    }

    public boolean fetchAll(ResultSet resultSet, DbRowProcessor rowProcessor) {
        if (rowProcessor == null) {
            throw new IllegalArgumentException("rowProcessor can't be null.");
        }
        boolean result = false;
        while (this.fetch(resultSet, rowProcessor)) {
            result = true;
            if (rowProcessor != null && !rowProcessor.wasSuccessful()) break;
        }
        return result;
    }

    public DbConnection getConnection() {
        return this.mDatasource.getConnection();
    }

    public Datasource getDatasource() {
        return this.mDatasource;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.database").severe(ExceptionUtils.getExceptionStackTrace(e));
            return null;
        }
    }

    private void defensiveClose(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException e) {}
    }

    private void defensiveClose(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException e) {}
    }

    private void defensiveClose(DbStatement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (DatabaseException e) {}
    }
}

