/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database;

import com.uwyn.rife.database.DbConnection;
import com.uwyn.rife.database.DbStatement;
import com.uwyn.rife.database.VirtualParameters;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.exceptions.ExecutionErrorException;
import com.uwyn.rife.database.exceptions.NoParametersException;
import com.uwyn.rife.database.exceptions.NoParametrizedQueryException;
import com.uwyn.rife.database.exceptions.ParameterDoesntExistException;
import com.uwyn.rife.database.exceptions.UndefinedVirtualParameterException;
import com.uwyn.rife.database.exceptions.UnsupportedVirtualParameterTypeException;
import com.uwyn.rife.database.queries.Query;
import com.uwyn.rife.site.Constrained;
import com.uwyn.rife.site.ConstrainedUtils;
import com.uwyn.rife.tools.ArrayUtils;
import com.uwyn.rife.tools.BeanUtils;
import com.uwyn.rife.tools.exceptions.BeanUtilsException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;

public class DbPreparedStatement
extends DbStatement {
    private String mSql = null;
    private Query mQuery = null;
    private List<String> mParameterNames = null;
    private VirtualParameters mVirtualParameters = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    DbPreparedStatement(DbConnection connection, String sql, PreparedStatement preparedStatement) {
        super(connection, preparedStatement);
        if (!$assertionsDisabled && connection == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && sql == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && sql.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && preparedStatement == null) {
            throw new AssertionError();
        }
        this.mSql = sql;
        this.mQuery = null;
    }

    DbPreparedStatement(DbConnection connection, Query query, PreparedStatement preparedStatement) {
        super(connection, preparedStatement);
        String sql = query.getSql();
        if (!$assertionsDisabled && connection == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && sql == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && sql.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && query == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && preparedStatement == null) {
            throw new AssertionError();
        }
        this.mSql = sql;
        this.mQuery = query;
    }

    public String getSql() {
        return this.mSql;
    }

    public Query getQuery() {
        return this.mQuery;
    }

    public void executeQuery() {
        try {
            this.waitForConnection();
            this.cleanResultSet();
            long start = this.startTrace();
            if (this.mVirtualParameters != null) {
                this.mVirtualParameters.callHandler(this);
            }
            ResultSet resultset = ((PreparedStatement)this.mStatement).executeQuery();
            this.outputTrace(start, this.getSql());
            this.setResultset(resultset);
            return;
        }
        catch (SQLException e) {
            this.handleException();
            throw new ExecutionErrorException(this.mSql, this.mConnection.getDatasource(), e);
        }
    }

    public int executeUpdate() {
        try {
            this.waitForConnection();
            long start = this.startTrace();
            if (this.mVirtualParameters != null) {
                this.mVirtualParameters.callHandler(this);
            }
            int result = ((PreparedStatement)this.mStatement).executeUpdate();
            this.outputTrace(start, this.getSql());
            return result;
        }
        catch (SQLException e) {
            this.handleException();
            throw new ExecutionErrorException(this.mSql, this.mConnection.getDatasource(), e);
        }
    }

    public void addBatch() {
        try {
            ((PreparedStatement)this.mStatement).addBatch();
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public void close() {
        super.close();
    }

    public ResultSetMetaData getMetaData() {
        try {
            return ((PreparedStatement)this.mStatement).getMetaData();
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    public ParameterMetaData getParameterMetaData() {
        try {
            return ((PreparedStatement)this.mStatement).getParameterMetaData();
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    private void validateParametrizedQuery() {
        if (this.mQuery == null) {
            throw new NoParametrizedQueryException(this);
        }
        if (this.mQuery.getParameters() == null || 0 == this.mQuery.getParameters().getOrderedNames().size()) {
            throw new NoParametersException(this);
        }
        if (this.mParameterNames == null) {
            this.mParameterNames = this.mQuery.getParameters().getOrderedNames();
            if (this.mVirtualParameters != null) {
                this.mVirtualParameters.setup(this.mQuery);
            }
        }
    }

    public Object getVirtualParameterValue(String name) {
        this.validateParametrizedQuery();
        int[] virtual_indices = this.getParameterIndices(name);
        if (!this.mVirtualParameters.hasValue(virtual_indices[0])) {
            throw new UndefinedVirtualParameterException(this, name);
        }
        return this.mVirtualParameters.getValue(virtual_indices[0]);
    }

    public Object getVirtualParameterValue(int parameterIndex) {
        this.validateParametrizedQuery();
        if (!this.mVirtualParameters.hasValue(parameterIndex)) {
            throw new UndefinedVirtualParameterException(this, parameterIndex);
        }
        return this.mVirtualParameters.getValue(parameterIndex);
    }

    public DbPreparedStatement setBean(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException("bean can't be null.");
        }
        try {
            this.validateParametrizedQuery();
            String[] parameters_array = this.mQuery.getParameters().getOrderedNamesArray();
            SortedMap<String, Class> property_types = BeanUtils.getPropertyTypes(bean.getClass(), parameters_array, null, null);
            SortedMap<String, Object> property_values = BeanUtils.getPropertyValues(bean, parameters_array, null, null);
            Class property_type = null;
            Object property_value = null;
            int parameter_counter = 1;
            Constrained constrained = ConstrainedUtils.makeConstrainedInstance(bean);
            Iterator iterator = ((Collection)this.mParameterNames).iterator();
            while (iterator.hasNext()) {
                String parameter_name = (String)iterator.next();
                if (property_types.containsKey(parameter_name)) {
                    property_type = (Class)property_types.get(parameter_name);
                    property_value = property_values.get(parameter_name);
                    this.getConnection().getDatasource().getSqlConversion().setTypedParameter(this, parameter_counter, property_type, parameter_name, property_value, constrained);
                }
                ++parameter_counter;
            }
        }
        catch (BeanUtilsException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public void setVirtualParameters(VirtualParameters parameters) {
        this.mParameterNames = null;
        this.mVirtualParameters = parameters;
    }

    private int[] getParameterIndices(String parameterName) {
        if (parameterName == null) {
            throw new IllegalArgumentException("parameterName can't be null.");
        }
        if (0 == parameterName.length()) {
            throw new IllegalArgumentException("parameterName can't be empty.");
        }
        this.validateParametrizedQuery();
        int parameter_index = 1;
        int[] parameter_indices = new int[]{};
        Iterator iterator = ((Collection)this.mParameterNames).iterator();
        while (iterator.hasNext()) {
            String parameter_name = (String)iterator.next();
            if (parameter_name.equals(parameterName)) {
                parameter_indices = ArrayUtils.join(parameter_indices, parameter_index);
            }
            ++parameter_index;
        }
        if (0 == parameter_indices.length) {
            throw new ParameterDoesntExistException(this, parameterName);
        }
        return parameter_indices;
    }

    public DbPreparedStatement setDouble(String parameterName, double x) {
        this.setDoubles(this.getParameterIndices(parameterName), x);
        return this;
    }

    public DbPreparedStatement setDoubles(int[] parameterIndices, double x) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setDouble(parameter_index, x);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setDouble(int parameterIndex, double x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                this.mVirtualParameters.putValue(parameterIndex, new Double(x));
                return this;
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setDouble(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setShort(String parameterName, short x) {
        this.setShorts(this.getParameterIndices(parameterName), x);
        return this;
    }

    public DbPreparedStatement setShorts(int[] parameterIndices, short x) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setShort(parameter_index, x);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setShort(int parameterIndex, short x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                this.mVirtualParameters.putValue(parameterIndex, new Short(x));
                return this;
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setShort(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setNull(String parameterName, int sqlType) {
        this.setNulls(this.getParameterIndices(parameterName), sqlType);
        return this;
    }

    public DbPreparedStatement setNulls(int[] parameterIndices, int sqlType) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setNull(parameter_index, sqlType);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setNull(int parameterIndex, int sqlType) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                this.mVirtualParameters.putValue(parameterIndex, null);
                return this;
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setNull(parameterIndex, sqlType);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setNull(String parameterName, int sqlType, String typeName) {
        this.setNulls(this.getParameterIndices(parameterName), sqlType, typeName);
        return this;
    }

    public DbPreparedStatement setNulls(int[] parameterIndices, int sqlType, String typeName) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setNull(parameter_index, sqlType, typeName);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setNull(int parameterIndex, int sqlType, String typeName) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                this.mVirtualParameters.putValue(parameterIndex, null);
                return this;
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setNull(parameterIndex, sqlType, typeName);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setBoolean(String parameterName, boolean x) {
        this.setBooleans(this.getParameterIndices(parameterName), x);
        return this;
    }

    public DbPreparedStatement setBooleans(int[] parameterIndices, boolean x) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setBoolean(parameter_index, x);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setBoolean(int parameterIndex, boolean x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                this.mVirtualParameters.putValue(parameterIndex, new Boolean(x));
                return this;
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setBoolean(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setByte(String parameterName, byte x) {
        this.setBytes(this.getParameterIndices(parameterName), x);
        return this;
    }

    public DbPreparedStatement setBytes(int[] parameterIndices, byte x) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setByte(parameter_index, x);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setByte(int parameterIndex, byte x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                this.mVirtualParameters.putValue(parameterIndex, new Byte(x));
                return this;
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setByte(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setDate(String parameterName, Date x) {
        this.setDates(this.getParameterIndices(parameterName), x);
        return this;
    }

    public DbPreparedStatement setDates(int[] parameterIndices, Date x) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setDate(parameter_index, x);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setDate(int parameterIndex, Date x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                this.mVirtualParameters.putValue(parameterIndex, x);
                return this;
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setDate(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setDate(String parameterName, Date x, Calendar cal) {
        this.setDates(this.getParameterIndices(parameterName), x, cal);
        return this;
    }

    public DbPreparedStatement setDates(int[] parameterIndices, Date x, Calendar cal) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setDate(parameter_index, x, cal);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setDate(int parameterIndex, Date x, Calendar cal) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                throw new UnsupportedVirtualParameterTypeException(this, parameterIndex, x.getClass().getName() + " with " + cal.getClass().getName());
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setDate(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setInt(String parameterName, int x) {
        this.setInts(this.getParameterIndices(parameterName), x);
        return this;
    }

    public DbPreparedStatement setInts(int[] parameterIndices, int x) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setInt(parameter_index, x);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setInt(int parameterIndex, int x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                this.mVirtualParameters.putValue(parameterIndex, new Integer(x));
                return this;
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setInt(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setLong(String parameterName, long x) {
        this.setLongs(this.getParameterIndices(parameterName), x);
        return this;
    }

    public DbPreparedStatement setLongs(int[] parameterIndices, long x) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setLong(parameter_index, x);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setLong(int parameterIndex, long x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                this.mVirtualParameters.putValue(parameterIndex, new Long(x));
                return this;
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setLong(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setFloat(String parameterName, float x) {
        this.setFloats(this.getParameterIndices(parameterName), x);
        return this;
    }

    public DbPreparedStatement setFloats(int[] parameterIndices, float x) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setFloat(parameter_index, x);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setFloat(int parameterIndex, float x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                this.mVirtualParameters.putValue(parameterIndex, new Float(x));
                return this;
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setFloat(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setBigDecimal(String parameterName, BigDecimal x) {
        this.setBigDecimals(this.getParameterIndices(parameterName), x);
        return this;
    }

    public DbPreparedStatement setBigDecimals(int[] parameterIndices, BigDecimal x) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setBigDecimal(parameter_index, x);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setBigDecimal(int parameterIndex, BigDecimal x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                this.mVirtualParameters.putValue(parameterIndex, x);
                return this;
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setBigDecimal(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setString(String parameterName, String x) {
        this.setStrings(this.getParameterIndices(parameterName), x);
        return this;
    }

    public DbPreparedStatement setStrings(int[] parameterIndices, String x) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setString(parameter_index, x);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setString(int parameterIndex, String x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                this.mVirtualParameters.putValue(parameterIndex, x);
                return this;
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setString(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setBytes(String parameterName, byte[] x) {
        this.setBytes(this.getParameterIndices(parameterName), x);
        return this;
    }

    public DbPreparedStatement setBytes(int[] parameterIndices, byte[] x) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setBytes(parameter_index, x);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setBytes(int parameterIndex, byte[] x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                this.mVirtualParameters.putValue(parameterIndex, x);
                return this;
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setBytes(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setObject(String parameterName, Object x, int targetSqlType, int scale) {
        this.setObjects(this.getParameterIndices(parameterName), x, targetSqlType, scale);
        return this;
    }

    public DbPreparedStatement setObjects(int[] parameterIndices, Object x, int targetSqlType, int scale) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setObject(parameter_index, x, targetSqlType, scale);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setObject(int parameterIndex, Object x, int targetSqlType, int scale) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                throw new UnsupportedVirtualParameterTypeException(this, parameterIndex, x.getClass().getName() + " targetSqlType:" + targetSqlType + " scale:" + scale);
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setObject(parameterIndex, x, targetSqlType, scale);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setObject(String parameterName, Object x, int targetSqlType) {
        this.setObjects(this.getParameterIndices(parameterName), x, targetSqlType);
        return this;
    }

    public DbPreparedStatement setObjects(int[] parameterIndices, Object x, int targetSqlType) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setObject(parameter_index, x, targetSqlType);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setObject(int parameterIndex, Object x, int targetSqlType) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                throw new UnsupportedVirtualParameterTypeException(this, parameterIndex, x.getClass().getName() + " targetSqlType:" + targetSqlType);
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setTime(String parameterName, Time x) {
        this.setTimes(this.getParameterIndices(parameterName), x);
        return this;
    }

    public DbPreparedStatement setTimes(int[] parameterIndices, Time x) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setTime(parameter_index, x);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setTime(int parameterIndex, Time x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                this.mVirtualParameters.putValue(parameterIndex, x);
                return this;
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setTime(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setTime(String parameterName, Time x, Calendar cal) {
        this.setTimes(this.getParameterIndices(parameterName), x, cal);
        return this;
    }

    public DbPreparedStatement setTimes(int[] parameterIndices, Time x, Calendar cal) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setTime(parameter_index, x, cal);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setTime(int parameterIndex, Time x, Calendar cal) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                throw new UnsupportedVirtualParameterTypeException(this, parameterIndex, x.getClass().getName() + " with " + cal.getClass().getName());
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setTime(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setTimestamp(String parameterName, Timestamp x) {
        this.setTimestamps(this.getParameterIndices(parameterName), x);
        return this;
    }

    public DbPreparedStatement setTimestamps(int[] parameterIndices, Timestamp x) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setTimestamp(parameter_index, x);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setTimestamp(int parameterIndex, Timestamp x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                this.mVirtualParameters.putValue(parameterIndex, x);
                return this;
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setTimestamp(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setTimestamp(String parameterName, Timestamp x, Calendar cal) {
        this.setTimestamps(this.getParameterIndices(parameterName), x, cal);
        return this;
    }

    public DbPreparedStatement setTimestamps(int[] parameterIndices, Timestamp x, Calendar cal) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setTimestamp(parameter_index, x, cal);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setTimestamp(int parameterIndex, Timestamp x, Calendar cal) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                throw new UnsupportedVirtualParameterTypeException(this, parameterIndex, x.getClass().getName() + " with " + cal.getClass().getName());
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setAsciiStream(String parameterName, InputStream x, int length) {
        this.setAsciiStream(this.getParameterIndices(parameterName)[0], x, length);
        return this;
    }

    public DbPreparedStatement setAsciiStream(int parameterIndex, InputStream x, int length) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                throw new UnsupportedVirtualParameterTypeException(this, parameterIndex, x.getClass().getName() + " length:" + length);
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setCharacterStream(String parameterName, Reader x, int length) {
        this.setCharacterStream(this.getParameterIndices(parameterName)[0], x, length);
        return this;
    }

    public DbPreparedStatement setCharacterStream(int parameterIndex, Reader x, int length) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                throw new UnsupportedVirtualParameterTypeException(this, parameterIndex, x.getClass().getName() + " length:" + length);
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setCharacterStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setBinaryStream(String parameterName, InputStream x, int length) {
        this.setBinaryStream(this.getParameterIndices(parameterName)[0], x, length);
        return this;
    }

    public DbPreparedStatement setBinaryStream(int parameterIndex, InputStream x, int length) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                throw new UnsupportedVirtualParameterTypeException(this, parameterIndex, x.getClass().getName() + " length:" + length);
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setArray(String parameterName, Array x) {
        this.setArray(this.getParameterIndices(parameterName)[0], x);
        return this;
    }

    public DbPreparedStatement setArray(int parameterIndex, Array x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                throw new UnsupportedVirtualParameterTypeException(this, parameterIndex, x.getClass().getName());
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setArray(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setObject(String parameterName, Object x) {
        this.setObjects(this.getParameterIndices(parameterName), x);
        return this;
    }

    public DbPreparedStatement setObjects(int[] parameterIndices, Object x) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setObject(parameter_index, x);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setObject(int parameterIndex, Object x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                this.mVirtualParameters.putValue(parameterIndex, x);
                return this;
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setObject(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setRef(String parameterName, Ref x) {
        this.setRef(this.getParameterIndices(parameterName)[0], x);
        return this;
    }

    public DbPreparedStatement setRef(int parameterIndex, Ref x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                throw new UnsupportedVirtualParameterTypeException(this, parameterIndex, x.getClass().getName());
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setRef(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setBlob(String parameterName, Blob x) {
        this.setBlob(this.getParameterIndices(parameterName)[0], x);
        return this;
    }

    public DbPreparedStatement setBlob(int parameterIndex, Blob x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                throw new UnsupportedVirtualParameterTypeException(this, parameterIndex, x.getClass().getName());
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setBlob(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setClob(String parameterName, Clob x) {
        this.setClob(this.getParameterIndices(parameterName)[0], x);
        return this;
    }

    public DbPreparedStatement setClob(int parameterIndex, Clob x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                throw new UnsupportedVirtualParameterTypeException(this, parameterIndex, x.getClass().getName());
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setClob(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public DbPreparedStatement setURL(String parameterName, URL x) {
        this.setURLs(this.getParameterIndices(parameterName), x);
        return this;
    }

    public DbPreparedStatement setURLs(int[] parameterIndices, URL x) {
        if (parameterIndices == null) {
            throw new IllegalArgumentException("parameterIndices can't be null.");
        }
        int[] nArray = parameterIndices;
        int n = 0;
        while (n < nArray.length) {
            int parameter_index = nArray[n];
            this.setURL(parameter_index, x);
            ++n;
        }
        return this;
    }

    public DbPreparedStatement setURL(int parameterIndex, URL x) {
        if (this.mVirtualParameters != null && this.mVirtualParameters.hasParameter(parameterIndex)) {
            int real_index = this.mVirtualParameters.getRealIndex(parameterIndex);
            if (-1 == real_index) {
                this.mVirtualParameters.putValue(parameterIndex, x);
                return this;
            }
            parameterIndex = real_index;
        }
        try {
            ((PreparedStatement)this.mStatement).setURL(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
        return this;
    }

    public void clearParameters() {
        try {
            ((PreparedStatement)this.mStatement).clearParameters();
        }
        catch (SQLException e) {
            this.handleException();
            throw new DatabaseException(e);
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.database.DbPreparedStatement");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

