/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database;

import com.uwyn.rife.database.ConnectionPool;
import com.uwyn.rife.database.DbConnection;
import com.uwyn.rife.database.capabilities.CapabilitiesCompensator;
import com.uwyn.rife.database.exceptions.ConnectionOpenErrorException;
import com.uwyn.rife.database.exceptions.DriverInstantiationErrorException;
import com.uwyn.rife.database.exceptions.UnsupportedJdbcDriverException;
import com.uwyn.rife.database.types.SqlConversion;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.StringUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Logger;

public class Datasource
implements Cloneable {
    private static HashMap<String, String> sDriverAliases;
    private String mDriver = null;
    private String mUrl = null;
    private String mUser = null;
    private String mPassword = null;
    private SqlConversion mSqlConversion = null;
    private CapabilitiesCompensator mCapabilitiesCompensator = null;
    private ConnectionPool mConnectionPool = new ConnectionPool();
    private static /* synthetic */ boolean $assertionsDisabled;

    public Datasource() {
    }

    public Datasource(String driver, String url, String user, String password, int poolsize) {
        this.setDriver(driver);
        this.setUrl(url);
        this.setUser(user);
        this.setPassword(password);
        this.setPoolsize(poolsize);
        if (!$assertionsDisabled && this.mDriver == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mDriver.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mUrl == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mUrl.length() <= 0) {
            throw new AssertionError();
        }
    }

    DbConnection createConnection() {
        try {
            Class.forName(this.mDriver).newInstance();
        }
        catch (InstantiationException e) {
            throw new DriverInstantiationErrorException(this.mDriver, e);
        }
        catch (ClassNotFoundException e) {
            throw new DriverInstantiationErrorException(this.mDriver, e);
        }
        catch (IllegalAccessException e) {
            throw new DriverInstantiationErrorException(this.mDriver, e);
        }
        Connection connection = null;
        if (this.mUser != null && this.mPassword != null) {
            try {
                connection = DriverManager.getConnection(this.mUrl, this.mUser, this.mPassword);
            }
            catch (SQLException e) {
                throw new ConnectionOpenErrorException(this.mUrl, this.mUser, this.mPassword, e);
            }
        }
        try {
            connection = DriverManager.getConnection(this.mUrl);
        }
        catch (SQLException e) {
            throw new ConnectionOpenErrorException(this.mUrl, e);
        }
        return new DbConnection(connection, this);
    }

    public DbConnection getConnection() {
        return this.mConnectionPool.getConnection(this);
    }

    public String getDriver() {
        return this.mDriver;
    }

    public String getAliasedDriver() {
        if (this.mDriver == null) {
            return null;
        }
        String alias = sDriverAliases.get(this.mDriver);
        if (alias == null) {
            return this.mDriver;
        }
        return alias;
    }

    public void setDriver(String driver) {
        if (driver == null) {
            throw new IllegalArgumentException("driver can't be null.");
        }
        if (0 == driver.length()) {
            throw new IllegalArgumentException("driver can't be empty.");
        }
        if (this.mConnectionPool.isInitialized()) {
            throw new IllegalArgumentException("driver can't be changed after the connection pool has been set up.");
        }
        this.mDriver = driver;
        this.mSqlConversion = null;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setUrl(String url) {
        if (url == null) {
            throw new IllegalArgumentException("url can't be null.");
        }
        if (0 == url.length()) {
            throw new IllegalArgumentException("url can't be empty.");
        }
        if (this.mConnectionPool.isInitialized()) {
            throw new IllegalArgumentException("url can't be changed after the connection pool has been set up.");
        }
        this.mUrl = url;
    }

    public String getUser() {
        return this.mUser;
    }

    public void setUser(String user) {
        if (this.mConnectionPool.isInitialized()) {
            throw new IllegalArgumentException("user can't be changed after the connection pool has been set up.");
        }
        this.mUser = user;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String password) {
        if (this.mConnectionPool.isInitialized()) {
            throw new IllegalArgumentException("password can't be changed after the connection pool has been set up.");
        }
        this.mPassword = password;
    }

    public int getPoolsize() {
        return this.mConnectionPool.getPoolsize();
    }

    public boolean isPooled() {
        return this.getPoolsize() > 0;
    }

    public void setPoolsize(int poolsize) {
        if (poolsize < 0) {
            throw new IllegalArgumentException("poolsize can't be negative.");
        }
        this.mConnectionPool.setPoolsize(poolsize);
    }

    public SqlConversion getSqlConversion() {
        if (this.mSqlConversion == null && this.mDriver != null) {
            try {
                this.mSqlConversion = (SqlConversion)Class.forName("com.uwyn.rife.database.types." + StringUtils.encodeClassname(this.getAliasedDriver())).newInstance();
            }
            catch (InstantiationException e) {
                throw new UnsupportedJdbcDriverException(this.mDriver, e);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedJdbcDriverException(this.mDriver, e);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedJdbcDriverException(this.mDriver, e);
            }
        }
        return this.mSqlConversion;
    }

    public CapabilitiesCompensator getCapabilitiesCompensator() {
        if (this.mCapabilitiesCompensator == null && this.mDriver != null) {
            try {
                this.mCapabilitiesCompensator = (CapabilitiesCompensator)Class.forName("com.uwyn.rife.database.capabilities." + StringUtils.encodeClassname(this.getAliasedDriver())).newInstance();
            }
            catch (InstantiationException e) {
                throw new UnsupportedJdbcDriverException(this.mDriver, e);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedJdbcDriverException(this.mDriver, e);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedJdbcDriverException(this.mDriver, e);
            }
        }
        return this.mCapabilitiesCompensator;
    }

    public int hashCode() {
        return this.mDriver.hashCode() * this.mUrl.hashCode() * this.mUser.hashCode() * this.mPassword.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Datasource)) {
            return false;
        }
        Datasource other_datasource = (Datasource)object;
        if (!other_datasource.getDriver().equals(this.getDriver())) {
            return false;
        }
        if (!other_datasource.getUrl().equals(this.getUrl())) {
            return false;
        }
        if (other_datasource.getUser() != null || this.getUser() != null) {
            if (other_datasource.getUser() == null || this.getUser() == null) {
                return false;
            }
            if (!other_datasource.getUser().equals(this.getUser())) {
                return false;
            }
        }
        if (other_datasource.getPassword() != null || this.getPassword() != null) {
            if (other_datasource.getPassword() == null || this.getPassword() == null) {
                return false;
            }
            if (!other_datasource.getPassword().equals(this.getPassword())) {
                return false;
            }
        }
        return true;
    }

    public Datasource clone() {
        Datasource other = null;
        try {
            other = (Datasource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.database").severe(ExceptionUtils.getExceptionStackTrace(e));
            return null;
        }
        other.mSqlConversion = this.mSqlConversion;
        other.mConnectionPool = this.mConnectionPool;
        return other;
    }

    public /* synthetic */ Object clone() {
        return this.clone();
    }

    public void cleanup() {
        this.mConnectionPool.cleanup();
    }

    public ConnectionPool getPool() {
        return this.mConnectionPool;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.database.Datasource");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        sDriverAliases = new HashMap();
        sDriverAliases.put("org.gjt.mm.mysql.Driver", "com.mysql.jdbc.Driver");
        sDriverAliases.put("in.co.daffodil.db.rmi.RmiDaffodilDBDriver", "in.co.daffodil.db.jdbc.DaffodilDBDriver");
    }
}

