/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.config;

import com.uwyn.rife.config.Config;
import com.uwyn.rife.config.exceptions.ConfigErrorException;
import com.uwyn.rife.rep.Rep;
import com.uwyn.rife.xml.Xml2Data;
import com.uwyn.rife.xml.exceptions.XmlErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xml2Config
extends Xml2Data {
    private StringBuffer mCharacterDataStack = null;
    private String mCurrentListName = null;
    private String mCurrentParameterName = null;
    private HashMap<String, String> mParameters = null;
    private ArrayList<String> mFinalParameters = null;
    private HashMap<String, ArrayList<String>> mLists = null;
    private ArrayList<String> mFinalLists = null;

    public Xml2Config() {
        this(null, null, null, null);
    }

    public Xml2Config(HashMap<String, String> parameters, ArrayList<String> finalParameters, HashMap<String, ArrayList<String>> lists, ArrayList<String> finalLists) {
        this.mParameters = parameters;
        this.mFinalParameters = finalParameters;
        this.mLists = lists;
        this.mFinalLists = finalLists;
        if (this.mParameters == null) {
            this.mParameters = new HashMap();
        }
        if (this.mFinalParameters == null) {
            this.mFinalParameters = new ArrayList();
        }
        if (this.mLists == null) {
            this.mLists = new HashMap();
        }
        if (this.mFinalLists == null) {
            this.mFinalLists = new ArrayList();
        }
    }

    public HashMap<String, String> getParameters() {
        return this.mParameters;
    }

    public ArrayList<String> getFinalParameters() {
        return this.mFinalParameters;
    }

    public HashMap<String, ArrayList<String>> getLists() {
        return this.mLists;
    }

    public ArrayList<String> getFinalLists() {
        return this.mFinalLists;
    }

    @Override
    public void startDocument() {
        this.mCharacterDataStack = null;
        this.mCurrentListName = null;
        this.mCurrentParameterName = null;
    }

    @Override
    public void endDocument() {
        this.mCharacterDataStack = null;
        this.mCurrentListName = null;
        this.mCurrentParameterName = null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (qName.equals("param") || qName.equals("item")) {
            this.mCharacterDataStack = new StringBuffer();
        }
        if (!qName.equals("config")) {
            if (qName.equals("list")) {
                String name = atts.getValue("name");
                if (!this.mFinalLists.contains(name)) {
                    this.mCurrentListName = name;
                    this.mLists.put(name, new ArrayList());
                    String final_attribute = atts.getValue("final");
                    if (final_attribute != null && (final_attribute.equals("1") || final_attribute.equals("t") || final_attribute.equals("true"))) {
                        this.mFinalLists.add(name);
                    }
                }
            } else if (qName.equals("param")) {
                String name = atts.getValue("name");
                if (!this.mFinalParameters.contains(name)) {
                    this.mCurrentParameterName = name;
                    String final_attribute = atts.getValue("final");
                    if (final_attribute != null && (final_attribute.equals("1") || final_attribute.equals("t") || final_attribute.equals("true"))) {
                        this.mFinalParameters.add(name);
                    }
                }
            } else if (!qName.equals("item")) {
                if (qName.equals("value")) {
                    String parameter_name = atts.getValue("name");
                    if (this.mParameters.containsKey(parameter_name)) {
                        this.mCharacterDataStack.append(this.mParameters.get(parameter_name));
                    }
                } else if (qName.equals("property")) {
                    String property_name = atts.getValue("name");
                    Properties properties = Rep.getProperties();
                    properties.containsKey(property_name);
                    if (properties.containsKey(property_name)) {
                        this.mCharacterDataStack.append(properties.get(property_name));
                    }
                } else if (qName.equals("include")) {
                    String included_file = atts.getValue("file");
                    try {
                        Config included_config = new Config(included_file, this.getResourceFinder(), this.mParameters, this.mFinalParameters, this.mLists, this.mFinalLists);
                    }
                    catch (ConfigErrorException e) {
                        throw new XmlErrorException(new StringBuffer().append(new StringBuffer().append("Error while processing the included config file '").append(included_file).toString()).append("'.").toString(), e);
                    }
                } else {
                    throw new XmlErrorException(new StringBuffer().append(new StringBuffer().append("Unsupport element name '").append(qName).toString()).append("'.").toString());
                }
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (!qName.equals("config")) {
            if (qName.equals("param")) {
                if (this.mCurrentParameterName != null) {
                    String parameter_name = this.mCurrentParameterName;
                    this.mParameters.put(parameter_name, this.mCharacterDataStack.toString());
                    this.mCurrentParameterName = null;
                }
                this.mCharacterDataStack = null;
            } else if (qName.equals("list")) {
                this.mCurrentListName = null;
            } else if (qName.equals("item")) {
                if (this.mCurrentListName != null) {
                    this.mLists.get(this.mCurrentListName).add(this.mCharacterDataStack.toString());
                    this.mCharacterDataStack = null;
                }
            } else if (qName.equals("value")) {
                // empty if block
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.mCharacterDataStack != null && length > 0) {
            this.mCharacterDataStack.append(String.copyValueOf(ch, start, length));
        }
    }
}

